# Anatomy of a Play application

## The standard application layout

The layout of a Play application is standardized to keep things as simple as possible. After a first successful compile, a standard Play application looks like this:

```
app                      → Application sources
 └ assets                → Compiled asset sources
    └ stylesheets        → Typically LESS CSS sources
    └ javascripts        → Typically CoffeeScript sources
 └ controllers           → Application controllers
 └ models                → Application business layer
 └ views                 → Templates
conf                     → Configurations files and other non-compiled resources (on classpath)
 └ application.conf      → Main configuration file
 └ routes                → Routes definition
public                   → Public assets
 └ stylesheets           → CSS files
 └ javascripts           → Javascript files
 └ images                → Image files
project                  → sbt configuration files
 └ build.properties      → Marker for sbt project
 └ Build.scala           → Application build script
 └ plugins.sbt           → sbt plugins
lib                      → Unmanaged libraries dependencies
logs                     → Standard logs folder
 └ application.log       → Default log file
target                   → Generated stuff
 └ scala-2.10.0            
    └ cache              
    └ classes            → Compiled class files
    └ classes_managed    → Managed class files (templates, ...)
    └ resource_managed   → Managed resources (less, ...)
    └ src_managed        → Generated sources (templates, ...)
test                     → source folder for unit or functional tests
```

## The app/ directory

The `app` directory contains all executable artifacts: Java and Scala source code, templates and compiled assets’ sources.

There are three standard packages in the `app` directory, one for each component of the MVC architectural pattern: 

- `app/controllers`
- `app/models`
- `app/views`

You can of course add your own packages, for example an `app/utils` package.

> Note that in Play, the controllers, models and views package name conventions are now just that and can be changed if needed (such as prefixing everything with `com.yourcompany`).

There is also an optional directory called `app/assets` for compiled assets such as [[LESS sources | http://lesscss.org/]] and [[CoffeeScript sources | http://jashkenas.github.com/coffee-script/]].

## The public/ directory

Resources stored in the `public` directory are static assets that are served directly by the Web server.

This directory is split into three standard sub-directories for images, CSS stylesheets and JavaScript files. You should organize your static assets like this to keep all Play applications consistent.

> In a newly-created application, the `/public` directory is mapped to the `/assets` URL path, but you can easily change that, or even use several directories for your static assets.

## The conf/ directory

The `conf` directory contains the application’s configuration files. There are two main configuration files:

- `application.conf`, the main configuration file for the application, which contains standard configuration parameters
- `routes`, the routes definition file.

If you need to add configuration options that are specific to your application, it’s a good idea to add more options to the `application.conf` file.

If a library needs a specific configuration file, try to file it under the `conf` directory.

## The lib/ directory

The `lib` directory is optional and contains unmanaged library dependencies, ie. all JAR files you want to manually manage outside the build system. Just drop any JAR files here and they will be added to your application classpath.

## The project/ directory

The `project` directory contains the sbt build definitions:

- `plugins.sbt` defines sbt plugins used by this project
- `Build.scala` defines your application build script.
- `build.properties` contains the sbt version to use to build your app.

## The target/ directory

The `target` directory contains everything generated by the build system. It can be useful to know what is generated here.

- `classes/` contains all compiled classes (from both Java and Scala sources).
- `classes_managed/` contains only the classes that are managed by the framework (such as the classes generated by the router or the template system). It can be useful to add this class folder as an external class folder in your IDE project.
- `resource_managed/` contains generated resources, typically compiled assets such as LESS CSS and CoffeeScript compilation results.
- `src_managed/` contains generated sources, such as the Scala sources generated by the template system.

## Typical .gitignore file

Generated folders should be ignored by your version control system. Here is the typical `.gitignore` file for a Play application:

```txt
logs
project/project
project/target
target
tmp
dist
.cache
```

> **Next:** [[Using the Play console | PlayConsole ]]