# Play for Java developers

The Java API for the Play application developers is available in the `play` package. 

> The API available in the `play.api` package (such as `play.api.mvc`) is reserved for Scala developers. As a Java developer, look at `play.mvc`.

## Main concepts

1. [[HTTP programming | JavaActions]]
    1. [[Actions, Controllers and Results | JavaActions]]
    1. [[HTTP routing | JavaRouting]]
    1. [[Manipulating the HTTP response | JavaResponse]]
    1. [[Session and Flash scopes | JavaSessionFlash]]
    1. [[Body parsers | JavaBodyParsers]]
    1. [[Action composition | JavaActionsComposition]]
    1. [[Content negotiation | JavaContentNegotiation]]
1. [[Asynchronous HTTP programming | JavaAsync]]
    1. [[Handling asynchronous results | JavaAsync]]
    1. [[Streaming HTTP responses | JavaStream]]
    1. [[Comet sockets | JavaComet]]
    1. [[WebSockets | JavaWebSockets]]
1. [[The template engine | JavaTemplates]]
    1. [[Templates syntax | JavaTemplates]]
    1. [[Common use cases | JavaTemplateUseCases]]
1. [[HTTP form submission and validation | JavaForms]]
    1. [[Form definitions | JavaForms]]
    1. [[Using the form template helpers | JavaFormHelpers]]
1. [[Working with Json | JavaJsonRequests]]
    1. [[Handling and serving Json requests | JavaJsonRequests]]
1. [[Working with XML | JavaXmlRequests]]
    1. [[Handling and serving XML requests | JavaXmlRequests]]
1. [[Handling file upload | JavaFileUpload]]
    1. [[Direct upload and multipart/form-data | JavaFileUpload]]
1. [[Accessing an SQL database | JavaDatabase]]
    1. [[Configuring and using JDBC | JavaDatabase]]
    1. [[Using Ebean ORM | JavaEbean]]
    1. [[Integrating with JPA | JavaJPA]]
1. [[Using the Cache | JavaCache]]
    1. [[The Play cache API | JavaCache]]
1. [[Calling WebServices | JavaWS]]
    1. [[The Play WS API  | JavaWS]]
    1. [[Connect to OpenID servers | JavaOpenID]]
1. [[Integrating with Akka | JavaAkka]]
    1. [[Setting up Actors and scheduling asynchronous tasks | JavaAkka]]
1. [[Internationalization | JavaI18N]]
    1. [[Messages externalization and i18n | JavaI18N]]
1. [[The application Global object | JavaGlobal]]
    1. [[Application global settings | JavaGlobal]]
    1. [[Intercepting requests | JavaInterceptors]]
    1. [[Managing Controller Class Instantiation | JavaInjection]]
1. [[Testing your application | JavaTest]]
    1. [[Writing tests | JavaTest]]
    1. [[Writing functional tests | JavaFunctionalTest]]

## Tutorials

1. [[Your first application | JavaTodoList]]
1. [[Zentask | JavaGuide1]]