defmodule Anoma.Identity.SignsFor do
  alias Anoma.Identity.{Evidence, Verification}
  alias Anoma.Node.Storage
  alias Anoma.Crypto.Id
  alias Anoma.Node.Router

  @spec sign_for(Router.Addr.t(), Evidence.name()) ::
          :key_not_verified | :ok | :could_not_update_storage
  def sign_for(
        tab,
        ev = %Evidence{signed_data: trusted_key, signature_key: our_key}
      ) do
    if Verification.verify_request(
         ev.signature,
         trusted_key,
         ev.signature_key,
         tab
       ) do
      key_space = [name_space(), our_key]

      new_set =
        case Storage.get(tab, key_space) do
          {:ok, set} -> MapSet.put(set, trusted_key)
          :absent -> MapSet.new([trusted_key])
        end

      Storage.put(tab, key_space, new_set)
    else
      :key_not_verified
    end
  end

  @spec known(Router.Addr.t(), Id.Extern.t()) :: MapSet.t(Id.Extern.t())
  def known(tab, key) do
    case Storage.get(tab, [name_space(), key]) do
      {:ok, set} -> set
      :absent -> MapSet.new()
    end
  end

  @spec signs_for?(Router.Addr.t(), Id.Extern.t(), Id.Extern.t()) :: boolean
  def signs_for?(tab, our_key, key_in_question) do
    known(tab, our_key)
    |> MapSet.member?(key_in_question)
  end

  @base_name_space "signs_for"
  def name_space, do: @base_name_space
end
