/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.ComponentProcessor;
import dagger.internal.codegen.SourceFileGenerationException;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;

abstract class SourceFileGenerator<T> {
    private static final String GENERATED_COMMENTS = "https://google.github.io/dagger";
    private static final AnnotationSpec GENERATED = AnnotationSpec.builder(Generated.class).addMember("value", "$S", ComponentProcessor.class.getName()).addMember("comments", "$S", "https://google.github.io/dagger").build();
    private final Filer filer;
    private final boolean generatedAnnotationAvailable;

    SourceFileGenerator(Filer filer, Elements elements) {
        this.filer = (Filer)Preconditions.checkNotNull((Object)filer);
        this.generatedAnnotationAvailable = elements.getTypeElement("javax.annotation.Generated") != null;
    }

    void generate(T input) throws SourceFileGenerationException {
        ClassName generatedTypeName = this.nameGeneratedType(input);
        try {
            Optional<TypeSpec.Builder> type = this.write(generatedTypeName, input);
            if (!type.isPresent()) {
                return;
            }
            JavaFile javaFile = this.buildJavaFile(generatedTypeName, (TypeSpec.Builder)type.get());
            final JavaFileObject sourceFile = this.filer.createSourceFile(generatedTypeName.toString(), (Element[])Iterables.toArray(javaFile.typeSpec.originatingElements, Element.class));
            try {
                new Formatter().formatSource(CharSource.wrap((CharSequence)javaFile.toString()), new CharSink(){

                    public Writer openStream() throws IOException {
                        return sourceFile.openWriter();
                    }
                });
            }
            catch (FormatterException e) {
                throw new SourceFileGenerationException((Optional<ClassName>)Optional.of((Object)generatedTypeName), e, this.getElementForErrorReporting(input));
            }
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, SourceFileGenerationException.class);
            throw new SourceFileGenerationException((Optional<ClassName>)Optional.absent(), e, this.getElementForErrorReporting(input));
        }
    }

    private JavaFile buildJavaFile(ClassName generatedTypeName, TypeSpec.Builder typeSpecBuilder) {
        if (this.generatedAnnotationAvailable) {
            typeSpecBuilder.addAnnotation(GENERATED);
        }
        JavaFile.Builder javaFileBuilder = JavaFile.builder(generatedTypeName.packageName(), typeSpecBuilder.build()).skipJavaLangImports(true);
        if (!this.generatedAnnotationAvailable) {
            javaFileBuilder.addFileComment("Generated by $L ($L).", ComponentProcessor.class.getName(), GENERATED_COMMENTS);
        }
        return javaFileBuilder.build();
    }

    abstract ClassName nameGeneratedType(T var1);

    abstract Optional<? extends Element> getElementForErrorReporting(T var1);

    abstract Optional<TypeSpec.Builder> write(ClassName var1, T var2);
}

