---
title: Cloud Functions Master Course
description: Master the fundamentals of serverless with Firebase Cloud Functions where we build seven different microservices
weight: 0
type: courses
tags: 
    - cloud-functions
    - firestore
    - firebase
    - serverless
    - node
---

<video-player src="https://firebasestorage.googleapis.com/v0/b/fireship-app.appspot.com/o/courses%2Fcloud-functions-master-course%2Fintro.mp4?alt=media&token=9761ab04-68a7-487d-9a00-1b624e3b9390"></video=player>

This course takes a hands-on approach to Firebase Cloud Functions where we build seven different microservices, each demonstrating a fundamental concept of the platform. Here's a quick summary of the topics you will learn.

- Serverless Computing Basics
- HTTP and ExpressJS
- Event-driven Background FunctionsF
- Firestore Functions
- Storage Buckets and the Functions Filesystem
- Working with Google APIs
- Callable Functions and Authentication
- Working with 3rd party APIs like Twilio to send SMS Text messages
- By the end of this course you will have the foundation necessary to build virtually any backend feature into your Firebase app.

This Project is for Developers who...
are building a mobile or web app with Firebase
want to learn how to build backend features in a serverless NodeJS backend
want direct access to the content creator (let's chat on Slack).
have at least some experience with JavaScript and programming fundamentals
Experience Level Required
The course is fast-paced and content-rich, but most of the subject matter is suitable for developers with beginner JavaScript skills. It is expected that you're already familiar with Firebase because Cloud Functions are a way to extend the platform.

Brand New to Firebase?
If you've never used Firebase, start by working with the frontend SDKs before attempting Cloud Functions. The video below is a great way to get started: