# coding: utf-8


from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from anchore_engine.services.policy_engine.api.models.base_model_ import Model
from anchore_engine.services.policy_engine.api import util


class ImageIngressRequest(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, user_id=None, image_id=None, fetch_url=None):  # noqa: E501
        """ImageIngressRequest - a model defined in Swagger

        :param user_id: The user_id of this ImageIngressRequest.  # noqa: E501
        :type user_id: str
        :param image_id: The image_id of this ImageIngressRequest.  # noqa: E501
        :type image_id: str
        :param fetch_url: The fetch_url of this ImageIngressRequest.  # noqa: E501
        :type fetch_url: str
        """
        self.swagger_types = {
            'user_id': str,
            'image_id': str,
            'fetch_url': str
        }

        self.attribute_map = {
            'user_id': 'user_id',
            'image_id': 'image_id',
            'fetch_url': 'fetch_url'
        }

        self._user_id = user_id
        self._image_id = image_id
        self._fetch_url = fetch_url

    @classmethod
    def from_dict(cls, dikt):
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ImageIngressRequest of this ImageIngressRequest.  # noqa: E501
        :rtype: ImageIngressRequest
        """
        return util.deserialize_model(dikt, cls)

    @property
    def user_id(self):
        """Gets the user_id of this ImageIngressRequest.


        :return: The user_id of this ImageIngressRequest.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this ImageIngressRequest.


        :param user_id: The user_id of this ImageIngressRequest.
        :type user_id: str
        """
        if user_id is None:
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def image_id(self):
        """Gets the image_id of this ImageIngressRequest.


        :return: The image_id of this ImageIngressRequest.
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """Sets the image_id of this ImageIngressRequest.


        :param image_id: The image_id of this ImageIngressRequest.
        :type image_id: str
        """
        if image_id is None:
            raise ValueError("Invalid value for `image_id`, must not be `None`")  # noqa: E501

        self._image_id = image_id

    @property
    def fetch_url(self):
        """Gets the fetch_url of this ImageIngressRequest.

        The url to pull image data from, if available. If None the system will ask the catalog endpoint  # noqa: E501

        :return: The fetch_url of this ImageIngressRequest.
        :rtype: str
        """
        return self._fetch_url

    @fetch_url.setter
    def fetch_url(self, fetch_url):
        """Sets the fetch_url of this ImageIngressRequest.

        The url to pull image data from, if available. If None the system will ask the catalog endpoint  # noqa: E501

        :param fetch_url: The fetch_url of this ImageIngressRequest.
        :type fetch_url: str
        """
        if fetch_url is None:
            raise ValueError("Invalid value for `fetch_url`, must not be `None`")  # noqa: E501

        self._fetch_url = fetch_url
