# coding: utf-8


from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from anchore_engine.services.policy_engine.api.models.base_model_ import Model
from anchore_engine.services.policy_engine.api import util


class PolicyEvaluationProblem(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, severity=None, problem_type=None, details=None):  # noqa: E501
        """PolicyEvaluationProblem - a model defined in Swagger

        :param severity: The severity of this PolicyEvaluationProblem.  # noqa: E501
        :type severity: str
        :param problem_type: The problem_type of this PolicyEvaluationProblem.  # noqa: E501
        :type problem_type: str
        :param details: The details of this PolicyEvaluationProblem.  # noqa: E501
        :type details: str
        """
        self.swagger_types = {
            'severity': str,
            'problem_type': str,
            'details': str
        }

        self.attribute_map = {
            'severity': 'severity',
            'problem_type': 'problem_type',
            'details': 'details'
        }

        self._severity = severity
        self._problem_type = problem_type
        self._details = details

    @classmethod
    def from_dict(cls, dikt):
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PolicyEvaluationProblem of this PolicyEvaluationProblem.  # noqa: E501
        :rtype: PolicyEvaluationProblem
        """
        return util.deserialize_model(dikt, cls)

    @property
    def severity(self):
        """Gets the severity of this PolicyEvaluationProblem.

        severity string such as \"warn\", \"error\", \"fatal\"  # noqa: E501

        :return: The severity of this PolicyEvaluationProblem.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this PolicyEvaluationProblem.

        severity string such as \"warn\", \"error\", \"fatal\"  # noqa: E501

        :param severity: The severity of this PolicyEvaluationProblem.
        :type severity: str
        """
        if severity is None:
            raise ValueError("Invalid value for `severity`, must not be `None`")  # noqa: E501

        self._severity = severity

    @property
    def problem_type(self):
        """Gets the problem_type of this PolicyEvaluationProblem.

        the type of problem encountered, such as a misconfiguration or unavailable data  # noqa: E501

        :return: The problem_type of this PolicyEvaluationProblem.
        :rtype: str
        """
        return self._problem_type

    @problem_type.setter
    def problem_type(self, problem_type):
        """Sets the problem_type of this PolicyEvaluationProblem.

        the type of problem encountered, such as a misconfiguration or unavailable data  # noqa: E501

        :param problem_type: The problem_type of this PolicyEvaluationProblem.
        :type problem_type: str
        """
        if problem_type is None:
            raise ValueError("Invalid value for `problem_type`, must not be `None`")  # noqa: E501

        self._problem_type = problem_type

    @property
    def details(self):
        """Gets the details of this PolicyEvaluationProblem.

        Details about the problem itself and how to fix it  # noqa: E501

        :return: The details of this PolicyEvaluationProblem.
        :rtype: str
        """
        return self._details

    @details.setter
    def details(self, details):
        """Sets the details of this PolicyEvaluationProblem.

        Details about the problem itself and how to fix it  # noqa: E501

        :param details: The details of this PolicyEvaluationProblem.
        :type details: str
        """
        if details is None:
            raise ValueError("Invalid value for `details`, must not be `None`")  # noqa: E501

        self._details = details
