# coding: utf-8


from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from anchore_engine.services.policy_engine.api.models.base_model_ import Model
from anchore_engine.services.policy_engine.api.models.policy_evaluation_problem import PolicyEvaluationProblem  # noqa: F401,E501
from anchore_engine.services.policy_engine.api import util


class PolicyValidationResponse(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, valid=None, validation_details=None):  # noqa: E501
        """PolicyValidationResponse - a model defined in Swagger

        :param valid: The valid of this PolicyValidationResponse.  # noqa: E501
        :type valid: bool
        :param validation_details: The validation_details of this PolicyValidationResponse.  # noqa: E501
        :type validation_details: List[PolicyEvaluationProblem]
        """
        self.swagger_types = {
            'valid': bool,
            'validation_details': List[PolicyEvaluationProblem]
        }

        self.attribute_map = {
            'valid': 'valid',
            'validation_details': 'validation_details'
        }

        self._valid = valid
        self._validation_details = validation_details

    @classmethod
    def from_dict(cls, dikt):
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PolicyValidationResponse of this PolicyValidationResponse.  # noqa: E501
        :rtype: PolicyValidationResponse
        """
        return util.deserialize_model(dikt, cls)

    @property
    def valid(self):
        """Gets the valid of this PolicyValidationResponse.

        The validation result. If True, the policy bundle is valid. If False, it is invalid and there should be content in the validation_details property.  # noqa: E501

        :return: The valid of this PolicyValidationResponse.
        :rtype: bool
        """
        return self._valid

    @valid.setter
    def valid(self, valid):
        """Sets the valid of this PolicyValidationResponse.

        The validation result. If True, the policy bundle is valid. If False, it is invalid and there should be content in the validation_details property.  # noqa: E501

        :param valid: The valid of this PolicyValidationResponse.
        :type valid: bool
        """

        self._valid = valid

    @property
    def validation_details(self):
        """Gets the validation_details of this PolicyValidationResponse.

        An array of validation details including error messages as appropriate. Will be empty on a successful validation.  # noqa: E501

        :return: The validation_details of this PolicyValidationResponse.
        :rtype: List[PolicyEvaluationProblem]
        """
        return self._validation_details

    @validation_details.setter
    def validation_details(self, validation_details):
        """Sets the validation_details of this PolicyValidationResponse.

        An array of validation details including error messages as appropriate. Will be empty on a successful validation.  # noqa: E501

        :param validation_details: The validation_details of this PolicyValidationResponse.
        :type validation_details: List[PolicyEvaluationProblem]
        """

        self._validation_details = validation_details
