# coding: utf-8


from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from anchore_engine.services.policy_engine.api.models.base_model_ import Model
from anchore_engine.services.policy_engine.api import util


class TriggerParamSpec(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, name=None, description=None, example=None, required=None, state=None, superceded_by=None, validator=None):  # noqa: E501
        """TriggerParamSpec - a model defined in Swagger

        :param name: The name of this TriggerParamSpec.  # noqa: E501
        :type name: str
        :param description: The description of this TriggerParamSpec.  # noqa: E501
        :type description: str
        :param example: The example of this TriggerParamSpec.  # noqa: E501
        :type example: str
        :param required: The required of this TriggerParamSpec.  # noqa: E501
        :type required: bool
        :param state: The state of this TriggerParamSpec.  # noqa: E501
        :type state: str
        :param superceded_by: The superceded_by of this TriggerParamSpec.  # noqa: E501
        :type superceded_by: str
        :param validator: The validator of this TriggerParamSpec.  # noqa: E501
        :type validator: object
        """
        self.swagger_types = {
            'name': str,
            'description': str,
            'example': str,
            'required': bool,
            'state': str,
            'superceded_by': str,
            'validator': object
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'example': 'example',
            'required': 'required',
            'state': 'state',
            'superceded_by': 'superceded_by',
            'validator': 'validator'
        }

        self._name = name
        self._description = description
        self._example = example
        self._required = required
        self._state = state
        self._superceded_by = superceded_by
        self._validator = validator

    @classmethod
    def from_dict(cls, dikt):
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The TriggerParamSpec of this TriggerParamSpec.  # noqa: E501
        :rtype: TriggerParamSpec
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this TriggerParamSpec.

        Parameter name as it appears in policy document  # noqa: E501

        :return: The name of this TriggerParamSpec.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TriggerParamSpec.

        Parameter name as it appears in policy document  # noqa: E501

        :param name: The name of this TriggerParamSpec.
        :type name: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this TriggerParamSpec.


        :return: The description of this TriggerParamSpec.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this TriggerParamSpec.


        :param description: The description of this TriggerParamSpec.
        :type description: str
        """

        self._description = description

    @property
    def example(self):
        """Gets the example of this TriggerParamSpec.

        An example value for the parameter (encoded as a string if the parameter is an object or list type)  # noqa: E501

        :return: The example of this TriggerParamSpec.
        :rtype: str
        """
        return self._example

    @example.setter
    def example(self, example):
        """Sets the example of this TriggerParamSpec.

        An example value for the parameter (encoded as a string if the parameter is an object or list type)  # noqa: E501

        :param example: The example of this TriggerParamSpec.
        :type example: str
        """

        self._example = example

    @property
    def required(self):
        """Gets the required of this TriggerParamSpec.

        Is this a required parameter or optional. If required it must be present in the json and validate based on the provided validator. If optional it can be present in json and null or omitted.  # noqa: E501

        :return: The required of this TriggerParamSpec.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """Sets the required of this TriggerParamSpec.

        Is this a required parameter or optional. If required it must be present in the json and validate based on the provided validator. If optional it can be present in json and null or omitted.  # noqa: E501

        :param required: The required of this TriggerParamSpec.
        :type required: bool
        """

        self._required = required

    @property
    def state(self):
        """Gets the state of this TriggerParamSpec.

        State of the trigger parameter  # noqa: E501

        :return: The state of this TriggerParamSpec.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this TriggerParamSpec.

        State of the trigger parameter  # noqa: E501

        :param state: The state of this TriggerParamSpec.
        :type state: str
        """
        allowed_values = ["active", "deprecated", "eol"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def superceded_by(self):
        """Gets the superceded_by of this TriggerParamSpec.

        The name of another gate that supercedes this on functionally if this is deprecated  # noqa: E501

        :return: The superceded_by of this TriggerParamSpec.
        :rtype: str
        """
        return self._superceded_by

    @superceded_by.setter
    def superceded_by(self, superceded_by):
        """Sets the superceded_by of this TriggerParamSpec.

        The name of another gate that supercedes this on functionally if this is deprecated  # noqa: E501

        :param superceded_by: The superceded_by of this TriggerParamSpec.
        :type superceded_by: str
        """

        self._superceded_by = superceded_by

    @property
    def validator(self):
        """Gets the validator of this TriggerParamSpec.

        If present, a definition for validation of input. Typically a jsonschema object that can be used to validate an input against.  # noqa: E501

        :return: The validator of this TriggerParamSpec.
        :rtype: object
        """
        return self._validator

    @validator.setter
    def validator(self, validator):
        """Sets the validator of this TriggerParamSpec.

        If present, a definition for validation of input. Typically a jsonschema object that can be used to validate an input against.  # noqa: E501

        :param validator: The validator of this TriggerParamSpec.
        :type validator: object
        """

        self._validator = validator
