# coding: utf-8


from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from anchore_engine.services.policy_engine.api.models.base_model_ import Model
from anchore_engine.services.policy_engine.api import util


class DistroMapping(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, from_distro=None, to_distro=None, flavor=None, created_at=None):  # noqa: E501
        """DistroMapping - a model defined in Swagger

        :param from_distro: The from_distro of this DistroMapping.  # noqa: E501
        :type from_distro: str
        :param to_distro: The to_distro of this DistroMapping.  # noqa: E501
        :type to_distro: str
        :param flavor: The flavor of this DistroMapping.  # noqa: E501
        :type flavor: str
        :param created_at: The created_at of this DistroMapping.  # noqa: E501
        :type created_at: datetime
        """
        self.swagger_types = {
            'from_distro': str,
            'to_distro': str,
            'flavor': str,
            'created_at': datetime
        }

        self.attribute_map = {
            'from_distro': 'from_distro',
            'to_distro': 'to_distro',
            'flavor': 'flavor',
            'created_at': 'created_at'
        }

        self._from_distro = from_distro
        self._to_distro = to_distro
        self._flavor = flavor
        self._created_at = created_at

    @classmethod
    def from_dict(cls, dikt):
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The DistroMapping of this DistroMapping.  # noqa: E501
        :rtype: DistroMapping
        """
        return util.deserialize_model(dikt, cls)

    @property
    def from_distro(self):
        """Gets the from_distro of this DistroMapping.

        The name of the distro to map as would be reported in the image itself from a file like /etc/os_release  # noqa: E501

        :return: The from_distro of this DistroMapping.
        :rtype: str
        """
        return self._from_distro

    @from_distro.setter
    def from_distro(self, from_distro):
        """Sets the from_distro of this DistroMapping.

        The name of the distro to map as would be reported in the image itself from a file like /etc/os_release  # noqa: E501

        :param from_distro: The from_distro of this DistroMapping.
        :type from_distro: str
        """

        self._from_distro = from_distro

    @property
    def to_distro(self):
        """Gets the to_distro of this DistroMapping.

        The distro name to use instead for cve matching purposes.  # noqa: E501

        :return: The to_distro of this DistroMapping.
        :rtype: str
        """
        return self._to_distro

    @to_distro.setter
    def to_distro(self, to_distro):
        """Sets the to_distro of this DistroMapping.

        The distro name to use instead for cve matching purposes.  # noqa: E501

        :param to_distro: The to_distro of this DistroMapping.
        :type to_distro: str
        """

        self._to_distro = to_distro

    @property
    def flavor(self):
        """Gets the flavor of this DistroMapping.

        The flavor of the distro  # noqa: E501

        :return: The flavor of this DistroMapping.
        :rtype: str
        """
        return self._flavor

    @flavor.setter
    def flavor(self, flavor):
        """Sets the flavor of this DistroMapping.

        The flavor of the distro  # noqa: E501

        :param flavor: The flavor of this DistroMapping.
        :type flavor: str
        """

        self._flavor = flavor

    @property
    def created_at(self):
        """Gets the created_at of this DistroMapping.

        Timestamp of mapping creation  # noqa: E501

        :return: The created_at of this DistroMapping.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this DistroMapping.

        Timestamp of mapping creation  # noqa: E501

        :param created_at: The created_at of this DistroMapping.
        :type created_at: datetime
        """

        self._created_at = created_at
