# coding: utf-8


from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from anchore_engine.services.policy_engine.api.models.base_model_ import Model
from anchore_engine.services.policy_engine.api.models.feed_group_metadata import FeedGroupMetadata  # noqa: F401,E501
from anchore_engine.services.policy_engine.api import util


class FeedMetadata(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, name=None, created_at=None, updated_at=None, groups=None, last_full_sync=None, enabled=None):  # noqa: E501
        """FeedMetadata - a model defined in Swagger

        :param name: The name of this FeedMetadata.  # noqa: E501
        :type name: str
        :param created_at: The created_at of this FeedMetadata.  # noqa: E501
        :type created_at: datetime
        :param updated_at: The updated_at of this FeedMetadata.  # noqa: E501
        :type updated_at: datetime
        :param groups: The groups of this FeedMetadata.  # noqa: E501
        :type groups: List[FeedGroupMetadata]
        :param last_full_sync: The last_full_sync of this FeedMetadata.  # noqa: E501
        :type last_full_sync: datetime
        """
        self.swagger_types = {
            'name': str,
            'created_at': datetime,
            'updated_at': datetime,
            'groups': List[FeedGroupMetadata],
            'last_full_sync': datetime,
            'enabled': bool
        }

        self.attribute_map = {
            'name': 'name',
            'created_at': 'created_at',
            'updated_at': 'updated_at',
            'groups': 'groups',
            'last_full_sync': 'last_full_sync',
            'enabled': 'enabled'
        }

        self._name = name
        self._created_at = created_at
        self._updated_at = updated_at
        self._groups = groups
        self._last_full_sync = last_full_sync
        self._enabled = enabled

    @classmethod
    def from_dict(cls, dikt):
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The FeedMetadata of this FeedMetadata.  # noqa: E501
        :rtype: FeedMetadata
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this FeedMetadata.

        name of the feed  # noqa: E501

        :return: The name of this FeedMetadata.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this FeedMetadata.

        name of the feed  # noqa: E501

        :param name: The name of this FeedMetadata.
        :type name: str
        """

        self._name = name

    @property
    def created_at(self):
        """Gets the created_at of this FeedMetadata.

        Date the metadata record was created in engine (first seen on source)  # noqa: E501

        :return: The created_at of this FeedMetadata.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this FeedMetadata.

        Date the metadata record was created in engine (first seen on source)  # noqa: E501

        :param created_at: The created_at of this FeedMetadata.
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this FeedMetadata.

        Date the metadata was last updated  # noqa: E501

        :return: The updated_at of this FeedMetadata.
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this FeedMetadata.

        Date the metadata was last updated  # noqa: E501

        :param updated_at: The updated_at of this FeedMetadata.
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def groups(self):
        """Gets the groups of this FeedMetadata.


        :return: The groups of this FeedMetadata.
        :rtype: List[FeedGroupMetadata]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """Sets the groups of this FeedMetadata.


        :param groups: The groups of this FeedMetadata.
        :type groups: List[FeedGroupMetadata]
        """

        self._groups = groups

    @property
    def last_full_sync(self):
        """Gets the last_full_sync of this FeedMetadata.


        :return: The last_full_sync of this FeedMetadata.
        :rtype: datetime
        """
        return self._last_full_sync

    @last_full_sync.setter
    def last_full_sync(self, last_full_sync):
        """Sets the last_full_sync of this FeedMetadata.


        :param last_full_sync: The last_full_sync of this FeedMetadata.
        :type last_full_sync: datetime
        """

        self._last_full_sync = last_full_sync

    @property
    def enabled(self):
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled
