# coding: utf-8


from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from anchore_engine.services.policy_engine.api.models.base_model_ import Model
from anchore_engine.services.policy_engine.api.models.trigger_spec import TriggerSpec  # noqa: F401,E501
from anchore_engine.services.policy_engine.api import util


class GateSpec(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, name=None, description=None, state=None, superceded_by=None, triggers=None):  # noqa: E501
        """GateSpec - a model defined in Swagger

        :param name: The name of this GateSpec.  # noqa: E501
        :type name: str
        :param description: The description of this GateSpec.  # noqa: E501
        :type description: str
        :param state: The state of this GateSpec.  # noqa: E501
        :type state: str
        :param superceded_by: The superceded_by of this GateSpec.  # noqa: E501
        :type superceded_by: str
        :param triggers: The triggers of this GateSpec.  # noqa: E501
        :type triggers: List[TriggerSpec]
        """
        self.swagger_types = {
            'name': str,
            'description': str,
            'state': str,
            'superceded_by': str,
            'triggers': List[TriggerSpec]
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'state': 'state',
            'superceded_by': 'superceded_by',
            'triggers': 'triggers'
        }

        self._name = name
        self._description = description
        self._state = state
        self._superceded_by = superceded_by
        self._triggers = triggers

    @classmethod
    def from_dict(cls, dikt):
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The GateSpec of this GateSpec.  # noqa: E501
        :rtype: GateSpec
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this GateSpec.

        Gate name, as it would appear in a policy document  # noqa: E501

        :return: The name of this GateSpec.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GateSpec.

        Gate name, as it would appear in a policy document  # noqa: E501

        :param name: The name of this GateSpec.
        :type name: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this GateSpec.

        Description of the gate  # noqa: E501

        :return: The description of this GateSpec.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this GateSpec.

        Description of the gate  # noqa: E501

        :param description: The description of this GateSpec.
        :type description: str
        """

        self._description = description

    @property
    def state(self):
        """Gets the state of this GateSpec.

        State of the gate, applied transitively to all triggers if a state other than active  # noqa: E501

        :return: The state of this GateSpec.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this GateSpec.

        State of the gate, applied transitively to all triggers if a state other than active  # noqa: E501

        :param state: The state of this GateSpec.
        :type state: str
        """
        allowed_values = ["active", "deprecated", "eol"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def superceded_by(self):
        """Gets the superceded_by of this GateSpec.

        The name of another gate that supercedes this on functionally if this is deprecated  # noqa: E501

        :return: The superceded_by of this GateSpec.
        :rtype: str
        """
        return self._superceded_by

    @superceded_by.setter
    def superceded_by(self, superceded_by):
        """Sets the superceded_by of this GateSpec.

        The name of another gate that supercedes this on functionally if this is deprecated  # noqa: E501

        :param superceded_by: The superceded_by of this GateSpec.
        :type superceded_by: str
        """

        self._superceded_by = superceded_by

    @property
    def triggers(self):
        """Gets the triggers of this GateSpec.

        List of the triggers that can fire for this Gate  # noqa: E501

        :return: The triggers of this GateSpec.
        :rtype: List[TriggerSpec]
        """
        return self._triggers

    @triggers.setter
    def triggers(self, triggers):
        """Sets the triggers of this GateSpec.

        List of the triggers that can fire for this Gate  # noqa: E501

        :param triggers: The triggers of this GateSpec.
        :type triggers: List[TriggerSpec]
        """

        self._triggers = triggers
