# coding: utf-8


from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from anchore_engine.services.policy_engine.api.models.base_model_ import Model
from anchore_engine.services.policy_engine.api.models.policy_rule import PolicyRule  # noqa: F401,E501
from anchore_engine.services.policy_engine.api import util


class Policy(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, id=None, name=None, comment=None, version=None, rules=None):  # noqa: E501
        """Policy - a model defined in Swagger

        :param id: The id of this Policy.  # noqa: E501
        :type id: str
        :param name: The name of this Policy.  # noqa: E501
        :type name: str
        :param comment: The comment of this Policy.  # noqa: E501
        :type comment: str
        :param version: The version of this Policy.  # noqa: E501
        :type version: str
        :param rules: The rules of this Policy.  # noqa: E501
        :type rules: List[PolicyRule]
        """
        self.swagger_types = {
            'id': str,
            'name': str,
            'comment': str,
            'version': str,
            'rules': List[PolicyRule]
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'comment': 'comment',
            'version': 'version',
            'rules': 'rules'
        }

        self._id = id
        self._name = name
        self._comment = comment
        self._version = version
        self._rules = rules

    @classmethod
    def from_dict(cls, dikt):
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Policy of this Policy.  # noqa: E501
        :rtype: Policy
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self):
        """Gets the id of this Policy.


        :return: The id of this Policy.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Policy.


        :param id: The id of this Policy.
        :type id: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this Policy.


        :return: The name of this Policy.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Policy.


        :param name: The name of this Policy.
        :type name: str
        """

        self._name = name

    @property
    def comment(self):
        """Gets the comment of this Policy.


        :return: The comment of this Policy.
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this Policy.


        :param comment: The comment of this Policy.
        :type comment: str
        """

        self._comment = comment

    @property
    def version(self):
        """Gets the version of this Policy.


        :return: The version of this Policy.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Policy.


        :param version: The version of this Policy.
        :type version: str
        """
        if version is None:
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    @property
    def rules(self):
        """Gets the rules of this Policy.


        :return: The rules of this Policy.
        :rtype: List[PolicyRule]
        """
        return self._rules

    @rules.setter
    def rules(self, rules):
        """Sets the rules of this Policy.


        :param rules: The rules of this Policy.
        :type rules: List[PolicyRule]
        """

        self._rules = rules
