# coding: utf-8


from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from anchore_engine.services.policy_engine.api.models.base_model_ import Model
from anchore_engine.services.policy_engine.api.models.policy_rule_params import PolicyRuleParams  # noqa: F401,E501
from anchore_engine.services.policy_engine.api import util


class PolicyRule(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, id=None, gate=None, trigger=None, action=None, params=None):  # noqa: E501
        """PolicyRule - a model defined in Swagger

        :param id: The id of this PolicyRule.  # noqa: E501
        :type id: str
        :param gate: The gate of this PolicyRule.  # noqa: E501
        :type gate: str
        :param trigger: The trigger of this PolicyRule.  # noqa: E501
        :type trigger: str
        :param action: The action of this PolicyRule.  # noqa: E501
        :type action: str
        :param params: The params of this PolicyRule.  # noqa: E501
        :type params: List[PolicyRuleParams]
        """
        self.swagger_types = {
            'id': str,
            'gate': str,
            'trigger': str,
            'action': str,
            'params': List[PolicyRuleParams]
        }

        self.attribute_map = {
            'id': 'id',
            'gate': 'gate',
            'trigger': 'trigger',
            'action': 'action',
            'params': 'params'
        }

        self._id = id
        self._gate = gate
        self._trigger = trigger
        self._action = action
        self._params = params

    @classmethod
    def from_dict(cls, dikt):
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PolicyRule of this PolicyRule.  # noqa: E501
        :rtype: PolicyRule
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self):
        """Gets the id of this PolicyRule.


        :return: The id of this PolicyRule.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this PolicyRule.


        :param id: The id of this PolicyRule.
        :type id: str
        """

        self._id = id

    @property
    def gate(self):
        """Gets the gate of this PolicyRule.


        :return: The gate of this PolicyRule.
        :rtype: str
        """
        return self._gate

    @gate.setter
    def gate(self, gate):
        """Sets the gate of this PolicyRule.


        :param gate: The gate of this PolicyRule.
        :type gate: str
        """
        if gate is None:
            raise ValueError("Invalid value for `gate`, must not be `None`")  # noqa: E501

        self._gate = gate

    @property
    def trigger(self):
        """Gets the trigger of this PolicyRule.


        :return: The trigger of this PolicyRule.
        :rtype: str
        """
        return self._trigger

    @trigger.setter
    def trigger(self, trigger):
        """Sets the trigger of this PolicyRule.


        :param trigger: The trigger of this PolicyRule.
        :type trigger: str
        """
        if trigger is None:
            raise ValueError("Invalid value for `trigger`, must not be `None`")  # noqa: E501

        self._trigger = trigger

    @property
    def action(self):
        """Gets the action of this PolicyRule.


        :return: The action of this PolicyRule.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this PolicyRule.


        :param action: The action of this PolicyRule.
        :type action: str
        """
        allowed_values = ["GO", "STOP", "WARN"]  # noqa: E501
        if action not in allowed_values:
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def params(self):
        """Gets the params of this PolicyRule.


        :return: The params of this PolicyRule.
        :rtype: List[PolicyRuleParams]
        """
        return self._params

    @params.setter
    def params(self, params):
        """Sets the params of this PolicyRule.


        :param params: The params of this PolicyRule.
        :type params: List[PolicyRuleParams]
        """

        self._params = params
