/**
 * @license almond 0.2.9 Copyright (c) 2011-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */

(function(factory){var library=factory();if(typeof Virtjs!=="undefined")Virtjs.engine[library.name]=library;if(typeof define==="function"&&define.amd){define([],function(){return library})}})(function(){var requirejs,require,define;(function(undef){var main,req,makeMap,handlers,defined={},waiting={},config={},defining={},hasOwn=Object.prototype.hasOwnProperty,aps=[].slice,jsSuffixRegExp=/\.js$/;function hasProp(obj,prop){return hasOwn.call(obj,prop)}function normalize(name,baseName){var nameParts,nameSegment,mapValue,foundMap,lastIndex,foundI,foundStarMap,starI,i,j,part,baseParts=baseName&&baseName.split("/"),map=config.map,starMap=map&&map["*"]||{};if(name&&name.charAt(0)==="."){if(baseName){baseParts=baseParts.slice(0,baseParts.length-1);name=name.split("/");lastIndex=name.length-1;if(config.nodeIdCompat&&jsSuffixRegExp.test(name[lastIndex])){name[lastIndex]=name[lastIndex].replace(jsSuffixRegExp,"")}name=baseParts.concat(name);for(i=0;i<name.length;i+=1){part=name[i];if(part==="."){name.splice(i,1);i-=1}else if(part===".."){if(i===1&&(name[2]===".."||name[0]==="..")){break}else if(i>0){name.splice(i-1,2);i-=2}}}name=name.join("/")}else if(name.indexOf("./")===0){name=name.substring(2)}}if((baseParts||starMap)&&map){nameParts=name.split("/");for(i=nameParts.length;i>0;i-=1){nameSegment=nameParts.slice(0,i).join("/");if(baseParts){for(j=baseParts.length;j>0;j-=1){mapValue=map[baseParts.slice(0,j).join("/")];if(mapValue){mapValue=mapValue[nameSegment];if(mapValue){foundMap=mapValue;foundI=i;break}}}}if(foundMap){break}if(!foundStarMap&&starMap&&starMap[nameSegment]){foundStarMap=starMap[nameSegment];starI=i}}if(!foundMap&&foundStarMap){foundMap=foundStarMap;foundI=starI}if(foundMap){nameParts.splice(0,foundI,foundMap);name=nameParts.join("/")}}return name}function makeRequire(relName,forceSync){return function(){return req.apply(undef,aps.call(arguments,0).concat([relName,forceSync]))}}function makeNormalize(relName){return function(name){return normalize(name,relName)}}function makeLoad(depName){return function(value){defined[depName]=value}}function callDep(name){if(hasProp(waiting,name)){var args=waiting[name];delete waiting[name];defining[name]=true;main.apply(undef,args)}if(!hasProp(defined,name)&&!hasProp(defining,name)){throw new Error("No "+name)}return defined[name]}function splitPrefix(name){var prefix,index=name?name.indexOf("!"):-1;if(index>-1){prefix=name.substring(0,index);name=name.substring(index+1,name.length)}return[prefix,name]}makeMap=function(name,relName){var plugin,parts=splitPrefix(name),prefix=parts[0];name=parts[1];if(prefix){prefix=normalize(prefix,relName);plugin=callDep(prefix)}if(prefix){if(plugin&&plugin.normalize){name=plugin.normalize(name,makeNormalize(relName))}else{name=normalize(name,relName)}}else{name=normalize(name,relName);parts=splitPrefix(name);prefix=parts[0];name=parts[1];if(prefix){plugin=callDep(prefix)}}return{f:prefix?prefix+"!"+name:name,n:name,pr:prefix,p:plugin}};function makeConfig(name){return function(){return config&&config.config&&config.config[name]||{}}}handlers={require:function(name){return makeRequire(name)},exports:function(name){var e=defined[name];if(typeof e!=="undefined"){return e}else{return defined[name]={}}},module:function(name){return{id:name,uri:"",exports:defined[name],config:makeConfig(name)}}};main=function(name,deps,callback,relName){var cjsModule,depName,ret,map,i,args=[],callbackType=typeof callback,usingExports;relName=relName||name;if(callbackType==="undefined"||callbackType==="function"){deps=!deps.length&&callback.length?["require","exports","module"]:deps;for(i=0;i<deps.length;i+=1){map=makeMap(deps[i],relName);depName=map.f;if(depName==="require"){args[i]=handlers.require(name)}else if(depName==="exports"){args[i]=handlers.exports(name);usingExports=true}else if(depName==="module"){cjsModule=args[i]=handlers.module(name)}else if(hasProp(defined,depName)||hasProp(waiting,depName)||hasProp(defining,depName)){args[i]=callDep(depName)}else if(map.p){map.p.load(map.n,makeRequire(relName,true),makeLoad(depName),{});args[i]=defined[depName]}else{throw new Error(name+" missing "+depName)}}ret=callback?callback.apply(defined[name],args):undefined;if(name){if(cjsModule&&cjsModule.exports!==undef&&cjsModule.exports!==defined[name]){defined[name]=cjsModule.exports}else if(ret!==undef||!usingExports){defined[name]=ret}}}else if(name){defined[name]=callback}};requirejs=require=req=function(deps,callback,relName,forceSync,alt){if(typeof deps==="string"){if(handlers[deps]){return handlers[deps](callback)}return callDep(makeMap(deps,callback).f)}else if(!deps.splice){config=deps;if(config.deps){req(config.deps,config.callback)}if(!callback){return}if(callback.splice){deps=callback;callback=relName;relName=null}else{deps=undef}}callback=callback||function(){};if(typeof relName==="function"){relName=forceSync;forceSync=alt}if(forceSync){main(undef,deps,callback,relName)}else{setTimeout(function(){main(undef,deps,callback,relName)},4)}return req};req.config=function(cfg){return req(cfg)};requirejs._defined=defined;define=function(name,deps,callback){if(!deps.splice){callback=deps;deps=[]}if(!hasProp(defined,name)&&!hasProp(waiting,name)){waiting[name]=[name,deps,callback]}};define.amd={jQuery:true}})();define("../tools/Almond-0.2.9.min",function(){});define("virtjs",[],function(){return window.Virtjs||window.require("virtjs")});define("../../libraries/architectures/gb/././components/./cpu/instructionSets",[],function(){var Virtjs,engine,parameters;return{unprefixed:{ADC_r_n:{command:function ADC_r_n(){var rBefore=parameters[0][0];parameters[0][0]+=this.readUint8();var rAfter=parameters[0][0];parameters[0][0]+=engine.environment.cpuCarry;var rAfterCarry=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfterCarry===0;engine.environment.cpuHalf=(rAfter&15)<(rBefore&15)||(rAfterCarry&15)<(rAfter&15);engine.environment.cpuCarry=rAfter<rBefore||rAfterCarry<rAfter;return 2},debug:function(address){return{size:2,label:"adc "+[parameters[0].xRegister,Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint8(address),8)].join(", ")}}},ADC_r_r:{command:function ADC_r_r(){var rBefore=parameters[0][0];parameters[0][0]+=parameters[1][0];var rAfter=parameters[0][0];parameters[0][0]+=engine.environment.cpuCarry;var rAfterCarry=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfterCarry===0;engine.environment.cpuHalf=(rAfter&15)<(rBefore&15)||(rAfterCarry&15)<(rAfter&15);engine.environment.cpuCarry=rAfter<rBefore||rAfterCarry<rAfter;return 1},debug:function(address){return{size:1,label:"adc "+[parameters[0].xRegister,parameters[1].xRegister].join(", ")}}},ADC_r_rrm:{command:function ADC_r_rrm(){var rBefore=parameters[0][0];parameters[0][0]+=engine.mmu.readUint8(parameters[1][0]);var rAfter=parameters[0][0];parameters[0][0]+=engine.environment.cpuCarry;var rAfterCarry=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfterCarry===0;engine.environment.cpuHalf=(rAfter&15)<(rBefore&15)||(rAfterCarry&15)<(rAfter&15);engine.environment.cpuCarry=rAfter<rBefore||rAfterCarry<rAfter;return 2},debug:function(address){return{size:1,label:"adc "+[parameters[0].xRegister,"("+parameters[1].xRegister+")"].join(", ")}}},ADD_r_n:{command:function ADD_r_n(){var rBefore=parameters[0][0];parameters[0][0]+=this.readUint8();var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=(rAfter&15)<(rBefore&15);engine.environment.cpuCarry=rAfter<rBefore;return 2},debug:function(address){return{size:2,label:"add "+[parameters[0].xRegister,Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint8(address),8)].join(", ")}}},ADD_r_r:{command:function ADD_r_r(){var rBefore=parameters[0][0];parameters[0][0]+=parameters[1][0];var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=(rAfter&15)<(rBefore&15);engine.environment.cpuCarry=rAfter<rBefore;return 1},debug:function(address){return{size:1,label:"add "+[parameters[0].xRegister,parameters[1].xRegister].join(", ")}}},ADD_r_rrm:{command:function ADD_r_rrm(){var rBefore=parameters[0][0];parameters[0][0]+=engine.mmu.readUint8(parameters[1][0]);var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=(rAfter&15)<(rBefore&15);engine.environment.cpuCarry=rAfter<rBefore;return 2},debug:function(address){return{size:1,label:"add "+[parameters[0].xRegister,"("+parameters[1].xRegister+")"].join(", ")}}},ADD_rr_rr:{command:function ADD_rr_rr(){var rrBefore=parameters[0][0];parameters[0][0]+=parameters[1][0];var rrAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuHalf=(rrBefore&4095)>(rrAfter&4095);engine.environment.cpuCarry=rrBefore>rrAfter;return 2},debug:function(address){return{size:1,label:"add "+[parameters[0].xRegister,parameters[1].xRegister].join(", ")}}},ADD_rr_sn:{command:function ADD_rr_sn(){var rrBefore=parameters[0][0];parameters[0][0]+=this.readInt8();var rrAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=false;engine.environment.cpuHalf=(rrBefore&15)>(rrAfter&15);engine.environment.cpuCarry=(rrBefore&255)>(rrAfter&255);return 4},debug:function(address){return{size:2,label:"add "+[parameters[0].xRegister,Virtjs.FormatUtil.decimal(engine.mmu.readInt8(address))].join(", ")}}},AND_n:{command:function AND_n(){engine.environment.a[0]&=this.readUint8();engine.environment.cpuBCD=false;engine.environment.cpuZero=engine.environment.a[0]===0;engine.environment.cpuHalf=true;engine.environment.cpuCarry=false;return 2},debug:function(address){return{size:2,label:"and "+[Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint8(address),8)].join(", ")}}},AND_r:{command:function AND_r(){engine.environment.a[0]&=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=engine.environment.a[0]===0;engine.environment.cpuHalf=true;engine.environment.cpuCarry=false;return 1},debug:function(address){return{size:1,label:"and "+[parameters[0].xRegister].join(", ")}}},AND_rrm:{command:function AND_rrm(){engine.environment.a[0]&=engine.mmu.readUint16(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=engine.environment.a[0]===0;engine.environment.cpuHalf=true;engine.environment.cpuCarry=false;return 2},debug:function(address){return{size:1,label:"and "+["("+parameters[0].xRegister+")"].join(", ")}}},CALL_C_nn:{command:function CALL_C_nn(){var target=this.readUint16();if(!engine.environment.cpuCarry)return 3;this.push(engine.environment.pc[0]);engine.environment.pc[0]=target;return 6},debug:function(address){return{size:3,label:"call c "+[Virtjs.FormatUtil.address(engine.mmu.readUint16(address),16)].join(", ")}}},CALL_NC_nn:{command:function CALL_NC_nn(){var target=this.readUint16();if(engine.environment.cpuCarry)return 3;this.push(engine.environment.pc[0]);engine.environment.pc[0]=target;return 6},debug:function(address){return{size:3,label:"call nc "+[Virtjs.FormatUtil.address(engine.mmu.readUint16(address),16)].join(", ")}}},CALL_NZ_nn:{command:function CALL_NZ_nn(){var target=this.readUint16();if(engine.environment.cpuZero)return 3;this.push(engine.environment.pc[0]);engine.environment.pc[0]=target;return 6},debug:function(address){return{size:3,label:"call nz "+[Virtjs.FormatUtil.address(engine.mmu.readUint16(address),16)].join(", ")}}},CALL_Z_nn:{command:function CALL_Z_nn(){var target=this.readUint16();if(!engine.environment.cpuZero)return 3;this.push(engine.environment.pc[0]);engine.environment.pc[0]=target;return 6},debug:function(address){return{size:3,label:"call z "+[Virtjs.FormatUtil.address(engine.mmu.readUint16(address),16)].join(", ")}}},CALL_nn:{command:function CALL_nn(){var target=this.readUint16();this.push(engine.environment.pc[0]);engine.environment.pc[0]=target;return 6},debug:function(address){return{size:3,label:"call "+[Virtjs.FormatUtil.address(engine.mmu.readUint16(address),16)].join(", ")}}},CCF:{command:function CCF(){engine.environment.cpuBCD=false;engine.environment.cpuHalf=false;engine.environment.cpuCarry=!engine.environment.cpuCarry;return 1},debug:function(address){return{size:1,label:"ccf"}}},CPL:{command:function CPL(){engine.environment.a[0]=~engine.environment.a[0];engine.environment.cpuBCD=true;engine.environment.cpuHalf=true;return 1},debug:function(address){return{size:1,label:"cpl"}}},CP_n:{command:function CP_n(){var a=engine.environment.a[0];var n=this.readUint8();var cmp=a-n&255;engine.environment.cpuBCD=true;engine.environment.cpuZero=cmp===0;engine.environment.cpuHalf=(cmp&15)>(a&15);engine.environment.cpuCarry=cmp>a;return 2},debug:function(address){return{size:2,label:"cp "+[Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint8(address),8)].join(", ")}}},CP_r:{command:function CP_r(){var a=engine.environment.a[0];var r=parameters[0][0];var cmp=a-r&255;engine.environment.cpuBCD=true;engine.environment.cpuZero=cmp===0;engine.environment.cpuHalf=(cmp&15)>(a&15);engine.environment.cpuCarry=cmp>a;return 1},debug:function(address){return{size:1,label:"cp "+[parameters[0].xRegister].join(", ")}}},CP_rrm:{command:function CP_rrm(){var a=engine.environment.a[0];var r=engine.mmu.readUint8(parameters[0][0]);var cmp=a-r&255;engine.environment.cpuBCD=true;engine.environment.cpuZero=cmp===0;engine.environment.cpuHalf=(cmp&15)>(a&15);engine.environment.cpuCarry=cmp>a;return 2},debug:function(address){return{size:1,label:"cp "+["("+parameters[0].xRegister+")"].join(", ")}}},DAA:{command:function DAA(){var correction=0;correction|=engine.environment.cpuHalf?6:0;correction|=engine.environment.cpuCarry?96:0;if(engine.environment.cpuBCD){engine.environment.a[0]-=correction}else{correction|=(engine.environment.a[0]&15)>9?6:0;correction|=(engine.environment.a[0]&255)>153?96:0;engine.environment.a[0]+=correction}engine.environment.cpuZero=engine.environment.a[0]===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(correction&96)===96;return 1},debug:function(address){return{size:1,label:"daa"}}},DEC_r:{command:function DEC_r(){var rBefore=parameters[0][0];parameters[0][0]-=1;var rAfter=parameters[0][0];engine.environment.cpuBCD=true;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=(rAfter&15)===15;return 1},debug:function(address){return{size:1,label:"dec "+[parameters[0].xRegister].join(", ")}}},DEC_rr:{command:function DEC_rr(){parameters[0][0]-=1;return 2},debug:function(address){return{size:1,label:"dec "+[parameters[0].xRegister].join(", ")}}},DEC_rrm:{command:function DEC_rrm(){var rrmBefore=engine.mmu.readUint8(parameters[0][0]);engine.mmu.writeUint8(parameters[0][0],rrmBefore-1);var rrmAfter=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=true;engine.environment.cpuZero=rrmAfter===0;engine.environment.cpuHalf=(rrmAfter&15)===15;return 3},debug:function(address){return{size:1,label:"dec "+["("+parameters[0].xRegister+")"].join(", ")}}},DI:{command:function DI(){engine.environment.cpuInterruptFeature=false;return 1},debug:function(address){return{size:1,label:"di"}}},EI:{command:function EI(){engine.environment.cpuInterruptFeature=true;return 1},debug:function(address){return{size:1,label:"ei"}}},HALT:{command:function HALT(){engine.environment.cpuHalt=true;return 1},debug:function(address){return{size:1,label:"halt"}}},INC_r:{command:function INC_r(){var rBefore=parameters[0][0];parameters[0][0]+=1;var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=(rAfter&15)===0;return 1},debug:function(address){return{size:1,label:"inc "+[parameters[0].xRegister].join(", ")}}},INC_rr:{command:function INC_rr(){parameters[0][0]+=1;return 2},debug:function(address){return{size:1,label:"inc "+[parameters[0].xRegister].join(", ")}}},INC_rrm:{command:function INC_rrm(){var rrmBefore=engine.mmu.readUint8(parameters[0][0]);engine.mmu.writeUint8(parameters[0][0],rrmBefore+1);var rrmAfter=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=rrmAfter===0;engine.environment.cpuHalf=(rrmAfter&15)===0;return 3},debug:function(address){return{size:1,label:"inc "+["("+parameters[0].xRegister+")"].join(", ")}}},JP_C_nn:{command:function JP_C_nn(){var target=this.readUint16();if(!engine.environment.cpuCarry)return 3;engine.environment.pc[0]=target;return 4},debug:function(address){return{size:3,label:"jp c "+[Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint16(address),16)].join(", ")}}},JP_NC_nn:{command:function JP_NC_nn(){var target=this.readUint16();if(engine.environment.cpuCarry)return 3;engine.environment.pc[0]=target;return 4},debug:function(address){return{size:3,label:"jp nc "+[Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint16(address),16)].join(", ")}}},JP_NZ_nn:{command:function JP_NZ_nn(){var target=this.readUint16();if(engine.environment.cpuZero)return 3;engine.environment.pc[0]=target;return 4},debug:function(address){return{size:3,label:"jp nz "+[Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint16(address),16)].join(", ")}}},JP_Z_nn:{command:function JP_Z_nn(){var target=this.readUint16();if(!engine.environment.cpuZero)return 3;engine.environment.pc[0]=target;return 4},debug:function(address){return{size:3,label:"jp z "+[Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint16(address),16)].join(", ")}}},JP_nn:{command:function JP_nn(){var target=this.readUint16();engine.environment.pc[0]=target;return 4},debug:function(address){return{size:3,label:"jp "+[Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint16(address),16)].join(", ")}}},JP_rr:{command:function JP_rr(){engine.environment.pc[0]=parameters[0][0];return 1},debug:function(address){return{size:1,label:"jp "+[parameters[0].xRegister].join(", ")}}},JR_C_sn:{command:function JR_C_sn(){var relativeOffset=this.readInt8();if(!engine.environment.cpuCarry)return 2;engine.environment.pc[0]+=relativeOffset;return 3},debug:function(address){return{size:2,label:"jr c "+[Virtjs.FormatUtil.address(address+engine.mmu.readInt8(address)+1,16)].join(", ")}}},JR_NC_sn:{command:function JR_NC_sn(){var relativeOffset=this.readInt8();if(engine.environment.cpuCarry)return 2;engine.environment.pc[0]+=relativeOffset;return 3},debug:function(address){return{size:2,label:"jr nc "+[Virtjs.FormatUtil.address(address+engine.mmu.readInt8(address)+1,16)].join(", ")}}},JR_NZ_sn:{command:function JR_NZ_sn(){var relativeOffset=this.readInt8();if(engine.environment.cpuZero)return 2;engine.environment.pc[0]+=relativeOffset;return 3},debug:function(address){return{size:2,label:"jr nz "+[Virtjs.FormatUtil.address(address+engine.mmu.readInt8(address)+1,16)].join(", ")}}},JR_Z_sn:{command:function JR_Z_sn(){var relativeOffset=this.readInt8();if(!engine.environment.cpuZero)return 2;engine.environment.pc[0]+=relativeOffset;return 3},debug:function(address){return{size:2,label:"jr z "+[Virtjs.FormatUtil.address(address+engine.mmu.readInt8(address)+1,16)].join(", ")}}},JR_sn:{command:function JR_sn(){var relativeOffset=this.readInt8();engine.environment.pc[0]+=relativeOffset;return 3},debug:function(address){return{size:2,label:"jr "+[Virtjs.FormatUtil.address(address+engine.mmu.readInt8(address)+1,16)].join(", ")}}},LDD_r_rrm:{command:function LDD_r_rrm(){parameters[0][0]=engine.mmu.readUint8(parameters[1][0]);parameters[1][0]-=1;return 2},debug:function(address){return{size:1,label:"ldd "+[parameters[0].xRegister,"("+parameters[1].xRegister+")"].join(", ")}}},LDD_rrm_r:{command:function LDD_rrm_r(){engine.mmu.writeUint8(parameters[0][0],parameters[1][0]);parameters[0][0]-=1;return 2},debug:function(address){return{size:1,label:"ldd "+["("+parameters[0].xRegister+")",parameters[1].xRegister].join(", ")}}},LDHL_rr_n:{command:function LDHL_rr_sn(){engine.environment.hl[0]=parameters[0][0];var hlBefore=engine.environment.hl[0];engine.environment.hl[0]+=this.readInt8();var hlAfter=engine.environment.hl[0];engine.environment.cpuBCD=false;engine.environment.cpuZero=false;engine.environment.cpuHalf=(hlBefore&15)>(hlAfter&15);engine.environment.cpuCarry=(hlBefore&255)>(hlAfter&255);return 3},debug:function(address){return{size:2,label:"ldhl "+[parameters[0].xRegister,Virtjs.FormatUtil.decimal(engine.mmu.readInt8(address))].join(", ")}}},LDH_nm_r:{command:function LDH_nm_r(){engine.mmu.writeUint8(65280+this.readUint8(),parameters[0][0]);return 3},debug:function(address){return{size:2,label:"ldh "+["("+Virtjs.FormatUtil.relativeAddress(65280,engine.mmu.readUint8(address),16,8)+")",parameters[0].xRegister].join(", ")}}},LDH_r_nm:{command:function LDH_r_nm(){parameters[0][0]=engine.mmu.readUint8(65280+this.readUint8());return 3},debug:function(address){return{size:2,label:"ldh "+[parameters[0].xRegister,"("+Virtjs.FormatUtil.relativeAddress(65280,engine.mmu.readUint8(address),16,8)+")"].join(", ")}}},LDI_r_rrm:{command:function LDI_r_rrm(){parameters[0][0]=engine.mmu.readUint8(parameters[1][0]);parameters[1][0]+=1;return 2},debug:function(address){return{size:1,label:"ldi "+[parameters[0].xRegister,"("+parameters[1].xRegister+")"].join(", ")}}},LDI_rrm_r:{command:function LDI_rrm_r(){engine.mmu.writeUint8(parameters[0][0],parameters[1][0]);parameters[0][0]+=1;return 2},debug:function(address){return{size:1,label:"ldi "+["("+parameters[0].xRegister+")",parameters[1].xRegister].join(", ")}}},LD_nnm_r:{command:function LD_nnm_r(){engine.mmu.writeUint8(this.readUint16(),parameters[0][0]);return 4},debug:function(address){return{size:3,label:"ld "+[Virtjs.FormatUtil.address(engine.mmu.readUint16(address),16),parameters[0].xRegister].join(", ")}}},LD_nnm_rr:{command:function LD_nnm_rr(){engine.mmu.writeUint16(this.readUint16(),parameters[0][0]);return 5},debug:function(address){return{size:3,label:"ld "+[Virtjs.FormatUtil.address(engine.mmu.readUint16(address),16),parameters[0].xRegister].join(", ")}}},LD_r_n:{command:function LD_r_n(){parameters[0][0]=this.readUint8();return 2},debug:function(address){return{size:2,label:"ld "+[parameters[0].xRegister,Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint8(address),8)].join(", ")}}},LD_r_nnm:{command:function LD_r_nnm(){parameters[0][0]=engine.mmu.readUint8(this.readUint16());return 4},debug:function(address){return{size:3,label:"ld "+[parameters[0].xRegister,Virtjs.FormatUtil.address(engine.mmu.readUint16(address),16)].join(", ")}}},LD_r_r:{command:function LD_r_r(){parameters[0][0]=parameters[1][0];return 1},debug:function(address){return{size:1,label:"ld "+[parameters[0].xRegister,parameters[1].xRegister].join(", ")}}},LD_r_rm:{command:function LD_r_rm(){parameters[0][0]=engine.mmu.readUint8(65280+parameters[1][0]);return 2},debug:function(address){return{size:1,label:"ld "+[parameters[0].xRegister,"("+Virtjs.FormatUtil.relativeAddress(65280,parameters[1].xRegister,16,8)+")"].join(", ")}}},LD_r_rrm:{command:function LD_r_rrm(){parameters[0][0]=engine.mmu.readUint8(parameters[1][0]);return 2},debug:function(address){return{size:1,label:"ld "+[parameters[0].xRegister,"("+parameters[1].xRegister+")"].join(", ")}}},LD_rm_r:{command:function LD_rm_r(){engine.mmu.writeUint8(65280+parameters[0][0],parameters[1][0]);return 2},debug:function(address){return{size:1,label:"ld "+["("+Virtjs.FormatUtil.relativeAddress(65280,parameters[0].xRegister,16,8)+")",parameters[1].xRegister].join(", ")}}},LD_rr_nn:{command:function LD_rr_nn(){parameters[0][0]=this.readUint16();return 3},debug:function(address){return{size:3,label:"ld "+[parameters[0].xRegister,Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint16(address),16)].join(", ")}}},LD_rr_rr:{command:function LD_rr_rr(){parameters[0][0]=parameters[1][0];return 2},debug:function(address){return{size:1,label:"ld "+[parameters[0].xRegister,parameters[1].xRegister].join(", ")}}},LD_rrm_n:{command:function LD_rrm_n(){engine.mmu.writeUint8(parameters[0][0],this.readUint8());return 3},debug:function(address){return{size:2,label:"ld "+["("+parameters[0].xRegister+")",Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint8(address),8)].join(", ")}}},LD_rrm_r:{command:function LD_rrm_r(){engine.mmu.writeUint8(parameters[0][0],parameters[1][0]);return 2},debug:function(address){return{size:1,label:"ld "+["("+parameters[0].xRegister+")",parameters[1].xRegister].join(", ")}}},NOP:{command:function NOP(){return 1},debug:function(address){return{size:1,label:"nop"}}},OR_n:{command:function OR_n(){engine.environment.a[0]|=engine.mmu.readUint8(engine.environment.pc[0]);engine.environment.pc[0]+=1;engine.environment.cpuBCD=false;engine.environment.cpuZero=engine.environment.a[0]===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=false;return 2},debug:function(address){return{size:2,label:"or "+[Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint8(address),8)].join(", ")}}},OR_r:{command:function OR_r(){engine.environment.a[0]|=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=engine.environment.a[0]===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=false;return 1},debug:function(address){return{size:1,label:"or "+[parameters[0].xRegister].join(", ")}}},OR_rrm:{command:function OR_rrm(){engine.environment.a[0]|=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=engine.environment.a[0]===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=false;return 2},debug:function(address){return{size:1,label:"or "+["("+parameters[0].xRegister+")"].join(", ")}}},POP_rr:{command:function POP_rr(){parameters[0][0]=this.pop();return 3},debug:function(address){return{size:1,label:"pop "+[parameters[0].xRegister].join(", ")}}},POP_AF:{command:function POP_AF(){engine.environment.af[0]=this.pop();return 3},debug:function(address){return{size:1,label:"pop af"}}},PREFIX_CB:{command:function PREFIX_CB(){var opcode=this.readUint8();return this._opcodeMaps.cbprefixed[opcode]()},debug:function(address){var opcode=engine.mmu.readUint8(address);var instruction=this._opcodeMaps.cbprefixed[opcode];return{size:2,label:instruction.xDefinition.debug.call(this,address+1).label}}},PUSH_rr:{command:function PUSH_rr(){this.push(parameters[0][0]);return 4},debug:function(address){return{size:1,label:"push "+[parameters[0].xRegister].join(", ")}}},RET:{command:function RET(){engine.environment.pc[0]=this.pop();return 4},debug:function(address){return{size:1,label:"ret"}}},RETI:{command:function RETI(){engine.environment.pc[0]=this.pop();engine.environment.cpuInterruptFeature=true;return 4},debug:function(address){return{size:1,label:"reti"}}},RET_NC:{command:function RET_NC(){if(engine.environment.cpuCarry)return 2;engine.environment.pc[0]=this.pop();return 5},debug:function(address){return{size:1,label:"ret nc"}}},RET_NZ:{command:function RET_NZ(){if(engine.environment.cpuZero)return 2;engine.environment.pc[0]=this.pop();return 5},debug:function(address){return{size:1,label:"ret nz"}}},RET_Z:{command:function RET_Z(){if(!engine.environment.cpuZero)return 2;engine.environment.pc[0]=this.pop();return 5},debug:function(address){return{size:1,label:"ret z"}}},RET_C:{command:function RET_C(){if(!engine.environment.cpuCarry)return 2;engine.environment.pc[0]=this.pop();return 5},debug:function(address){return{size:1,label:"ret c"}}},RLA:{command:function RLA(){var carry=engine.environment.cpuCarry?1:0;var leftMostBit=engine.environment.a[0]&128?1:0;engine.environment.a[0]<<=1;engine.environment.a[0]|=carry<<0;engine.environment.cpuBCD=false;engine.environment.cpuZero=false;engine.environment.cpuHalf=false;engine.environment.cpuCarry=leftMostBit===1;return 1},debug:function(address){return{size:1,label:"rla"}}},RLCA:{command:function RLCA(){var leftMostBit=engine.environment.a[0]&128?1:0;engine.environment.a[0]<<=1;engine.environment.a[0]|=leftMostBit<<0;engine.environment.cpuBCD=false;engine.environment.cpuZero=false;engine.environment.cpuHalf=false;engine.environment.cpuCarry=leftMostBit===1;return 1},debug:function(address){return{size:1,label:"rlca"}}},RRA:{command:function RRA(){var carry=engine.environment.cpuCarry?1:0;var rightMostBit=engine.environment.a[0]&1?1:0;engine.environment.a[0]>>=1;engine.environment.a[0]|=carry<<7;engine.environment.cpuBCD=false;engine.environment.cpuZero=false;engine.environment.cpuHalf=false;engine.environment.cpuCarry=rightMostBit===1;return 1},debug:function(address){return{size:1,label:"rra"}}},RRCA:{command:function RRCA(){var rightMostBit=engine.environment.a[0]&1?1:0;engine.environment.a[0]>>=1;engine.environment.a[0]|=rightMostBit<<7;engine.environment.cpuBCD=false;engine.environment.cpuZero=false;engine.environment.cpuHalf=false;engine.environment.cpuCarry=rightMostBit===1;return 1},debug:function(address){return{size:1,label:"rrca"}}},RST_n:{command:function RST_n(){this.push(engine.environment.pc[0]);engine.environment.pc[0]=parameters[0];return 4},debug:function(address){return{size:1,label:"rst "+[Virtjs.FormatUtil.hexadecimal(parameters[0],8)].join(", ")}}},SBC_r_n:{command:function SBC_r_n(){var carryIn=engine.environment.cpuCarry?1:0;var rBefore=parameters[0][0];parameters[0][0]-=this.readUint8();var rAfter=parameters[0][0];parameters[0][0]-=carryIn;var rAfterCarry=parameters[0][0];engine.environment.cpuBCD=true;engine.environment.cpuZero=rAfterCarry===0;engine.environment.cpuHalf=(rAfter&15)>(rBefore&15)||(rAfterCarry&15)>(rAfter&15);engine.environment.cpuCarry=rAfter>rBefore||rAfterCarry>rAfter;return 2},debug:function(address){return{size:2,label:"sbc "+[parameters[0].xRegister,Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint8(address),8)].join(", ")}}},SBC_r_r:{command:function SBC_r_r(){var carryIn=engine.environment.cpuCarry?1:0;var rBefore=parameters[0][0];parameters[0][0]-=parameters[1][0];var rAfter=parameters[0][0];parameters[0][0]-=carryIn;var rAfterCarry=parameters[0][0];engine.environment.cpuBCD=true;engine.environment.cpuZero=rAfterCarry===0;engine.environment.cpuHalf=(rAfter&15)>(rBefore&15)||(rAfterCarry&15)>(rAfter&15);engine.environment.cpuCarry=rAfter>rBefore||rAfterCarry>rAfter;return 1},debug:function(address){return{size:1,label:"sbc "+[parameters[0].xRegister,parameters[1].xRegister].join(", ")}}},SBC_r_rrm:{command:function SBC_r_rrm(){var carryIn=engine.environment.cpuCarry?1:0;var rBefore=parameters[0][0];parameters[0][0]-=engine.mmu.readUint8(parameters[1][0]);var rAfter=parameters[0][0];parameters[0][0]-=carryIn;var rAfterCarry=parameters[0][0];engine.environment.cpuBCD=true;engine.environment.cpuZero=rAfterCarry===0;engine.environment.cpuHalf=(rAfter&15)>(rBefore&15)||(rAfterCarry&15)>(rAfter&15);engine.environment.cpuCarry=rAfter>rBefore||rAfterCarry>rAfter;return 2},debug:function(address){return{size:1,label:"sbc "+[parameters[0].xRegister,"("+parameters[1].xRegister+")"].join(", ")}}},SCF:{command:function SCF(){engine.environment.cpuBCD=false;engine.environment.cpuHalf=false;engine.environment.cpuCarry=true;return 1},debug:function(address){return{size:1,label:"scf"}}},STOP_0:{command:function STOP_0(){engine.environment.pc[0]+=1;return 1},debug:function(address){return{size:2,label:"stop 0"}}},SUB_n:{command:function SUB_n(){var aBefore=engine.environment.a[0];engine.environment.a[0]-=this.readUint8();var aAfter=engine.environment.a[0];engine.environment.cpuBCD=true;engine.environment.cpuZero=aAfter===0;engine.environment.cpuHalf=(aAfter&15)>(aBefore&15);engine.environment.cpuCarry=aAfter>aBefore;return 2},debug:function(address){return{size:2,label:"sub "+[Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint8(address),8)].join(", ")}}},SUB_r:{command:function SUB_r(){var aBefore=engine.environment.a[0];engine.environment.a[0]-=parameters[0][0];var aAfter=engine.environment.a[0];engine.environment.cpuBCD=true;engine.environment.cpuZero=aAfter===0;engine.environment.cpuHalf=(aAfter&15)>(aBefore&15);engine.environment.cpuCarry=aAfter>aBefore;return 1},debug:function(address){return{size:1,label:"sub "+[parameters[0].xRegister].join(", ")}}},SUB_rrm:{command:function SUB_rrm(){var aBefore=engine.environment.a[0];
engine.environment.a[0]-=engine.mmu.readUint8(parameters[0][0]);var aAfter=engine.environment.a[0];engine.environment.cpuBCD=true;engine.environment.cpuZero=aAfter===0;engine.environment.cpuHalf=(aAfter&15)>(aBefore&15);engine.environment.cpuCarry=aAfter>aBefore;return 2},debug:function(address){return{size:1,label:"sub "+["("+parameters[0].xRegister+")"].join(", ")}}},XOR_n:{command:function XOR_n(){engine.environment.a[0]^=this.readUint8();engine.environment.cpuBCD=false;engine.environment.cpuZero=engine.environment.a[0]===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=false;return 2},debug:function(address){return{size:2,label:"xor "+[Virtjs.FormatUtil.hexadecimal(engine.mmu.readUint8(address),8)].join(", ")}}},XOR_r:{command:function XOR_r(){engine.environment.a[0]^=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=engine.environment.a[0]===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=false;return 1},debug:function(address){return{size:1,label:"xor "+[parameters[0].xRegister].join(", ")}}},XOR_rrm:{command:function XOR_rrm(){engine.environment.a[0]^=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=engine.environment.a[0]===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=false;return 2},debug:function(address){return{size:1,label:"xor "+["("+parameters[0].xRegister+")"].join(", ")}}}},cbprefixed:{BIT_n_r:{command:function BIT_n_r(){var test=(parameters[1][0]&1<<parameters[0])===0;engine.environment.cpuBCD=false;engine.environment.cpuZero=test;engine.environment.cpuHalf=true;return 2},debug:function(address){return{size:2,label:"bit "+[parameters[0],parameters[1].xRegister].join(", ")}}},BIT_n_rrm:{command:function BIT_n_rrm(){var value=engine.mmu.readUint8(parameters[1][0]);var test=(value&1<<parameters[0])===0;engine.environment.cpuBCD=false;engine.environment.cpuZero=test;engine.environment.cpuHalf=true;return 3},debug:function(address){return{size:2,label:"bit "+[parameters[0],"("+parameters[1].xRegister+")"].join(", ")}}},RES_n_r:{command:function RES_n_r(){parameters[1][0]&=~(1<<parameters[0]);return 2},debug:function(address){return{size:2,label:"res "+[parameters[0],parameters[1].xRegister].join(", ")}}},RES_n_rrm:{command:function RES_n_rrm(){var newValue=engine.mmu.readUint8(parameters[1][0])&~(1<<parameters[0]);engine.mmu.writeUint8(parameters[1][0],newValue);return 4},debug:function(address){return{size:2,label:"res "+[parameters[0],"("+parameters[1].xRegister+")"].join(", ")}}},RLC_r:{command:function RLC_r(){var rBefore=parameters[0][0],leftMostBit=rBefore&128?1:0;parameters[0][0]=rBefore<<1|leftMostBit<<0;var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=leftMostBit===1;return 2},debug:function(address){return{size:2,label:"rlc "+[parameters[0].xRegister].join(", ")}}},RLC_rrm:{command:function RLC_rrm(){var rrmBefore=engine.mmu.readUint8(parameters[0][0]),leftMostBit=rrmBefore&128?1:0;engine.mmu.writeUint8(parameters[0][0],rrmBefore<<1|leftMostBit<<0);var rrmAfter=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=rrmAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=leftMostBit===1;return 4},debug:function(address){return{size:2,label:"rlc "+["("+parameters[0].xRegister+")"].join(", ")}}},RL_r:{command:function RL_r(){var carry=engine.environment.cpuCarry?1:0;var rBefore=parameters[0][0];parameters[0][0]=rBefore<<1|carry<<0;var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(rBefore&128)===128;return 2},debug:function(address){return{size:2,label:"rl "+[parameters[0].xRegister].join(", ")}}},RL_rrm:{command:function RL_rrm(){var carry=engine.environment.cpuCarry?1:0;var rrmBefore=engine.mmu.readUint8(parameters[0][0]);engine.mmu.writeUint8(parameters[0][0],rrmBefore<<1|carry<<0);var rrmAfter=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=rrmAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(rrmBefore&128)===128;return 4},debug:function(address){return{size:2,label:"rl "+["("+parameters[0].xRegister+")"].join(", ")}}},RRC_r:{command:function RRC_r(){var rBefore=parameters[0][0],rightMostBit=rBefore&1?1:0;parameters[0][0]=rBefore>>1|rightMostBit<<7;var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=rightMostBit===1;return 2},debug:function(address){return{size:2,label:"rrc "+[parameters[0].xRegister].join(", ")}}},RRC_rrm:{command:function RRC_rrm(){var rrmBefore=engine.mmu.readUint8(parameters[0][0]),rightMostBit=rrmBefore&1?1:0;engine.mmu.writeUint8(parameters[0][0],rrmBefore>>1|rightMostBit<<7);var rrmAfter=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=rrmAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=rightMostBit===1;return 4},debug:function(address){return{size:2,label:"rrc "+["("+parameters[0].xRegister+")"].join(", ")}}},RR_r:{command:function RR_r(){var carry=engine.environment.cpuCarry?1:0;var rBefore=parameters[0][0];parameters[0][0]=carry<<7|rBefore>>1;var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(rBefore&1)===1;return 2},debug:function(address){return{size:2,label:"rr "+[parameters[0].xRegister].join(", ")}}},RR_rrm:{command:function RR_rrm(){var carry=engine.environment.cpuCarry?1:0;var rrmBefore=engine.mmu.readUint8(parameters[0][0]);engine.mmu.writeUint8(parameters[0][0],carry<<7|rrmBefore>>1);var rrmAfter=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=rrmAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(rrmBefore&1)===1;return 4},debug:function(address){return{size:2,label:"rr "+["("+parameters[0].xRegister+")"].join(", ")}}},SET_n_r:{command:function SET_n_r(){parameters[1][0]|=1<<parameters[0];return 2},debug:function(address){return{size:2,label:"set "+[parameters[0],parameters[1].xRegister].join(", ")}}},SET_n_rrm:{command:function SET_n_rrm(){var newValue=engine.mmu.readUint8(parameters[1][0])|1<<parameters[0];engine.mmu.writeUint8(parameters[1][0],newValue);return 4},debug:function(address){return{size:2,label:"set "+[parameters[0],"("+parameters[1].xRegister+")"].join(", ")}}},SLA_r:{command:function SLA_r(){var rBefore=parameters[0][0];parameters[0][0]<<=1;var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(rBefore&128)===128;return 2},debug:function(address){return{size:2,label:"sla "+[parameters[0].xRegister].join(", ")}}},SLA_rrm:{command:function SLA_rrm(){var rrmBefore=engine.mmu.readUint8(parameters[0][0]);engine.mmu.writeUint8(parameters[0][0],rrmBefore<<1);var rrmAfter=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=rrmAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(rrmBefore&128)===128;return 4},debug:function(address){return{size:2,label:"sla "+["("+parameters[0].xRegister+")"].join(", ")}}},SRA_r:{command:function SRA_r(){var rBefore=parameters[0][0];parameters[0][0]=rBefore>>1|rBefore&128;var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(rBefore&1)===1;return 2},debug:function(address){return{size:2,label:"sra "+[parameters[0].xRegister].join(", ")}}},SRA_rrm:{command:function SRA_rrm(){var rrmBefore=engine.mmu.readUint8(parameters[0][0]);engine.mmu.writeUint8(parameters[0][0],rrmBefore>>1|rrmBefore&128);var rrmAfter=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=rrmAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(rrmBefore&1)===1;return 4},debug:function(address){return{size:2,label:"sra "+["("+parameters[0].xRegister+")"].join(", ")}}},SRL_r:{command:function SRL_r(){var rBefore=parameters[0][0];parameters[0][0]>>=1;var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(rBefore&1)===1;return 2},debug:function(address){return{size:2,label:"srl "+[parameters[0].xRegister].join(", ")}}},SRL_rrm:{command:function SRL_rrm(){var rrmBefore=engine.mmu.readUint8(parameters[0][0]);engine.mmu.writeUint8(parameters[0][0],rrmBefore>>1);var rrmAfter=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=rrmAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=(rrmBefore&1)===1;return 4},debug:function(address){return{size:2,label:"srl "+["("+parameters[0].xRegister+")"].join(", ")}}},SWAP_r:{command:function SWAP_r(){var rBefore=parameters[0][0];parameters[0][0]=rBefore<<4|rBefore>>4;var rAfter=parameters[0][0];engine.environment.cpuBCD=false;engine.environment.cpuZero=rAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=false;return 2},debug:function(address){return{size:2,label:"swap "+[parameters[0].xRegister].join(", ")}}},SWAP_rrm:{command:function SWAP_rrm(){var rrmBefore=engine.mmu.readUint8(parameters[0][0]);engine.mmu.writeUint8(parameters[0][0],rrmBefore<<4|rrmBefore>>4);var rrmAfter=engine.mmu.readUint8(parameters[0][0]);engine.environment.cpuBCD=false;engine.environment.cpuZero=rrmAfter===0;engine.environment.cpuHalf=false;engine.environment.cpuCarry=false;return 4},debug:function(address){return{size:2,label:"swap "+["("+parameters[0].xRegister+")"].join(", ")}}}},interruptions:{RST_n:{command:function RST_n(){this.push(engine.environment.pc[0]);engine.environment.pc[0]=parameters[0];return 4},debug:function(address){return{size:1,label:"rst "+[Virtjs.FormatUtil.hexadecimal(parameters[0],8)].join(", ")}}}}}});define("../../libraries/architectures/gb/././components/../tables/opcodeMaps",[],function(){return{interruptions:["RST_n:0x40","RST_n:0x48","RST_n:0x50","RST_n:0x60",null],unprefixed:["NOP","LD_rr:bc_nn","LD_rrm:bc_r:a","INC_rr:bc","INC_r:b","DEC_r:b","LD_r:b_n","RLCA","LD_nnm_rr:sp","ADD_rr:hl_rr:bc","LD_r:a_rrm:bc","DEC_rr:bc","INC_r:c","DEC_r:c","LD_r:c_n","RRCA","STOP_0","LD_rr:de_nn","LD_rrm:de_r:a","INC_rr:de","INC_r:d","DEC_r:d","LD_r:d_n","RLA","JR_sn","ADD_rr:hl_rr:de","LD_r:a_rrm:de","DEC_rr:de","INC_r:e","DEC_r:e","LD_r:e_n","RRA","JR_NZ_sn","LD_rr:hl_nn","LDI_rrm:hl_r:a","INC_rr:hl","INC_r:h","DEC_r:h","LD_r:h_n","DAA","JR_Z_sn","ADD_rr:hl_rr:hl","LDI_r:a_rrm:hl","DEC_rr:hl","INC_r:l","DEC_r:l","LD_r:l_n","CPL","JR_NC_sn","LD_rr:sp_nn","LDD_rrm:hl_r:a","INC_rr:sp","INC_rrm:hl","DEC_rrm:hl","LD_rrm:hl_n","SCF","JR_C_sn","ADD_rr:hl_rr:sp","LDD_r:a_rrm:hl","DEC_rr:sp","INC_r:a","DEC_r:a","LD_r:a_n","CCF","LD_r:b_r:b","LD_r:b_r:c","LD_r:b_r:d","LD_r:b_r:e","LD_r:b_r:h","LD_r:b_r:l","LD_r:b_rrm:hl","LD_r:b_r:a","LD_r:c_r:b","LD_r:c_r:c","LD_r:c_r:d","LD_r:c_r:e","LD_r:c_r:h","LD_r:c_r:l","LD_r:c_rrm:hl","LD_r:c_r:a","LD_r:d_r:b","LD_r:d_r:c","LD_r:d_r:d","LD_r:d_r:e","LD_r:d_r:h","LD_r:d_r:l","LD_r:d_rrm:hl","LD_r:d_r:a","LD_r:e_r:b","LD_r:e_r:c","LD_r:e_r:d","LD_r:e_r:e","LD_r:e_r:h","LD_r:e_r:l","LD_r:e_rrm:hl","LD_r:e_r:a","LD_r:h_r:b","LD_r:h_r:c","LD_r:h_r:d","LD_r:h_r:e","LD_r:h_r:h","LD_r:h_r:l","LD_r:h_rrm:hl","LD_r:h_r:a","LD_r:l_r:b","LD_r:l_r:c","LD_r:l_r:d","LD_r:l_r:e","LD_r:l_r:h","LD_r:l_r:l","LD_r:l_rrm:hl","LD_r:l_r:a","LD_rrm:hl_r:b","LD_rrm:hl_r:c","LD_rrm:hl_r:d","LD_rrm:hl_r:e","LD_rrm:hl_r:h","LD_rrm:hl_r:l","HALT","LD_rrm:hl_r:a","LD_r:a_r:b","LD_r:a_r:c","LD_r:a_r:d","LD_r:a_r:e","LD_r:a_r:h","LD_r:a_r:l","LD_r:a_rrm:hl","LD_r:a_r:a","ADD_r:a_r:b","ADD_r:a_r:c","ADD_r:a_r:d","ADD_r:a_r:e","ADD_r:a_r:h","ADD_r:a_r:l","ADD_r:a_rrm:hl","ADD_r:a_r:a","ADC_r:a_r:b","ADC_r:a_r:c","ADC_r:a_r:d","ADC_r:a_r:e","ADC_r:a_r:h","ADC_r:a_r:l","ADC_r:a_rrm:hl","ADC_r:a_r:a","SUB_r:b","SUB_r:c","SUB_r:d","SUB_r:e","SUB_r:h","SUB_r:l","SUB_rrm:hl","SUB_r:a","SBC_r:a_r:b","SBC_r:a_r:c","SBC_r:a_r:d","SBC_r:a_r:e","SBC_r:a_r:h","SBC_r:a_r:l","SBC_r:a_rrm:hl","SBC_r:a_r:a","AND_r:b","AND_r:c","AND_r:d","AND_r:e","AND_r:h","AND_r:l","AND_rrm:hl","AND_r:a","XOR_r:b","XOR_r:c","XOR_r:d","XOR_r:e","XOR_r:h","XOR_r:l","XOR_rrm:hl","XOR_r:a","OR_r:b","OR_r:c","OR_r:d","OR_r:e","OR_r:h","OR_r:l","OR_rrm:hl","OR_r:a","CP_r:b","CP_r:c","CP_r:d","CP_r:e","CP_r:h","CP_r:l","CP_rrm:hl","CP_r:a","RET_NZ","POP_rr:bc","JP_NZ_nn","JP_nn","CALL_NZ_nn","PUSH_rr:bc","ADD_r:a_n","RST_n:0x00","RET_Z","RET","JP_Z_nn","PREFIX_CB","CALL_Z_nn","CALL_nn","ADC_r:a_n","RST_n:0x08","RET_NC","POP_rr:de","JP_NC_nn",null,"CALL_NC_nn","PUSH_rr:de","SUB_n","RST_n:0x10","RET_C","RETI","JP_C_nn",null,"CALL_C_nn",null,"SBC_r:a_n","RST_n:0x18","LDH_nm_r:a","POP_rr:hl","LD_rm:c_r:a",null,null,"PUSH_rr:hl","AND_n","RST_n:0x20","ADD_rr:sp_sn","JP_rr:hl","LD_nnm_r:a",null,null,null,"XOR_n","RST_n:0x28","LDH_r:a_nm","POP_AF","LD_r:a_rm:c","DI",null,"PUSH_rr:af","OR_n","RST_n:0x30","LDHL_rr:sp_n","LD_rr:sp_rr:hl","LD_r:a_nnm","EI",null,null,"CP_n","RST_n:0x38"],cbprefixed:["RLC_r:b","RLC_r:c","RLC_r:d","RLC_r:e","RLC_r:h","RLC_r:l","RLC_rrm:hl","RLC_r:a","RRC_r:b","RRC_r:c","RRC_r:d","RRC_r:e","RRC_r:h","RRC_r:l","RRC_rrm:hl","RRC_r:a","RL_r:b","RL_r:c","RL_r:d","RL_r:e","RL_r:h","RL_r:l","RL_rrm:hl","RL_r:a","RR_r:b","RR_r:c","RR_r:d","RR_r:e","RR_r:h","RR_r:l","RR_rrm:hl","RR_r:a","SLA_r:b","SLA_r:c","SLA_r:d","SLA_r:e","SLA_r:h","SLA_r:l","SLA_rrm:hl","SLA_r:a","SRA_r:b","SRA_r:c","SRA_r:d","SRA_r:e","SRA_r:h","SRA_r:l","SRA_rrm:hl","SRA_r:a","SWAP_r:b","SWAP_r:c","SWAP_r:d","SWAP_r:e","SWAP_r:h","SWAP_r:l","SWAP_rrm:hl","SWAP_r:a","SRL_r:b","SRL_r:c","SRL_r:d","SRL_r:e","SRL_r:h","SRL_r:l","SRL_rrm:hl","SRL_r:a","BIT_n:0_r:b","BIT_n:0_r:c","BIT_n:0_r:d","BIT_n:0_r:e","BIT_n:0_r:h","BIT_n:0_r:l","BIT_n:0_rrm:hl","BIT_n:0_r:a","BIT_n:1_r:b","BIT_n:1_r:c","BIT_n:1_r:d","BIT_n:1_r:e","BIT_n:1_r:h","BIT_n:1_r:l","BIT_n:1_rrm:hl","BIT_n:1_r:a","BIT_n:2_r:b","BIT_n:2_r:c","BIT_n:2_r:d","BIT_n:2_r:e","BIT_n:2_r:h","BIT_n:2_r:l","BIT_n:2_rrm:hl","BIT_n:2_r:a","BIT_n:3_r:b","BIT_n:3_r:c","BIT_n:3_r:d","BIT_n:3_r:e","BIT_n:3_r:h","BIT_n:3_r:l","BIT_n:3_rrm:hl","BIT_n:3_r:a","BIT_n:4_r:b","BIT_n:4_r:c","BIT_n:4_r:d","BIT_n:4_r:e","BIT_n:4_r:h","BIT_n:4_r:l","BIT_n:4_rrm:hl","BIT_n:4_r:a","BIT_n:5_r:b","BIT_n:5_r:c","BIT_n:5_r:d","BIT_n:5_r:e","BIT_n:5_r:h","BIT_n:5_r:l","BIT_n:5_rrm:hl","BIT_n:5_r:a","BIT_n:6_r:b","BIT_n:6_r:c","BIT_n:6_r:d","BIT_n:6_r:e","BIT_n:6_r:h","BIT_n:6_r:l","BIT_n:6_rrm:hl","BIT_n:6_r:a","BIT_n:7_r:b","BIT_n:7_r:c","BIT_n:7_r:d","BIT_n:7_r:e","BIT_n:7_r:h","BIT_n:7_r:l","BIT_n:7_rrm:hl","BIT_n:7_r:a","RES_n:0_r:b","RES_n:0_r:c","RES_n:0_r:d","RES_n:0_r:e","RES_n:0_r:h","RES_n:0_r:l","RES_n:0_rrm:hl","RES_n:0_r:a","RES_n:1_r:b","RES_n:1_r:c","RES_n:1_r:d","RES_n:1_r:e","RES_n:1_r:h","RES_n:1_r:l","RES_n:1_rrm:hl","RES_n:1_r:a","RES_n:2_r:b","RES_n:2_r:c","RES_n:2_r:d","RES_n:2_r:e","RES_n:2_r:h","RES_n:2_r:l","RES_n:2_rrm:hl","RES_n:2_r:a","RES_n:3_r:b","RES_n:3_r:c","RES_n:3_r:d","RES_n:3_r:e","RES_n:3_r:h","RES_n:3_r:l","RES_n:3_rrm:hl","RES_n:3_r:a","RES_n:4_r:b","RES_n:4_r:c","RES_n:4_r:d","RES_n:4_r:e","RES_n:4_r:h","RES_n:4_r:l","RES_n:4_rrm:hl","RES_n:4_r:a","RES_n:5_r:b","RES_n:5_r:c","RES_n:5_r:d","RES_n:5_r:e","RES_n:5_r:h","RES_n:5_r:l","RES_n:5_rrm:hl","RES_n:5_r:a","RES_n:6_r:b","RES_n:6_r:c","RES_n:6_r:d","RES_n:6_r:e","RES_n:6_r:h","RES_n:6_r:l","RES_n:6_rrm:hl","RES_n:6_r:a","RES_n:7_r:b","RES_n:7_r:c","RES_n:7_r:d","RES_n:7_r:e","RES_n:7_r:h","RES_n:7_r:l","RES_n:7_rrm:hl","RES_n:7_r:a","SET_n:0_r:b","SET_n:0_r:c","SET_n:0_r:d","SET_n:0_r:e","SET_n:0_r:h","SET_n:0_r:l","SET_n:0_rrm:hl","SET_n:0_r:a","SET_n:1_r:b","SET_n:1_r:c","SET_n:1_r:d","SET_n:1_r:e","SET_n:1_r:h","SET_n:1_r:l","SET_n:1_rrm:hl","SET_n:1_r:a","SET_n:2_r:b","SET_n:2_r:c","SET_n:2_r:d","SET_n:2_r:e","SET_n:2_r:h","SET_n:2_r:l","SET_n:2_rrm:hl","SET_n:2_r:a","SET_n:3_r:b","SET_n:3_r:c","SET_n:3_r:d","SET_n:3_r:e","SET_n:3_r:h","SET_n:3_r:l","SET_n:3_rrm:hl","SET_n:3_r:a","SET_n:4_r:b","SET_n:4_r:c","SET_n:4_r:d","SET_n:4_r:e","SET_n:4_r:h","SET_n:4_r:l","SET_n:4_rrm:hl","SET_n:4_r:a","SET_n:5_r:b","SET_n:5_r:c","SET_n:5_r:d","SET_n:5_r:e","SET_n:5_r:h","SET_n:5_r:l","SET_n:5_rrm:hl","SET_n:5_r:a","SET_n:6_r:b","SET_n:6_r:c","SET_n:6_r:d","SET_n:6_r:e","SET_n:6_r:h","SET_n:6_r:l","SET_n:6_rrm:hl","SET_n:6_r:a","SET_n:7_r:b","SET_n:7_r:c","SET_n:7_r:d","SET_n:7_r:e","SET_n:7_r:h","SET_n:7_r:l","SET_n:7_rrm:hl","SET_n:7_r:a"]}});define("../../libraries/architectures/gb/././components/CPU",["virtjs","./cpu/instructionSets","../tables/opcodeMaps"],function(Virtjs,instructionSets,opcodeMaps){return Virtjs.ClassUtil.extend([Virtjs.EmitterMixin],{initialize:function(engine){this._engine=engine;Virtjs.DebugUtil.preprocessFunction(this,"step",this._engine._options)},setup:function(){this._instructionSets={};this._opcodeMaps={};Object.keys(opcodeMaps).forEach(function(namespace){var instructionSet=this._instructionSets[namespace]={};var opcodeMap=this._opcodeMaps[namespace]=[];opcodeMaps[namespace].forEach(function(prototype,index){if(!prototype)return;var generalization=prototype.replace(/:[^_]*/g,"");var definition=instructionSets[namespace][generalization];var resolvedArguments={Virtjs:Virtjs,engine:this._engine,parameters:prototype.split(/_/).filter(function(part){return part.indexOf(":")!==-1}).map(function(part){return part.split(":")}).map(function(specialization){if(specialization[0]==="n")return parseInt(specialization[1]);return this._engine.environment[specialization[1]]}.bind(this))};var instruction=Object.keys(definition).reduce(function(newDefinition,method){Virtjs.ReflectionUtil.resetScope(newDefinition,method,definition[method],resolvedArguments);newDefinition[method]=Virtjs.FunctionUtil.fastBind(newDefinition[method],this);return newDefinition}.bind(this),{});instructionSet[prototype]=instruction;opcodeMap[index]=instruction.command;instruction.command.xDefinition=instruction}.bind(this))}.bind(this))},step:function step(){if(this._engine.environment.cpuStop){this._engine._continue=false}else if(this._engine.environment.cpuHalt){var time=this._calculateHaltPeriod();var time=1;this._engine.gpu.step(time);this._engine.timer.step(time)}else{var address=this._engine.environment.pc[0];var opcode=this._engine.mmu.readUint8(address);var instruction=this._opcodeMaps.unprefixed[opcode];if(typeof preprocess!=="undefined"&&(preprocess.events||[]).indexOf("instruction")!==-1){var breakRequested=false,breakFn=function(){breakRequested=true};this.emit("instruction",{address:address,opcode:opcode,instruction:instruction,"break":breakFn});if(breakRequested){this._engine.pause();return}}this._engine.environment.pc[0]+=1;var time=instruction();this._engine.gpu.step(time);this._engine.timer.step(time)}var enabledInterrupts=this._engine.environment.enabledInterrupts;var pendingInterrupts=this._engine.environment.pendingInterrupts;var firedInterrupts=pendingInterrupts&enabledInterrupts;if(!firedInterrupts)return;this._engine.environment.cpuStop=false;this._engine.environment.cpuHalt=false;if(!this._engine.environment.cpuInterruptFeature)return;this._engine.environment.cpuInterruptFeature=false;for(var bit=0;bit<5;++bit){var mask=1<<bit;if(firedInterrupts&mask){break}}this._engine.environment.pendingInterrupts-=mask;var interruptionTime=this._opcodeMaps.interruptions[bit].call(this);this._engine.gpu.step(time);this._engine.timer.step(time)},readUint8:function(){var value=this._engine.mmu.readUint8(this._engine.environment.pc[0]);this._engine.environment.pc[0]+=1;return value},readInt8:function(){var value=this._engine.mmu.readInt8(this._engine.environment.pc[0]);this._engine.environment.pc[0]+=1;return value},readUint16:function(){var value=this._engine.mmu.readUint16(this._engine.environment.pc[0]);this._engine.environment.pc[0]+=2;return value},push:function(value){this._engine.environment.sp[0]-=2;this._engine.mmu.writeUint16(this._engine.environment.sp[0],value)},pop:function(){var value=this._engine.mmu.readUint16(this._engine.environment.sp[0],value);this._engine.environment.sp[0]+=2;return value},_calculateHaltPeriod:function(){return;if(this._engine.environment.gpuLCDFeature){if(this._engine.environment.enabledInterrupts&1){var interrupt01Period=this._engine.environment.gpuMode!==1?144*114-this._engine.environment.gpuFrameClock:298*114-this._engine.environment.gpuFrameClock;return interrupt01Period}}throw new Error}})});define("../../libraries/architectures/gb/././components/./gpu/StateMachine",["virtjs"],function(Virtjs){return Virtjs.ClassUtil.extend({initialize:function(engine){this._engine=engine},setup:function(){},step:function(cycles){this._engine.environment.gpuClock+=cycles;this._engine.environment.gpuFrameClock+=cycles;switch(this._engine.environment.gpuMode){case 0:this._hblank();break;case 1:this._vblank();break;case 2:this._oam();break;case 3:this._vram();break}},reclock:function(cycles){this._engine.environment.gpuFrameClock+=cycles;this._engine.environment.gpuLine=Math.floor(this._engine.environment.gpuFrameClock/114);if(this._engine.environment.gpuFrameClock>=144*114){this._setMode(1);this._engine.environment.gpuClock=this._engine.environment.gpuFrameClock-144*114}else{var x=this._engine.environment.gpuFrameClock%114;if((x-=20)<0){this._setMode(2);this._engine.environment.gpuClock=20+x}else if((x-=43)<0){this._setMode(3);this._engine.environment.gpuClock=43+x}else if((x-=51)<0){this._setMode(0);this._engine.environment.gpuClock=51+x}}},_setMode:function(mode){this._engine.environment.gpuMode=mode;if(mode===0){this._engine.gpu._hblank(this._engine.environment.gpuLine)}else if(mode===1){this._engine.gpu._vblank()}if(mode!==3&&this._engine.environment.gpuInterrupts&1<<3+mode){this._engine.environment.pendingInterrupts|=2}},_hblank:function(){if(this._engine.environment.gpuClock<51)return;this._engine.environment.gpuClock=0;this._engine.environment.gpuLine+=1;this._engine.environment.gpuCoincidence=this._engine.environment.gpuLine===this._engine.environment.gpuLyCompare;if(this._engine.environment.gpuCoincidence)if(this._engine.environment.gpuInterrupts&1<<6)this._engine.environment.pendingInterrupts|=2;if(this._engine.environment.gpuLine<144){this._setMode(2)}else{this._setMode(1)}},_vblank:function(){if(this._engine.environment.gpuClock<114)return;this._engine.environment.gpuClock=0;this._engine.environment.gpuLine+=1;if(this._engine.environment.gpuLine===154)this._engine.environment.gpuLine=0;this._engine.environment.gpuCoincidence=this._engine.environment.gpuLine===this._engine.environment.gpuLyCompare;if(this._engine.environment.gpuCoincidence)if(this._engine.environment.gpuInterrupts&1<<6)this._engine.environment.pendingInterrupts|=2;if(this._engine.environment.gpuLine!==0)return;this._engine.environment.gpuFrameClock=0;this._setMode(2)},_oam:function(){if(this._engine.environment.gpuClock<20)return;this._engine.environment.gpuClock=0;this._setMode(3)},_vram:function(){if(this._engine.environment.gpuClock<43)return;this._engine.environment.gpuClock=0;this._setMode(0)}})});define("../../libraries/architectures/gb/././components/GPU",["virtjs","./gpu/StateMachine"],function(Virtjs,StateMachine){var colors={0:255,1:192,2:96,3:0};return Virtjs.ClassUtil.extend({initialize:function(engine){this._engine=engine;this._states=new StateMachine(engine);this._scanline=new Uint16Array(160)},setup:function(){this._sprites=[];for(var t=0;t<40;++t)this._sprites[t]={};for(var t=0;t<160;++t)this._updateSprite(t);this._states.setup()},step:function(time){this._states.step(time)},reclock:function(time){this._states.reclock(time);this._states.step(0)},settingsMapping:function(address){if(address===0)return Virtjs.MemoryUtil.accessor(this._settingsAccess,this);if(address===1)return Virtjs.MemoryUtil.accessor(this._lcdStatusAccess,this);if(address===2)return Virtjs.MemoryUtil.accessor(this._scrollAccess,this,1);if(address===3)return Virtjs.MemoryUtil.accessor(this._scrollAccess,this,0);if(address===4)return Virtjs.MemoryUtil.accessor(this._lineAccess,this);if(address===5)return Virtjs.MemoryUtil.accessor(this._lycAccess,this);if(address===6)return Virtjs.MemoryUtil.accessor(this._oamDmaAccess,this);if(address===7)return Virtjs.MemoryUtil.accessor(this._paletteAccess,this,0);if(address===8)return Virtjs.MemoryUtil.accessor(this._paletteAccess,this,1);if(address===9)return Virtjs.MemoryUtil.accessor(this._paletteAccess,this,2);if(address===10)return Virtjs.MemoryUtil.accessor(this._windowPositionAccess,this,1);if(address===11)return Virtjs.MemoryUtil.accessor(this._windowPositionAccess,this,0);if(address===13)return Virtjs.MemoryUtil.immutable(0);if(address===15)return Virtjs.MemoryUtil.immutable(0);if(address>=40&&address<=43)return Virtjs.MemoryUtil.immutable(0);return Virtjs.MemoryUtil.unaddressable(address,16)},oamMapping:function(address){return Virtjs.MemoryUtil.accessor(this._oamAccess,this,address)},vramMapping:function(address){return Virtjs.MemoryUtil.accessor(this._vramAccess,this,address)},_settingsAccess:function(value){if(typeof value==="undefined"){return this._packSettings()}else{this._unpackSettings(value)}},_scrollAccess:function(index,value){if(typeof value==="undefined"){return this._engine.environment.gpuScrolls[index]}else{this._engine.environment.gpuScrolls[index]=value}},_windowPositionAccess:function(index,value){if(typeof value==="undefined"){return this._engine.environment.gpuWindowPosition[index]}else{this._engine.environment.gpuWindowPosition[index]=value}},_lcdStatusAccess:function(value){if(typeof value==="undefined"){return this._packLcdStatus()}else{this._engine.environment.gpuInterrupts=value&120}},_lineAccess:function(value,user){if(typeof value!=="undefined")throw new Error("Invalid write at "+Virtjs.FormatUtil.address(user,16));return this._engine.environment.gpuLine},_lycAccess:function(value){if(typeof value==="undefined"){return this._engine.environment.gpuLyCompare}else{this._engine.environment.gpuLyCompare=value}},_oamDmaAccess:function(value,user){if(typeof value==="undefined")throw new Error("Invalid read at "+Virtjs.FormatUtil.address(user,16));var start=value<<8;for(var offset=0;offset<160;++offset){this._engine.environment.oam[offset]=this._engine.mmu.readUint8(start+offset);this._updateSprite(offset)}},_paletteAccess:function(index,value){if(typeof value==="undefined"){return this._packPalette(index)}else{this._unpackPalette(index,value)}},_oamAccess:function(address,value,user){if(typeof value==="undefined"){return this._engine.environment.oam[address]}else if(!this._engine.environment.gpuLCDFeature||this._engine.environment.gpuMode===0||this._engine.environment.gpuMode===1){this._engine.environment.oam[address]=value;this._updateSprite(address)}},_vramAccess:function(address,value){if(typeof value==="undefined"){return this._engine.environment.vram[address]}else if(!this._engine.environment.gpuLCDFeature||this._engine.environment.gpuMode!==3){this._engine.environment.vram[address]=value;this._updateTile(address)}},_packSettings:function(){return(this._engine.environment.gpuBackgroundFeature?1<<0:0)|(this._engine.environment.gpuSpriteFeature?1<<1:0)|(this._engine.environment.gpuSpriteSize?1<<2:0)|(this._engine.environment.gpuBackgroundBase?1<<3:0)|(this._engine.environment.gpuTilesetBase?1<<4:0)|(this._engine.environment.gpuWindowFeature?1<<5:0)|(this._engine.environment.gpuWindowBase?1<<6:0)|(this._engine.environment.gpuLCDFeature?1<<7:0)},_unpackSettings:function(value){this._engine.environment.gpuBackgroundFeature=(value&1<<0)!==0;this._engine.environment.gpuSpriteFeature=(value&1<<1)!==0;this._engine.environment.gpuSpriteSize=(value&1<<2)!==0;this._engine.environment.gpuBackgroundBase=(value&1<<3)!==0;this._engine.environment.gpuTilesetBase=(value&1<<4)!==0;this._engine.environment.gpuWindowFeature=(value&1<<5)!==0;this._engine.environment.gpuWindowBase=(value&1<<6)!==0;this._engine.environment.gpuLCDFeature=(value&1<<7)!==0},_packLcdStatus:function(){return this._engine.environment.gpuMode<<0|this._engine.environment.gpuCoincidence<<2|this._engine.environment.gpuInterrupts<<3},_packPalette:function(index,value){var palette=this._engine.environment.palettes[index];return palette[0]<<0|palette[1]<<2|palette[2]<<4|palette[3]<<6},_unpackPalette:function(index,value){var palette=this._engine.environment.palettes[index];palette[0]=value>>0&3;palette[1]=value>>2&3;palette[2]=value>>4&3;palette[3]=value>>6&3},_updateTile:function(address){var rowAddress=address&65534;var tileIndex=rowAddress>>4;var y=rowAddress>>1&7;for(var x=0;x<8;++x){var mask=1<<7-x;this._engine.environment.tilesets[tileIndex][y][x]=(this._engine.environment.vram[rowAddress+0]&mask?1:0)|(this._engine.environment.vram[rowAddress+1]&mask?2:0)}},_updateSprite:function(address){var sprite=this._sprites[address>>2];var value=this._engine.environment.oam[address];switch(address&3){case 0:sprite.y=value-16;break;case 1:sprite.x=value-8;break;case 2:sprite.tile=value;break;case 3:sprite.palette=value&16?1:0;sprite.xflip=value&32?true:false;sprite.yflip=value&64?true:false;sprite.priority=value&128?1:0}},_hblank:function(line){for(var x=0,X=this._scanline.length;x<X;++x)this._scanline[x]=255;if(this._engine.environment.gpuLCDFeature&&this._engine.environment.gpuBackgroundFeature)this._backgroundScanline(this._scanline,line);if(this._engine.environment.gpuLCDFeature&&this._engine.environment.gpuWindowFeature)this._windowScanline(this._scanline,line);if(this._engine.environment.gpuLCDFeature&&this._engine.environment.gpuSpriteFeature)this._spritesScanline(this._scanline,line);for(var x=0,y=line,X=this._scanline.length;x<X;++x){var trueColor=this._scanline[x]&255;this._engine.devices.screen.setPixel(x,y,trueColor,trueColor,trueColor)}},_vblank:function(){this._engine.environment.pendingInterrupts|=1;if(!this._engine._disableFlush)this._engine.devices.screen.flushScreen();this._engine._continue=false},_backgroundScanline:function(scanline,line){var mapBase=this._engine.environment.gpuBackgroundBase?7168:6144;var scrollX=this._engine.environment.gpuScrolls[0];var scrollY=this._engine.environment.gpuScrolls[1];this._backgroundScanliner(scanline,mapBase,0,line,scrollX,scrollY)},_spritesScanline:function(scanline,line){var size=this._engine.environment.gpuSpriteSize?16:8;for(var t=0;t<40;++t){var sprite=this._sprites[t];if(sprite.y+size<=line||sprite.y>line)continue;var palette=this._engine.environment.palettes[1+sprite.palette];var tileIndex=sprite.tile;if(this._engine.environment.gpuSpriteSize){var isBottomTile=line-sprite.y>=8;if(sprite.yflip)isBottomTile=!isBottomTile;tileIndex=isBottomTile?tileIndex|1:tileIndex&254}var tileY=line-sprite.y&7;var tileRow=sprite.yflip?this._engine.environment.tilesets[tileIndex][7-tileY]:this._engine.environment.tilesets[tileIndex][0+tileY];for(var tileX=0;tileX<8;++tileX){var x=sprite.x+tileX;if(x<0||x>=160)continue;var actualTileX=sprite.xflip?7-tileX:tileX;var paletteIndex=tileRow[actualTileX];var trueColor=colors[palette[paletteIndex]];if(tileRow[actualTileX]===0)continue;if(scanline[x]&65280&&sprite.priority)continue;scanline[x]=paletteIndex<<8|trueColor}}},_windowScanline:function(scanline,line){var mapBase=this._engine.environment.gpuWindowBase?7168:6144;var positionX=this._engine.environment.gpuWindowPosition[0]-7;var positionY=this._engine.environment.gpuWindowPosition[1];if(positionY>line||positionY+144<=line)return;this._backgroundScanliner(scanline,mapBase,positionX,line-positionY,0,0)},_backgroundScanliner:function(scanline,base,offsetX,line,scrollX,scrollY){var tilesOffset=this._engine.environment.gpuTilesetBase?0:256;var actualY=scrollY+line&255;
var mapOffsetY=actualY>>3<<5;var tileY=actualY&7;var palette=this._engine.environment.palettes[0];for(var x=0;x<160;++x){var actualX=scrollX+offsetX+x&255;var mapOffsetX=actualX>>3&31;var tileX=actualX&7;var mapOffset=base+mapOffsetY+mapOffsetX;var tileIndex=this._engine.environment.vram[mapOffset];if(!this._engine.environment.gpuTilesetBase)if(tileIndex>127)tileIndex-=256;var paletteIndex=this._engine.environment.tilesets[tilesOffset+tileIndex][tileY][tileX];var trueColor=colors[palette[paletteIndex]];scanline[x]=paletteIndex<<8|trueColor}}})});define("../../libraries/architectures/gb/././components/IO",["virtjs"],function(Virtjs){return Virtjs.ClassUtil.extend({initialize:function(engine){this._engine=engine;this._keys={};this._engine.devices.input.on("keydown",function(key){if(!(this._keys[key&240]&(key&15)))return;this._keys[key&240]&=key^15;if(key&this._engine.environment.ioKeyColumn){this._engine.environment.pendingInterrupts[1]|=16}}.bind(this));this._engine.devices.input.on("keyup",function(key){this._keys[key&240]|=key&15}.bind(this))},setup:function(){this._keys[16]=15;this._keys[32]=15},keyMapping:function(address){if(address===0)return Virtjs.MemoryUtil.accessor(this._keyAccess,this);return Virtjs.MemoryUtil.unadressable(16)},_keyAccess:function(value){if(typeof value==="undefined"){var keyline=this._engine.environment.ioKeyColumn|15;if(this._engine.environment.ioKeyColumn&16)keyline&=this._keys[16];if(this._engine.environment.ioKeyColumn&32)keyline&=this._keys[32];return keyline}else{this._engine.environment.ioKeyColumn=value&48}}})});define("../../libraries/architectures/gb/././components/../bios",[],function(){return[49,254,255,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,119,62,252,224,71,17,4,1,33,16,128,26,205,149,0,205,150,0,19,123,254,52,32,243,17,216,0,6,8,26,19,34,35,5,32,249,62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,103,62,100,87,224,66,62,145,224,64,4,30,2,14,12,240,68,254,144,32,250,13,32,247,29,32,242,14,19,36,124,30,131,254,98,40,6,30,193,254,100,32,6,123,226,12,62,135,242,240,66,144,224,66,21,32,210,5,32,79,22,32,24,203,79,6,4,197,203,17,23,193,203,17,23,5,32,245,34,35,34,35,201,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,220,204,110,230,221,221,217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,76,33,4,1,17,168,0,26,19,190,32,254,35,125,254,52,32,245,6,25,120,134,35,5,32,251,134,32,254,62,1,224,80]});define("../../libraries/architectures/gb/././components/MMU",["virtjs","../bios"],function(Virtjs,bios){return Virtjs.ClassUtil.extend([Virtjs.EmitterMixin],{initialize:function(engine){this._engine=engine;Virtjs.DebugUtil.preprocessFunction(this,"readUint8",this._engine._options);Virtjs.DebugUtil.preprocessFunction(this,"writeUint8",this._engine._options);this._memoryDescriptors=new Array(65536);this._memoryAccessors=new Array(65536)},setup:function(){for(var t=0;t<=65535;++t){var mapping=this.mapAddress(t);if(Array.isArray(mapping)){this._memoryDescriptors[t]=mapping}else{this._memoryAccessors[t]=mapping}}},readInt8:function(address){var n=this.readUint8(address);if(n>127)n-=256;return n},readUint8:function(address){var value;var descriptor=this._memoryDescriptors[address];if(descriptor){value=descriptor[0][descriptor[1]]}else{value=this._memoryAccessors[address](void 0,address)}if(typeof preprocess!=="undefined"&&(preprocess.events||[]).indexOf("read")!==-1){var overrideFn=function(newValue){value=newValue};this.emit("read",{address:address,value:value,override:overrideFn})}return value},writeUint8:function(address,value){if(typeof preprocess!=="undefined"&&(preprocess.events||[]).indexOf("write")!==-1){var overrideFn=function(newValue){value=newValue};this.emit("write",{address:address,value:value,override:overrideFn});if(typeof value==="undefined"){return}}var descriptor=this._memoryDescriptors[address];if(descriptor){descriptor[0][descriptor[1]]=value}else{this._memoryAccessors[address](value,address)}if(typeof preprocess!=="undefined"&&(preprocess.events||[]).indexOf("post-write")!==-1){this.emit("post-write",{address:address,value:value})}},readUint16:function(address){var a=this.readUint8(address+0);var b=this.readUint8(address+1);return b<<8|a<<0},writeUint16:function(address,value){this.writeUint8(address+0,(value&255)>>0);this.writeUint8(address+1,(value&65280)>>8)},mapAddress:function(address){if(address===65535)return Virtjs.MemoryUtil.plainOldData(this._engine.environment,"enabledInterrupts");if(address>=65408&&address<65535)return Virtjs.MemoryUtil.plainOldData(this._engine.environment.hram,address-65408);if(!this._engine.environment.mmuBiosLocked&&address===65360)return Virtjs.MemoryUtil.accessor(this._biosLockAccess,this);if(address>=65392&&address<65408)return Virtjs.MemoryUtil.immutable(0);if(address>=65344&&address<65392)return this._engine.gpu.settingsMapping(address-65344);if(address>=65296&&address<65344)return Virtjs.MemoryUtil.immutable(0);if(address===65295)return Virtjs.MemoryUtil.plainOldData(this._engine.environment,"pendingInterrupts");if(address>=65284&&address<65288)return this._engine.timer.timerMapping(address-65284);if(address>=65281&&address<=65282)return Virtjs.MemoryUtil.immutable(0);if(address===65280)return this._engine.io.keyMapping(address-65280);if(address>=65184&&address<65280)return Virtjs.MemoryUtil.immutable(0);if(address>=65024&&address<65184)return this._engine.gpu.oamMapping(address-65024);if(address>=57344&&address<65024)return Virtjs.MemoryUtil.plainOldData(this._engine.environment.wram,address&8191);if(address>=49152&&address<57344)return Virtjs.MemoryUtil.plainOldData(this._engine.environment.wram,address&8191);if(address>=40960&&address<49152)return this._engine.cartridge.ramMapping(address-40960);if(address>=32768&&address<40960)return this._engine.gpu.vramMapping(address&8191);if(!this._engine.environment.mmuBiosLocked&&address<256)return Virtjs.MemoryUtil.accessor(this._biosAccess,this,address);if(address<32768)return this._engine.cartridge.romMapping(address);return Virtjs.MemoryUtil.unaddressable(address,16)},_biosLockAccess:function(value){if(typeof value==="undefined"){return 0}else{this._engine.environment.mmuBiosLocked=value!==0}},_biosAccess:function(address,value){if(typeof value==="undefined"){return bios[address]}else{return void 0}}})});define("../../libraries/architectures/gb/././components/Timer",["virtjs"],function(Virtjs){var frequencies={0:1024,1:16,2:64,3:256};return Virtjs.ClassUtil.extend({initialize:function(engine){this._engine=engine},setup:function(){this._buffers=[0,0,0];this._clocks=new Uint8Array(4);this._counterLimits=new Uint8Array(2);this._flags=new Uint8Array(1)},step:function(time){this._buffers[0]+=time*4;while(this._buffers[0]>=256){this._buffers[0]-=256;this._clocks[0]+=1}if(!this._enableTimer)return;this._buffers[1]+=time*4;var frequency=frequencies[this._counterLimits[1]];while(this._buffers[1]>=frequency){this._buffers[1]-=frequency;this._clocks[1]+=1;if(this._clocks[1]===0){this._clocks[1]=this._counterLimits[0];this._engine.environment.pendingInterrupts|=4}}},oldStep:function(time){this._buffers[0]+=time;if(this._buffers[0]>=4){this._buffers[0]-=4;this._buffers[1]+=1;if(this._buffers[1]===16){this._clocks[0]+=1;this._buffers[1]=0}if(this._enableTimer)this._buffers[2]+=1;if(this._buffers[2]===this._counterLimits[1]){this._clocks[1]+=1;this._buffers[2]=0;if(this._clocks[1]===0){this._clocks[1]=this._counterLimits[0];this._engine.environment.pendingInterrupts|=4}}}},timerMapping:function(address){if(address===0)return Virtjs.MemoryUtil.accessor(this._dividerAccess,this);if(address===1)return Virtjs.MemoryUtil.plainOldData(this._clocks,1);if(address===2)return Virtjs.MemoryUtil.plainOldData(this._counterLimits,0);if(address===3)return Virtjs.MemoryUtil.accessor(this._controlAccess,this);return Virtjs.MemoryUtil.unadressable(address,16)},_dividerAccess:function(value){if(typeof value==="undefined"){return this._clocks[0]}else{this._clocks[0]=0}},_controlAccess:function(value){if(typeof value==="undefined"){return this._packFlags()}else{this._unpackFlags(value)}},_packFlags:function(){return(this._enableTimer?1<<2:0)|this._counterLimits[1]},_unpackFlags:function(value){this._enableTimer=!!(value&4);this._counterLimits[1]=value&3}})});define("../../libraries/architectures/gb/././tables/../cartridges/MBC1",["virtjs"],function(Virtjs){return Virtjs.ClassUtil.extend({initialize:function(features,engine){this._features=features;this._engine=engine;if(this._engine.devices.data&&this._features.battery){this._engine.devices.data.on("requestSave",function(){this.save()}.bind(this))}},save:function(){if(!this._features.battery)return;if(!this._engine.devices.data)return;if(this._features.ram){this._engine.devices.data.save(this._storageName,{ram:this._engine.environment.mbc1Ram.buffer})}},setup:function(){this._storageName=this._engine.environment.ident?this._engine.environment.ident+".":"";this._storageName+="cartridge";var saved=this._engine.devices.data&&this._features.battery?this._engine.devices.data.restore(this._storageName)||{}:{};this._engine.environment.mbc1Mode=0;this._engine.environment.mbc1RamFeature=false;var ramBuffer=saved.ram||new ArrayBuffer(8192*4);this._engine.environment.mbc1Ram=new Uint8Array(ramBuffer);this._engine.environment.mbc1RomBank=1;this._engine.environment.mbc1RamBank=0;this._romBanks=[];for(var romBank=0;romBank*16384<this._engine.environment.rom.buffer.byteLength;++romBank)this._romBanks[romBank]=new Uint8Array(this._engine.environment.rom.buffer,romBank*16384,16384);this._ramBanks=[];for(var ramBank=0;ramBank*8192<this._engine.environment.mbc1Ram.buffer.byteLength;++ramBank)this._ramBanks[ramBank]=new Uint8Array(this._engine.environment.mbc1Ram.buffer,ramBank*8192,8192);this._romBank00=this._romBanks[0];this._romBankNN=null;this._ramBankNN=null;this._rebank()},romMapping:function(address){if(address<16384){return Virtjs.MemoryUtil.accessor(this._romBank00Access,this,address)}else{return Virtjs.MemoryUtil.accessor(this._romBankNNAccess,this,address-16384)}},ramMapping:function(address){return Virtjs.MemoryUtil.accessor(this._ramBankNNAccess,this,address)},_rebank:function(){var romBank=this._engine.environment.mbc1RomBank;var ramBank=this._engine.environment.mbc1RamBank;if(this._engine.environment.mbc1Mode===0){ramBank=0}else{romBank&=31}if((romBank&31)===0)romBank+=1;this._romBankNN=this._romBanks[romBank];this._ramBankNN=this._ramBanks[ramBank]},_romBank00Access:function(address,value){if(typeof value==="undefined")return this._romBank00[address];if(address<8192){this._engine.environment.mbc1RamFeature=(value&10)===10}else{this._engine.environment.mbc1RomBank&=96;this._engine.environment.mbc1RomBank|=(value&31)<<0;this._rebank()}return undefined},_romBankNNAccess:function(address,value){if(typeof value==="undefined")return this._romBankNN[address];if(address<8192){this._engine.environment.mbc1RomBank&=31;this._engine.environment.mbc1RomBank|=(value&3)<<5;this._engine.environment.mbc1RamBank=value&3;this._rebank()}else{this._engine.environment.mbc1Mode=value&1;this._rebank()}return undefined},_ramBankNNAccess:function(address,value){if(typeof value==="undefined")return this._engine.environment.mbc1RamFeature?this._ramBankNN[address]:0;if(this._engine.environment.mbc1RamFeature)this._ramBankNN[address]=value;return undefined}})});define("../../libraries/architectures/gb/././tables/../cartridges/MBC3",["virtjs"],function(Virtjs){return Virtjs.ClassUtil.extend({initialize:function(features,engine){this._features=features;this._engine=engine;if(this._engine.devices.data&&this._features.battery){this._engine.devices.data.on("requestSave",function(){this.save()}.bind(this))}},save:function(){if(!this._features.battery)return;if(!this._engine.devices.data)return;if(this._features.ram){this._engine.devices.data.save(this._storageName,{ram:this._engine.environment.mbc3Ram.buffer})}},setup:function(){this._storageName=this._engine.environment.ident?this._engine.environment.ident+".":"";this._storageName+="cartridge";var saved=this._engine.devices.data&&this._features.battery?this._engine.devices.data.restore(this._storageName)||{}:{};this._engine.environment.mbc3Mode=0;this._engine.environment.mbc3RamFeature=false;var ramBuffer=saved.ram||new ArrayBuffer(8192*4);this._engine.environment.mbc3Ram=new Uint8Array(ramBuffer);this._engine.environment.mbc3Rtc=new Uint8Array(5);this._engine.environment.mbc3Latch=new Uint8Array(1);this._engine.environment.mbc3RomBank=1;this._engine.environment.mbc3RamBank=0;this._romBanks=[];for(var romBank=0;romBank*16384<this._engine.environment.rom.buffer.byteLength;++romBank)this._romBanks[romBank]=new Uint8Array(this._engine.environment.rom.buffer,romBank*16384,16384);this._ramBanks=[];for(var ramBank=0;ramBank*8192<this._engine.environment.mbc3Ram.buffer.byteLength;++ramBank)this._ramBanks[ramBank]=new Uint8Array(this._engine.environment.mbc3Ram.buffer,ramBank*8192,8192);this._romBank00=this._romBanks[0];this._romBankNN=null;this._ramBankNN=null;this._rebank()},romMapping:function(address){if(address<16384){return Virtjs.MemoryUtil.accessor(this._romBank00Access,this,address)}else{return Virtjs.MemoryUtil.accessor(this._romBankNNAccess,this,address-16384)}},ramMapping:function(address){return Virtjs.MemoryUtil.accessor(this._ramBankNNAccess,this,address)},_rebank:function(){var romBank=this._engine.environment.mbc3RomBank;var ramBank=this._engine.environment.mbc3RamBank;this._romBankNN=this._romBanks[romBank];this._ramBankNN=this._ramBanks[ramBank]},_latch:function(){var d=new Date;var rtc=this._engine.environment.mbc3Rtc;rtc[0]=d.getSeconds();rtc[1]=d.getMinutes();rtc[2]=d.getHours();rtc[3]=0;rtc[4]=0},_romBank00Access:function(address,value){if(typeof value==="undefined")return this._romBank00[address];if(address<8192){this._engine.environment.mbc3RamFeature=(value&10)===10}else{this._engine.environment.mbc3RomBank=value&127;if(this._engine.environment.mbc3RomBank===0)this._engine.environment.mbc3RomBank+=1;this._rebank()}return undefined},_romBankNNAccess:function(address,value){if(typeof value==="undefined")return this._romBankNN[address];if(address<8192){this._engine.environment.mbc3RamFeature=value<=3;if(this._engine.environment.mbc3RamFeature){this._engine.environment.mbc3RamBank=value&3;this._engine.environment.mbc3RtcIndex=0}else{this._engine.environment.mbc3RtcIndex=value-8;this._engine.environment.mbc3RamBank=0}this._rebank()}else{var latchReady=this._engine.environment.mbc3Latch[0]===0;this._engine.environment.mbc3Latch[0]=value;var latch=latchReady&&this._engine.environment.mbc3Latch[0]===1;if(latch){this._latch()}}return undefined},_ramBankNNAccess:function(address,value){if(typeof value==="undefined"){return this._engine.environment.mbc3RamFeature?this._ramBankNN[address]:this._engine.environment.mbc3Rtc[this._engine.environment.mbc3RtcIndex]}if(this._engine.environment.mbc3RamFeature){this._ramBankNN[address]=value}else{this._engine.environment.mbc3Rtc[this._engine.environment.mbc3RtcIndex]=value}return undefined}})});define("../../libraries/architectures/gb/././tables/../cartridges/MBC5",["virtjs"],function(Virtjs){return Virtjs.ClassUtil.extend({initialize:function(features,engine){this._features=features;this._engine=engine;if(this._engine.devices.data&&this._features.battery){this._engine.devices.data.on("requestSave",function(){this.save()}.bind(this))}},save:function(){if(!this._features.battery)return;if(!this._engine.devices.data)return;if(this._features.ram){this._engine.devices.data.save(this._storageName,{ram:this._engine.environment.mbc1Ram.buffer})}},setup:function(){this._storageName=this._engine.environment.ident?this._engine.environment.ident+".":"";this._storageName+="cartridge";var saved=this._engine.devices.data&&this._features.battery?this._engine.devices.data.restore(this._storageName)||{}:{};this._engine.environment.mbc5Mode=0;this._engine.environment.mbc5RamFeature=false;var ramBuffer=saved.ram||new ArrayBuffer(8192*15);this._engine.environment.mbc5Ram=new Uint8Array(ramBuffer);this._engine.environment.mbc5RomBank=1;this._engine.environment.mbc5RamBank=0;this._romBanks=[];for(var romBank=0;romBank*16384<this._engine.environment.rom.buffer.byteLength;++romBank)this._romBanks[romBank]=new Uint8Array(this._engine.environment.rom.buffer,romBank*16384,16384);this._ramBanks=[];for(var ramBank=0;ramBank*8192<this._engine.environment.mbc5Ram.buffer.byteLength;++ramBank)this._ramBanks[ramBank]=new Uint8Array(this._engine.environment.mbc5Ram.buffer,ramBank*8192,8192);this._romBank00=this._romBanks[0];this._romBankNN=null;this._ramBankNN=null;this._rebank()},romMapping:function(address){if(address<16384){return Virtjs.MemoryUtil.accessor(this._romBank00Access,this,address)}else{return Virtjs.MemoryUtil.accessor(this._romBankNNAccess,this,address-16384)}},ramMapping:function(address){return Virtjs.MemoryUtil.accessor(this._ramBankNNAccess,this,address)},_rebank:function(){var romBank=this._engine.environment.mbc5RomBank;var ramBank=this._engine.environment.mbc5RamBank;this._romBankNN=this._romBanks[romBank];this._ramBankNN=this._ramBanks[ramBank]},_romBank00Access:function(address,value){if(typeof value==="undefined")return this._romBank00[address];if(address<8192){this._engine.environment.mbc5RamFeature=(value&10)===10}else{if(address<12288){this._engine.environment.mbc5RomBank&=256;this._engine.environment.mbc5RomBank|=value}else{this._engine.environment.mbc5RomBank&=255;this._engine.environment.mbc5RomBank|=(value&1)<<8}this._rebank()}return undefined},_romBankNNAccess:function(address,value){if(typeof value==="undefined")return this._romBankNN[address];this._engine.environment.mbc5RamBank=value&15;this._rebank()},_ramBankNNAccess:function(address,value){if(typeof value==="undefined")return this._engine.environment.mbc5RamFeature?this._ramBankNN[address]:0;if(this._engine.environment.mbc5RamFeature)this._ramBankNN[address]=value;return undefined}})});define("../../libraries/architectures/gb/././tables/../cartridges/NoMBC",["virtjs"],function(Virtjs){return Virtjs.ClassUtil.extend({initialize:function(engine){this._engine=engine},setup:function(){this._engine.environment.nombcRomBank=new Uint8Array(32768);this._engine.environment.nombcRamBank=new Uint8Array(8192);var rom=this._engine.environment.rom;for(var t=0,T=rom.length;t<T;++t){this._engine.environment.nombcRomBank[t]=rom[t]}},romMapping:function(address){return Virtjs.MemoryUtil.accessor(this._romAccess,this,address)},ramMapping:function(address){return Virtjs.MemoryUtil.plainOldData(this._engine.environment.nombcRamBank,address)},_romAccess:function(address,value){if(typeof value==="undefined"){return this._engine.environment.nombcRomBank[address]}else{return void 0}}})});define("../../libraries/architectures/gb/././tables/mbcTypes",["virtjs","../cartridges/MBC1","../cartridges/MBC3","../cartridges/MBC5","../cartridges/NoMBC"],function(Virtjs,MBC1,MBC3,MBC5,NoMBC){return{0:NoMBC,1:MBC1.bindConstructor({}),2:MBC1.bindConstructor({ram:true}),3:MBC1.bindConstructor({ram:true,battery:true}),15:MBC3.bindConstructor({}),16:MBC3.bindConstructor({timer:true}),17:MBC3.bindConstructor({timer:true,battery:true}),18:MBC3.bindConstructor({ram:true}),19:MBC3.bindConstructor({ram:true,battery:true}),25:MBC5.bindConstructor({}),26:MBC5.bindConstructor({ram:true}),27:MBC5.bindConstructor({ram:true,battery:true}),28:MBC5.bindConstructor({rumble:true}),29:MBC5.bindConstructor({rumble:true,ram:true}),30:MBC5.bindConstructor({rumble:true,ram:true,battery:true})}});define("../../libraries/architectures/gb/././Environment",["virtjs"],function(Virtjs){return Virtjs.ClassUtil.extend({initialize:function(buffer,options){this.rom=new Uint8Array(buffer);this.ident=options.ident;this.pc=new Uint16Array([0]);this.sp=new Uint16Array([65534]);this.af={};this.a=new Uint8Array(1);this.f={};this.bc=new Uint16Array(1);this.b=new Uint8Array(this.bc.buffer,1,1);this.c=new Uint8Array(this.bc.buffer,0,1);this.de=new Uint16Array(1);this.d=new Uint8Array(this.de.buffer,1,1);this.e=new Uint8Array(this.de.buffer,0,1);this.hl=new Uint16Array(1);this.h=new Uint8Array(this.hl.buffer,1,1);this.l=new Uint8Array(this.hl.buffer,0,1);this.mmuBiosLocked=false;this.gpuBackgroundFeature=true;this.gpuSpriteFeature=false;this.gpuLCDFeature=true;this.gpuCoincidence=false;this.gpuMode=2;this.gpuInterrupts=0;this.gpuLyCompare=0;this.gpuSpriteSize=0;this.gpuTilesetBase=1;this.gpuBackgroundBase=0;this.gpuScrolls=new Uint8Array(2);this.gpuWindowFeature=false;this.gpuWindowBase=0;this.gpuWindowPosition=new Uint8Array(2);this.gpuClock=0;this.gpuFrameClock=0;this.gpuLine=0;this.cpuInterruptFeature=false;this.cpuZero=false;this.cpuHalf=false;this.cpuCarry=false;this.cpuBCD=false;this.cpuMode=2;this.ioKeyColumn=0;this.enabledInterrupts=0;this.pendingInterrupts=0;this.wram=new Uint8Array(8192);this.hram=new Uint8Array(127);this.oam=new Uint8Array(175);this.vram=new Uint8Array(8192);this.nombcRomBank=null;this.nombcRamBank=null;this.mbc1Mode=null;this.mbc1RamFeature=false;this.mbc1Ram=null;this.mbc1RomBank=1;this.mbc1RamBank=0;this.mbc3Mode=null;this.mbc3RamFeature=false;this.mbc3Ram=null;this.mbc3Rtc=null;this.mbc3Latch=null;this.mbc3RomBank=1;this.mbc3RamBank=0;this.palettes=[];for(var t=0;t<4;++t)this.palettes[t]=new Uint8Array(4);this.tilesets=[];for(var t=0;t<32*32;++t){this.tilesets[t]=[];for(var y=0;y<8;++y){this.tilesets[t][y]=new Uint8Array(8)}}["af","a","f","bc","b","c","de","d","e","hl","h","l"].forEach(function(register){this[register].xRegister=register}.bind(this));Object.defineProperty(this.af,"0",{get:function(){return this.a[0]<<8|this.f[0]<<0}.bind(this),set:function(value){this.a[0]=(value&65280)>>8;this.f[0]=(value&255)>>0}.bind(this)});Object.defineProperty(this.f,"0",{get:function(){return(this.cpuBCD?64:0)|(this.cpuZero?128:0)|(this.cpuHalf?32:0)|(this.cpuCarry?16:0)}.bind(this),set:function(value){this.cpuBCD=(value&64)!==0;this.cpuZero=(value&128)!==0;this.cpuHalf=(value&32)!==0;this.cpuCarry=(value&16)!==0}.bind(this)})}})});define("../../libraries/architectures/gb/./Engine",["virtjs","./components/CPU","./components/GPU","./components/IO","./components/MMU","./components/Timer","./tables/mbcTypes","./Environment"],function(Virtjs,CPU,GPU,IO,MMU,Timer,mbcTypes,Environment){return Virtjs.Engine.extend([Virtjs.EmitterMixin],{initialize:function(){Virtjs.Engine.prototype.initialize.apply(this,arguments);this.devices=this._options.devices;this.devices.screen.setInputSize(160,144);this.environment=null;this.cpu=new CPU(this);this.gpu=new GPU(this);this.io=new IO(this);this.mmu=new MMU(this);this.timer=new Timer(this);Virtjs.DebugUtil.preprocessFunction(this,"_load",this._options);Virtjs.DebugUtil.preprocessFunction(this,"step",this._options);Virtjs.DebugUtil.preprocessFunction(this,"setIterationCountPerFrame",this._options);Virtjs.DebugUtil.preprocessFunction(this,"setMaxSubIterations",this._options);Virtjs.DebugUtil.preprocessFunction(this,"_setupEnvironment",this._options)},_load:function(romBuffer,options){options=options||{};this.environment=this._createEnvironment(romBuffer,options);this.cartridge=this._createRomMBC(this.environment);this.cpu.setup();this.gpu.setup();this.io.setup();this.timer.setup();this.cartridge.setup();this.mmu.setup();if(typeof preprocess!=="undefined"&&(preprocess.events||[]).indexOf("load")!==-1){this.emit("load")}},step:function(){if(typeof preprocess!=="undefined"&&typeof preprocess.maxSubIterations!=="undefined"){this._continue=true;for(var t=0;this._status==="running"&&this._continue&&t<this._options.maxSubIterations;++t){this.cpu.step()}}else if(typeof preprocess!=="undefined"&&typeof preprocess.iterationCountPerFrame!=="undefined"){this._disableFlush=true;for(var t=0,T=this._options.iterationCountPerFrame;t<T&&this._status==="running";++t){this._continue=true;while(this._status==="running"&&this._continue){this.cpu.step()}}this._options.devices.screen.flushScreen()}else{this._continue=true;while(this._status==="running"&&this._continue){this.cpu.step()}}},disassembleAt:function(address){try{var opcode=this.mmu.readUint8(address);var instruction=this.cpu._opcodeMaps.unprefixed[opcode]}catch(e){var infos={size:1,label:"<corrupted : cannot fetch opcode>"}}if(!infos)try{var infos=instruction?instruction.xDefinition.debug.call(this._cpu,address+1):{size:1,label:"<corrupted : null instruction>"}}catch(e){var infos={size:1,label:"<corrupted : "+e.message+">"}}infos.address=address;infos.opcode=[];for(var offset=0;offset<infos.size;++offset)infos.opcode.push(this.byteAt(address+offset));return infos},byteAt:function(address){try{return this.mmu.readUint8(address)}catch(e){return NaN}},setMaxSubIterations:function(maxSubIterations){if(typeof preprocess!=="undefined"&&typeof preprocess.maxSubIterations==="undefined")throw new Error("Cannot change the sub iteration limit of this engine - please set maxSubIterations to non-nil at creation");this._options.maxSubIterations=maxSubIterations},setIterationCountPerFrame:function(iterationCountPerFrame){if(typeof preprocess!=="undefined"&&typeof preprocess.iterationCountPerFrame==="undefined")throw new Error("Cannot change the iteration count per frame of this engine - please set iterationCountPerFrame to non-nil at creation");this._options.iterationCountPerFrame=iterationCountPerFrame},_createRomMBC:function(environment){var mbcType=environment.rom[327];if(!mbcTypes[mbcType])throw new Error("Unexpected MBC type ("+Virtjs.FormatUtil.hexadecimal(mbcType,8)+")");return new mbcTypes[mbcType](this)},_createEnvironment:function(romBuffer,options){if(options&&options.environment)return options.environment;return this._setupEnvironment(new Environment(romBuffer,options||{}))},_setupEnvironment:function(environment){if(typeof preprocess==="undefined"||!preprocess.skipBios)return environment;environment.a[0]=1;environment.f[0]=176;environment.b[0]=0;environment.c[0]=19;environment.d[0]=0;environment.e[0]=216;environment.h[0]=1;environment.l[0]=77;environment.pc[0]=256;environment.sp[0]=65534;environment.mmuBiosLocked=true;return environment}})});define("../../libraries/architectures/gb/index",["./Engine"],function(Engine){return{name:"GameBoy",Engine:Engine,RIGHT:33,LEFT:34,UP:36,DOWN:40,A:17,B:18,SELECT:20,START:24}});return require("../../libraries/architectures/gb/index")});