/*global define*/

define( [

], function ( ) {

    return {

        interruptions : [

            'RST_n:0x40',
            'RST_n:0x48',
            'RST_n:0x50',
            'RST_n:0x60',
            null

        ],

        unprefixed : [

            // 00
            'NOP',
            'LD_rr:bc_nn',
            'LD_rrm:bc_r:a',
            'INC_rr:bc',
            'INC_r:b',
            'DEC_r:b',
            'LD_r:b_n',
            'RLCA',
            'LD_nnm_rr:sp',
            'ADD_rr:hl_rr:bc',
            'LD_r:a_rrm:bc',
            'DEC_rr:bc',
            'INC_r:c',
            'DEC_r:c',
            'LD_r:c_n',
            'RRCA',

            // 10
            'STOP_0',
            'LD_rr:de_nn',
            'LD_rrm:de_r:a',
            'INC_rr:de',
            'INC_r:d',
            'DEC_r:d',
            'LD_r:d_n',
            'RLA',
            'JR_sn',
            'ADD_rr:hl_rr:de',
            'LD_r:a_rrm:de',
            'DEC_rr:de',
            'INC_r:e',
            'DEC_r:e',
            'LD_r:e_n',
            'RRA',

            // 20
            'JR_NZ_sn',
            'LD_rr:hl_nn',
            'LDI_rrm:hl_r:a',
            'INC_rr:hl',
            'INC_r:h',
            'DEC_r:h',
            'LD_r:h_n',
            'DAA',
            'JR_Z_sn',
            'ADD_rr:hl_rr:hl',
            'LDI_r:a_rrm:hl',
            'DEC_rr:hl',
            'INC_r:l',
            'DEC_r:l',
            'LD_r:l_n',
            'CPL',

            // 30
            'JR_NC_sn',
            'LD_rr:sp_nn',
            'LDD_rrm:hl_r:a',
            'INC_rr:sp',
            'INC_rrm:hl',
            'DEC_rrm:hl',
            'LD_rrm:hl_n',
            'SCF',
            'JR_C_sn',
            'ADD_rr:hl_rr:sp',
            'LDD_r:a_rrm:hl',
            'DEC_rr:sp',
            'INC_r:a',
            'DEC_r:a',
            'LD_r:a_n',
            'CCF',

            // 40
            'LD_r:b_r:b',
            'LD_r:b_r:c',
            'LD_r:b_r:d',
            'LD_r:b_r:e',
            'LD_r:b_r:h',
            'LD_r:b_r:l',
            'LD_r:b_rrm:hl',
            'LD_r:b_r:a',
            'LD_r:c_r:b',
            'LD_r:c_r:c',
            'LD_r:c_r:d',
            'LD_r:c_r:e',
            'LD_r:c_r:h',
            'LD_r:c_r:l',
            'LD_r:c_rrm:hl',
            'LD_r:c_r:a',

            // 50
            'LD_r:d_r:b',
            'LD_r:d_r:c',
            'LD_r:d_r:d',
            'LD_r:d_r:e',
            'LD_r:d_r:h',
            'LD_r:d_r:l',
            'LD_r:d_rrm:hl',
            'LD_r:d_r:a',
            'LD_r:e_r:b',
            'LD_r:e_r:c',
            'LD_r:e_r:d',
            'LD_r:e_r:e',
            'LD_r:e_r:h',
            'LD_r:e_r:l',
            'LD_r:e_rrm:hl',
            'LD_r:e_r:a',

            // 60
            'LD_r:h_r:b',
            'LD_r:h_r:c',
            'LD_r:h_r:d',
            'LD_r:h_r:e',
            'LD_r:h_r:h',
            'LD_r:h_r:l',
            'LD_r:h_rrm:hl',
            'LD_r:h_r:a',
            'LD_r:l_r:b',
            'LD_r:l_r:c',
            'LD_r:l_r:d',
            'LD_r:l_r:e',
            'LD_r:l_r:h',
            'LD_r:l_r:l',
            'LD_r:l_rrm:hl',
            'LD_r:l_r:a',

            // 70
            'LD_rrm:hl_r:b',
            'LD_rrm:hl_r:c',
            'LD_rrm:hl_r:d',
            'LD_rrm:hl_r:e',
            'LD_rrm:hl_r:h',
            'LD_rrm:hl_r:l',
            'HALT',
            'LD_rrm:hl_r:a',
            'LD_r:a_r:b',
            'LD_r:a_r:c',
            'LD_r:a_r:d',
            'LD_r:a_r:e',
            'LD_r:a_r:h',
            'LD_r:a_r:l',
            'LD_r:a_rrm:hl',
            'LD_r:a_r:a',

            // 80
            'ADD_r:a_r:b',
            'ADD_r:a_r:c',
            'ADD_r:a_r:d',
            'ADD_r:a_r:e',
            'ADD_r:a_r:h',
            'ADD_r:a_r:l',
            'ADD_r:a_rrm:hl',
            'ADD_r:a_r:a',
            'ADC_r:a_r:b',
            'ADC_r:a_r:c',
            'ADC_r:a_r:d',
            'ADC_r:a_r:e',
            'ADC_r:a_r:h',
            'ADC_r:a_r:l',
            'ADC_r:a_rrm:hl',
            'ADC_r:a_r:a',

            // 90
            'SUB_r:b',
            'SUB_r:c',
            'SUB_r:d',
            'SUB_r:e',
            'SUB_r:h',
            'SUB_r:l',
            'SUB_rrm:hl',
            'SUB_r:a',
            'SBC_r:a_r:b',
            'SBC_r:a_r:c',
            'SBC_r:a_r:d',
            'SBC_r:a_r:e',
            'SBC_r:a_r:h',
            'SBC_r:a_r:l',
            'SBC_r:a_rrm:hl',
            'SBC_r:a_r:a',

            // A0
            'AND_r:b',
            'AND_r:c',
            'AND_r:d',
            'AND_r:e',
            'AND_r:h',
            'AND_r:l',
            'AND_rrm:hl',
            'AND_r:a',
            'XOR_r:b',
            'XOR_r:c',
            'XOR_r:d',
            'XOR_r:e',
            'XOR_r:h',
            'XOR_r:l',
            'XOR_rrm:hl',
            'XOR_r:a',

            // B0
            'OR_r:b',
            'OR_r:c',
            'OR_r:d',
            'OR_r:e',
            'OR_r:h',
            'OR_r:l',
            'OR_rrm:hl',
            'OR_r:a',
            'CP_r:b',
            'CP_r:c',
            'CP_r:d',
            'CP_r:e',
            'CP_r:h',
            'CP_r:l',
            'CP_rrm:hl',
            'CP_r:a',

            // C0
            'RET_NZ',
            'POP_rr:bc',
            'JP_NZ_nn',
            'JP_nn',
            'CALL_NZ_nn',
            'PUSH_rr:bc',
            'ADD_r:a_n',
            'RST_n:0x00',
            'RET_Z',
            'RET',
            'JP_Z_nn',
            'PREFIX_CB',
            'CALL_Z_nn',
            'CALL_nn',
            'ADC_r:a_n',
            'RST_n:0x08',

            // D0
            'RET_NC',
            'POP_rr:de',
            'JP_NC_nn',
            null,
            'CALL_NC_nn',
            'PUSH_rr:de',
            'SUB_n',
            'RST_n:0x10',
            'RET_C',
            'RETI',
            'JP_C_nn',
            null,
            'CALL_C_nn',
            null,
            'SBC_r:a_n',
            'RST_n:0x18',

            // E0
            'LDH_nm_r:a',
            'POP_rr:hl',
            'LD_rm:c_r:a',
            null,
            null,
            'PUSH_rr:hl',
            'AND_n',
            'RST_n:0x20',
            'ADD_rr:sp_sn',
            'JP_rr:hl',
            'LD_nnm_r:a',
            null,
            null,
            null,
            'XOR_n',
            'RST_n:0x28',

            // F0
            'LDH_r:a_nm',
            'POP_AF',
            'LD_r:a_rm:c',
            'DI',
            null,
            'PUSH_rr:af',
            'OR_n',
            'RST_n:0x30',
            'LDHL_rr:sp_n',
            'LD_rr:sp_rr:hl',
            'LD_r:a_nnm',
            'EI',
            null,
            null,
            'CP_n',
            'RST_n:0x38'

        ],

        cbprefixed : [

            // 00
            'RLC_r:b',
            'RLC_r:c',
            'RLC_r:d',
            'RLC_r:e',
            'RLC_r:h',
            'RLC_r:l',
            'RLC_rrm:hl',
            'RLC_r:a',
            'RRC_r:b',
            'RRC_r:c',
            'RRC_r:d',
            'RRC_r:e',
            'RRC_r:h',
            'RRC_r:l',
            'RRC_rrm:hl',
            'RRC_r:a',

            // 10
            'RL_r:b',
            'RL_r:c',
            'RL_r:d',
            'RL_r:e',
            'RL_r:h',
            'RL_r:l',
            'RL_rrm:hl',
            'RL_r:a',
            'RR_r:b',
            'RR_r:c',
            'RR_r:d',
            'RR_r:e',
            'RR_r:h',
            'RR_r:l',
            'RR_rrm:hl',
            'RR_r:a',

            // 20
            'SLA_r:b',
            'SLA_r:c',
            'SLA_r:d',
            'SLA_r:e',
            'SLA_r:h',
            'SLA_r:l',
            'SLA_rrm:hl',
            'SLA_r:a',
            'SRA_r:b',
            'SRA_r:c',
            'SRA_r:d',
            'SRA_r:e',
            'SRA_r:h',
            'SRA_r:l',
            'SRA_rrm:hl',
            'SRA_r:a',

            // 30
            'SWAP_r:b',
            'SWAP_r:c',
            'SWAP_r:d',
            'SWAP_r:e',
            'SWAP_r:h',
            'SWAP_r:l',
            'SWAP_rrm:hl',
            'SWAP_r:a',
            'SRL_r:b',
            'SRL_r:c',
            'SRL_r:d',
            'SRL_r:e',
            'SRL_r:h',
            'SRL_r:l',
            'SRL_rrm:hl',
            'SRL_r:a',

            // 40
            'BIT_n:0_r:b',
            'BIT_n:0_r:c',
            'BIT_n:0_r:d',
            'BIT_n:0_r:e',
            'BIT_n:0_r:h',
            'BIT_n:0_r:l',
            'BIT_n:0_rrm:hl',
            'BIT_n:0_r:a',
            'BIT_n:1_r:b',
            'BIT_n:1_r:c',
            'BIT_n:1_r:d',
            'BIT_n:1_r:e',
            'BIT_n:1_r:h',
            'BIT_n:1_r:l',
            'BIT_n:1_rrm:hl',
            'BIT_n:1_r:a',

            // 50
            'BIT_n:2_r:b',
            'BIT_n:2_r:c',
            'BIT_n:2_r:d',
            'BIT_n:2_r:e',
            'BIT_n:2_r:h',
            'BIT_n:2_r:l',
            'BIT_n:2_rrm:hl',
            'BIT_n:2_r:a',
            'BIT_n:3_r:b',
            'BIT_n:3_r:c',
            'BIT_n:3_r:d',
            'BIT_n:3_r:e',
            'BIT_n:3_r:h',
            'BIT_n:3_r:l',
            'BIT_n:3_rrm:hl',
            'BIT_n:3_r:a',

            // 60
            'BIT_n:4_r:b',
            'BIT_n:4_r:c',
            'BIT_n:4_r:d',
            'BIT_n:4_r:e',
            'BIT_n:4_r:h',
            'BIT_n:4_r:l',
            'BIT_n:4_rrm:hl',
            'BIT_n:4_r:a',
            'BIT_n:5_r:b',
            'BIT_n:5_r:c',
            'BIT_n:5_r:d',
            'BIT_n:5_r:e',
            'BIT_n:5_r:h',
            'BIT_n:5_r:l',
            'BIT_n:5_rrm:hl',
            'BIT_n:5_r:a',

            // 70
            'BIT_n:6_r:b',
            'BIT_n:6_r:c',
            'BIT_n:6_r:d',
            'BIT_n:6_r:e',
            'BIT_n:6_r:h',
            'BIT_n:6_r:l',
            'BIT_n:6_rrm:hl',
            'BIT_n:6_r:a',
            'BIT_n:7_r:b',
            'BIT_n:7_r:c',
            'BIT_n:7_r:d',
            'BIT_n:7_r:e',
            'BIT_n:7_r:h',
            'BIT_n:7_r:l',
            'BIT_n:7_rrm:hl',
            'BIT_n:7_r:a',

            // 80
            'RES_n:0_r:b',
            'RES_n:0_r:c',
            'RES_n:0_r:d',
            'RES_n:0_r:e',
            'RES_n:0_r:h',
            'RES_n:0_r:l',
            'RES_n:0_rrm:hl',
            'RES_n:0_r:a',
            'RES_n:1_r:b',
            'RES_n:1_r:c',
            'RES_n:1_r:d',
            'RES_n:1_r:e',
            'RES_n:1_r:h',
            'RES_n:1_r:l',
            'RES_n:1_rrm:hl',
            'RES_n:1_r:a',

            // 90
            'RES_n:2_r:b',
            'RES_n:2_r:c',
            'RES_n:2_r:d',
            'RES_n:2_r:e',
            'RES_n:2_r:h',
            'RES_n:2_r:l',
            'RES_n:2_rrm:hl',
            'RES_n:2_r:a',
            'RES_n:3_r:b',
            'RES_n:3_r:c',
            'RES_n:3_r:d',
            'RES_n:3_r:e',
            'RES_n:3_r:h',
            'RES_n:3_r:l',
            'RES_n:3_rrm:hl',
            'RES_n:3_r:a',

            // A0
            'RES_n:4_r:b',
            'RES_n:4_r:c',
            'RES_n:4_r:d',
            'RES_n:4_r:e',
            'RES_n:4_r:h',
            'RES_n:4_r:l',
            'RES_n:4_rrm:hl',
            'RES_n:4_r:a',
            'RES_n:5_r:b',
            'RES_n:5_r:c',
            'RES_n:5_r:d',
            'RES_n:5_r:e',
            'RES_n:5_r:h',
            'RES_n:5_r:l',
            'RES_n:5_rrm:hl',
            'RES_n:5_r:a',

            // B0
            'RES_n:6_r:b',
            'RES_n:6_r:c',
            'RES_n:6_r:d',
            'RES_n:6_r:e',
            'RES_n:6_r:h',
            'RES_n:6_r:l',
            'RES_n:6_rrm:hl',
            'RES_n:6_r:a',
            'RES_n:7_r:b',
            'RES_n:7_r:c',
            'RES_n:7_r:d',
            'RES_n:7_r:e',
            'RES_n:7_r:h',
            'RES_n:7_r:l',
            'RES_n:7_rrm:hl',
            'RES_n:7_r:a',

            // C0
            'SET_n:0_r:b',
            'SET_n:0_r:c',
            'SET_n:0_r:d',
            'SET_n:0_r:e',
            'SET_n:0_r:h',
            'SET_n:0_r:l',
            'SET_n:0_rrm:hl',
            'SET_n:0_r:a',
            'SET_n:1_r:b',
            'SET_n:1_r:c',
            'SET_n:1_r:d',
            'SET_n:1_r:e',
            'SET_n:1_r:h',
            'SET_n:1_r:l',
            'SET_n:1_rrm:hl',
            'SET_n:1_r:a',

            // D0
            'SET_n:2_r:b',
            'SET_n:2_r:c',
            'SET_n:2_r:d',
            'SET_n:2_r:e',
            'SET_n:2_r:h',
            'SET_n:2_r:l',
            'SET_n:2_rrm:hl',
            'SET_n:2_r:a',
            'SET_n:3_r:b',
            'SET_n:3_r:c',
            'SET_n:3_r:d',
            'SET_n:3_r:e',
            'SET_n:3_r:h',
            'SET_n:3_r:l',
            'SET_n:3_rrm:hl',
            'SET_n:3_r:a',

            // E0
            'SET_n:4_r:b',
            'SET_n:4_r:c',
            'SET_n:4_r:d',
            'SET_n:4_r:e',
            'SET_n:4_r:h',
            'SET_n:4_r:l',
            'SET_n:4_rrm:hl',
            'SET_n:4_r:a',
            'SET_n:5_r:b',
            'SET_n:5_r:c',
            'SET_n:5_r:d',
            'SET_n:5_r:e',
            'SET_n:5_r:h',
            'SET_n:5_r:l',
            'SET_n:5_rrm:hl',
            'SET_n:5_r:a',

            // F0
            'SET_n:6_r:b',
            'SET_n:6_r:c',
            'SET_n:6_r:d',
            'SET_n:6_r:e',
            'SET_n:6_r:h',
            'SET_n:6_r:l',
            'SET_n:6_rrm:hl',
            'SET_n:6_r:a',
            'SET_n:7_r:b',
            'SET_n:7_r:c',
            'SET_n:7_r:d',
            'SET_n:7_r:e',
            'SET_n:7_r:h',
            'SET_n:7_r:l',
            'SET_n:7_rrm:hl',
            'SET_n:7_r:a'

        ]

    };

} );
