<h1 align="center">EyeJS</h1>
<p align="center">
  <img src="https://rawgit.com/arguiot/EyeJS/master/docs/img/EyeJS-logo.svg" width="256">
<br/>
A JavaScript testing framework for the real world
<br/>
By the way, you can ⭐️ the project to support it 😊

<div align="center">
  
[![GitHub release](https://img.shields.io/github/release/arguiot/EyeJS.svg)](https://github.com/arguiot/EyeJS/releases)
[![Build Status](https://travis-ci.org/arguiot/EyeJS.svg?branch=master)](https://travis-ci.org/arguiot/EyeJS)
[![Github All Releases](https://img.shields.io/github/downloads/arguiot/EyeJS/total.svg)](https://github.com/arguiot/EyeJS/)
[![npm](https://img.shields.io/npm/dt/eye.js.svg)](https://www.npmjs.com/package/eye.js)
[![License](https://img.shields.io/github/license/arguiot/EyeJS.svg)](LICENSE)

</div>
</p>

## Getting Started

To use EyeJS, you'll need to download EyeJS via NPM, and create a `__test__` folder in your project folder, and put tests files in it. (NPM might require `sudo` on Mac).
```bash
$ npm install -g eye.js
```
## Run EyeJS
EyeJS comes with a CLI:
```bash
$ eye
```
## The full docs can be found [here](https://github.com/arguiot/EyeJS/wiki)

## Support
EyeJS is a project that required a lot of work and effort. You can show your appreciation by leaving a ⭐️. But you can also contribute in a 'financial' way by giving some XMRs (if you have no idea of what this is, look for Monero on Google) at this address:
```bash
49qzWTyu4awZFpnVRUZHCQE8xz1bcoRkCQh1nrRsTHg3if6osQqVXRoFAyGYvhDR4pZ4w8WTKQDykYy5Z2Sj6i9TAj2fiBr
```

## Contributing

Please read [CONTRIBUTING.md](./CONTRIBUTING.md) for details on our code of conduct, and the process for submitting pull requests to us.

#### Made something using the EyeJS?

Add the built with EyeJS badge to your `README.md`

[![Built with EyeJS](https://img.shields.io/badge/Built%20with-EyeJS-blue.svg)](https://img.shields.io/badge/Built%20with-EyeJS-blue.svg)


Feel free to send me an email at [arguiot@gmail.com](mailto:arguiot@gmail.com), and I might add your site to an examples section I'm currently working on.

## Examples of projects using EyeJS
- [DisplayJS](https://display.js.org)
- [Glottologist](https://glottologist.js.org)
- [CrypTools Org](https://cryptools.github.io)

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://github.com/arguiot/EyeJS/tags).

## Authors

- **Arthur Guiot** - *Initial work* - [@arguiot](https://github.com/arguiot)

Also look at the list of [contributors](https://github.com/arguiot/EyeJS/contributors) who participated in this project. If you don't code but you have great ideas, don't hesitate to write your idea in the issue part. If your idea is accepted, I will add you to this list 😊.

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details

Copyright &copy; 2017 Arthur Guiot All Rights Reserved.
