% Rust documentation

<!-- Completely hide the TOC and the section numbers -->
<style type="text/css">
#TOC { display: none; }
.header-section-number { display: none; }
</style>

[The Rust tutorial](tutorial.html)  
[The Rust reference manual](rust.html) ([PDF](rust.pdf))  

# Guides

[Pointers](guide-pointers.html)  
[References and Lifetimes](guide-lifetimes.html)  
[Containers and Iterators](guide-container.html)  
[Tasks and Communication](guide-tasks.html)  
[Foreign Function Interface](guide-ffi.html)  
[Macros](guide-macros.html)  
[Packaging](guide-rustpkg.html)  
[Testing](guide-testing.html)  
[Conditions](guide-conditions.html)  

# Libraries

[std](std/index.html)  
[extra](extra/index.html)  
[green](green/index.html)  
[native](native/index.html)  
[syntax](syntax/index.html)  
[rustc](rustc/index.html)  

# Tooling

[The rustpkg manual](rustpkg.html)  

# FAQs

[Language FAQ](complement-lang-faq.html)  
[Project FAQ](complement-project-faq.html)  
[Usage FAQ](complement-usage-faq.html)  
[Code cheatsheet](complement-cheatsheet.html) - "How do I do X?"  
[HOWTO submit a bug report](complement-bugreport.html)  

# External resources

The Rust [IRC channel](http://chat.mibbit.com/?server=irc.mozilla.org&channel=%23rust) - #rust on irc.mozilla.org  
The Rust community on [Reddit](http://reddit.com/r/rust)  
The Rust [wiki](http://github.com/mozilla/rust/wiki)  
