declare function makePlatformerTestRuntimeScene(timeDelta?: number): gdjs.RuntimeScene;
declare function addPlatformObject(runtimeScene: any): {
    _customWidth: number;
    _customHeight: number;
    _customCenterX: number | null;
    _customCenterY: number | null;
    setCustomWidthAndHeight(customWidth: any, customHeight: any): void;
    hitBoxesDirty: boolean;
    setCustomCenter(customCenterX: any, customCenterY: any): void;
    getRendererObject(): null;
    getWidth(): number;
    setWidth(width: any): number;
    getHeight(): number;
    setHeight(height: any): number;
    getCenterX(): number;
    getCenterY(): number;
    name: string;
    type: string;
    x: number;
    y: number;
    angle: number;
    zOrder: number;
    hidden: boolean;
    layer: string;
    _nameId: number;
    _livingOnScene: boolean;
    readonly id: number;
    destroyCallbacks: Set<() => void>;
    _runtimeScene: gdjs.RuntimeScene;
    persistentUuid: string | null;
    pick: boolean;
    _defaultHitBoxes: gdjs.Polygon[];
    hitBoxes: gdjs.Polygon[];
    aabb: gdjs.AABB;
    _variables: gdjs.VariablesContainer;
    _rendererEffects: Record<string, gdjs.PixiFiltersTools.Filter>;
    _forces: gdjs.Force[];
    _averageForce: gdjs.Force;
    _behaviors: gdjs.RuntimeBehavior[];
    _behaviorsTable: Hashtable<gdjs.RuntimeBehavior>;
    _timers: Hashtable<gdjs.Timer>;
    onCreated(): void;
    reinitialize(objectData: ObjectData): void;
    getElapsedTime(runtimeScene?: gdjs.RuntimeScene | undefined): number;
    getRuntimeScene(): gdjs.RuntimeScene;
    update(runtimeScene: gdjs.RuntimeScene): void;
    updatePreRender(runtimeScene: gdjs.RuntimeScene): void;
    extraInitializationFromInitialInstance(initialInstanceData: InstanceData): void;
    updateFromObjectData(oldObjectData: ObjectData, newObjectData: ObjectData): boolean;
    deleteFromScene(runtimeScene: gdjs.RuntimeScene): void;
    registerDestroyCallback(callback: () => void): void;
    unregisterDestroyCallback(callback: () => void): void;
    onDestroyFromScene(runtimeScene: gdjs.RuntimeScene): void;
    onScenePaused(runtimeScene: gdjs.RuntimeScene): void;
    onSceneResumed(runtimeScene: gdjs.RuntimeScene): void;
    getName(): string;
    getNameId(): number;
    getUniqueId(): number;
    setPosition(x: number, y: number): void;
    setX(x: number): void;
    getX(): number;
    setY(y: number): void;
    getY(): number;
    getDrawableX(): number;
    getDrawableY(): number;
    rotateTowardPosition(x: number, y: number, speed: number, scene: gdjs.RuntimeScene): void;
    rotateTowardAngle(angle: number, speed: number, runtimeScene: gdjs.RuntimeScene): void;
    rotate(speed: number, runtimeScene: gdjs.RuntimeScene): void;
    setAngle(angle: number): void;
    getAngle(): number;
    setLayer(layer: string): void;
    getLayer(): string;
    isOnLayer(layer: string): boolean;
    setZOrder(z: number): void;
    getZOrder(): number;
    getVariables(): gdjs.VariablesContainer;
    hasVariable(name: string): boolean;
    getRendererEffects(): Record<string, gdjs.PixiFiltersTools.Filter>;
    addEffect(effectData: EffectData): boolean;
    removeEffect(effectName: string): boolean;
    clearEffects(): boolean;
    setEffectDoubleParameter(name: string, parameterName: string, value: number): boolean;
    setEffectStringParameter(name: string, parameterName: string, value: string): boolean;
    setEffectBooleanParameter(name: string, parameterName: string, value: boolean): boolean;
    updateAllEffectParameters(effectData: EffectData): boolean;
    enableEffect(name: string, enable: boolean): void;
    isEffectEnabled(name: string): boolean;
    hasEffect(name: string): boolean;
    hide(enable: boolean): void;
    isVisible(): boolean;
    isHidden(): boolean;
    getCenterXInScene(): number;
    getCenterYInScene(): number;
    setCenterPositionInScene(x: number, y: number): void;
    setCenterXInScene(x: number): void;
    setCenterYInScene(y: number): void;
    _getRecycledForce(x: number, y: number, multiplier: number): gdjs.Force;
    addForce(x: number, y: number, multiplier: number): void;
    addPolarForce(angle: number, len: number, multiplier: number): void;
    addForceTowardPosition(x: number, y: number, len: number, multiplier: number): void;
    addForceTowardObject(object: gdjs.RuntimeObject, len: number, multiplier: number): void;
    clearForces(): void;
    hasNoForces(): boolean;
    updateForces(elapsedTime: number): void;
    getAverageForce(): gdjs.Force;
    averageForceAngleIs(angle: number, toleranceInDegrees: number): boolean;
    getHitBoxes(): gdjs.Polygon[];
    getHitBoxesAround(left: number, top: number, right: number, bottom: number): Iterable<gdjs.Polygon>;
    updateHitBoxes(): void;
    getAABB(): gdjs.AABB;
    getVisibilityAABB(): gdjs.AABB | null;
    updateAABB(): void;
    getAABBLeft(): number;
    getAABBTop(): number;
    getAABBRight(): number;
    getAABBBottom(): number;
    getAABBCenterX(): number;
    getAABBCenterY(): number;
    stepBehaviorsPreEvents(runtimeScene: any): void;
    stepBehaviorsPostEvents(runtimeScene: any): void;
    notifyBehaviorsObjectHotReloaded(): void;
    getBehavior(name: string): gdjs.RuntimeBehavior | null;
    hasBehavior(name: string): boolean;
    activateBehavior(name: string, enable: boolean): void;
    behaviorActivated(name: string): boolean;
    removeBehavior(name: string): boolean;
    addNewBehavior(behaviorData: BehaviorData): boolean;
    updateTimers(elapsedTime: number): void;
    timerElapsedTime(timerName: string, timeInSeconds: number): boolean;
    timerPaused(timerName: string): boolean;
    resetTimer(timerName: string): void;
    pauseTimer(timerName: string): void;
    unpauseTimer(timerName: string): void;
    removeTimer(timerName: string): void;
    getTimerElapsedTimeInSeconds(timerName: string): number;
    getTimerElapsedTimeInSecondsOrNaN(timerName: string): number;
    separateFromObjects(objects: gdjs.RuntimeObject[], ignoreTouchingEdges: boolean): boolean;
    separateFromObjectsList(objectsLists: ObjectsLists, ignoreTouchingEdges: boolean): boolean;
    getDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getSqDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getDistanceToPosition(targetX: number, targetY: number): number;
    getSqDistanceToPosition(targetX: number, targetY: number): number;
    getAngleToObject(otherObject: gdjs.RuntimeObject): number;
    getXFromAngleAndDistance(angle: number, distance: number): number;
    getYFromAngleAndDistance(angle: number, distance: number): number;
    getAngleToPosition(targetX: number, targetY: number): number;
    putAround(x: number, y: number, distance: number, angleInDegrees: number): void;
    putAroundObject(obj: gdjs.RuntimeObject, distance: number, angleInDegrees: number): void;
    separateObjectsWithoutForces(objectsLists: ObjectsLists): void;
    separateObjectsWithForces(objectsLists: ObjectsLists): void;
    raycastTest(x: number, y: number, endX: number, endY: number, closest: boolean): gdjs.RaycastTestResult;
    insideObject(x: number, y: number): boolean;
    cursorOnObject(runtimeScene: gdjs.RuntimeScene): boolean;
    isCollidingWithPoint(pointX: number, pointY: number): boolean;
    getVariableNumber: typeof gdjs.RuntimeObject.getVariableNumber;
    returnVariable: typeof gdjs.RuntimeObject.returnVariable;
    getVariableString: typeof gdjs.RuntimeObject.getVariableString;
    setVariableNumber: typeof gdjs.RuntimeObject.setVariableNumber;
    setVariableString: typeof gdjs.RuntimeObject.setVariableString;
    getVariableBoolean: (variable: gdjs.Variable, compareWith: boolean) => boolean;
    setVariableBoolean: (variable: gdjs.Variable, newValue: boolean) => void;
    toggleVariableBoolean: (variable: gdjs.Variable) => void;
    variableChildExists: typeof gdjs.RuntimeObject.variableChildExists;
    variableRemoveChild: typeof gdjs.RuntimeObject.variableRemoveChild;
    variableClearChildren: typeof gdjs.RuntimeObject.variableClearChildren;
    variablePushCopy: (array: gdjs.Variable, variable: gdjs.Variable) => void;
    valuePush: (array: gdjs.Variable, value: string | number | boolean) => void;
    variableRemoveAt: (array: gdjs.Variable, index: number) => void;
    getSqDistanceTo: (targetX: number, targetY: number) => number;
};
declare function addUpSlopePlatformObject(runtimeScene: any): {
    _customWidth: number;
    _customHeight: number;
    _unscaledWidth: number;
    _unscaledHeight: number;
    _customCenterX: number | null;
    _customCenterY: number | null;
    setCustomWidthAndHeight(customWidth: any, customHeight: any): void;
    hitBoxesDirty: any;
    setUnscaledWidthAndHeight(unscaledWidth: any, unscaledHeight: any): void;
    setCustomCenter(customCenterX: any, customCenterY: any): void;
    getRendererObject(): {};
    getWidth(): number;
    getHeight(): number;
    getCenterX(): number;
    getCenterY(): number;
    _currentAnimation: number;
    _currentDirection: number;
    _currentFrame: number;
    _frameElapsedTime: number;
    _animationSpeedScale: number;
    _animationPaused: boolean;
    _scaleX: number;
    _scaleY: number;
    _blendMode: number;
    _flippedX: boolean;
    _flippedY: boolean;
    opacity: number;
    _updateIfNotVisible: boolean;
    _animations: gdjs.SpriteAnimation[];
    _animationFrame: gdjs.SpriteAnimationFrame | null;
    _renderer: gdjs.SpriteRuntimeObjectPixiRenderer;
    _animationFrameDirty: any;
    reinitialize(spriteObjectData: gdjs.SpriteObjectData): void;
    updateFromObjectData(oldObjectData: gdjs.SpriteObjectData, newObjectData: gdjs.SpriteObjectData): boolean;
    extraInitializationFromInitialInstance(initialInstanceData: InstanceData): void;
    update(runtimeScene: gdjs.RuntimeScene): void;
    updatePreRender(runtimeScene: gdjs.RuntimeScene): void;
    _updateAnimationFrame(): void;
    updateHitBoxes(): void;
    setAnimation(newAnimation: number): void;
    setAnimationName(newAnimationName: string): void;
    getAnimation(): number;
    getAnimationName(): string;
    isCurrentAnimationName(name: any): boolean;
    setDirectionOrAngle(newValue: any): void;
    getDirectionOrAngle(): number;
    setAnimationFrame(newFrame: number): void;
    getAnimationFrame(): number;
    hasAnimationEnded(): boolean;
    animationPaused(): boolean;
    pauseAnimation(): void;
    playAnimation(): void;
    getAnimationSpeedScale(): number;
    setAnimationSpeedScale(ratio: any): void;
    getPointX(name: string): number;
    getPointY(name: string): number;
    getPointPosition(name: string): [x: number, y: number];
    _transformToGlobal(x: number, y: number, result: number[]): void;
    getDrawableX(): number;
    getDrawableY(): number;
    setX(x: number): void;
    setY(y: number): void;
    setAngle(angle: number): void;
    getAngle(): number;
    setBlendMode(newMode: any): void;
    getBlendMode(): number;
    setOpacity(opacity: number): void;
    getOpacity(): number;
    hide(enable: boolean): void;
    setColor(rgbColor: string): void;
    getColor(): string;
    flipX(enable: any): void;
    flipY(enable: any): void;
    isFlippedX(): boolean;
    isFlippedY(): boolean;
    setWidth(newWidth: number): void;
    setHeight(newHeight: number): void;
    setSize(newWidth: number, newHeight: number): void;
    setScale(newScale: number): void;
    setScaleX(newScale: number): void;
    setScaleY(newScale: number): void;
    getScale(): number;
    getScaleY(): number;
    getScaleX(): number;
    turnTowardObject(obj: any, scene: any): void;
    name: string;
    type: string;
    x: number;
    y: number;
    angle: number;
    zOrder: number;
    hidden: boolean;
    layer: string;
    _nameId: number;
    _livingOnScene: boolean;
    readonly id: number;
    destroyCallbacks: Set<() => void>;
    _runtimeScene: gdjs.RuntimeScene;
    persistentUuid: string | null;
    pick: boolean;
    _defaultHitBoxes: gdjs.Polygon[];
    hitBoxes: gdjs.Polygon[];
    aabb: gdjs.AABB;
    _variables: gdjs.VariablesContainer;
    _rendererEffects: Record<string, gdjs.PixiFiltersTools.Filter>;
    _forces: gdjs.Force[];
    _averageForce: gdjs.Force;
    _behaviors: gdjs.RuntimeBehavior[];
    _behaviorsTable: Hashtable<gdjs.RuntimeBehavior>;
    _timers: Hashtable<gdjs.Timer>;
    onCreated(): void;
    getElapsedTime(runtimeScene?: gdjs.RuntimeScene | undefined): number;
    getRuntimeScene(): gdjs.RuntimeScene;
    deleteFromScene(runtimeScene: gdjs.RuntimeScene): void;
    registerDestroyCallback(callback: () => void): void;
    unregisterDestroyCallback(callback: () => void): void;
    onDestroyFromScene(runtimeScene: gdjs.RuntimeScene): void;
    onScenePaused(runtimeScene: gdjs.RuntimeScene): void;
    onSceneResumed(runtimeScene: gdjs.RuntimeScene): void;
    getName(): string;
    getNameId(): number;
    getUniqueId(): number;
    setPosition(x: number, y: number): void;
    getX(): number;
    getY(): number;
    rotateTowardPosition(x: number, y: number, speed: number, scene: gdjs.RuntimeScene): void;
    rotateTowardAngle(angle: number, speed: number, runtimeScene: gdjs.RuntimeScene): void;
    rotate(speed: number, runtimeScene: gdjs.RuntimeScene): void;
    setLayer(layer: string): void;
    getLayer(): string;
    isOnLayer(layer: string): boolean;
    setZOrder(z: number): void;
    getZOrder(): number;
    getVariables(): gdjs.VariablesContainer;
    hasVariable(name: string): boolean;
    getRendererEffects(): Record<string, gdjs.PixiFiltersTools.Filter>;
    addEffect(effectData: EffectData): boolean;
    removeEffect(effectName: string): boolean;
    clearEffects(): boolean;
    setEffectDoubleParameter(name: string, parameterName: string, value: number): boolean;
    setEffectStringParameter(name: string, parameterName: string, value: string): boolean;
    setEffectBooleanParameter(name: string, parameterName: string, value: boolean): boolean;
    updateAllEffectParameters(effectData: EffectData): boolean;
    enableEffect(name: string, enable: boolean): void;
    isEffectEnabled(name: string): boolean;
    hasEffect(name: string): boolean;
    isVisible(): boolean;
    isHidden(): boolean;
    getCenterXInScene(): number;
    getCenterYInScene(): number;
    setCenterPositionInScene(x: number, y: number): void;
    setCenterXInScene(x: number): void;
    setCenterYInScene(y: number): void;
    _getRecycledForce(x: number, y: number, multiplier: number): gdjs.Force;
    addForce(x: number, y: number, multiplier: number): void;
    addPolarForce(angle: number, len: number, multiplier: number): void;
    addForceTowardPosition(x: number, y: number, len: number, multiplier: number): void;
    addForceTowardObject(object: gdjs.RuntimeObject, len: number, multiplier: number): void;
    clearForces(): void;
    hasNoForces(): boolean;
    updateForces(elapsedTime: number): void;
    getAverageForce(): gdjs.Force;
    averageForceAngleIs(angle: number, toleranceInDegrees: number): boolean;
    getHitBoxes(): gdjs.Polygon[];
    getHitBoxesAround(left: number, top: number, right: number, bottom: number): Iterable<gdjs.Polygon>;
    getAABB(): gdjs.AABB;
    getVisibilityAABB(): gdjs.AABB | null;
    updateAABB(): void;
    getAABBLeft(): number;
    getAABBTop(): number;
    getAABBRight(): number;
    getAABBBottom(): number;
    getAABBCenterX(): number;
    getAABBCenterY(): number;
    stepBehaviorsPreEvents(runtimeScene: any): void;
    stepBehaviorsPostEvents(runtimeScene: any): void;
    notifyBehaviorsObjectHotReloaded(): void;
    getBehavior(name: string): gdjs.RuntimeBehavior | null;
    hasBehavior(name: string): boolean;
    activateBehavior(name: string, enable: boolean): void;
    behaviorActivated(name: string): boolean;
    removeBehavior(name: string): boolean;
    addNewBehavior(behaviorData: BehaviorData): boolean;
    updateTimers(elapsedTime: number): void;
    timerElapsedTime(timerName: string, timeInSeconds: number): boolean;
    timerPaused(timerName: string): boolean;
    resetTimer(timerName: string): void;
    pauseTimer(timerName: string): void;
    unpauseTimer(timerName: string): void;
    removeTimer(timerName: string): void;
    getTimerElapsedTimeInSeconds(timerName: string): number;
    getTimerElapsedTimeInSecondsOrNaN(timerName: string): number;
    separateFromObjects(objects: gdjs.RuntimeObject[], ignoreTouchingEdges: boolean): boolean;
    separateFromObjectsList(objectsLists: ObjectsLists, ignoreTouchingEdges: boolean): boolean;
    getDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getSqDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getDistanceToPosition(targetX: number, targetY: number): number;
    getSqDistanceToPosition(targetX: number, targetY: number): number;
    getAngleToObject(otherObject: gdjs.RuntimeObject): number;
    getXFromAngleAndDistance(angle: number, distance: number): number;
    getYFromAngleAndDistance(angle: number, distance: number): number;
    getAngleToPosition(targetX: number, targetY: number): number;
    putAround(x: number, y: number, distance: number, angleInDegrees: number): void;
    putAroundObject(obj: gdjs.RuntimeObject, distance: number, angleInDegrees: number): void;
    separateObjectsWithoutForces(objectsLists: ObjectsLists): void;
    separateObjectsWithForces(objectsLists: ObjectsLists): void;
    raycastTest(x: number, y: number, endX: number, endY: number, closest: boolean): gdjs.RaycastTestResult;
    insideObject(x: number, y: number): boolean;
    cursorOnObject(runtimeScene: gdjs.RuntimeScene): boolean;
    isCollidingWithPoint(pointX: number, pointY: number): boolean;
    getVariableNumber: typeof gdjs.RuntimeObject.getVariableNumber;
    returnVariable: typeof gdjs.RuntimeObject.returnVariable;
    getVariableString: typeof gdjs.RuntimeObject.getVariableString;
    setVariableNumber: typeof gdjs.RuntimeObject.setVariableNumber;
    setVariableString: typeof gdjs.RuntimeObject.setVariableString;
    getVariableBoolean: (variable: gdjs.Variable, compareWith: boolean) => boolean;
    setVariableBoolean: (variable: gdjs.Variable, newValue: boolean) => void;
    toggleVariableBoolean: (variable: gdjs.Variable) => void;
    variableChildExists: typeof gdjs.RuntimeObject.variableChildExists;
    variableRemoveChild: typeof gdjs.RuntimeObject.variableRemoveChild;
    variableClearChildren: typeof gdjs.RuntimeObject.variableClearChildren;
    variablePushCopy: (array: gdjs.Variable, variable: gdjs.Variable) => void;
    valuePush: (array: gdjs.Variable, value: string | number | boolean) => void;
    variableRemoveAt: (array: gdjs.Variable, index: number) => void;
    getSqDistanceTo: (targetX: number, targetY: number) => number;
};
declare function addDownSlopePlatformObject(runtimeScene: any): {
    _customWidth: number;
    _customHeight: number;
    _unscaledWidth: number;
    _unscaledHeight: number;
    _customCenterX: number | null;
    _customCenterY: number | null;
    setCustomWidthAndHeight(customWidth: any, customHeight: any): void;
    hitBoxesDirty: any;
    setUnscaledWidthAndHeight(unscaledWidth: any, unscaledHeight: any): void;
    setCustomCenter(customCenterX: any, customCenterY: any): void;
    getRendererObject(): {};
    getWidth(): number;
    getHeight(): number;
    getCenterX(): number;
    getCenterY(): number;
    _currentAnimation: number;
    _currentDirection: number;
    _currentFrame: number;
    _frameElapsedTime: number;
    _animationSpeedScale: number;
    _animationPaused: boolean;
    _scaleX: number;
    _scaleY: number;
    _blendMode: number;
    _flippedX: boolean;
    _flippedY: boolean;
    opacity: number;
    _updateIfNotVisible: boolean;
    _animations: gdjs.SpriteAnimation[];
    _animationFrame: gdjs.SpriteAnimationFrame | null;
    _renderer: gdjs.SpriteRuntimeObjectPixiRenderer;
    _animationFrameDirty: any;
    reinitialize(spriteObjectData: gdjs.SpriteObjectData): void;
    updateFromObjectData(oldObjectData: gdjs.SpriteObjectData, newObjectData: gdjs.SpriteObjectData): boolean;
    extraInitializationFromInitialInstance(initialInstanceData: InstanceData): void;
    update(runtimeScene: gdjs.RuntimeScene): void;
    updatePreRender(runtimeScene: gdjs.RuntimeScene): void;
    _updateAnimationFrame(): void;
    updateHitBoxes(): void;
    setAnimation(newAnimation: number): void;
    setAnimationName(newAnimationName: string): void;
    getAnimation(): number;
    getAnimationName(): string;
    isCurrentAnimationName(name: any): boolean;
    setDirectionOrAngle(newValue: any): void;
    getDirectionOrAngle(): number;
    setAnimationFrame(newFrame: number): void;
    getAnimationFrame(): number;
    hasAnimationEnded(): boolean;
    animationPaused(): boolean;
    pauseAnimation(): void;
    playAnimation(): void;
    getAnimationSpeedScale(): number;
    setAnimationSpeedScale(ratio: any): void;
    getPointX(name: string): number;
    getPointY(name: string): number;
    getPointPosition(name: string): [x: number, y: number];
    _transformToGlobal(x: number, y: number, result: number[]): void;
    getDrawableX(): number;
    getDrawableY(): number;
    setX(x: number): void;
    setY(y: number): void;
    setAngle(angle: number): void;
    getAngle(): number;
    setBlendMode(newMode: any): void;
    getBlendMode(): number;
    setOpacity(opacity: number): void;
    getOpacity(): number;
    hide(enable: boolean): void;
    setColor(rgbColor: string): void;
    getColor(): string;
    flipX(enable: any): void;
    flipY(enable: any): void;
    isFlippedX(): boolean;
    isFlippedY(): boolean;
    setWidth(newWidth: number): void;
    setHeight(newHeight: number): void;
    setSize(newWidth: number, newHeight: number): void;
    setScale(newScale: number): void;
    setScaleX(newScale: number): void;
    setScaleY(newScale: number): void;
    getScale(): number;
    getScaleY(): number;
    getScaleX(): number;
    turnTowardObject(obj: any, scene: any): void;
    name: string;
    type: string;
    x: number;
    y: number;
    angle: number;
    zOrder: number;
    hidden: boolean;
    layer: string;
    _nameId: number;
    _livingOnScene: boolean;
    readonly id: number;
    destroyCallbacks: Set<() => void>;
    _runtimeScene: gdjs.RuntimeScene;
    persistentUuid: string | null;
    pick: boolean;
    _defaultHitBoxes: gdjs.Polygon[];
    hitBoxes: gdjs.Polygon[];
    aabb: gdjs.AABB;
    _variables: gdjs.VariablesContainer;
    _rendererEffects: Record<string, gdjs.PixiFiltersTools.Filter>;
    _forces: gdjs.Force[];
    _averageForce: gdjs.Force;
    _behaviors: gdjs.RuntimeBehavior[];
    _behaviorsTable: Hashtable<gdjs.RuntimeBehavior>;
    _timers: Hashtable<gdjs.Timer>;
    onCreated(): void;
    getElapsedTime(runtimeScene?: gdjs.RuntimeScene | undefined): number;
    getRuntimeScene(): gdjs.RuntimeScene;
    deleteFromScene(runtimeScene: gdjs.RuntimeScene): void;
    registerDestroyCallback(callback: () => void): void;
    unregisterDestroyCallback(callback: () => void): void;
    onDestroyFromScene(runtimeScene: gdjs.RuntimeScene): void;
    onScenePaused(runtimeScene: gdjs.RuntimeScene): void;
    onSceneResumed(runtimeScene: gdjs.RuntimeScene): void;
    getName(): string;
    getNameId(): number;
    getUniqueId(): number;
    setPosition(x: number, y: number): void;
    getX(): number;
    getY(): number;
    rotateTowardPosition(x: number, y: number, speed: number, scene: gdjs.RuntimeScene): void;
    rotateTowardAngle(angle: number, speed: number, runtimeScene: gdjs.RuntimeScene): void;
    rotate(speed: number, runtimeScene: gdjs.RuntimeScene): void;
    setLayer(layer: string): void;
    getLayer(): string;
    isOnLayer(layer: string): boolean;
    setZOrder(z: number): void;
    getZOrder(): number;
    getVariables(): gdjs.VariablesContainer;
    hasVariable(name: string): boolean;
    getRendererEffects(): Record<string, gdjs.PixiFiltersTools.Filter>;
    addEffect(effectData: EffectData): boolean;
    removeEffect(effectName: string): boolean;
    clearEffects(): boolean;
    setEffectDoubleParameter(name: string, parameterName: string, value: number): boolean;
    setEffectStringParameter(name: string, parameterName: string, value: string): boolean;
    setEffectBooleanParameter(name: string, parameterName: string, value: boolean): boolean;
    updateAllEffectParameters(effectData: EffectData): boolean;
    enableEffect(name: string, enable: boolean): void;
    isEffectEnabled(name: string): boolean;
    hasEffect(name: string): boolean;
    isVisible(): boolean;
    isHidden(): boolean;
    getCenterXInScene(): number;
    getCenterYInScene(): number;
    setCenterPositionInScene(x: number, y: number): void;
    setCenterXInScene(x: number): void;
    setCenterYInScene(y: number): void;
    _getRecycledForce(x: number, y: number, multiplier: number): gdjs.Force;
    addForce(x: number, y: number, multiplier: number): void;
    addPolarForce(angle: number, len: number, multiplier: number): void;
    addForceTowardPosition(x: number, y: number, len: number, multiplier: number): void;
    addForceTowardObject(object: gdjs.RuntimeObject, len: number, multiplier: number): void;
    clearForces(): void;
    hasNoForces(): boolean;
    updateForces(elapsedTime: number): void;
    getAverageForce(): gdjs.Force;
    averageForceAngleIs(angle: number, toleranceInDegrees: number): boolean;
    getHitBoxes(): gdjs.Polygon[];
    getHitBoxesAround(left: number, top: number, right: number, bottom: number): Iterable<gdjs.Polygon>;
    getAABB(): gdjs.AABB;
    getVisibilityAABB(): gdjs.AABB | null;
    updateAABB(): void;
    getAABBLeft(): number;
    getAABBTop(): number;
    getAABBRight(): number;
    getAABBBottom(): number;
    getAABBCenterX(): number;
    getAABBCenterY(): number;
    stepBehaviorsPreEvents(runtimeScene: any): void;
    stepBehaviorsPostEvents(runtimeScene: any): void;
    notifyBehaviorsObjectHotReloaded(): void;
    getBehavior(name: string): gdjs.RuntimeBehavior | null;
    hasBehavior(name: string): boolean;
    activateBehavior(name: string, enable: boolean): void;
    behaviorActivated(name: string): boolean;
    removeBehavior(name: string): boolean;
    addNewBehavior(behaviorData: BehaviorData): boolean;
    updateTimers(elapsedTime: number): void;
    timerElapsedTime(timerName: string, timeInSeconds: number): boolean;
    timerPaused(timerName: string): boolean;
    resetTimer(timerName: string): void;
    pauseTimer(timerName: string): void;
    unpauseTimer(timerName: string): void;
    removeTimer(timerName: string): void;
    getTimerElapsedTimeInSeconds(timerName: string): number;
    getTimerElapsedTimeInSecondsOrNaN(timerName: string): number;
    separateFromObjects(objects: gdjs.RuntimeObject[], ignoreTouchingEdges: boolean): boolean;
    separateFromObjectsList(objectsLists: ObjectsLists, ignoreTouchingEdges: boolean): boolean;
    getDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getSqDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getDistanceToPosition(targetX: number, targetY: number): number;
    getSqDistanceToPosition(targetX: number, targetY: number): number;
    getAngleToObject(otherObject: gdjs.RuntimeObject): number;
    getXFromAngleAndDistance(angle: number, distance: number): number;
    getYFromAngleAndDistance(angle: number, distance: number): number;
    getAngleToPosition(targetX: number, targetY: number): number;
    putAround(x: number, y: number, distance: number, angleInDegrees: number): void;
    putAroundObject(obj: gdjs.RuntimeObject, distance: number, angleInDegrees: number): void;
    separateObjectsWithoutForces(objectsLists: ObjectsLists): void;
    separateObjectsWithForces(objectsLists: ObjectsLists): void;
    raycastTest(x: number, y: number, endX: number, endY: number, closest: boolean): gdjs.RaycastTestResult;
    insideObject(x: number, y: number): boolean;
    cursorOnObject(runtimeScene: gdjs.RuntimeScene): boolean;
    isCollidingWithPoint(pointX: number, pointY: number): boolean;
    getVariableNumber: typeof gdjs.RuntimeObject.getVariableNumber;
    returnVariable: typeof gdjs.RuntimeObject.returnVariable;
    getVariableString: typeof gdjs.RuntimeObject.getVariableString;
    setVariableNumber: typeof gdjs.RuntimeObject.setVariableNumber;
    setVariableString: typeof gdjs.RuntimeObject.setVariableString;
    getVariableBoolean: (variable: gdjs.Variable, compareWith: boolean) => boolean;
    setVariableBoolean: (variable: gdjs.Variable, newValue: boolean) => void;
    toggleVariableBoolean: (variable: gdjs.Variable) => void;
    variableChildExists: typeof gdjs.RuntimeObject.variableChildExists;
    variableRemoveChild: typeof gdjs.RuntimeObject.variableRemoveChild;
    variableClearChildren: typeof gdjs.RuntimeObject.variableClearChildren;
    variablePushCopy: (array: gdjs.Variable, variable: gdjs.Variable) => void;
    valuePush: (array: gdjs.Variable, value: string | number | boolean) => void;
    variableRemoveAt: (array: gdjs.Variable, index: number) => void;
    getSqDistanceTo: (targetX: number, targetY: number) => number;
};
declare function addTunnelPlatformObject(runtimeScene: any): {
    _customWidth: number;
    _customHeight: number;
    _unscaledWidth: number;
    _unscaledHeight: number;
    _customCenterX: number | null;
    _customCenterY: number | null;
    setCustomWidthAndHeight(customWidth: any, customHeight: any): void;
    hitBoxesDirty: any;
    setUnscaledWidthAndHeight(unscaledWidth: any, unscaledHeight: any): void;
    setCustomCenter(customCenterX: any, customCenterY: any): void;
    getRendererObject(): {};
    getWidth(): number;
    getHeight(): number;
    getCenterX(): number;
    getCenterY(): number;
    _currentAnimation: number;
    _currentDirection: number;
    _currentFrame: number;
    _frameElapsedTime: number;
    _animationSpeedScale: number;
    _animationPaused: boolean;
    _scaleX: number;
    _scaleY: number;
    _blendMode: number;
    _flippedX: boolean;
    _flippedY: boolean;
    opacity: number;
    _updateIfNotVisible: boolean;
    _animations: gdjs.SpriteAnimation[];
    _animationFrame: gdjs.SpriteAnimationFrame | null;
    _renderer: gdjs.SpriteRuntimeObjectPixiRenderer;
    _animationFrameDirty: any;
    reinitialize(spriteObjectData: gdjs.SpriteObjectData): void;
    updateFromObjectData(oldObjectData: gdjs.SpriteObjectData, newObjectData: gdjs.SpriteObjectData): boolean;
    extraInitializationFromInitialInstance(initialInstanceData: InstanceData): void;
    update(runtimeScene: gdjs.RuntimeScene): void;
    updatePreRender(runtimeScene: gdjs.RuntimeScene): void;
    _updateAnimationFrame(): void;
    updateHitBoxes(): void;
    setAnimation(newAnimation: number): void;
    setAnimationName(newAnimationName: string): void;
    getAnimation(): number;
    getAnimationName(): string;
    isCurrentAnimationName(name: any): boolean;
    setDirectionOrAngle(newValue: any): void;
    getDirectionOrAngle(): number;
    setAnimationFrame(newFrame: number): void;
    getAnimationFrame(): number;
    hasAnimationEnded(): boolean;
    animationPaused(): boolean;
    pauseAnimation(): void;
    playAnimation(): void;
    getAnimationSpeedScale(): number;
    setAnimationSpeedScale(ratio: any): void;
    getPointX(name: string): number;
    getPointY(name: string): number;
    getPointPosition(name: string): [x: number, y: number];
    _transformToGlobal(x: number, y: number, result: number[]): void;
    getDrawableX(): number;
    getDrawableY(): number;
    setX(x: number): void;
    setY(y: number): void;
    setAngle(angle: number): void;
    getAngle(): number;
    setBlendMode(newMode: any): void;
    getBlendMode(): number;
    setOpacity(opacity: number): void;
    getOpacity(): number;
    hide(enable: boolean): void;
    setColor(rgbColor: string): void;
    getColor(): string;
    flipX(enable: any): void;
    flipY(enable: any): void;
    isFlippedX(): boolean;
    isFlippedY(): boolean;
    setWidth(newWidth: number): void;
    setHeight(newHeight: number): void;
    setSize(newWidth: number, newHeight: number): void;
    setScale(newScale: number): void;
    setScaleX(newScale: number): void;
    setScaleY(newScale: number): void;
    getScale(): number;
    getScaleY(): number;
    getScaleX(): number;
    turnTowardObject(obj: any, scene: any): void;
    name: string;
    type: string;
    x: number;
    y: number;
    angle: number;
    zOrder: number;
    hidden: boolean;
    layer: string;
    _nameId: number;
    _livingOnScene: boolean;
    readonly id: number;
    destroyCallbacks: Set<() => void>;
    _runtimeScene: gdjs.RuntimeScene;
    persistentUuid: string | null;
    pick: boolean;
    _defaultHitBoxes: gdjs.Polygon[];
    hitBoxes: gdjs.Polygon[];
    aabb: gdjs.AABB;
    _variables: gdjs.VariablesContainer;
    _rendererEffects: Record<string, gdjs.PixiFiltersTools.Filter>;
    _forces: gdjs.Force[];
    _averageForce: gdjs.Force;
    _behaviors: gdjs.RuntimeBehavior[];
    _behaviorsTable: Hashtable<gdjs.RuntimeBehavior>;
    _timers: Hashtable<gdjs.Timer>;
    onCreated(): void;
    getElapsedTime(runtimeScene?: gdjs.RuntimeScene | undefined): number;
    getRuntimeScene(): gdjs.RuntimeScene;
    deleteFromScene(runtimeScene: gdjs.RuntimeScene): void;
    registerDestroyCallback(callback: () => void): void;
    unregisterDestroyCallback(callback: () => void): void;
    onDestroyFromScene(runtimeScene: gdjs.RuntimeScene): void;
    onScenePaused(runtimeScene: gdjs.RuntimeScene): void;
    onSceneResumed(runtimeScene: gdjs.RuntimeScene): void;
    getName(): string;
    getNameId(): number;
    getUniqueId(): number;
    setPosition(x: number, y: number): void;
    getX(): number;
    getY(): number;
    rotateTowardPosition(x: number, y: number, speed: number, scene: gdjs.RuntimeScene): void;
    rotateTowardAngle(angle: number, speed: number, runtimeScene: gdjs.RuntimeScene): void;
    rotate(speed: number, runtimeScene: gdjs.RuntimeScene): void;
    setLayer(layer: string): void;
    getLayer(): string;
    isOnLayer(layer: string): boolean;
    setZOrder(z: number): void;
    getZOrder(): number;
    getVariables(): gdjs.VariablesContainer;
    hasVariable(name: string): boolean;
    getRendererEffects(): Record<string, gdjs.PixiFiltersTools.Filter>;
    addEffect(effectData: EffectData): boolean;
    removeEffect(effectName: string): boolean;
    clearEffects(): boolean;
    setEffectDoubleParameter(name: string, parameterName: string, value: number): boolean;
    setEffectStringParameter(name: string, parameterName: string, value: string): boolean;
    setEffectBooleanParameter(name: string, parameterName: string, value: boolean): boolean;
    updateAllEffectParameters(effectData: EffectData): boolean;
    enableEffect(name: string, enable: boolean): void;
    isEffectEnabled(name: string): boolean;
    hasEffect(name: string): boolean;
    isVisible(): boolean;
    isHidden(): boolean;
    getCenterXInScene(): number;
    getCenterYInScene(): number;
    setCenterPositionInScene(x: number, y: number): void;
    setCenterXInScene(x: number): void;
    setCenterYInScene(y: number): void;
    _getRecycledForce(x: number, y: number, multiplier: number): gdjs.Force;
    addForce(x: number, y: number, multiplier: number): void;
    addPolarForce(angle: number, len: number, multiplier: number): void;
    addForceTowardPosition(x: number, y: number, len: number, multiplier: number): void;
    addForceTowardObject(object: gdjs.RuntimeObject, len: number, multiplier: number): void;
    clearForces(): void;
    hasNoForces(): boolean;
    updateForces(elapsedTime: number): void;
    getAverageForce(): gdjs.Force;
    averageForceAngleIs(angle: number, toleranceInDegrees: number): boolean;
    getHitBoxes(): gdjs.Polygon[];
    getHitBoxesAround(left: number, top: number, right: number, bottom: number): Iterable<gdjs.Polygon>;
    getAABB(): gdjs.AABB;
    getVisibilityAABB(): gdjs.AABB | null;
    updateAABB(): void;
    getAABBLeft(): number;
    getAABBTop(): number;
    getAABBRight(): number;
    getAABBBottom(): number;
    getAABBCenterX(): number;
    getAABBCenterY(): number;
    stepBehaviorsPreEvents(runtimeScene: any): void;
    stepBehaviorsPostEvents(runtimeScene: any): void;
    notifyBehaviorsObjectHotReloaded(): void;
    getBehavior(name: string): gdjs.RuntimeBehavior | null;
    hasBehavior(name: string): boolean;
    activateBehavior(name: string, enable: boolean): void;
    behaviorActivated(name: string): boolean;
    removeBehavior(name: string): boolean;
    addNewBehavior(behaviorData: BehaviorData): boolean;
    updateTimers(elapsedTime: number): void;
    timerElapsedTime(timerName: string, timeInSeconds: number): boolean;
    timerPaused(timerName: string): boolean;
    resetTimer(timerName: string): void;
    pauseTimer(timerName: string): void;
    unpauseTimer(timerName: string): void;
    removeTimer(timerName: string): void;
    getTimerElapsedTimeInSeconds(timerName: string): number;
    getTimerElapsedTimeInSecondsOrNaN(timerName: string): number;
    separateFromObjects(objects: gdjs.RuntimeObject[], ignoreTouchingEdges: boolean): boolean;
    separateFromObjectsList(objectsLists: ObjectsLists, ignoreTouchingEdges: boolean): boolean;
    getDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getSqDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getDistanceToPosition(targetX: number, targetY: number): number;
    getSqDistanceToPosition(targetX: number, targetY: number): number;
    getAngleToObject(otherObject: gdjs.RuntimeObject): number;
    getXFromAngleAndDistance(angle: number, distance: number): number;
    getYFromAngleAndDistance(angle: number, distance: number): number;
    getAngleToPosition(targetX: number, targetY: number): number;
    putAround(x: number, y: number, distance: number, angleInDegrees: number): void;
    putAroundObject(obj: gdjs.RuntimeObject, distance: number, angleInDegrees: number): void;
    separateObjectsWithoutForces(objectsLists: ObjectsLists): void;
    separateObjectsWithForces(objectsLists: ObjectsLists): void;
    raycastTest(x: number, y: number, endX: number, endY: number, closest: boolean): gdjs.RaycastTestResult;
    insideObject(x: number, y: number): boolean;
    cursorOnObject(runtimeScene: gdjs.RuntimeScene): boolean;
    isCollidingWithPoint(pointX: number, pointY: number): boolean;
    getVariableNumber: typeof gdjs.RuntimeObject.getVariableNumber;
    returnVariable: typeof gdjs.RuntimeObject.returnVariable;
    getVariableString: typeof gdjs.RuntimeObject.getVariableString;
    setVariableNumber: typeof gdjs.RuntimeObject.setVariableNumber;
    setVariableString: typeof gdjs.RuntimeObject.setVariableString;
    getVariableBoolean: (variable: gdjs.Variable, compareWith: boolean) => boolean;
    setVariableBoolean: (variable: gdjs.Variable, newValue: boolean) => void;
    toggleVariableBoolean: (variable: gdjs.Variable) => void;
    variableChildExists: typeof gdjs.RuntimeObject.variableChildExists;
    variableRemoveChild: typeof gdjs.RuntimeObject.variableRemoveChild;
    variableClearChildren: typeof gdjs.RuntimeObject.variableClearChildren;
    variablePushCopy: (array: gdjs.Variable, variable: gdjs.Variable) => void;
    valuePush: (array: gdjs.Variable, value: string | number | boolean) => void;
    variableRemoveAt: (array: gdjs.Variable, index: number) => void;
    getSqDistanceTo: (targetX: number, targetY: number) => number;
};
/**
 * @returns A platform with 2 hitboxes that can act as a floor and a wall at
 * the same time.
 * It can happen when a tile map collision mask object is used because all
 * the platforms are part of the same object instance.
 */
declare function addFloorAndWallPlatformObject(runtimeScene: any): {
    _customWidth: number;
    _customHeight: number;
    _unscaledWidth: number;
    _unscaledHeight: number;
    _customCenterX: number | null;
    _customCenterY: number | null;
    setCustomWidthAndHeight(customWidth: any, customHeight: any): void;
    hitBoxesDirty: any;
    setUnscaledWidthAndHeight(unscaledWidth: any, unscaledHeight: any): void;
    setCustomCenter(customCenterX: any, customCenterY: any): void;
    getRendererObject(): {};
    getWidth(): number;
    getHeight(): number;
    getCenterX(): number;
    getCenterY(): number;
    _currentAnimation: number;
    _currentDirection: number;
    _currentFrame: number;
    _frameElapsedTime: number;
    _animationSpeedScale: number;
    _animationPaused: boolean;
    _scaleX: number;
    _scaleY: number;
    _blendMode: number;
    _flippedX: boolean;
    _flippedY: boolean;
    opacity: number;
    _updateIfNotVisible: boolean;
    _animations: gdjs.SpriteAnimation[];
    _animationFrame: gdjs.SpriteAnimationFrame | null;
    _renderer: gdjs.SpriteRuntimeObjectPixiRenderer;
    _animationFrameDirty: any;
    reinitialize(spriteObjectData: gdjs.SpriteObjectData): void;
    updateFromObjectData(oldObjectData: gdjs.SpriteObjectData, newObjectData: gdjs.SpriteObjectData): boolean;
    extraInitializationFromInitialInstance(initialInstanceData: InstanceData): void;
    update(runtimeScene: gdjs.RuntimeScene): void;
    updatePreRender(runtimeScene: gdjs.RuntimeScene): void;
    _updateAnimationFrame(): void;
    updateHitBoxes(): void;
    setAnimation(newAnimation: number): void;
    setAnimationName(newAnimationName: string): void;
    getAnimation(): number;
    getAnimationName(): string;
    isCurrentAnimationName(name: any): boolean;
    setDirectionOrAngle(newValue: any): void;
    getDirectionOrAngle(): number;
    setAnimationFrame(newFrame: number): void;
    getAnimationFrame(): number;
    hasAnimationEnded(): boolean;
    animationPaused(): boolean;
    pauseAnimation(): void;
    playAnimation(): void;
    getAnimationSpeedScale(): number;
    setAnimationSpeedScale(ratio: any): void;
    getPointX(name: string): number;
    getPointY(name: string): number;
    getPointPosition(name: string): [x: number, y: number];
    _transformToGlobal(x: number, y: number, result: number[]): void;
    getDrawableX(): number;
    getDrawableY(): number;
    setX(x: number): void;
    setY(y: number): void;
    setAngle(angle: number): void;
    getAngle(): number;
    setBlendMode(newMode: any): void;
    getBlendMode(): number;
    setOpacity(opacity: number): void;
    getOpacity(): number;
    hide(enable: boolean): void;
    setColor(rgbColor: string): void;
    getColor(): string;
    flipX(enable: any): void;
    flipY(enable: any): void;
    isFlippedX(): boolean;
    isFlippedY(): boolean;
    setWidth(newWidth: number): void;
    setHeight(newHeight: number): void;
    setSize(newWidth: number, newHeight: number): void;
    setScale(newScale: number): void;
    setScaleX(newScale: number): void;
    setScaleY(newScale: number): void;
    getScale(): number;
    getScaleY(): number;
    getScaleX(): number;
    turnTowardObject(obj: any, scene: any): void;
    name: string;
    type: string;
    x: number;
    y: number;
    angle: number;
    zOrder: number;
    hidden: boolean;
    layer: string;
    _nameId: number;
    _livingOnScene: boolean;
    readonly id: number;
    destroyCallbacks: Set<() => void>;
    _runtimeScene: gdjs.RuntimeScene;
    persistentUuid: string | null;
    pick: boolean;
    _defaultHitBoxes: gdjs.Polygon[];
    hitBoxes: gdjs.Polygon[];
    aabb: gdjs.AABB;
    _variables: gdjs.VariablesContainer;
    _rendererEffects: Record<string, gdjs.PixiFiltersTools.Filter>;
    _forces: gdjs.Force[];
    _averageForce: gdjs.Force;
    _behaviors: gdjs.RuntimeBehavior[];
    _behaviorsTable: Hashtable<gdjs.RuntimeBehavior>;
    _timers: Hashtable<gdjs.Timer>;
    onCreated(): void;
    getElapsedTime(runtimeScene?: gdjs.RuntimeScene | undefined): number;
    getRuntimeScene(): gdjs.RuntimeScene;
    deleteFromScene(runtimeScene: gdjs.RuntimeScene): void;
    registerDestroyCallback(callback: () => void): void;
    unregisterDestroyCallback(callback: () => void): void;
    onDestroyFromScene(runtimeScene: gdjs.RuntimeScene): void;
    onScenePaused(runtimeScene: gdjs.RuntimeScene): void;
    onSceneResumed(runtimeScene: gdjs.RuntimeScene): void;
    getName(): string;
    getNameId(): number;
    getUniqueId(): number;
    setPosition(x: number, y: number): void;
    getX(): number;
    getY(): number;
    rotateTowardPosition(x: number, y: number, speed: number, scene: gdjs.RuntimeScene): void;
    rotateTowardAngle(angle: number, speed: number, runtimeScene: gdjs.RuntimeScene): void;
    rotate(speed: number, runtimeScene: gdjs.RuntimeScene): void;
    setLayer(layer: string): void;
    getLayer(): string;
    isOnLayer(layer: string): boolean;
    setZOrder(z: number): void;
    getZOrder(): number;
    getVariables(): gdjs.VariablesContainer;
    hasVariable(name: string): boolean;
    getRendererEffects(): Record<string, gdjs.PixiFiltersTools.Filter>;
    addEffect(effectData: EffectData): boolean;
    removeEffect(effectName: string): boolean;
    clearEffects(): boolean;
    setEffectDoubleParameter(name: string, parameterName: string, value: number): boolean;
    setEffectStringParameter(name: string, parameterName: string, value: string): boolean;
    setEffectBooleanParameter(name: string, parameterName: string, value: boolean): boolean;
    updateAllEffectParameters(effectData: EffectData): boolean;
    enableEffect(name: string, enable: boolean): void;
    isEffectEnabled(name: string): boolean;
    hasEffect(name: string): boolean;
    isVisible(): boolean;
    isHidden(): boolean;
    getCenterXInScene(): number;
    getCenterYInScene(): number;
    setCenterPositionInScene(x: number, y: number): void;
    setCenterXInScene(x: number): void;
    setCenterYInScene(y: number): void;
    _getRecycledForce(x: number, y: number, multiplier: number): gdjs.Force;
    addForce(x: number, y: number, multiplier: number): void;
    addPolarForce(angle: number, len: number, multiplier: number): void;
    addForceTowardPosition(x: number, y: number, len: number, multiplier: number): void;
    addForceTowardObject(object: gdjs.RuntimeObject, len: number, multiplier: number): void;
    clearForces(): void;
    hasNoForces(): boolean;
    updateForces(elapsedTime: number): void;
    getAverageForce(): gdjs.Force;
    averageForceAngleIs(angle: number, toleranceInDegrees: number): boolean;
    getHitBoxes(): gdjs.Polygon[];
    getHitBoxesAround(left: number, top: number, right: number, bottom: number): Iterable<gdjs.Polygon>;
    getAABB(): gdjs.AABB;
    getVisibilityAABB(): gdjs.AABB | null;
    updateAABB(): void;
    getAABBLeft(): number;
    getAABBTop(): number;
    getAABBRight(): number;
    getAABBBottom(): number;
    getAABBCenterX(): number;
    getAABBCenterY(): number;
    stepBehaviorsPreEvents(runtimeScene: any): void;
    stepBehaviorsPostEvents(runtimeScene: any): void;
    notifyBehaviorsObjectHotReloaded(): void;
    getBehavior(name: string): gdjs.RuntimeBehavior | null;
    hasBehavior(name: string): boolean;
    activateBehavior(name: string, enable: boolean): void;
    behaviorActivated(name: string): boolean;
    removeBehavior(name: string): boolean;
    addNewBehavior(behaviorData: BehaviorData): boolean;
    updateTimers(elapsedTime: number): void;
    timerElapsedTime(timerName: string, timeInSeconds: number): boolean;
    timerPaused(timerName: string): boolean;
    resetTimer(timerName: string): void;
    pauseTimer(timerName: string): void;
    unpauseTimer(timerName: string): void;
    removeTimer(timerName: string): void;
    getTimerElapsedTimeInSeconds(timerName: string): number;
    getTimerElapsedTimeInSecondsOrNaN(timerName: string): number;
    separateFromObjects(objects: gdjs.RuntimeObject[], ignoreTouchingEdges: boolean): boolean;
    separateFromObjectsList(objectsLists: ObjectsLists, ignoreTouchingEdges: boolean): boolean;
    getDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getSqDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getDistanceToPosition(targetX: number, targetY: number): number;
    getSqDistanceToPosition(targetX: number, targetY: number): number;
    getAngleToObject(otherObject: gdjs.RuntimeObject): number;
    getXFromAngleAndDistance(angle: number, distance: number): number;
    getYFromAngleAndDistance(angle: number, distance: number): number;
    getAngleToPosition(targetX: number, targetY: number): number;
    putAround(x: number, y: number, distance: number, angleInDegrees: number): void;
    putAroundObject(obj: gdjs.RuntimeObject, distance: number, angleInDegrees: number): void;
    separateObjectsWithoutForces(objectsLists: ObjectsLists): void;
    separateObjectsWithForces(objectsLists: ObjectsLists): void;
    raycastTest(x: number, y: number, endX: number, endY: number, closest: boolean): gdjs.RaycastTestResult;
    insideObject(x: number, y: number): boolean;
    cursorOnObject(runtimeScene: gdjs.RuntimeScene): boolean;
    isCollidingWithPoint(pointX: number, pointY: number): boolean;
    getVariableNumber: typeof gdjs.RuntimeObject.getVariableNumber;
    returnVariable: typeof gdjs.RuntimeObject.returnVariable;
    getVariableString: typeof gdjs.RuntimeObject.getVariableString;
    setVariableNumber: typeof gdjs.RuntimeObject.setVariableNumber;
    setVariableString: typeof gdjs.RuntimeObject.setVariableString;
    getVariableBoolean: (variable: gdjs.Variable, compareWith: boolean) => boolean;
    setVariableBoolean: (variable: gdjs.Variable, newValue: boolean) => void;
    toggleVariableBoolean: (variable: gdjs.Variable) => void;
    variableChildExists: typeof gdjs.RuntimeObject.variableChildExists;
    variableRemoveChild: typeof gdjs.RuntimeObject.variableRemoveChild;
    variableClearChildren: typeof gdjs.RuntimeObject.variableClearChildren;
    variablePushCopy: (array: gdjs.Variable, variable: gdjs.Variable) => void;
    valuePush: (array: gdjs.Variable, value: string | number | boolean) => void;
    variableRemoveAt: (array: gdjs.Variable, index: number) => void;
    getSqDistanceTo: (targetX: number, targetY: number) => number;
};
declare function addJumpThroughPlatformObject(runtimeScene: any): {
    _customWidth: number;
    _customHeight: number;
    _customCenterX: number | null;
    _customCenterY: number | null;
    setCustomWidthAndHeight(customWidth: any, customHeight: any): void;
    hitBoxesDirty: boolean;
    setCustomCenter(customCenterX: any, customCenterY: any): void;
    getRendererObject(): null;
    getWidth(): number;
    setWidth(width: any): number;
    getHeight(): number;
    setHeight(height: any): number;
    getCenterX(): number;
    getCenterY(): number;
    name: string;
    type: string;
    x: number;
    y: number;
    angle: number;
    zOrder: number;
    hidden: boolean;
    layer: string;
    _nameId: number;
    _livingOnScene: boolean;
    readonly id: number;
    destroyCallbacks: Set<() => void>;
    _runtimeScene: gdjs.RuntimeScene;
    persistentUuid: string | null;
    pick: boolean;
    _defaultHitBoxes: gdjs.Polygon[];
    hitBoxes: gdjs.Polygon[];
    aabb: gdjs.AABB;
    _variables: gdjs.VariablesContainer;
    _rendererEffects: Record<string, gdjs.PixiFiltersTools.Filter>;
    _forces: gdjs.Force[];
    _averageForce: gdjs.Force;
    _behaviors: gdjs.RuntimeBehavior[];
    _behaviorsTable: Hashtable<gdjs.RuntimeBehavior>;
    _timers: Hashtable<gdjs.Timer>;
    onCreated(): void;
    reinitialize(objectData: ObjectData): void;
    getElapsedTime(runtimeScene?: gdjs.RuntimeScene | undefined): number;
    getRuntimeScene(): gdjs.RuntimeScene;
    update(runtimeScene: gdjs.RuntimeScene): void;
    updatePreRender(runtimeScene: gdjs.RuntimeScene): void;
    extraInitializationFromInitialInstance(initialInstanceData: InstanceData): void;
    updateFromObjectData(oldObjectData: ObjectData, newObjectData: ObjectData): boolean;
    deleteFromScene(runtimeScene: gdjs.RuntimeScene): void;
    registerDestroyCallback(callback: () => void): void;
    unregisterDestroyCallback(callback: () => void): void;
    onDestroyFromScene(runtimeScene: gdjs.RuntimeScene): void;
    onScenePaused(runtimeScene: gdjs.RuntimeScene): void;
    onSceneResumed(runtimeScene: gdjs.RuntimeScene): void;
    getName(): string;
    getNameId(): number;
    getUniqueId(): number;
    setPosition(x: number, y: number): void;
    setX(x: number): void;
    getX(): number;
    setY(y: number): void;
    getY(): number;
    getDrawableX(): number;
    getDrawableY(): number;
    rotateTowardPosition(x: number, y: number, speed: number, scene: gdjs.RuntimeScene): void;
    rotateTowardAngle(angle: number, speed: number, runtimeScene: gdjs.RuntimeScene): void;
    rotate(speed: number, runtimeScene: gdjs.RuntimeScene): void;
    setAngle(angle: number): void;
    getAngle(): number;
    setLayer(layer: string): void;
    getLayer(): string;
    isOnLayer(layer: string): boolean;
    setZOrder(z: number): void;
    getZOrder(): number;
    getVariables(): gdjs.VariablesContainer;
    hasVariable(name: string): boolean;
    getRendererEffects(): Record<string, gdjs.PixiFiltersTools.Filter>;
    addEffect(effectData: EffectData): boolean;
    removeEffect(effectName: string): boolean;
    clearEffects(): boolean;
    setEffectDoubleParameter(name: string, parameterName: string, value: number): boolean;
    setEffectStringParameter(name: string, parameterName: string, value: string): boolean;
    setEffectBooleanParameter(name: string, parameterName: string, value: boolean): boolean;
    updateAllEffectParameters(effectData: EffectData): boolean;
    enableEffect(name: string, enable: boolean): void;
    isEffectEnabled(name: string): boolean;
    hasEffect(name: string): boolean;
    hide(enable: boolean): void;
    isVisible(): boolean;
    isHidden(): boolean;
    getCenterXInScene(): number;
    getCenterYInScene(): number;
    setCenterPositionInScene(x: number, y: number): void;
    setCenterXInScene(x: number): void;
    setCenterYInScene(y: number): void;
    _getRecycledForce(x: number, y: number, multiplier: number): gdjs.Force;
    addForce(x: number, y: number, multiplier: number): void;
    addPolarForce(angle: number, len: number, multiplier: number): void;
    addForceTowardPosition(x: number, y: number, len: number, multiplier: number): void;
    addForceTowardObject(object: gdjs.RuntimeObject, len: number, multiplier: number): void;
    clearForces(): void;
    hasNoForces(): boolean;
    updateForces(elapsedTime: number): void;
    getAverageForce(): gdjs.Force;
    averageForceAngleIs(angle: number, toleranceInDegrees: number): boolean;
    getHitBoxes(): gdjs.Polygon[];
    getHitBoxesAround(left: number, top: number, right: number, bottom: number): Iterable<gdjs.Polygon>;
    updateHitBoxes(): void;
    getAABB(): gdjs.AABB;
    getVisibilityAABB(): gdjs.AABB | null;
    updateAABB(): void;
    getAABBLeft(): number;
    getAABBTop(): number;
    getAABBRight(): number;
    getAABBBottom(): number;
    getAABBCenterX(): number;
    getAABBCenterY(): number;
    stepBehaviorsPreEvents(runtimeScene: any): void;
    stepBehaviorsPostEvents(runtimeScene: any): void;
    notifyBehaviorsObjectHotReloaded(): void;
    getBehavior(name: string): gdjs.RuntimeBehavior | null;
    hasBehavior(name: string): boolean;
    activateBehavior(name: string, enable: boolean): void;
    behaviorActivated(name: string): boolean;
    removeBehavior(name: string): boolean;
    addNewBehavior(behaviorData: BehaviorData): boolean;
    updateTimers(elapsedTime: number): void;
    timerElapsedTime(timerName: string, timeInSeconds: number): boolean;
    timerPaused(timerName: string): boolean;
    resetTimer(timerName: string): void;
    pauseTimer(timerName: string): void;
    unpauseTimer(timerName: string): void;
    removeTimer(timerName: string): void;
    getTimerElapsedTimeInSeconds(timerName: string): number;
    getTimerElapsedTimeInSecondsOrNaN(timerName: string): number;
    separateFromObjects(objects: gdjs.RuntimeObject[], ignoreTouchingEdges: boolean): boolean;
    separateFromObjectsList(objectsLists: ObjectsLists, ignoreTouchingEdges: boolean): boolean;
    getDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getSqDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getDistanceToPosition(targetX: number, targetY: number): number;
    getSqDistanceToPosition(targetX: number, targetY: number): number;
    getAngleToObject(otherObject: gdjs.RuntimeObject): number;
    getXFromAngleAndDistance(angle: number, distance: number): number;
    getYFromAngleAndDistance(angle: number, distance: number): number;
    getAngleToPosition(targetX: number, targetY: number): number;
    putAround(x: number, y: number, distance: number, angleInDegrees: number): void;
    putAroundObject(obj: gdjs.RuntimeObject, distance: number, angleInDegrees: number): void;
    separateObjectsWithoutForces(objectsLists: ObjectsLists): void;
    separateObjectsWithForces(objectsLists: ObjectsLists): void;
    raycastTest(x: number, y: number, endX: number, endY: number, closest: boolean): gdjs.RaycastTestResult;
    insideObject(x: number, y: number): boolean;
    cursorOnObject(runtimeScene: gdjs.RuntimeScene): boolean;
    isCollidingWithPoint(pointX: number, pointY: number): boolean;
    getVariableNumber: typeof gdjs.RuntimeObject.getVariableNumber;
    returnVariable: typeof gdjs.RuntimeObject.returnVariable;
    getVariableString: typeof gdjs.RuntimeObject.getVariableString;
    setVariableNumber: typeof gdjs.RuntimeObject.setVariableNumber;
    setVariableString: typeof gdjs.RuntimeObject.setVariableString;
    getVariableBoolean: (variable: gdjs.Variable, compareWith: boolean) => boolean;
    setVariableBoolean: (variable: gdjs.Variable, newValue: boolean) => void;
    toggleVariableBoolean: (variable: gdjs.Variable) => void;
    variableChildExists: typeof gdjs.RuntimeObject.variableChildExists;
    variableRemoveChild: typeof gdjs.RuntimeObject.variableRemoveChild;
    variableClearChildren: typeof gdjs.RuntimeObject.variableClearChildren;
    variablePushCopy: (array: gdjs.Variable, variable: gdjs.Variable) => void;
    valuePush: (array: gdjs.Variable, value: string | number | boolean) => void;
    variableRemoveAt: (array: gdjs.Variable, index: number) => void;
    getSqDistanceTo: (targetX: number, targetY: number) => number;
};
declare function addLadderObject(runtimeScene: any): {
    _customWidth: number;
    _customHeight: number;
    _customCenterX: number | null;
    _customCenterY: number | null;
    setCustomWidthAndHeight(customWidth: any, customHeight: any): void;
    hitBoxesDirty: boolean;
    setCustomCenter(customCenterX: any, customCenterY: any): void;
    getRendererObject(): null;
    getWidth(): number;
    setWidth(width: any): number;
    getHeight(): number;
    setHeight(height: any): number;
    getCenterX(): number;
    getCenterY(): number;
    name: string;
    type: string;
    x: number;
    y: number;
    angle: number;
    zOrder: number;
    hidden: boolean;
    layer: string;
    _nameId: number;
    _livingOnScene: boolean;
    readonly id: number;
    destroyCallbacks: Set<() => void>;
    _runtimeScene: gdjs.RuntimeScene;
    persistentUuid: string | null;
    pick: boolean;
    _defaultHitBoxes: gdjs.Polygon[];
    hitBoxes: gdjs.Polygon[];
    aabb: gdjs.AABB;
    _variables: gdjs.VariablesContainer;
    _rendererEffects: Record<string, gdjs.PixiFiltersTools.Filter>;
    _forces: gdjs.Force[];
    _averageForce: gdjs.Force;
    _behaviors: gdjs.RuntimeBehavior[];
    _behaviorsTable: Hashtable<gdjs.RuntimeBehavior>;
    _timers: Hashtable<gdjs.Timer>;
    onCreated(): void;
    reinitialize(objectData: ObjectData): void;
    getElapsedTime(runtimeScene?: gdjs.RuntimeScene | undefined): number;
    getRuntimeScene(): gdjs.RuntimeScene;
    update(runtimeScene: gdjs.RuntimeScene): void;
    updatePreRender(runtimeScene: gdjs.RuntimeScene): void;
    extraInitializationFromInitialInstance(initialInstanceData: InstanceData): void;
    updateFromObjectData(oldObjectData: ObjectData, newObjectData: ObjectData): boolean;
    deleteFromScene(runtimeScene: gdjs.RuntimeScene): void;
    registerDestroyCallback(callback: () => void): void;
    unregisterDestroyCallback(callback: () => void): void;
    onDestroyFromScene(runtimeScene: gdjs.RuntimeScene): void;
    onScenePaused(runtimeScene: gdjs.RuntimeScene): void;
    onSceneResumed(runtimeScene: gdjs.RuntimeScene): void;
    getName(): string;
    getNameId(): number;
    getUniqueId(): number;
    setPosition(x: number, y: number): void;
    setX(x: number): void;
    getX(): number;
    setY(y: number): void;
    getY(): number;
    getDrawableX(): number;
    getDrawableY(): number;
    rotateTowardPosition(x: number, y: number, speed: number, scene: gdjs.RuntimeScene): void;
    rotateTowardAngle(angle: number, speed: number, runtimeScene: gdjs.RuntimeScene): void;
    rotate(speed: number, runtimeScene: gdjs.RuntimeScene): void;
    setAngle(angle: number): void;
    getAngle(): number;
    setLayer(layer: string): void;
    getLayer(): string;
    isOnLayer(layer: string): boolean;
    setZOrder(z: number): void;
    getZOrder(): number;
    getVariables(): gdjs.VariablesContainer;
    hasVariable(name: string): boolean;
    getRendererEffects(): Record<string, gdjs.PixiFiltersTools.Filter>;
    addEffect(effectData: EffectData): boolean;
    removeEffect(effectName: string): boolean;
    clearEffects(): boolean;
    setEffectDoubleParameter(name: string, parameterName: string, value: number): boolean;
    setEffectStringParameter(name: string, parameterName: string, value: string): boolean;
    setEffectBooleanParameter(name: string, parameterName: string, value: boolean): boolean;
    updateAllEffectParameters(effectData: EffectData): boolean;
    enableEffect(name: string, enable: boolean): void;
    isEffectEnabled(name: string): boolean;
    hasEffect(name: string): boolean;
    hide(enable: boolean): void;
    isVisible(): boolean;
    isHidden(): boolean;
    getCenterXInScene(): number;
    getCenterYInScene(): number;
    setCenterPositionInScene(x: number, y: number): void;
    setCenterXInScene(x: number): void;
    setCenterYInScene(y: number): void;
    _getRecycledForce(x: number, y: number, multiplier: number): gdjs.Force;
    addForce(x: number, y: number, multiplier: number): void;
    addPolarForce(angle: number, len: number, multiplier: number): void;
    addForceTowardPosition(x: number, y: number, len: number, multiplier: number): void;
    addForceTowardObject(object: gdjs.RuntimeObject, len: number, multiplier: number): void;
    clearForces(): void;
    hasNoForces(): boolean;
    updateForces(elapsedTime: number): void;
    getAverageForce(): gdjs.Force;
    averageForceAngleIs(angle: number, toleranceInDegrees: number): boolean;
    getHitBoxes(): gdjs.Polygon[];
    getHitBoxesAround(left: number, top: number, right: number, bottom: number): Iterable<gdjs.Polygon>;
    updateHitBoxes(): void;
    getAABB(): gdjs.AABB;
    getVisibilityAABB(): gdjs.AABB | null;
    updateAABB(): void;
    getAABBLeft(): number;
    getAABBTop(): number;
    getAABBRight(): number;
    getAABBBottom(): number;
    getAABBCenterX(): number;
    getAABBCenterY(): number;
    stepBehaviorsPreEvents(runtimeScene: any): void;
    stepBehaviorsPostEvents(runtimeScene: any): void;
    notifyBehaviorsObjectHotReloaded(): void;
    getBehavior(name: string): gdjs.RuntimeBehavior | null;
    hasBehavior(name: string): boolean;
    activateBehavior(name: string, enable: boolean): void;
    behaviorActivated(name: string): boolean;
    removeBehavior(name: string): boolean;
    addNewBehavior(behaviorData: BehaviorData): boolean;
    updateTimers(elapsedTime: number): void;
    timerElapsedTime(timerName: string, timeInSeconds: number): boolean;
    timerPaused(timerName: string): boolean;
    resetTimer(timerName: string): void;
    pauseTimer(timerName: string): void;
    unpauseTimer(timerName: string): void;
    removeTimer(timerName: string): void;
    getTimerElapsedTimeInSeconds(timerName: string): number;
    getTimerElapsedTimeInSecondsOrNaN(timerName: string): number;
    separateFromObjects(objects: gdjs.RuntimeObject[], ignoreTouchingEdges: boolean): boolean;
    separateFromObjectsList(objectsLists: ObjectsLists, ignoreTouchingEdges: boolean): boolean;
    getDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getSqDistanceToObject(otherObject: gdjs.RuntimeObject): number;
    getDistanceToPosition(targetX: number, targetY: number): number;
    getSqDistanceToPosition(targetX: number, targetY: number): number;
    getAngleToObject(otherObject: gdjs.RuntimeObject): number;
    getXFromAngleAndDistance(angle: number, distance: number): number;
    getYFromAngleAndDistance(angle: number, distance: number): number;
    getAngleToPosition(targetX: number, targetY: number): number;
    putAround(x: number, y: number, distance: number, angleInDegrees: number): void;
    putAroundObject(obj: gdjs.RuntimeObject, distance: number, angleInDegrees: number): void;
    separateObjectsWithoutForces(objectsLists: ObjectsLists): void;
    separateObjectsWithForces(objectsLists: ObjectsLists): void;
    raycastTest(x: number, y: number, endX: number, endY: number, closest: boolean): gdjs.RaycastTestResult;
    insideObject(x: number, y: number): boolean;
    cursorOnObject(runtimeScene: gdjs.RuntimeScene): boolean;
    isCollidingWithPoint(pointX: number, pointY: number): boolean;
    getVariableNumber: typeof gdjs.RuntimeObject.getVariableNumber;
    returnVariable: typeof gdjs.RuntimeObject.returnVariable;
    getVariableString: typeof gdjs.RuntimeObject.getVariableString;
    setVariableNumber: typeof gdjs.RuntimeObject.setVariableNumber;
    setVariableString: typeof gdjs.RuntimeObject.setVariableString;
    getVariableBoolean: (variable: gdjs.Variable, compareWith: boolean) => boolean;
    setVariableBoolean: (variable: gdjs.Variable, newValue: boolean) => void;
    toggleVariableBoolean: (variable: gdjs.Variable) => void;
    variableChildExists: typeof gdjs.RuntimeObject.variableChildExists;
    variableRemoveChild: typeof gdjs.RuntimeObject.variableRemoveChild;
    variableClearChildren: typeof gdjs.RuntimeObject.variableClearChildren;
    variablePushCopy: (array: gdjs.Variable, variable: gdjs.Variable) => void;
    valuePush: (array: gdjs.Variable, value: string | number | boolean) => void;
    variableRemoveAt: (array: gdjs.Variable, index: number) => void;
    getSqDistanceTo: (targetX: number, targetY: number) => number;
};
