require "base64"

class CommitsController < ApplicationController
  before_filter :project

  # GET /commits
  # GET /commits.json
  def index
    @repo = project.repo
    @branch = params[:branch] || "master"
    @commits = @repo.commits(@branch, params[:limit] || 100, params[:offset] || 0)

    respond_to do |format|
      format.html # index.html.erb
      format.js
      format.json { render json: @commits }
    end
  end

  # GET /commits/1
  # GET /commits/1.json
  def show
    @commit = project.repo.commits(params[:id]).first

    respond_to do |format|
      format.html # show.html.erb
      format.json { render json: @commit }
    end
  end

  protected 

  def project 
    @project ||= Project.find(params[:project_id])
  end
end
