class TeamMembersController < ApplicationController
  before_filter :project 

  def show
    @team_member = TeamMember.find(params[:id])

    respond_to do |format|
      format.html # show.html.erb
      format.js
      format.json { render json: @team_member }
    end
  end

  # GET /team_members/new
  # GET /team_members/new.json
  def new
    @team_member = project.users_projects.new

    respond_to do |format|
      format.html # new.html.erb
      format.js
      format.json { render json: @team_member }
    end
  end

  # POST /team_members
  # POST /team_members.json
  def create
    @team_member = project.users_projects.new(params[:team_member])

    respond_to do |format|
      if @team_member.save
        format.html { redirect_to @team_member, notice: 'Team member was successfully created.' }
        format.js
        format.json { render json: @team_member, status: :created, location: @team_member }
      else
        format.html { render action: "new" }
        format.js
        format.json { render json: @team_member.errors, status: :unprocessable_entity }
      end
    end
  end

  # PUT /team_members/1
  # PUT /team_members/1.json
  #def update
    #@team_member = TeamMember.find(params[:id])

    #respond_to do |format|
      #if @team_member.update_attributes(params[:team_member])
        #format.html { redirect_to @team_member, notice: 'Team member was successfully updated.' }
        #format.json { head :ok }
      #else
        #format.html { render action: "edit" }
        #format.json { render json: @team_member.errors, status: :unprocessable_entity }
      #end
    #end
  #end

  # DELETE /team_members/1
  # DELETE /team_members/1.json
  def destroy
    @team_member = UsersProject.find(params[:id])
    @team_member.destroy

    respond_to do |format|
      format.html { redirect_to team_members_url }
      format.json { head :ok }
      format.js { render :nothing => true }  
    end
  end


  protected 

  def project 
    @project ||= Project.find(params[:project_id])
  end
end
