require File.join(Rails.root, "spec", "factories")


# 
# Test repo
#
if Rails.env == "test"
  Dir.chdir("/tmp")
`rm -rf legit_test`
  Dir.mkdir('legit_test') unless File.exists?("/tmp/legit_test")
  Dir.chdir("/tmp/legit_test")
`git clone git://github.com/randx/legit.git`
  puts "/tmp/legit_test/legit repo cloned"
end


# 
# Dev repo
#
  Dir.chdir("/tmp")
`rm -rf legit_dev`
  Dir.mkdir('legit_dev') unless File.exists?("/tmp/legit_dev")
  Dir.chdir("/tmp/legit_dev")
`git clone git://github.com/randx/legit.git`
  puts "/tmp/legit_dev/legit repo cloned"


#
# Dev seeds
#
if Rails.env == "development" || Rails.env == "production" 
  @project = Project.find_by_name("TestApp") ||
    Project.create(:name => "TestApp", 
                   :path => "/tmp/legit_dev/legit",
                   :description => "Lorem ipsum dolor sit amet, ...")

  @user = Factory :user,
    :email => "admin@legit.com",
    :password => "123456",
    :password_confirmation => "123456"

  @project.add_access(@user, :read, :write, :admin)

  # 2 collaborators
  3.times do |i|
    user = Factory :user
    @project.add_access(user, :read, :write)
  end

  # 2 viewers
  4.times do |i|
    user = Factory :user
    @project.add_access(user, :read)
  end

  # 2 other users
  8.times do |i|
    user = Factory :user
  end
end
