/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.PLPXMLInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSLenType;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.SimpleInputStream;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.IOException;
import java.util.Calendar;

final class ServerDTVImpl
extends DTVImpl {
    private int valueLength;
    private TDSReaderMark valueMark;
    private boolean isNull;
    private static final int STREAMCONSUMED = -2;

    ServerDTVImpl() {
    }

    @Override
    void setValue(DTV dTV, SQLCollation sQLCollation, JDBCType jDBCType, Object object, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        dTV.setImpl(new AppDTVImpl());
        dTV.setValue(sQLCollation, jDBCType, object, javaType, streamSetterArgs, calendar, n, sQLServerConnection);
    }

    @Override
    void setValue(Object object, JavaType javaType) {
        assert (false);
    }

    void setPositionAfterStreamed(TDSReader tDSReader) {
        this.valueMark = tDSReader.mark();
        this.valueLength = -2;
    }

    @Override
    void setStreamSetterArgs(StreamSetterArgs streamSetterArgs) {
        assert (false);
    }

    @Override
    void setCalendar(Calendar calendar) {
        assert (false);
    }

    @Override
    void setScale(Integer n) {
        assert (false);
    }

    @Override
    StreamSetterArgs getStreamSetterArgs() {
        assert (false);
        return null;
    }

    @Override
    Calendar getCalendar() {
        assert (false);
        return null;
    }

    @Override
    Integer getScale() {
        assert (false);
        return null;
    }

    @Override
    boolean isNull() {
        return this.isNull;
    }

    @Override
    void setJdbcType(JDBCType jDBCType) {
        assert (false);
    }

    @Override
    JDBCType getJdbcType() {
        assert (false);
        return JDBCType.UNKNOWN;
    }

    @Override
    JavaType getJavaType() {
        assert (false);
        return JavaType.OBJECT;
    }

    @Override
    final void initFromCompressedNull() {
        assert (this.valueMark == null);
        this.isNull = true;
    }

    @Override
    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.valueMark && this.isNull) {
            return;
        }
        if (null == this.valueMark) {
            this.getValuePrep(typeInfo, tDSReader);
        }
        tDSReader.reset(this.valueMark);
        if (this.valueLength != -2) {
            if (this.valueLength == -1) {
                assert (SSLenType.PARTLENTYPE == typeInfo.getSSLenType());
                PLPInputStream pLPInputStream = PLPInputStream.makeTempStream(tDSReader, bl, this);
                try {
                    if (null != pLPInputStream) {
                        pLPInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    tDSReader.getConnection().terminate(3, iOException.getMessage());
                }
            } else {
                assert (this.valueLength >= 0);
                tDSReader.skip(this.valueLength);
            }
        }
    }

    private final void getValuePrep(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        assert (null == this.valueMark);
        switch (typeInfo.getSSLenType()) {
            case PARTLENTYPE: {
                this.valueLength = -1;
                this.isNull = PLPInputStream.isNull(tDSReader);
                break;
            }
            case FIXEDLENTYPE: {
                this.valueLength = typeInfo.getMaxLength();
                this.isNull = 0 == this.valueLength;
                break;
            }
            case BYTELENTYPE: {
                this.valueLength = tDSReader.readUnsignedByte();
                this.isNull = 0 == this.valueLength;
                break;
            }
            case USHORTLENTYPE: {
                this.valueLength = tDSReader.readUnsignedShort();
                boolean bl = this.isNull = 65535 == this.valueLength;
                if (!this.isNull) break;
                this.valueLength = 0;
                break;
            }
            case LONGLENTYPE: {
                if (SSType.TEXT == typeInfo.getSSType() || SSType.IMAGE == typeInfo.getSSType() || SSType.NTEXT == typeInfo.getSSType()) {
                    boolean bl = this.isNull = 0 == tDSReader.readUnsignedByte();
                    if (this.isNull) {
                        this.valueLength = 0;
                        break;
                    }
                    tDSReader.skip(24);
                    this.valueLength = tDSReader.readInt();
                    break;
                }
                this.valueLength = tDSReader.readInt();
                boolean bl = this.isNull = 0 == this.valueLength;
            }
        }
        if (this.valueLength > typeInfo.getMaxLength()) {
            tDSReader.throwInvalidTDS();
        }
        this.valueMark = tDSReader.mark();
    }

    @Override
    Object getValue(DTV dTV, JDBCType jDBCType, int n, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        Object object = null;
        if (null == this.valueMark && !this.isNull) {
            this.getValuePrep(typeInfo, tDSReader);
        }
        assert (this.valueMark != null || this.valueMark == null && this.isNull);
        boolean bl = false;
        if (null != inputStreamGetterArgs) {
            if (!inputStreamGetterArgs.streamType.convertsFrom(typeInfo)) {
                DataTypes.throwConversionError(typeInfo.getSSType().toString(), inputStreamGetterArgs.streamType.toString());
            }
        } else {
            if (!typeInfo.getSSType().convertsTo(jDBCType)) {
                DataTypes.throwConversionError(typeInfo.getSSType().toString(), jDBCType.toString());
            }
            inputStreamGetterArgs = InputStreamGetterArgs.getDefaultArgs();
        }
        if (-2 == this.valueLength) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_dataAlreadyAccessed"), null, 0, false);
        }
        if (!this.isNull) {
            tDSReader.reset(this.valueMark);
            block0 : switch (typeInfo.getSSType()) {
                case VARBINARYMAX: 
                case VARCHARMAX: 
                case NVARCHARMAX: 
                case UDT: {
                    object = DDC.convertStreamToObject(PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, this), typeInfo, jDBCType, inputStreamGetterArgs);
                    break;
                }
                case XML: {
                    object = DDC.convertStreamToObject(jDBCType.isBinary() || jDBCType == JDBCType.SQLXML ? PLPXMLInputStream.makeXMLStream(tDSReader, inputStreamGetterArgs, this) : PLPInputStream.makeStream(tDSReader, inputStreamGetterArgs, this), typeInfo, jDBCType, inputStreamGetterArgs);
                    break;
                }
                case CHAR: 
                case VARCHAR: 
                case TEXT: 
                case NCHAR: 
                case NVARCHAR: 
                case NTEXT: 
                case IMAGE: 
                case BINARY: 
                case VARBINARY: 
                case TIMESTAMP: {
                    object = DDC.convertStreamToObject(new SimpleInputStream(tDSReader, this.valueLength, inputStreamGetterArgs, this), typeInfo, jDBCType, inputStreamGetterArgs);
                    break;
                }
                case BIT: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    switch (this.valueLength) {
                        case 8: {
                            object = DDC.convertLongToObject(tDSReader.readLong(), jDBCType, inputStreamGetterArgs.streamType);
                            break block0;
                        }
                        case 4: {
                            object = DDC.convertIntegerToObject(tDSReader.readInt(), this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                            break block0;
                        }
                        case 2: {
                            object = DDC.convertIntegerToObject(tDSReader.readShort(), this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                            break block0;
                        }
                        case 1: {
                            object = DDC.convertIntegerToObject(tDSReader.readUnsignedByte(), this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                            break block0;
                        }
                    }
                    assert (false) : "Unexpected valueLength" + this.valueLength;
                    break;
                }
                case DECIMAL: 
                case NUMERIC: {
                    object = tDSReader.readDecimal(this.valueLength, typeInfo, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                case MONEY: 
                case SMALLMONEY: {
                    object = tDSReader.readMoney(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                case FLOAT: {
                    object = tDSReader.readFloat(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                case REAL: {
                    object = tDSReader.readReal(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                case DATETIME: 
                case SMALLDATETIME: {
                    object = tDSReader.readDateTime(this.valueLength, calendar, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                case DATE: {
                    object = tDSReader.readDate(this.valueLength, calendar, jDBCType);
                    break;
                }
                case TIME: {
                    object = tDSReader.readTime(this.valueLength, typeInfo, calendar, jDBCType);
                    break;
                }
                case DATETIME2: {
                    object = tDSReader.readDateTime2(this.valueLength, typeInfo, calendar, jDBCType);
                    break;
                }
                case DATETIMEOFFSET: {
                    object = tDSReader.readDateTimeOffset(this.valueLength, typeInfo, jDBCType);
                    break;
                }
                case GUID: {
                    object = tDSReader.readGUID(this.valueLength, jDBCType, inputStreamGetterArgs.streamType);
                    break;
                }
                default: {
                    assert (false) : "Unexpected SSType " + (Object)((Object)typeInfo.getSSType());
                    break;
                }
            }
        }
        assert (this.isNull || null != object);
        return object;
    }

    @Override
    Object getSetterValue() {
        assert (false);
        return null;
    }
}

