package com.dotmarketing.business.web;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import com.dotcms.business.CloseDBIfOpened;
import com.dotmarketing.business.APILocator;
import com.dotmarketing.business.DotStateException;
import com.dotmarketing.exception.DotRuntimeException;
import com.dotmarketing.portlets.languagesmanager.business.LanguageAPI;
import com.dotmarketing.portlets.languagesmanager.model.Language;
import com.dotmarketing.util.Logger;
import com.dotmarketing.util.UtilMethods;
import com.dotmarketing.util.WebKeys;
import com.liferay.portal.struts.MultiMessageResources;
import com.liferay.portal.struts.MultiMessageResourcesFactory;

/**
 * Implement LanguageWebAPI methods to manage language cache and language struts
 *
 * @author Oswaldo
 * @author David H Torres
 * @version 1.9
 *
 */
public class LanguageWebAPIImpl implements LanguageWebAPI {

    private LanguageAPI langAPI;

    public LanguageWebAPIImpl() {
        langAPI = APILocator.getLanguageAPI();
    }
    private static final String HTMLPAGE_CURRENT_LANGUAGE = WebKeys.HTMLPAGE_LANGUAGE + ".current";
    /**
     * Clear the language cache and struts cache
     *
     * @throws DotRuntimeException
     */
    public void clearCache() throws DotRuntimeException {

        langAPI.clearCache();
        MultiMessageResources messages = (MultiMessageResources) MultiMessageResourcesFactory.getResources();
        messages.reload();

    }



    // only try internal session and attributes
    private Language currentLanguage(HttpServletRequest httpRequest) {
        HttpSession sessionOpt = httpRequest.getSession(false);
        Language lang = null;

        try{
            if(sessionOpt !=null){
                if(sessionOpt.getAttribute("tm_lang")!=null){
                    lang = langAPI.getLanguage((String) sessionOpt.getAttribute("tm_lang"));
                }else{
                    lang= langAPI.getLanguage((String) sessionOpt.getAttribute(com.dotmarketing.util.WebKeys.HTMLPAGE_LANGUAGE));
                }
            }
            else if(UtilMethods.isSet(httpRequest.getAttribute(HTMLPAGE_CURRENT_LANGUAGE))){
                lang= langAPI.getLanguage((String) httpRequest.getAttribute(HTMLPAGE_CURRENT_LANGUAGE));
            }
            if(lang==null) {
                lang =langAPI.getDefaultLanguage();
            }
        }
        catch(Exception e){
            lang =langAPI.getDefaultLanguage();
        }



        return lang;
    }


    @Override
    public void checkSessionLocale(HttpServletRequest httpRequest) {
        getLanguage(httpRequest);

    }

    private Language futureLanguage(HttpServletRequest httpRequest,Language currentLang) {
        Language futureLang = currentLang;
        // update page language
        String tryId=null;
        if (UtilMethods.isSet(httpRequest.getParameter(WebKeys.HTMLPAGE_LANGUAGE))){
            tryId = httpRequest.getParameter(WebKeys.HTMLPAGE_LANGUAGE);
        }else if(UtilMethods.isSet(httpRequest.getParameter("language_id"))) {
            tryId = httpRequest.getParameter("language_id");
        } else if(UtilMethods.isSet(httpRequest.getAttribute(WebKeys.HTMLPAGE_LANGUAGE))) {
            tryId = (String)httpRequest.getAttribute(WebKeys.HTMLPAGE_LANGUAGE);
        }
        if(tryId!=null){
            try{
                futureLang = langAPI.getLanguage(Long.parseLong(tryId));
                if(futureLang==null) throw new DotStateException("lang cannot be null");
            } catch (Exception e){
                Logger.debug(this.getClass(), "invalid language passed in:" + tryId);
                futureLang=currentLang;
            }
        }

        return futureLang;
    }

    /**
     * Here is the order in which langauges should be checked:
     * first,      is there a parameter passed, if so use it
     * second,     is there an attribute set, if so use it
     * third,      is there a language in session, if so use it
     * finally     use the default language
     */
    @CloseDBIfOpened
    @Override
    public Language getLanguage(HttpServletRequest httpRequest) {
        final Language current = currentLanguage(httpRequest);
        final Language future = futureLanguage(httpRequest,current);
        Locale locale = new Locale(future.getLanguageCode(), future.getCountryCode());
        HttpSession sessionOpt = httpRequest.getSession(false);
        httpRequest.setAttribute(HTMLPAGE_CURRENT_LANGUAGE, String.valueOf(future.getId()));

        httpRequest.setAttribute(WebKeys.LOCALE, locale);

        // if someone is changing langauges, we need a session
        if(!current.equals(future)){
            sessionOpt = httpRequest.getSession(true);
        }
        if(sessionOpt!=null){
            //only set in session if we are not in a timemachine
            if(sessionOpt.getAttribute("tm_lang")==null){
                sessionOpt.setAttribute(WebKeys.HTMLPAGE_LANGUAGE, String.valueOf(future.getId()));
                boolean ADMIN_MODE = (sessionOpt.getAttribute(WebKeys.ADMIN_MODE_SESSION) != null);
                if (ADMIN_MODE == false || httpRequest.getParameter("leftMenu") == null) {
                    sessionOpt.setAttribute(WebKeys.Globals_FRONTEND_LOCALE_KEY, locale);
                    httpRequest.setAttribute(WebKeys.Globals_FRONTEND_LOCALE_KEY, locale);
                }
                sessionOpt.setAttribute(WebKeys.LOCALE, locale);
            }
        }
        return future;

    }




}