package com.dotmarketing.startup.runonce;

import java.util.ArrayList;
import java.util.List;

import com.dotmarketing.startup.AbstractJDBCStartupTask;

/**
 * This update task will update every <code>VARCHAR</code> and <code>TEXT</code>
 * column types to <code>NVARCHAR</code> and <code>NVARCHAR(MAX)</code>
 * respectively.
 * <p>
 * Currently, all parameterized DB queries cannot use the indexes on the text
 * fields because the indexes are for ASCII text. SQL Server JDBC Drivers are
 * passing query parameters as UTF-8, which forces a whole table scan for all
 * tables: inode, tree, identifier tables, etc. This makes SQL Server operations
 * slow. In its current state, it is incapable of serving UTF-8 content.
 * 
 * @author Jose Castro
 * @version 3.7
 * @since Nov 10, 2016
 *
 */
public class Task03600UpdateMssqlVarcharTextColumns extends AbstractJDBCStartupTask {

	@Override
	public boolean forceRun() {
		return true;
	}

	@Override
	public String getPostgresScript() {
		return null;
	}

	@Override
	public String getMySQLScript() {
		return null;
	}

	@Override
	public String getOracleScript() {
		return null;
	}

	@Override
	public String getMSSQLScript() {
		return    "ALTER TABLE Address ALTER COLUMN addressId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Address ALTER COLUMN companyId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Address ALTER COLUMN userId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Address ALTER COLUMN userName NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN className NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN classPK NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN description NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN street1 NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN street2 NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN city NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN state NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN zip NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN country NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN phone NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN fax NVARCHAR(100) NULL;"
				+ "ALTER TABLE Address ALTER COLUMN cell NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE AdminConfig ALTER COLUMN configId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE AdminConfig ALTER COLUMN companyId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE AdminConfig ALTER COLUMN type_ NVARCHAR(100) NULL;"
				+ "ALTER TABLE AdminConfig ALTER COLUMN name NVARCHAR(100) NULL;"
				+ "ALTER TABLE AdminConfig ALTER COLUMN config NVARCHAR(MAX) NULL;"
				
				+ "ALTER TABLE Company ALTER COLUMN companyId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Company ALTER COLUMN key_ NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE Company ALTER COLUMN portalURL NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Company ALTER COLUMN homeURL NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Company ALTER COLUMN mx NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Company ALTER COLUMN name NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Company ALTER COLUMN shortName NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Company ALTER COLUMN type_ NVARCHAR(100) NULL;"
				+ "ALTER TABLE Company ALTER COLUMN size_ NVARCHAR(100) NULL;"
				+ "ALTER TABLE Company ALTER COLUMN street NVARCHAR(100) NULL;"
				+ "ALTER TABLE Company ALTER COLUMN city NVARCHAR(100) NULL;"
				+ "ALTER TABLE Company ALTER COLUMN state NVARCHAR(100) NULL;"
				+ "ALTER TABLE Company ALTER COLUMN zip NVARCHAR(100) NULL;"
				+ "ALTER TABLE Company ALTER COLUMN phone NVARCHAR(100) NULL;"
				+ "ALTER TABLE Company ALTER COLUMN fax NVARCHAR(100) NULL;"
				+ "ALTER TABLE Company ALTER COLUMN emailAddress NVARCHAR(100) NULL;"
				+ "ALTER TABLE Company ALTER COLUMN authType NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE Counter ALTER COLUMN name NVARCHAR(100) NOT NULL;"
				
				+ "ALTER TABLE Image ALTER COLUMN imageId NVARCHAR(200) NOT NULL;"
				+ "ALTER TABLE Image ALTER COLUMN text_ NVARCHAR(MAX) NOT NULL;"
				
				+ "ALTER TABLE PasswordTracker ALTER COLUMN passwordTrackerId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PasswordTracker ALTER COLUMN userId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PasswordTracker ALTER COLUMN password_ NVARCHAR(100) NOT NULL;"
				
				+ "ALTER TABLE PollsChoice ALTER COLUMN choiceId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsChoice ALTER COLUMN questionId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsChoice ALTER COLUMN description NVARCHAR(1000) NULL;"
				
				+ "ALTER TABLE PollsDisplay ALTER COLUMN layoutId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsDisplay ALTER COLUMN userId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsDisplay ALTER COLUMN portletId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsDisplay ALTER COLUMN questionId NVARCHAR(100) NOT NULL;"
				
				+ "ALTER TABLE PollsQuestion ALTER COLUMN questionId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsQuestion ALTER COLUMN portletId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsQuestion ALTER COLUMN groupId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsQuestion ALTER COLUMN companyId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsQuestion ALTER COLUMN userId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsQuestion ALTER COLUMN userName NVARCHAR(100) NULL;"
				+ "ALTER TABLE PollsQuestion ALTER COLUMN title NVARCHAR(100) NULL;"
				+ "ALTER TABLE PollsQuestion ALTER COLUMN description NVARCHAR(1000) NULL;"
				
				+ "ALTER TABLE PollsVote ALTER COLUMN questionId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsVote ALTER COLUMN userId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PollsVote ALTER COLUMN choiceId NVARCHAR(100) NOT NULL;"
				
				+ "ALTER TABLE Portlet ALTER COLUMN portletId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Portlet ALTER COLUMN groupId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Portlet ALTER COLUMN companyId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE Portlet ALTER COLUMN defaultPreferences NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE Portlet ALTER COLUMN roles NVARCHAR(1000) NULL;"
				
				+ "ALTER TABLE PortletPreferences ALTER COLUMN portletId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PortletPreferences ALTER COLUMN userId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PortletPreferences ALTER COLUMN layoutId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE PortletPreferences ALTER COLUMN preferences NVARCHAR(MAX) NULL;"
				
				+ "ALTER TABLE Release_ ALTER COLUMN releaseId NVARCHAR(100) NOT NULL;"
				
				+ "ALTER TABLE User_ ALTER COLUMN userId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN companyId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN password_ NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN firstName NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN middleName NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN lastName NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN nickName NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN emailAddress NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN smsId NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN aimId NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN icqId NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN msnId NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN ymId NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN favoriteActivity NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN favoriteBibleVerse NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN favoriteFood NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN favoriteMovie NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN favoriteMusic NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN languageId NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN timeZoneId NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN skinId NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN greeting NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN resolution NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN refreshRate NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN layoutIds NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN comments NVARCHAR(1000) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN loginIP NVARCHAR(100) NULL;"
				+ "ALTER TABLE User_ ALTER COLUMN lastLoginIP NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE UserTracker ALTER COLUMN userTrackerId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE UserTracker ALTER COLUMN companyId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE UserTracker ALTER COLUMN userId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE UserTracker ALTER COLUMN remoteAddr NVARCHAR(100) NULL;"
				+ "ALTER TABLE UserTracker ALTER COLUMN remoteHost NVARCHAR(100) NULL;"
				+ "ALTER TABLE UserTracker ALTER COLUMN userAgent NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE UserTrackerPath ALTER COLUMN userTrackerPathId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE UserTrackerPath ALTER COLUMN userTrackerId NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE UserTrackerPath ALTER COLUMN path NVARCHAR(1000) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_CALENDARS ALTER COLUMN [CALENDAR_NAME] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_CRON_TRIGGERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_CRON_TRIGGERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_CRON_TRIGGERS ALTER COLUMN [CRON_EXPRESSION] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_CRON_TRIGGERS ALTER COLUMN [TIME_ZONE_ID] [NVARCHAR](80);"
				
				+ "ALTER TABLE QRTZ_FIRED_TRIGGERS ALTER COLUMN [ENTRY_ID] [NVARCHAR](95) NOT NULL;"
				+ "ALTER TABLE QRTZ_FIRED_TRIGGERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_FIRED_TRIGGERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_FIRED_TRIGGERS ALTER COLUMN [IS_VOLATILE] [NVARCHAR](1) NOT NULL;"
				+ "ALTER TABLE QRTZ_FIRED_TRIGGERS ALTER COLUMN [INSTANCE_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_FIRED_TRIGGERS ALTER COLUMN [STATE] [NVARCHAR](16) NOT NULL;"
				+ "ALTER TABLE QRTZ_FIRED_TRIGGERS ALTER COLUMN [JOB_NAME] [NVARCHAR](80) NULL;"
				+ "ALTER TABLE QRTZ_FIRED_TRIGGERS ALTER COLUMN [JOB_GROUP] [NVARCHAR](80) NULL;"
				+ "ALTER TABLE QRTZ_FIRED_TRIGGERS ALTER COLUMN [IS_STATEFUL] [NVARCHAR](1) NULL;"
				+ "ALTER TABLE QRTZ_FIRED_TRIGGERS ALTER COLUMN [REQUESTS_RECOVERY] [NVARCHAR](1) NULL;"
				
				+ "ALTER TABLE QRTZ_PAUSED_TRIGGER_GRPS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_SCHEDULER_STATE ALTER COLUMN [INSTANCE_NAME] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_LOCKS ALTER COLUMN [LOCK_NAME] [NVARCHAR](40) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_JOB_DETAILS ALTER COLUMN [JOB_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_JOB_DETAILS ALTER COLUMN [JOB_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_JOB_DETAILS ALTER COLUMN [DESCRIPTION] [NVARCHAR](120) NULL;"
				+ "ALTER TABLE QRTZ_JOB_DETAILS ALTER COLUMN [JOB_CLASS_NAME] [NVARCHAR](128) NOT NULL;"
				+ "ALTER TABLE QRTZ_JOB_DETAILS ALTER COLUMN [IS_DURABLE] [NVARCHAR](1) NOT NULL;"
				+ "ALTER TABLE QRTZ_JOB_DETAILS ALTER COLUMN [IS_VOLATILE] [NVARCHAR](1) NOT NULL;"
				+ "ALTER TABLE QRTZ_JOB_DETAILS ALTER COLUMN [IS_STATEFUL] [NVARCHAR](1) NOT NULL;"
				+ "ALTER TABLE QRTZ_JOB_DETAILS ALTER COLUMN [REQUESTS_RECOVERY] [NVARCHAR](1) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_JOB_LISTENERS ALTER COLUMN [JOB_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_JOB_LISTENERS ALTER COLUMN [JOB_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_JOB_LISTENERS ALTER COLUMN [JOB_LISTENER] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_SIMPLE_TRIGGERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_SIMPLE_TRIGGERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_BLOB_TRIGGERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_BLOB_TRIGGERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_TRIGGER_LISTENERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_TRIGGER_LISTENERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_TRIGGER_LISTENERS ALTER COLUMN [TRIGGER_LISTENER] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_TRIGGERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_TRIGGERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_TRIGGERS ALTER COLUMN [JOB_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_TRIGGERS ALTER COLUMN [JOB_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_TRIGGERS ALTER COLUMN [IS_VOLATILE] [NVARCHAR](1) NOT NULL;"
				+ "ALTER TABLE QRTZ_TRIGGERS ALTER COLUMN [DESCRIPTION] [NVARCHAR](120) NULL;"
				+ "ALTER TABLE QRTZ_TRIGGERS ALTER COLUMN [TRIGGER_STATE] [NVARCHAR](16) NOT NULL;"
				+ "ALTER TABLE QRTZ_TRIGGERS ALTER COLUMN [TRIGGER_TYPE] [NVARCHAR](8) NOT NULL;"
				+ "ALTER TABLE QRTZ_TRIGGERS ALTER COLUMN [CALENDAR_NAME] [NVARCHAR](80) NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_CALENDARS ALTER COLUMN [CALENDAR_NAME] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_CRON_TRIGGERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_CRON_TRIGGERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_CRON_TRIGGERS ALTER COLUMN [CRON_EXPRESSION] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_CRON_TRIGGERS ALTER COLUMN [TIME_ZONE_ID] [NVARCHAR](80);"
				
				+ "ALTER TABLE QRTZ_EXCL_FIRED_TRIGGERS ALTER COLUMN [ENTRY_ID] [NVARCHAR](95) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_FIRED_TRIGGERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_FIRED_TRIGGERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_FIRED_TRIGGERS ALTER COLUMN [IS_VOLATILE] [NVARCHAR](1) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_FIRED_TRIGGERS ALTER COLUMN [INSTANCE_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_FIRED_TRIGGERS ALTER COLUMN [STATE] [NVARCHAR](16) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_FIRED_TRIGGERS ALTER COLUMN [JOB_NAME] [NVARCHAR](80) NULL;"
				+ "ALTER TABLE QRTZ_EXCL_FIRED_TRIGGERS ALTER COLUMN [JOB_GROUP] [NVARCHAR](80) NULL;"
				+ "ALTER TABLE QRTZ_EXCL_FIRED_TRIGGERS ALTER COLUMN [IS_STATEFUL] [NVARCHAR](1) NULL;"
				+ "ALTER TABLE QRTZ_EXCL_FIRED_TRIGGERS ALTER COLUMN [REQUESTS_RECOVERY] [NVARCHAR](1) NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_PAUSED_TRIGGER_GRPS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_SCHEDULER_STATE ALTER COLUMN [INSTANCE_NAME] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_LOCKS ALTER COLUMN [LOCK_NAME] [NVARCHAR](40) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_JOB_DETAILS ALTER COLUMN [JOB_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_JOB_DETAILS ALTER COLUMN [JOB_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_JOB_DETAILS ALTER COLUMN [DESCRIPTION] [NVARCHAR](120) NULL;"
				+ "ALTER TABLE QRTZ_EXCL_JOB_DETAILS ALTER COLUMN [JOB_CLASS_NAME] [NVARCHAR](128) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_JOB_DETAILS ALTER COLUMN [IS_DURABLE] [NVARCHAR](1) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_JOB_DETAILS ALTER COLUMN [IS_VOLATILE] [NVARCHAR](1) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_JOB_DETAILS ALTER COLUMN [IS_STATEFUL] [NVARCHAR](1)  NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_JOB_DETAILS ALTER COLUMN [REQUESTS_RECOVERY] [NVARCHAR](1) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_JOB_LISTENERS ALTER COLUMN [JOB_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_JOB_LISTENERS ALTER COLUMN [JOB_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_JOB_LISTENERS ALTER COLUMN [JOB_LISTENER] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_SIMPLE_TRIGGERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_SIMPLE_TRIGGERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_BLOB_TRIGGERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_BLOB_TRIGGERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_TRIGGER_LISTENERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_TRIGGER_LISTENERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_TRIGGER_LISTENERS ALTER COLUMN [TRIGGER_LISTENER] [NVARCHAR](80) NOT NULL;"
				
				+ "ALTER TABLE QRTZ_EXCL_TRIGGERS ALTER COLUMN [TRIGGER_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_TRIGGERS ALTER COLUMN [TRIGGER_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_TRIGGERS ALTER COLUMN [JOB_NAME] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_TRIGGERS ALTER COLUMN [JOB_GROUP] [NVARCHAR](80) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_TRIGGERS ALTER COLUMN [IS_VOLATILE] [NVARCHAR](1) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_TRIGGERS ALTER COLUMN [DESCRIPTION] [NVARCHAR](120) NULL;"
				+ "ALTER TABLE QRTZ_EXCL_TRIGGERS ALTER COLUMN [TRIGGER_STATE] [NVARCHAR](16) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_TRIGGERS ALTER COLUMN [TRIGGER_TYPE] [NVARCHAR](8) NOT NULL;"
				+ "ALTER TABLE QRTZ_EXCL_TRIGGERS ALTER COLUMN [CALENDAR_NAME] [NVARCHAR](80) NULL;"
				
				+ "ALTER TABLE calendar_reminder ALTER COLUMN user_id NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE calendar_reminder ALTER COLUMN event_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE analytic_summary_pages ALTER COLUMN inode NVARCHAR(255) NULL;"
				+ "ALTER TABLE analytic_summary_pages ALTER COLUMN uri NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE tag ALTER COLUMN tag_id NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE tag ALTER COLUMN tagname NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE tag ALTER COLUMN host_id NVARCHAR(255) NULL;"
				+ "ALTER TABLE tag ALTER COLUMN user_id NVARCHAR(MAX);"
				
				+ "ALTER TABLE user_comments ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE user_comments ALTER COLUMN user_id NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_comments ALTER COLUMN comment_user_id NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_comments ALTER COLUMN type NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_comments ALTER COLUMN method NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_comments ALTER COLUMN subject NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_comments ALTER COLUMN ucomment NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE user_comments ALTER COLUMN communication_id NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE permission_reference ALTER COLUMN asset_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE permission_reference ALTER COLUMN reference_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE permission_reference ALTER COLUMN permission_type NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE contentlet_version_info ALTER COLUMN identifier NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE contentlet_version_info ALTER COLUMN working_inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE contentlet_version_info ALTER COLUMN live_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE contentlet_version_info ALTER COLUMN locked_by NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE fixes_audit ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE fixes_audit ALTER COLUMN table_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE fixes_audit ALTER COLUMN action NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE container_version_info ALTER COLUMN identifier NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE container_version_info ALTER COLUMN working_inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE container_version_info ALTER COLUMN live_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE container_version_info ALTER COLUMN locked_by NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE trackback ALTER COLUMN asset_identifier NVARCHAR(36) NULL;"
				+ "ALTER TABLE trackback ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE trackback ALTER COLUMN excerpt NVARCHAR(255) NULL;"
				+ "ALTER TABLE trackback ALTER COLUMN url NVARCHAR(255) NULL;"
				+ "ALTER TABLE trackback ALTER COLUMN blog_name NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE plugin ALTER COLUMN id NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE plugin ALTER COLUMN plugin_name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE plugin ALTER COLUMN plugin_version NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE plugin ALTER COLUMN author NVARCHAR(255) NOT NULL;"
				
				+ "ALTER TABLE mailing_list ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE mailing_list ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE mailing_list ALTER COLUMN user_id NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE recipient ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE recipient ALTER COLUMN name NVARCHAR(255) NULL;"
				+ "ALTER TABLE recipient ALTER COLUMN lastname NVARCHAR(255) NULL;"
				+ "ALTER TABLE recipient ALTER COLUMN email NVARCHAR(255) NULL;"
				+ "ALTER TABLE recipient ALTER COLUMN last_message NVARCHAR(255) NULL;"
				+ "ALTER TABLE recipient ALTER COLUMN user_id NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE web_form ALTER COLUMN web_form_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN form_type NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN prefix NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN first_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN middle_initial NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN middle_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN full_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN organization NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN last_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN address1 NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN address2 NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN city NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN state NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN zip NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN country NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN phone NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN email NVARCHAR(255) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN custom_fields NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN user_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE web_form ALTER COLUMN categories NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE virtual_link ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE virtual_link ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE virtual_link ALTER COLUMN url NVARCHAR(255) NULL;"
				+ "ALTER TABLE virtual_link ALTER COLUMN uri NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE analytic_summary_period ALTER COLUMN year NVARCHAR(255) NULL;"
				+ "ALTER TABLE analytic_summary_period ALTER COLUMN dayname NVARCHAR(50) NOT NULL;"
				+ "ALTER TABLE analytic_summary_period ALTER COLUMN monthname NVARCHAR(50) NOT NULL;"
				
				+ "ALTER TABLE tree ALTER COLUMN child NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE tree ALTER COLUMN parent NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE tree ALTER COLUMN relation_type NVARCHAR(64) NOT NULL;"

				+ "ALTER TABLE analytic_summary ALTER COLUMN host_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE users_cms_roles ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE users_cms_roles ALTER COLUMN user_id NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE users_cms_roles ALTER COLUMN role_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE template ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE template ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE template ALTER COLUMN mod_user NVARCHAR(100) NULL;"
				+ "ALTER TABLE template ALTER COLUMN friendly_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE template ALTER COLUMN body NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE template ALTER COLUMN header NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE template ALTER COLUMN footer NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE template ALTER COLUMN image NVARCHAR(36) NULL;"
				+ "ALTER TABLE template ALTER COLUMN identifier NVARCHAR(36) NULL;"
				+ "ALTER TABLE template ALTER COLUMN drawed_body NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE template ALTER COLUMN head_code NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE template ALTER COLUMN theme NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE analytic_summary_content ALTER COLUMN inode NVARCHAR(255) NULL;"
				+ "ALTER TABLE analytic_summary_content ALTER COLUMN uri NVARCHAR(255) NULL;"
				+ "ALTER TABLE analytic_summary_content ALTER COLUMN title NVARCHAR(255) NULL;"

				+ "ALTER TABLE structure ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE structure ALTER COLUMN name NVARCHAR(255) NULL;"
				+ "ALTER TABLE structure ALTER COLUMN description NVARCHAR(255) NULL;"
				+ "ALTER TABLE structure ALTER COLUMN review_interval NVARCHAR(255) NULL;"
				+ "ALTER TABLE structure ALTER COLUMN reviewer_role NVARCHAR(255) NULL;"
				+ "ALTER TABLE structure ALTER COLUMN page_detail NVARCHAR(36) NULL;"
				+ "ALTER TABLE structure ALTER COLUMN velocity_var_name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE structure ALTER COLUMN url_map_pattern NVARCHAR(512) NULL;"
				+ "ALTER TABLE structure ALTER COLUMN host NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE structure ALTER COLUMN folder NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE structure ALTER COLUMN expire_date_var NVARCHAR(255) NULL;"
				+ "ALTER TABLE structure ALTER COLUMN publish_date_var NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE cms_role ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE cms_role ALTER COLUMN role_name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE cms_role ALTER COLUMN description NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE cms_role ALTER COLUMN role_key NVARCHAR(255) NULL;"
				+ "ALTER TABLE cms_role ALTER COLUMN db_fqn NVARCHAR(1000) NOT NULL;"
				+ "ALTER TABLE cms_role ALTER COLUMN parent NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE container_structures ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE container_structures ALTER COLUMN container_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE container_structures ALTER COLUMN container_inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE container_structures ALTER COLUMN structure_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE container_structures ALTER COLUMN code NVARCHAR(MAX) NULL;"
				
				+ "ALTER TABLE permission ALTER COLUMN permission_type NVARCHAR(100) NULL;"
				+ "ALTER TABLE permission ALTER COLUMN inode_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE permission ALTER COLUMN roleid NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE contentlet ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN mod_user NVARCHAR(100) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN friendly_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN structure_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN review_interval NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN disabled_wysiwyg NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN identifier NVARCHAR(36) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text1 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text2 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text3 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text4 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text5 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text6 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text7 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text8 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text9 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text10 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text11 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text12 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text13 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text14 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text15 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text16 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text17 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text18 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text19 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text20 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text21 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text22 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text23 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text24 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text25 NVARCHAR(255) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area1 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area2 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area3 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area4 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area5 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area6 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area7 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area8 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area8 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area10 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area11 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area12 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area13 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area14 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area15 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area16 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area17 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area18 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area19 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area20 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area21 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area22 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area23 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area24 NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE contentlet ALTER COLUMN text_area25 NVARCHAR(MAX) NULL;"
				
				+ "ALTER TABLE analytic_summary_404 ALTER COLUMN host_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE analytic_summary_404 ALTER COLUMN uri NVARCHAR(255) NULL;"
				+ "ALTER TABLE analytic_summary_404 ALTER COLUMN referer_uri NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE cms_layouts_portlets ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE cms_layouts_portlets ALTER COLUMN layout_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE cms_layouts_portlets ALTER COLUMN portlet_id NVARCHAR(100) NOT NULL;"
				
				+ "ALTER TABLE inode ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE inode ALTER COLUMN owner NVARCHAR(255) NULL;"
				+ "ALTER TABLE inode ALTER COLUMN type NVARCHAR(64) NULL;"
				
				+ "ALTER TABLE report_asset ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE report_asset ALTER COLUMN report_name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE report_asset ALTER COLUMN report_description NVARCHAR(1000) NOT NULL;"
				+ "ALTER TABLE report_asset ALTER COLUMN ds NVARCHAR(100) NOT NULL;"
				
				+ "ALTER TABLE workflow_comment ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_comment ALTER COLUMN posted_by NVARCHAR(255) NULL;"
				+ "ALTER TABLE workflow_comment ALTER COLUMN wf_comment NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE workflow_comment ALTER COLUMN workflowtask_id NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE category ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE category ALTER COLUMN category_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE category ALTER COLUMN category_key NVARCHAR(255) NULL;"
				+ "ALTER TABLE category ALTER COLUMN keywords NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE category ALTER COLUMN category_velocity_var_name NVARCHAR(255) NOT NULL;"
				
				+ "ALTER TABLE htmlpage ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE htmlpage ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE htmlpage ALTER COLUMN mod_user NVARCHAR(100) NULL;"
				+ "ALTER TABLE htmlpage ALTER COLUMN friendly_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE htmlpage ALTER COLUMN metadata NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE htmlpage ALTER COLUMN page_url NVARCHAR(255) NULL;"
				+ "ALTER TABLE htmlpage ALTER COLUMN redirect NVARCHAR(255) NULL;"
				+ "ALTER TABLE htmlpage ALTER COLUMN identifier NVARCHAR(36) NULL;"
				+ "ALTER TABLE htmlpage ALTER COLUMN seo_description NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE htmlpage ALTER COLUMN seo_keywords NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE htmlpage ALTER COLUMN template_id NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE chain_link_code ALTER COLUMN class_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE chain_link_code ALTER COLUMN code NVARCHAR(MAX) NOT NULL;"
				+ "ALTER TABLE chain_link_code ALTER COLUMN language NVARCHAR(255) NOT NULL;"
				
				+ "ALTER TABLE analytic_summary_visits ALTER COLUMN host_id NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE template_version_info ALTER COLUMN identifier NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE template_version_info ALTER COLUMN working_inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE template_version_info ALTER COLUMN live_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE template_version_info ALTER COLUMN locked_by NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE user_preferences ALTER COLUMN user_id NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE user_preferences ALTER COLUMN preference NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_preferences ALTER COLUMN pref_value NVARCHAR(MAX) NULL;"
				
				+ "ALTER TABLE language ALTER COLUMN language_code NVARCHAR(5) NULL;"
				+ "ALTER TABLE language ALTER COLUMN country_code NVARCHAR(255) NULL;"
				+ "ALTER TABLE language ALTER COLUMN language NVARCHAR(255) NULL;"
				+ "ALTER TABLE language ALTER COLUMN country NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE users_to_delete ALTER COLUMN user_id NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE identifier ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE identifier ALTER COLUMN parent_path NVARCHAR(255) NULL;"
				+ "ALTER TABLE identifier ALTER COLUMN asset_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE identifier ALTER COLUMN host_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE identifier ALTER COLUMN asset_type NVARCHAR(64) NULL;"
				
				+ "ALTER TABLE clickstream ALTER COLUMN cookie_id NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN user_id NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN referer NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN remote_address NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN remote_hostname NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN user_agent NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN host_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN last_page_id NVARCHAR(50) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN first_page_id NVARCHAR(50) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN operating_system NVARCHAR(50) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN browser_name NVARCHAR(50) NULL;"
				+ "ALTER TABLE clickstream ALTER COLUMN browser_version NVARCHAR(50) NULL;"
				
				+ "ALTER TABLE multi_tree ALTER COLUMN child NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE multi_tree ALTER COLUMN parent1 NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE multi_tree ALTER COLUMN parent2 NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE multi_tree ALTER COLUMN relation_type NVARCHAR(64) NULL;"
				
				+ "ALTER TABLE workflow_task ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_task ALTER COLUMN created_by NVARCHAR(255) NULL;"
				+ "ALTER TABLE workflow_task ALTER COLUMN assigned_to NVARCHAR(255) NULL;"
				+ "ALTER TABLE workflow_task ALTER COLUMN belongs_to NVARCHAR(255) NULL;"
				+ "ALTER TABLE workflow_task ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE workflow_task ALTER COLUMN description NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE workflow_task ALTER COLUMN status NVARCHAR(255) NULL;"
				+ "ALTER TABLE workflow_task ALTER COLUMN webasset NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE tag_inode ALTER COLUMN tag_id NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE tag_inode ALTER COLUMN inode NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE tag_inode ALTER COLUMN field_var_name NVARCHAR(255);"
				
				+ "ALTER TABLE click ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE click ALTER COLUMN link NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE challenge_question ALTER COLUMN cqtext NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE file_asset ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE file_asset ALTER COLUMN file_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE file_asset ALTER COLUMN mime_type NVARCHAR(255) NULL;"
				+ "ALTER TABLE file_asset ALTER COLUMN author NVARCHAR(255) NULL;"
				+ "ALTER TABLE file_asset ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE file_asset ALTER COLUMN friendly_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE file_asset ALTER COLUMN mod_user NVARCHAR(100) NULL;"
				+ "ALTER TABLE file_asset ALTER COLUMN identifier NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE layouts_cms_roles ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE layouts_cms_roles ALTER COLUMN layout_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE layouts_cms_roles ALTER COLUMN role_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE clickstream_request ALTER COLUMN server_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream_request ALTER COLUMN protocol NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream_request ALTER COLUMN request_uri NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream_request ALTER COLUMN query_string NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE clickstream_request ALTER COLUMN host_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE clickstream_request ALTER COLUMN associated_identifier NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE content_rating ALTER COLUMN user_id NVARCHAR(255) NULL;"
				+ "ALTER TABLE content_rating ALTER COLUMN session_id NVARCHAR(255) NULL;"
				+ "ALTER TABLE content_rating ALTER COLUMN identifier NVARCHAR(36) NULL;"
				+ "ALTER TABLE content_rating ALTER COLUMN user_ip NVARCHAR(255) NULL;"
				+ "ALTER TABLE content_rating ALTER COLUMN long_live_cookie_id NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE analytic_summary_workstream ALTER COLUMN inode NVARCHAR(255) NULL;"
				+ "ALTER TABLE analytic_summary_workstream ALTER COLUMN asset_type NVARCHAR(255) NULL;"
				+ "ALTER TABLE analytic_summary_workstream ALTER COLUMN mod_user_id NVARCHAR(255) NULL;"
				+ "ALTER TABLE analytic_summary_workstream ALTER COLUMN host_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE analytic_summary_workstream ALTER COLUMN action NVARCHAR(255) NULL;"
				+ "ALTER TABLE analytic_summary_workstream ALTER COLUMN name NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE dashboard_user_preferences ALTER COLUMN user_id NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE campaign ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN from_email NVARCHAR(255) NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN from_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN subject NVARCHAR(255) NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN message NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN user_id NVARCHAR(255) NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN sends_per_hour NVARCHAR(15) NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN communicationinode NVARCHAR(36) NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN userfilterinode NVARCHAR(36) NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN sendto NVARCHAR(15) NULL;"
				+ "ALTER TABLE campaign ALTER COLUMN parent_campaign NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE htmlpage_version_info ALTER COLUMN identifier NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE htmlpage_version_info ALTER COLUMN working_inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE htmlpage_version_info ALTER COLUMN live_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE htmlpage_version_info ALTER COLUMN locked_by NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE workflowtask_files ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflowtask_files ALTER COLUMN workflowtask_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflowtask_files ALTER COLUMN file_inode NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE analytic_summary_referer ALTER COLUMN uri NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE dot_containers ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE dot_containers ALTER COLUMN code NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE dot_containers ALTER COLUMN pre_loop NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE dot_containers ALTER COLUMN post_loop NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE dot_containers ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE dot_containers ALTER COLUMN mod_user NVARCHAR(100) NULL;"
				+ "ALTER TABLE dot_containers ALTER COLUMN friendly_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE dot_containers ALTER COLUMN sort_contentlets_by NVARCHAR(255) NULL;"
				+ "ALTER TABLE dot_containers ALTER COLUMN lucene_query NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE dot_containers ALTER COLUMN notes NVARCHAR(255) NULL;"
				+ "ALTER TABLE dot_containers ALTER COLUMN identifier NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE communication ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE communication ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE communication ALTER COLUMN trackback_link_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE communication ALTER COLUMN communication_type NVARCHAR(255) NULL;"
				+ "ALTER TABLE communication ALTER COLUMN from_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE communication ALTER COLUMN from_email NVARCHAR(255) NULL;"
				+ "ALTER TABLE communication ALTER COLUMN email_subject NVARCHAR(255) NULL;"
				+ "ALTER TABLE communication ALTER COLUMN html_page_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE communication ALTER COLUMN text_message NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE communication ALTER COLUMN modified_by NVARCHAR(255) NULL;"
				+ "ALTER TABLE communication ALTER COLUMN ext_comm_id NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE fileasset_version_info ALTER COLUMN identifier NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE fileasset_version_info ALTER COLUMN working_inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE fileasset_version_info ALTER COLUMN live_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE fileasset_version_info ALTER COLUMN locked_by NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE workflow_history ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_history ALTER COLUMN made_by NVARCHAR(255) NULL;"
				+ "ALTER TABLE workflow_history ALTER COLUMN change_desc NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE workflow_history ALTER COLUMN workflowtask_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE workflow_history ALTER COLUMN workflow_action_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE workflow_history ALTER COLUMN workflow_step_id NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE host_variable ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE host_variable ALTER COLUMN host_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE host_variable ALTER COLUMN variable_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE host_variable ALTER COLUMN variable_key NVARCHAR(255) NULL;"
				+ "ALTER TABLE host_variable ALTER COLUMN variable_value NVARCHAR(255) NULL;"
				+ "ALTER TABLE host_variable ALTER COLUMN user_id NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE links ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE links ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE links ALTER COLUMN mod_user NVARCHAR(100) NULL;"
				+ "ALTER TABLE links ALTER COLUMN friendly_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE links ALTER COLUMN protocal NVARCHAR(100) NULL;"
				+ "ALTER TABLE links ALTER COLUMN url NVARCHAR(255) NULL;"
				+ "ALTER TABLE links ALTER COLUMN target NVARCHAR(100) NULL;"
				+ "ALTER TABLE links ALTER COLUMN internal_link_identifier NVARCHAR(36) NULL;"
				+ "ALTER TABLE links ALTER COLUMN link_type NVARCHAR(255) NULL;"
				+ "ALTER TABLE links ALTER COLUMN link_code NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE links ALTER COLUMN identifier NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE user_proxy ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN user_id NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN prefix NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN suffix NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN school NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN how_heard NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN company NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN long_lived_cookie NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN website NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN organization NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var1 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var2 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var3 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var4 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var5 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var6 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var7 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var8 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var9 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var10 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var11 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var12 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var13 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var14 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var15 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var16 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var17 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var18 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var19 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var20 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var21 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var22 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var23 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var24 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN var25 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN last_message NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN cquestionid NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN cqanswer NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_proxy ALTER COLUMN chapter_officer NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE chain_state_parameter ALTER COLUMN name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE chain_state_parameter ALTER COLUMN value NVARCHAR(255) NOT NULL;"
				
				+ "ALTER TABLE field ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE field ALTER COLUMN structure_inode NVARCHAR(255) NULL;"
				+ "ALTER TABLE field ALTER COLUMN field_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE field ALTER COLUMN field_type NVARCHAR(255) NULL;"
				+ "ALTER TABLE field ALTER COLUMN field_relation_type NVARCHAR(255) NULL;"
				+ "ALTER TABLE field ALTER COLUMN field_contentlet NVARCHAR(255) NULL;"
				+ "ALTER TABLE field ALTER COLUMN velocity_var_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE field ALTER COLUMN field_values NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE field ALTER COLUMN regex_check NVARCHAR(255) NULL;"
				+ "ALTER TABLE field ALTER COLUMN hint NVARCHAR(255) NULL;"
				+ "ALTER TABLE field ALTER COLUMN default_value NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE relationship ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE relationship ALTER COLUMN parent_structure_inode NVARCHAR(255) NULL;"
				+ "ALTER TABLE relationship ALTER COLUMN child_structure_inode NVARCHAR(255) NULL;"
				+ "ALTER TABLE relationship ALTER COLUMN parent_relation_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE relationship ALTER COLUMN child_relation_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE relationship ALTER COLUMN relation_type_value NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE folder ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE folder ALTER COLUMN name NVARCHAR(255) NULL;"
				+ "ALTER TABLE folder ALTER COLUMN title NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE folder ALTER COLUMN files_masks NVARCHAR(255) NULL;"
				+ "ALTER TABLE folder ALTER COLUMN identifier NVARCHAR(36) NULL;"
				+ "ALTER TABLE folder ALTER COLUMN default_file_type NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE clickstream_404 ALTER COLUMN referer_uri NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream_404 ALTER COLUMN query_string NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE clickstream_404 ALTER COLUMN request_uri NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream_404 ALTER COLUMN user_id NVARCHAR(255) NULL;"
				+ "ALTER TABLE clickstream_404 ALTER COLUMN host_id NVARCHAR(36) NULL;"
				
				+ "ALTER TABLE cms_layout ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE cms_layout ALTER COLUMN layout_name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE cms_layout ALTER COLUMN description NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE field_variable ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE field_variable ALTER COLUMN field_id NVARCHAR(36) NULL;"
				+ "ALTER TABLE field_variable ALTER COLUMN variable_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE field_variable ALTER COLUMN variable_key NVARCHAR(255) NULL;"
				+ "ALTER TABLE field_variable ALTER COLUMN variable_value NVARCHAR(MAX) NULL;"
				+ "ALTER TABLE field_variable ALTER COLUMN user_id NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE report_parameter ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE report_parameter ALTER COLUMN report_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE report_parameter ALTER COLUMN parameter_description NVARCHAR(1000) NULL;"
				+ "ALTER TABLE report_parameter ALTER COLUMN parameter_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE report_parameter ALTER COLUMN class_type NVARCHAR(250) NULL;"
				+ "ALTER TABLE report_parameter ALTER COLUMN default_value NVARCHAR(4000) NULL;"
				
				+ "ALTER TABLE chain ALTER COLUMN key_name NVARCHAR(255) NULL;"
				+ "ALTER TABLE chain ALTER COLUMN name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE chain ALTER COLUMN success_value NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE chain ALTER COLUMN failure_value NVARCHAR(255) NOT NULL;"
				
				+ "ALTER TABLE link_version_info ALTER COLUMN identifier NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE link_version_info ALTER COLUMN working_inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE link_version_info ALTER COLUMN live_inode NVARCHAR(36) NULL;"
				+ "ALTER TABLE link_version_info ALTER COLUMN locked_by NVARCHAR(100) NULL;"
				
				+ "ALTER TABLE template_containers ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE template_containers ALTER COLUMN template_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE template_containers ALTER COLUMN container_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE user_filter ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN title NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN firstname NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN middlename NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN lastname NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN emailaddress NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN birthdaytypesearch NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN lastlogintypesearch NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN lastloginsince NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN createdtypesearch NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN createdsince NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN lastvisittypesearch NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN lastvisitsince NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN city NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN state NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN country NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN zip NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN cell NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN phone NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN fax NVARCHAR(100) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN active_ NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN tagname NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var1 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var2 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var3 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var4 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var5 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var6 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var7 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var8 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var9 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var10 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var11 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var12 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var13 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var14 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var15 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var16 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var17 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var18 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var19 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var20 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var21 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var22 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var23 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var24 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN var25 NVARCHAR(255) NULL;"
				+ "ALTER TABLE user_filter ALTER COLUMN categories NVARCHAR(255) NULL;"
				
				+ "ALTER TABLE dist_journal ALTER COLUMN object_to_index NVARCHAR(1024) NOT NULL;"
				+ "ALTER TABLE dist_journal ALTER COLUMN serverid NVARCHAR(64) NOT NULL;"
				
				+ "ALTER TABLE dist_process ALTER COLUMN object_to_index NVARCHAR(1024) NOT NULL;"
				+ "ALTER TABLE dist_process ALTER COLUMN serverid NVARCHAR(64) NOT NULL;"
				
				+ "ALTER TABLE plugin_property ALTER COLUMN plugin_id NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE plugin_property ALTER COLUMN propkey NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE plugin_property ALTER COLUMN original_value NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE plugin_property ALTER COLUMN current_value NVARCHAR(255) NOT NULL;"
				
				+ "ALTER TABLE dist_reindex_journal ALTER COLUMN inode_to_index NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE dist_reindex_journal ALTER COLUMN ident_to_index NVARCHAR(100) NOT NULL;"
				+ "ALTER TABLE dist_reindex_journal ALTER COLUMN serverid NVARCHAR(64);"
				+ "ALTER TABLE dist_reindex_journal ALTER COLUMN index_val NVARCHAR(325);"
				
				+ "ALTER TABLE quartz_log ALTER COLUMN JOB_NAME NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE quartz_log ALTER COLUMN serverid NVARCHAR(64);"
				
				+ "ALTER TABLE import_audit ALTER COLUMN userid NVARCHAR(255);"
				+ "ALTER TABLE import_audit ALTER COLUMN filename NVARCHAR(512);"
				+ "ALTER TABLE import_audit ALTER COLUMN last_inode NVARCHAR(100);"
				+ "ALTER TABLE import_audit ALTER COLUMN serverid NVARCHAR(255);"
				+ "ALTER TABLE import_audit ALTER COLUMN warnings NVARCHAR(MAX);"
				+ "ALTER TABLE import_audit ALTER COLUMN errors NVARCHAR(MAX);"
				+ "ALTER TABLE import_audit ALTER COLUMN results NVARCHAR(MAX);"
				+ "ALTER TABLE import_audit ALTER COLUMN messages NVARCHAR(MAX);"
				
				+ "ALTER TABLE workflow_scheme ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_scheme ALTER COLUMN name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE workflow_scheme ALTER COLUMN description NVARCHAR(255);"
				+ "ALTER TABLE workflow_scheme ALTER COLUMN entry_action_id NVARCHAR(36);"
				
				+ "ALTER TABLE workflow_step ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_step ALTER COLUMN name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE workflow_step ALTER COLUMN scheme_id NVARCHAR(36);"
				+ "ALTER TABLE workflow_step ALTER COLUMN escalation_action NVARCHAR(36);"
				
				+ "ALTER TABLE workflow_action ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_action ALTER COLUMN step_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_action ALTER COLUMN name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE workflow_action ALTER COLUMN condition_to_progress NVARCHAR(MAX);"
				+ "ALTER TABLE workflow_action ALTER COLUMN next_step_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_action ALTER COLUMN next_assign NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_action ALTER COLUMN icon NVARCHAR(255);"
				
				+ "ALTER TABLE workflow_action_class ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_action_class ALTER COLUMN action_id NVARCHAR(36);"
				+ "ALTER TABLE workflow_action_class ALTER COLUMN name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE workflow_action_class ALTER COLUMN clazz NVARCHAR(MAX);"
				
				+ "ALTER TABLE workflow_action_class_pars ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_action_class_pars ALTER COLUMN workflow_action_class_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_action_class_pars ALTER COLUMN \"key\" NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE workflow_action_class_pars ALTER COLUMN value NVARCHAR(MAX);"
				
				+ "ALTER TABLE workflow_scheme_x_structure ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE workflow_scheme_x_structure ALTER COLUMN scheme_id NVARCHAR(36);"
				+ "ALTER TABLE workflow_scheme_x_structure ALTER COLUMN structure_id NVARCHAR(36);"
				
				+ "ALTER TABLE indicies ALTER COLUMN index_name NVARCHAR(30) NOT NULL;"
				+ "ALTER TABLE indicies ALTER COLUMN index_type NVARCHAR(16) NOT NULL;"
				
				+ "ALTER TABLE log_mapper ALTER COLUMN log_name NVARCHAR(30) NOT NULL;"
				+ "ALTER TABLE log_mapper ALTER COLUMN description NVARCHAR(50) NOT NULL;"
				
				+ "ALTER TABLE broken_link ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE broken_link ALTER COLUMN inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE broken_link ALTER COLUMN field NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE broken_link ALTER COLUMN link NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE broken_link ALTER COLUMN title NVARCHAR(255) NOT NULL;"
				
				+ "ALTER TABLE publishing_queue_audit ALTER COLUMN bundle_id NVARCHAR(256) NOT NULL;"
				+ "ALTER TABLE publishing_queue_audit ALTER COLUMN status_pojo NVARCHAR(MAX);"
				
				+ "ALTER TABLE publishing_end_point ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE publishing_end_point ALTER COLUMN group_id NVARCHAR(700);"
				+ "ALTER TABLE publishing_end_point ALTER COLUMN server_name NVARCHAR(700);"
				+ "ALTER TABLE publishing_end_point ALTER COLUMN address NVARCHAR(250);"
				+ "ALTER TABLE publishing_end_point ALTER COLUMN port NVARCHAR(10);"
				+ "ALTER TABLE publishing_end_point ALTER COLUMN protocol NVARCHAR(10);"
				+ "ALTER TABLE publishing_end_point ALTER COLUMN auth_key NVARCHAR(MAX);"
				
				+ "ALTER TABLE publishing_environment ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE publishing_environment ALTER COLUMN name NVARCHAR(255) NOT NULL;"
				
				+ "ALTER TABLE sitesearch_audit ALTER COLUMN job_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE sitesearch_audit ALTER COLUMN job_name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE sitesearch_audit ALTER COLUMN host_list NVARCHAR(500) NOT NULL;"
				+ "ALTER TABLE sitesearch_audit ALTER COLUMN lang_list NVARCHAR(500) NOT NULL;"
				+ "ALTER TABLE sitesearch_audit ALTER COLUMN path NVARCHAR(500) NOT NULL;"
				+ "ALTER TABLE sitesearch_audit ALTER COLUMN index_name NVARCHAR(100) NOT NULL;"
				
				+ "ALTER TABLE publishing_queue ALTER COLUMN asset NVARCHAR(2000) NOT NULL;"
				+ "ALTER TABLE publishing_queue ALTER COLUMN type NVARCHAR(256);"
				+ "ALTER TABLE publishing_queue ALTER COLUMN bundle_id NVARCHAR(256);"
				
				+ "ALTER TABLE publishing_bundle ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE publishing_bundle ALTER COLUMN name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE publishing_bundle ALTER COLUMN owner NVARCHAR(100);"
				
				+ "ALTER TABLE publishing_bundle_environment ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE publishing_bundle_environment ALTER COLUMN bundle_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE publishing_bundle_environment ALTER COLUMN environment_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE publishing_pushed_assets ALTER COLUMN bundle_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE publishing_pushed_assets ALTER COLUMN asset_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE publishing_pushed_assets ALTER COLUMN asset_type NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE publishing_pushed_assets ALTER COLUMN environment_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE dot_cluster ALTER COLUMN cluster_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE cluster_server ALTER COLUMN server_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE cluster_server ALTER COLUMN cluster_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE cluster_server ALTER COLUMN name NVARCHAR(100);"
				+ "ALTER TABLE cluster_server ALTER COLUMN ip_address NVARCHAR(39) NOT NULL;"
				+ "ALTER TABLE cluster_server ALTER COLUMN host NVARCHAR(36);"
				+ "ALTER TABLE cluster_server ALTER COLUMN key_ NVARCHAR(100);"
				
				+ "ALTER TABLE cluster_server_uptime ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE cluster_server_uptime ALTER COLUMN server_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE notification ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE notification ALTER COLUMN message NVARCHAR(MAX) NOT NULL;"
				+ "ALTER TABLE notification ALTER COLUMN notification_type NVARCHAR(100);"
				+ "ALTER TABLE notification ALTER COLUMN notification_level NVARCHAR(100);"
				+ "ALTER TABLE notification ALTER COLUMN user_id NVARCHAR(255) NOT NULL;"
				
				+ "ALTER TABLE sitelic ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE sitelic ALTER COLUMN serverid NVARCHAR(100);"
				+ "ALTER TABLE sitelic ALTER COLUMN license NVARCHAR(MAX) NOT NULL;"
				
				+ "ALTER TABLE folders_ir ALTER COLUMN folder NVARCHAR(255);"
				+ "ALTER TABLE folders_ir ALTER COLUMN local_inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE folders_ir ALTER COLUMN remote_inode NVARCHAR(36);"
				+ "ALTER TABLE folders_ir ALTER COLUMN local_identifier NVARCHAR(36);"
				+ "ALTER TABLE folders_ir ALTER COLUMN remote_identifier NVARCHAR(36);"
				+ "ALTER TABLE folders_ir ALTER COLUMN endpoint_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE structures_ir ALTER COLUMN velocity_name NVARCHAR(255);"
				+ "ALTER TABLE structures_ir ALTER COLUMN local_inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE structures_ir ALTER COLUMN remote_inode NVARCHAR(36);"
				+ "ALTER TABLE structures_ir ALTER COLUMN endpoint_id NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE schemes_ir ALTER COLUMN name NVARCHAR(255);"
				+ "ALTER TABLE schemes_ir ALTER COLUMN local_inode NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE schemes_ir ALTER COLUMN remote_inode NVARCHAR(36);"
				+ "ALTER TABLE schemes_ir ALTER COLUMN endpoint_id NVARCHAR(36) NOT NULL;"

				+ "DROP TABLE htmlpages_ir; "
				+ "CREATE TABLE htmlpages_ir(html_page nvarchar(255), local_working_inode nvarchar(36) not null, local_live_inode nvarchar(36), "
				+ "remote_working_inode nvarchar(36), remote_live_inode nvarchar(36),local_identifier nvarchar(36),"
				+ "remote_identifier nvarchar(36), endpoint_id nvarchar(36) not null, language_id bigint, "
				+ "PRIMARY KEY (local_working_inode, language_id, endpoint_id));"

				+ "DROP TABLE fileassets_ir; "
				+ "create table fileassets_ir(file_name nvarchar(255), local_working_inode nvarchar(36) not null, local_live_inode nvarchar(36), "
				+ "remote_working_inode nvarchar(36), remote_live_inode nvarchar(36),local_identifier nvarchar(36), "
				+ "remote_identifier nvarchar(36), endpoint_id nvarchar(36) not null, language_id bigint, "
				+ "PRIMARY KEY (local_working_inode, language_id, endpoint_id));"
				
				+ "ALTER TABLE cluster_server_action ALTER COLUMN server_action_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE cluster_server_action ALTER COLUMN originator_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE cluster_server_action ALTER COLUMN server_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE cluster_server_action ALTER COLUMN response NVARCHAR(2048);"
				+ "ALTER TABLE cluster_server_action ALTER COLUMN action_id NVARCHAR(1024) NOT NULL;"
				
				+ "ALTER TABLE dot_rule ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE dot_rule ALTER COLUMN name NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE dot_rule ALTER COLUMN fire_on NVARCHAR(20);"
				+ "ALTER TABLE dot_rule ALTER COLUMN parent_id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE dot_rule ALTER COLUMN folder NVARCHAR(36) NOT NULL;"
				
				+ "ALTER TABLE rule_condition_group ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE rule_condition_group ALTER COLUMN rule_id NVARCHAR(36);"
				+ "ALTER TABLE rule_condition_group ALTER COLUMN operator NVARCHAR(10) NOT NULL;"
				
				+ "ALTER TABLE rule_condition ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE rule_condition ALTER COLUMN conditionlet NVARCHAR(MAX) NOT NULL;"
				+ "ALTER TABLE rule_condition ALTER COLUMN condition_group NVARCHAR(36);"
				+ "ALTER TABLE rule_condition ALTER COLUMN comparison NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE rule_condition ALTER COLUMN operator NVARCHAR(10) NOT NULL;"
				
				+ "ALTER TABLE rule_condition_value ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE rule_condition_value ALTER COLUMN condition_id NVARCHAR(36);"
				+ "ALTER TABLE rule_condition_value ALTER COLUMN paramkey NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE rule_condition_value ALTER COLUMN value NVARCHAR(MAX);"
				
				+ "ALTER TABLE rule_action ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE rule_action ALTER COLUMN rule_id NVARCHAR(36);"
				+ "ALTER TABLE rule_action ALTER COLUMN actionlet NVARCHAR(MAX) NOT NULL;"
				
				+ "ALTER TABLE rule_action_pars ALTER COLUMN id NVARCHAR(36) NOT NULL;"
				+ "ALTER TABLE rule_action_pars ALTER COLUMN rule_action_id NVARCHAR(36);"
				+ "ALTER TABLE rule_action_pars ALTER COLUMN paramkey NVARCHAR(255) NOT NULL;"
				+ "ALTER TABLE rule_action_pars ALTER COLUMN value NVARCHAR(MAX);";
	}

	@Override
	public String getH2Script() {
		return null;
	}

	@Override
	protected List<String> getTablesToDropConstraints() {
		final List<String> tableList = new ArrayList<>();
		tableList.add("Address");
		tableList.add("AdminConfig");
		tableList.add("Company");
		tableList.add("Counter");
		tableList.add("Image");
		tableList.add("PasswordTracker");
		tableList.add("PollsChoice");
		tableList.add("PollsDisplay");
		tableList.add("PollsQuestion");
		tableList.add("PollsVote");
		tableList.add("Portlet");
		tableList.add("PortletPreferences");
		tableList.add("Release_");
		tableList.add("links");
		tableList.add("file_asset");
		tableList.add("template");
		tableList.add("dot_containers");
		tableList.add("htmlpage");
		tableList.add("contentlet");
		tableList.add("publishing_bundle");
		tableList.add("users_cms_roles");
		tableList.add("link_version_info");
		tableList.add("User_");
		tableList.add("UserTracker");
		tableList.add("UserTrackerPath");
		tableList.add("QRTZ_CALENDARS");
		tableList.add("QRTZ_CRON_TRIGGERS");
		tableList.add("QRTZ_FIRED_TRIGGERS");
		tableList.add("QRTZ_PAUSED_TRIGGER_GRPS");
		tableList.add("QRTZ_SCHEDULER_STATE");
		tableList.add("QRTZ_LOCKS");
		tableList.add("QRTZ_JOB_DETAILS");
		tableList.add("QRTZ_JOB_LISTENERS");
		tableList.add("QRTZ_SIMPLE_TRIGGERS");
		tableList.add("QRTZ_BLOB_TRIGGERS");
		tableList.add("QRTZ_TRIGGER_LISTENERS");
		tableList.add("QRTZ_TRIGGERS");
		tableList.add("QRTZ_EXCL_CALENDARS");
		tableList.add("QRTZ_EXCL_CRON_TRIGGERS");
		tableList.add("QRTZ_EXCL_FIRED_TRIGGERS");
		tableList.add("QRTZ_EXCL_PAUSED_TRIGGER_GRPS");
		tableList.add("QRTZ_EXCL_SCHEDULER_STATE");
		tableList.add("QRTZ_EXCL_LOCKS");
		tableList.add("QRTZ_EXCL_JOB_DETAILS");
		tableList.add("QRTZ_EXCL_JOB_LISTENERS");
		tableList.add("QRTZ_EXCL_SIMPLE_TRIGGERS");
		tableList.add("QRTZ_EXCL_BLOB_TRIGGERS");
		tableList.add("QRTZ_EXCL_TRIGGER_LISTENERS");
		tableList.add("QRTZ_EXCL_TRIGGERS");
		tableList.add("calendar_reminder");
		tableList.add("analytic_summary_pages");
		tableList.add("tag");
		tableList.add("user_comments");
		tableList.add("permission_reference");
		tableList.add("contentlet_version_info");
		tableList.add("fixes_audit");
		tableList.add("container_version_info");
		tableList.add("trackback");
		tableList.add("plugin");
		tableList.add("mailing_list");
		tableList.add("recipient");
		tableList.add("web_form");
		tableList.add("virtual_link");
		tableList.add("analytic_summary");
		tableList.add("analytic_summary_period");
		tableList.add("tree");
		tableList.add("analytic_summary_content");
		tableList.add("structure");
		tableList.add("cms_role");
		tableList.add("container_structures");
		tableList.add("permission");
		tableList.add("analytic_summary_404");
		tableList.add("cms_layouts_portlets");
		tableList.add("workflow_comment");
		tableList.add("category");
		tableList.add("chain_state");
		tableList.add("chain_link_code");
		tableList.add("analytic_summary_visits");
		tableList.add("template_version_info");
		tableList.add("user_preferences");
		tableList.add("language");
		tableList.add("users_to_delete");
		tableList.add("identifier");
		tableList.add("clickstream");
		tableList.add("multi_tree");
		tableList.add("workflow_task");
		tableList.add("tag_inode");
		tableList.add("click");
		tableList.add("challenge_question");
		tableList.add("layouts_cms_roles");
		tableList.add("clickstream_request");
		tableList.add("content_rating");
		tableList.add("analytic_summary_workstream");
		tableList.add("dashboard_user_preferences");
		tableList.add("campaign");
		tableList.add("htmlpage_version_info");
		tableList.add("workflowtask_files");
		tableList.add("analytic_summary_referer");
		tableList.add("communication");
		tableList.add("fileasset_version_info");
		tableList.add("workflow_history");
		tableList.add("host_variable");
		tableList.add("user_proxy");
		tableList.add("chain_state_parameter");
		tableList.add("field");
		tableList.add("relationship");
		tableList.add("folder");
		tableList.add("clickstream_404");
		tableList.add("cms_layout");
		tableList.add("field_variable");
		tableList.add("report_parameter");
		tableList.add("chain");
		tableList.add("template_containers");
		tableList.add("user_filter");
		tableList.add("report_asset");
		tableList.add("inode");
		tableList.add("dist_journal");
		tableList.add("dist_process");
		tableList.add("plugin_property");
		tableList.add("dist_reindex_journal");
		tableList.add("quartz_log");
		tableList.add("dist_reindex_lock");
		tableList.add("dist_lock");
		tableList.add("import_audit");
		tableList.add("workflow_scheme");
		tableList.add("workflow_step");
		tableList.add("workflow_action");
		tableList.add("workflow_action_class");
		tableList.add("workflow_action_class_pars");
		tableList.add("workflow_scheme_x_structure");
		tableList.add("indicies");
		tableList.add("log_mapper");
		tableList.add("broken_link");
		tableList.add("publishing_queue");
		tableList.add("publishing_queue_audit");
		tableList.add("publishing_end_point");
		tableList.add("publishing_environment");
		tableList.add("sitesearch_audit");
		tableList.add("publishing_queue");
		tableList.add("publishing_bundle_environment");
		tableList.add("publishing_pushed_assets");
		tableList.add("dot_cluster");
		tableList.add("cluster_server");
		tableList.add("cluster_server_uptime");
		tableList.add("notification");
		tableList.add("sitelic");
		tableList.add("folders_ir");
		tableList.add("structures_ir");
		tableList.add("schemes_ir");
		tableList.add("htmlpages_ir");
		tableList.add("fileassets_ir");
		tableList.add("cluster_server_action");
		tableList.add("dot_rule");
		tableList.add("rule_condition_group");
		tableList.add("rule_condition");
		tableList.add("rule_condition_value");
		tableList.add("rule_action");
		tableList.add("rule_action_pars");
		return tableList;
	}

	@Override
	public CustomConstraintProcessor<PrimaryKeyHandler> getPrimaryKeyProcessor() {
		final CustomConstraintProcessor<PrimaryKeyHandler> processor = new CustomConstraintProcessor<>();
		String customSqlQuery = "ALTER TABLE %s WITH NOCHECK ADD CONSTRAINT %s PRIMARY KEY CLUSTERED (%s)";
		processor.addCreateHandlers(DbType.MSSQL, new PrimaryKeyHandler("PK_QRTZ_CALENDARS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_CRON_TRIGGERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_FIRED_TRIGGERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_PAUSED_TRIGGER_GRPS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_SCHEDULER_STATE", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_LOCKS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_JOB_DETAILS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_JOB_LISTENERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_SIMPLE_TRIGGERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_TRIGGER_LISTENERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_TRIGGERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_CALENDARS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_CRON_TRIGGERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_FIRED_TRIGGERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_PAUSED_TRIGGER_GRPS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_SCHEDULER_STATE", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_LOCKS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_JOB_DETAILS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_JOB_LISTENERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_SIMPLE_TRIGGERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_TRIGGER_LISTENERS", customSqlQuery),
				new PrimaryKeyHandler("PK_QRTZ_EXCL_TRIGGERS", customSqlQuery));
		customSqlQuery = "ALTER TABLE %s ADD CONSTRAINT %s PRIMARY KEY CLUSTERED (%s)";
		processor.addCreateHandlers(DbType.MSSQL, new PrimaryKeyHandler("PK_dist_journal", customSqlQuery),
				new PrimaryKeyHandler("PK_dist_process", customSqlQuery),
				new PrimaryKeyHandler("PK_dist_reindex_journal", customSqlQuery),
				new PrimaryKeyHandler("PK_dist_reindex_lock", customSqlQuery),
				new PrimaryKeyHandler("PK_dist_lock", customSqlQuery));
		return processor;
	}

	@Override
	public CustomConstraintProcessor<ForeignKeyHandler> getForeignKeyProcessor() {
		final CustomConstraintProcessor<ForeignKeyHandler> processor = new CustomConstraintProcessor<>();
		final String customSqlQuery = "ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s) ON DELETE CASCADE";
		processor.addCreateHandlers(DbType.MSSQL, new ForeignKeyHandler("FK_QRTZ_CRON_TRIGGERS_QRTZ_TRIGGERS", customSqlQuery),
				new ForeignKeyHandler("FK_QRTZ_JOB_LISTENERS_QRTZ_JOB_DETAILS", customSqlQuery),
				new ForeignKeyHandler("FK_QRTZ_SIMPLE_TRIGGERS_QRTZ_TRIGGERS", customSqlQuery),
				new ForeignKeyHandler("FK_QRTZ_TRIGGER_LISTENERS_QRTZ_TRIGGERS", customSqlQuery),
				new ForeignKeyHandler("FK_QRTZ_EXCL_CRON_TRIGGERS_QRTZ_EXCL_TRIGGERS", customSqlQuery),
				new ForeignKeyHandler("FK_QRTZ_EXCL_JOB_LISTENERS_QRTZ_EXCL_JOB_DETAILS", customSqlQuery),
				new ForeignKeyHandler("FK_QRTZ_EXCL_SIMPLE_TRIGGERS_QRTZ_EXCL_TRIGGERS", customSqlQuery),
				new ForeignKeyHandler("FK_QRTZ_EXCL_TRIGGER_LISTENERS_QRTZ_EXCL_TRIGGERS", customSqlQuery));
		return processor;
	}

	@Override
	public CustomConstraintProcessor<IndexHandler> getIndexProcessor() {
		final CustomConstraintProcessor<IndexHandler> processor = new CustomConstraintProcessor<>();
		String customSqlQuery = "ALTER TABLE %s ADD CONSTRAINT %s UNIQUE NONCLUSTERED (%s)";
		processor.addCreateHandlers(DbType.MSSQL, new IndexHandler("IX_dist_journal", customSqlQuery),
				new IndexHandler("IX_cms_role2", customSqlQuery), 
				new IndexHandler("IX_cms_role", customSqlQuery),
				new IndexHandler("IX_cms_layout", customSqlQuery), 
				new IndexHandler("IX_portletid", customSqlQuery),
				new IndexHandler("IX_cms_layouts_portlets", customSqlQuery),
				new IndexHandler("IX_layouts_cms_roles", customSqlQuery));
		customSqlQuery = "ALTER TABLE %s ADD CONSTRAINT %s UNIQUE (%s)";
		processor.addCreateHandlers(DbType.MSSQL, new IndexHandler("UQ__permissi__", customSqlQuery),
				new IndexHandler("UQ__analytic__", customSqlQuery),
				new IndexHandler("UQ__permissi__", customSqlQuery),
				new IndexHandler("UQ__chain_li__", customSqlQuery),
				new IndexHandler("UQ__identifi__", customSqlQuery),
				new IndexHandler("UQ__user_pro__", customSqlQuery),
				new IndexHandler("UQ__report_p__", customSqlQuery),
				new IndexHandler("UQ__chain__", customSqlQuery),
				new IndexHandler("UQ__indicies__", customSqlQuery),
				new IndexHandler("UQ__publishi__", customSqlQuery));
		return processor;
	}
	
}
