package com.dotmarketing.util;

import com.dotmarketing.business.PermissionCache;

/**
 * This class provides a centralized access point to the keys of several system
 * parameters that are set via the configuration files in dotCMS. The
 * configuration properties for many system features can be located in this
 * class.
 * 
 * @author Will Ezel
 * @version 1.0
 * @since Mar 22, 2012
 */
public final class WebKeys {

	//Generated File Indicator
	public static final String GENERATED_FILE ="dotGenerated_";
	public static final String RENDITION_FILE ="dotRendition_";
	public static final String EDITED_IMAGE_FILE_ASSET ="_dotfileAsset";
	public static final String IMAGE_TOOL_CLIPBOARD = "_imageToolClipboard";
	public static final String IMAGE_TOOL_SAVE_FILES = "_imageToolSaveFile";
	public static final String LONG_LIVED_DOTCMS_ID_COOKIE = "dmid";
	public static final String ONCE_PER_VISIT_COOKIE = "opvc";
	public static final String SITE_VISITS_COOKIE = "sitevisitscookie";

	public static final String DIRECTOR_URL = "com.dotmarketing.preview.DirectorURL";
	public static final String VIEW_FOLDERS_URL = "com.dotmarketing.preview.ViewFolderURL";
	public static final String VIEW_BROWSER_URL = "com.dotmarketing.preview.ViewBrowserURL";
	public static final String PREVIEW_PAGE_URL = "com.dotmarketing.preview.PreviewPageURL";
	public static final String VIEW_CONTENTS_URL = "com.dotmarketing.preview.ViewContentsURL";

	public static final String CART = "com.dotmarketing.cms.cart.cart";
	public static final String INODES_VIEW_PORTLET = "com.dotmarketing.inodes.view.portlet";
    public static final String INODES_VIEW = "com.dotmarketing.inodes.view";
    public static final String INODES_EDIT = "com.dotmarketing.inodes.edit";
    public static final String INODE_EDIT = "com.dotmarketing.inodes.edit";

	public static final String JOBS_LIST = "com.dotmarketing.jobs.view.portlet";
    public static final String JOB_EDIT = "com.dotmarketing.jobs.edit_job";
	public static final String RESUMES_LIST = "com.dotmarketing.jobs.resumes.view";
	public static final String RESUME_EDIT = "com.dotmarketing.jobs.resume.edit";
    public static final String SEARCHFIRMS_LIST = "com.dotmarketing.jobs.searchfirms.view";
    public static final String SEARCHFIRM_EDIT = "com.dotmarketing.jobs.searchfirm.edit";

    public static final String BANNER_VIEW_PORTLET = "com.dotmarketing.banner.view.portlet";
    public static final String BANNERS_VIEW = "com.dotmarketing.banners.view";
    public static final String BANNER_EDIT = "com.dotmarketing.banners.edit";
    public static final String BANNER_FORM_EDIT = "com.dotmarketing.banners.formedit";

    public static final String FILE_EDIT = "com.dotmarketing.files.edit";
    public static final String FILE_VIEW = "com.dotmarketing.files.view";
    public static final String FILE_FORM_EDIT = "com.dotmarketing.files.form";
    public static final String FILE_VERSIONS = "com.dotmarketing.files.versions";
    public static final String FILES_VIEW = "com.dotmarketing.files.view";
    public static final String FILES_VIEW_COUNT = "com.dotmarketing.files.view.count";
    public static final String FILE_RELATED_ASSETS = "com.dotmarketing.file.related.assets";
    public static final String FILE_TITLE = "com.dotmarketing.file.title";
    public static final String FILE_MIME = "com.dotmarketing.file.mime";
    public static final String FILE_NAME = "com.dotmarketing.file.name";
    public static final String FILE_DESCRIPTION = "com.dotmarketing.file.description";
    public static final String FILE_QUERY = "com.dotmarketing.file.query";
    public static final String FILE_SHOW_DELETED = "com.dotmarketing.file.show_deleted";
    public static final String FILE_HOST_CHANGED = "com.dotmarketing.file.host_changed";
    public static final String TEMP_FILE_PREFIX = "_temp_";

    public static final String REPORTS_VIEW = "com.dotmarketing.files.view";
    public static final String REPORTS_VIEW_COUNT = "com.dotmarketing.files.view.count";
    public static final String REPORTS_QUERY = "com.dotmarketing.file.query";
    public static final String REPORTS_SHOW_DELETED = "com.dotmarketing.file.show_deleted";

	public static final String CATEGORY_VIEW_PORTLET = "com.dotmarketing.categories.view.portlet";
	public static final String CATEGORY_VIEW = "com.dotmarketing.categories.view";
	public static final String CATEGORY_EDIT = "com.dotmarketing.categories.edit";
	public static final String CATEGORY_LIST_TOP = "com.dotmarketing.categories.top_list";
	public static final String CATEGORY_LIST_ORPHAN = "com.dotmarketing.categories.orphan_list";

    public static final String ENTITY_VIEW_PORTLET = "com.dotmarketing.entity.view.portlet";
    public static final String ENTITY_VIEW = "com.dotmarketing.entity.view";
    public static final String ENTITY_EDIT = "com.dotmarketing.entity.edit";
    public static final String ENTITY_FORM_EDIT = "com.dotmarketing.entity.formedit";

    public static final String NEWSLETTER_VIEW_PORTLET = "com.dotmarketing.newsletter.view.portlet";
    public static final String NEWSLETTER_VIEW = "com.dotmarketing.newsletter.view";
    public static final String NEWSLETTER_EDIT = "com.dotmarketing.newsletter.edit";
    public static final String NEWSLETTER_FORM_EDIT = "com.dotmarketing.newsletter.formedit";

    public static final String STORY_LIST = "com.dotmarketing.story.list";

    public static final String CONTENTLET_LIST = "com.dotmarketing.contentlet.list";
    public static final String CONTENTLETS_VIEW = "com.dotmarketing.contentlet.view";
    public static final String CONTENTLETS_VIEW_COUNT = "com.dotmarketing.contentlet.view.count";
    public static final String CONTENTLET_VIEW_PORTLET = "com.dotmarketing.contentlet.view.portlet";
    public static final String CONTENTLET_EDIT = "com.dotmarketing.contentlet.edit";
    public static final String CONTENTLET_RELATIONSHIPS_EDIT = "com.dotmarketing.contentlet.relationships.edit";
    public static final String CONTENTLET_SIBBLING_EDIT = "com.dotmarketing.contentlet.edit.sibbling";
    public static final String CONTENTLET_FORM_EDIT = "com.dotmarketing.contentlet.formedit";
    public static final String CONTENTLET_PARENT = "com.dotmarketing.contentlet.parent";
    public static final String CONTENTLET_VERSIONS = "com.dotmarketing.contentlet.versions";
    public static final String CONTENTLET_MAIN_IMAGE = "com.dotmarketing.contentlet.main_image";
    public static final String CONTENTLET_MAIN_LINK = "com.dotmarketing.contentlet.main_link";
    public static final String CONTENTLET_TITLE = "com.dotmarketing.contentlet.title";
    public static final String CONTENTLET_START_DATE = "com.dotmarketing.contentlet.startDate";
    public static final String CONTENTLET_END_DATE = "com.dotmarketing.contentlet.endDate";
    public static final String CONTENTLET_SUBTITLE = "com.dotmarketing.contentlet.subTitle";
    public static final String CONTENTLET_BODY = "com.dotmarketing.contentlet.body";
    public static final String CONTENTLET_AUTHOR = "com.dotmarketing.contentlet.author";
    public static final String CONTENTLET_SUMMARY = "com.dotmarketing.contentlet.summary";
    public static final String CONTENTLET_SUBSUBTITLE = "com.dotmarketing.contentlet.subsubtitle";
    public static final String CONTENTLET_RELATED_ASSETS = "com.dotmarketing.contentlet.related.assets";
    public static final String CONTENTLET_QUERY = "com.dotmarketing.contentlet.query";
    public static final String CONTENTLET_SHOW_DELETED = "com.dotmarketing.contentlet.show_deleted";
    public static final String CONTENTLET_LAST_SEARCH = "com.dotmarketing.contentlet.last_search";
    //http://jira.dotmarketing.net/browse/DOTCMS-2273
    public static final String CONTENTLET_FORM_NAME_VALUE_SEPARATOR = "com.dotmarketing.contentlet.form_name_value_separator";

    public static final String SECTIONS_LIST = "com.dotmarketing.section.list";
    public static final String COURSES_LIST = "com.dotmarketing.courses.list";
	public static final String COURSE = "com.dotmarketing.course";
    public static final String PACKAGES_LIST = "com.dotmarketing.packages.list";
	public static final String PACKAGE = "com.dotmarketing.package";
	public static final String COURSE_SECTIONS = "com.dotmarketing.course_sections";
	public static final String COURSE_DEPARTMENTS= "com.dotmarketing.course_departments";
	public static final String DEPARTMENT= "com.dotmarketing.department";
	public static final String DEPARTMENTS= "com.dotmarketing.departments";
    public static final String FOLDER_VIEW_PORTLET = "com.dotmarketing.folder.view.portlet";
    public static final String FOLDERS_VIEW = "com.dotmarketing.folder.view";
    public static final String FOLDER_EDIT = "com.dotmarketing.folder.edit";
    public static final String FOLDER_FORM_EDIT = "com.dotmarketing.folder.formedit";
    public static final String ROOTFOLDER_VIEW_PORTLET = "com.dotmarketing.folder.rootfolder.portlet";
    public static final String FOLDER_PARENT = "com.dotmarketing.folder.parent.folder";
	public static final String HOST_PARENT = "com.dotmarketing.folder.parent.host";

    public static final String FOLDER_ENTRY_LIST = "com.dotmarketing.folder.entry_list";
    public static final String FOLDER_SELECTED = "com.dotmarketing.folder.selected";
    public static final String FOLDER_THUMBNAIL_LIST = "com.dotmarketing.folder.thumbnail_list";
    public static final String FOLDER_THUMBS = "com.dotmarketing.folder.thumbs";
    public static final String FOLDER_OPEN_NODES = "com.dotmarketing.folder.open_nodes";
    public static final String FOLDER_RELATED_ASSETS = "com.dotmarketing.folder.related_assets";
    public static final String FOLDER_SHOWMENU = "com.dotmarketing.folder.show_menu";
    public static final String HOST_EDIT = "com.dotmarketing.host.edit";

    ////EXCEPTIONS
    public static final String EDIT_ASSET_EXCEPTION = "com.dotmarketing.webasset.edit.exception";
	public static final String GET_LIVE_ASSET_EXCEPTION = "com.dotmarketing.webasset.get.live.exception";
    public static final String USER_PERMISSIONS_EXCEPTION = "com.dotmarketing.webasset.user.permissions.exception";

    public static final String FILEUPLOAD_EDIT = "com.dotmarketing.fileupload.edit";
    public static final String FILEUPLOAD_VIEW = "com.dotmarketing.fileupload.view";

    // Permissions tab keys
    public static final String PERMISSIONABLE_EDIT = "com.dotmarketing.permissions.permissionable_edit";
    public static final String PERMISSIONABLE_EDIT_BASE = "com.dotmarketing.permissions.permissionable_edit_base";

    //Version tab keys
    public static final String VERSIONS_INODE_EDIT = "com.dotmarketing.webassets.asset_versions";

	public static final String PARENT_FOLDER = "com.dotmarketing.webasset.parent_folder";

    public static final String CONTAINER_EDIT = "com.dotmarketing.containers.edit";
    public static final String CONTAINERS_VIEW = "com.dotmarketing.containers.view";
    public static final String CONTAINERS_VIEW_COUNT = "com.dotmarketing.containers.view.count";
    public static final String CONTAINER_VIEW_PORTLET = "com.dotmarketing.containers.view.portlet";
    public static final String CONTAINER_FORM_EDIT = "com.dotmarketing.containers.form";
    public static final String CONTAINER_VERSIONS = "com.dotmarketing.containers.versions";
    public static final String CONTAINER_PARENT = "com.dotmarketing.container.parent";
    public static final String CONTAINER_RELATED_ASSETS = "com.dotmarketing.containers.related.assets";
    public static final String CONTAINER_QUERY = "com.dotmarketing.container.query";
    public static final String CONTAINER_SHOW_DELETED = "com.dotmarketing.container.show_deleted";
    public static final String CONTAINER_HOST_CHANGED = "com.dotmarketing.container.host_changed";
    public static final String CONTAINER_INODE = "com.dotmarketing.containers.inode";
    public static final String CONTAINER_CAN_ADD = "com.dotmarketing.container.can.add.container";
    public static final String CONTAINER_HOSTS = "com.dotmarketing.container.hosts";

    public static final String TEMPLATE_EDIT = "com.dotmarketing.templates.edit";
    public static final String TEMPLATES_VIEW = "com.dotmarketing.templates.view";
    public static final String TEMPLATES_VIEW_COUNT = "com.dotmarketing.templates.view.count";
    public static final String TEMPLATE_VIEW_PORTLET = "com.dotmarketing.templates.view.portlet";
    public static final String TEMPLATE_FORM_EDIT = "com.dotmarketing.templates.form";
    public static final String TEMPLATE_VERSIONS = "com.dotmarketing.templates.versions";
    public static final String TEMPLATE_PARENT = "com.dotmarketing.templates.parent";
    public static final String TEMPLATE_PREVIEW_PAGE = "com.dotmarketing.templates.preview.page";
    public static final String TEMPLATE_RELATED_ASSETS = "com.dotmarketing.templates.related.assets";
    public static final String TEMPLATE_QUERY = "com.dotmarketing.template.query";
    public static final String TEMPLATE_SHOW_DELETED = "com.dotmarketing.template.show_deleted";
    public static final String TEMPLATE_HOST_CHANGED = "com.dotmarketing.template.host_changed";
    public static final String TEMPLATE_CAN_ADD = "com.dotmarketing.template.can.add.template";
    
    // *********************** BEGIN GRAZIANO issue-12-dnd-template
    public static final String TEMPLATE_CAN_DESIGN = "com.dotmarketing.template.can.design.template";
    public static final String TEMPLATE_IS_DRAWED = "com.dotmarketing.template.can.design.template._drawed";
    public static final String OVERRIDE_DRAWED_TEMPLATE_BODY = "com.dotmarketing.template.can.design.template._drawedOverride";
    public static final String TEMPLATE_JAVASCRIPT_PARAMETERS = "com.dotmarketing.template.can.design.template._jsParameters";
    public static final String FILE_PATH_SQL_TEMPLATE_DESIGN = "path.sql.file.design.template";
    public static final String PREVIEW_TEMPLATE_DESIGN_ENABLE = "PREVIEW_ENABLE";
    // *********************** END GRAZIANO issue-12-dnd-template
    
    public static final String TEMPLATE_HOSTS = "com.dotmarketing.template.hosts";

    public static final String HTMLPAGE_EDIT = "com.dotmarketing.htmlpages.edit";
    public static final String HTMLPAGE_REFERER = "com.dotmarketing.htmlpages.referer";
    public static final String HTMLPAGES_VIEW = "com.dotmarketing.htmlpages.view";
    public static final String HTMLPAGES_VIEW_COUNT = "com.dotmarketing.htmlpages.view.count";
    public static final String HTMLPAGE_VIEW_PORTLET = "com.dotmarketing.htmlpages.view.portlet";
    public static final String HTMLPAGE_FORM_EDIT = "com.dotmarketing.htmlpages.form";
    public static final String HTMLPAGE_VERSIONS = "com.dotmarketing.htmlpages.versions";
    public static final String HTMLPAGE_PREVIEW_PAGE = "com.dotmarketing.htmlpages.preview.page";
	public static final String HTML_CONTENTCONTAINERS = "com.dotmarketing.htmlpages.contentcontainers";
    public static final String HTMLPAGE_PARENT = "com.dotmarketing.htmlpages.parent";
    public static final String HTMLPAGE_RELATED_ASSETS = "com.dotmarketing.htmlpages.related.assets";
    public static final String HTMLPAGE_RELATED_WORKFLOWS = "com.dotmarketing.htmlpages.related.workflows";
    public static final String HTMLPAGE_QUERY = "com.dotmarketing.htmlpage.query";
    public static final String HTMLPAGE_SHOW_DELETED = "com.dotmarketing.htmlpage.show_deleted";
    public static final String HTMLPAGE_HOST_CHANGED = "com.dotmarketing.htmlpage.host_changed";
	public static final String HTMLPAGE_INODE = "com.dotmarketing.htmlpage.inode";
	public static final String REDIRECT_PREVIEW_PAGE = "com.dotmarketing.htmlpage.redirect.preview";
	public static final String HTMLPAGE_LANGUAGE = "com.dotmarketing.htmlpage.language";
    public static final String CONTENT_SELECTED_LANGUAGE = "com.dotmarketing.content.selected.language";
    public static final String Globals_FRONTEND_LOCALE_KEY = "com.dotmarketing.frontend.locale";

	public static final String HTMLPAGE_ID = "pageId";
	public static final String HTMLPAGE_TITLE = "pageTitle";
	public static final String HTMLPAGE_META = "pageMeta";
	public static final String HTMLPAGE_SERVER_NAME = "serverName";

	public static final String HTMLPAGE_SECURE = "com.dotmarketing.htmlpage.secure";
	public static final String HTMLPAGE_REDIRECT = "com.dotmarketing.htmlpage.redirect";

    public static final String MAILING_LIST_VIEW_PORTLET = "com.dotmarketing.mailinglist.view.portlet";
    public static final String MAILING_LIST_VIEW = "com.dotmarketing.mailinglist.view";
    public static final String MAILING_LIST_EDIT = "com.dotmarketing.mailinglist.edit";
    public static final String MAILING_LIST_SUBSCRIBERS = "com.dotmarketing.mailinglist.subscribers";
    public static final String COMMUNICATION_LIST_VIEW = "com.dotmarketing.communicationlist.view";

    public static final String MAILING_LIST_SYSTEM = "System Account";

    public static final String FILE_EDIT_TEXT = "com.dotmarketing.portlets.file.edit.text";
    public static final String FILE_EDIT_TEXT_FILE_EXT = "com.dotmarketing.portlets.file.edit.text.file.ext";

    public static final String COPY_CONTENTLET_UNIQUE_HAS_VALIDATION = "Unique Has Validation";
    public static final String COPY_CONTENTLET_UNIQUE_NOT_TEXT = "Unique Not Text";

    //Links
	public static final String LINK_EDIT = "com.dotmarketing.links.edit";
	public static final String LINK_FORM_EDIT = "com.dotmarketing.links.form";
	public static final String LINK_VERSIONS = "com.dotmarketing.links.versions";
	public static final String LINKS_VIEW = "com.dotmarketing.links.linksview";
	public static final String LINKS_VIEW_COUNT = "com.dotmarketing.links.linksview.count";
	public static final String LINK_VIEW_PORTLET = "com.dotmarketing.links.portlet";
    public static final String LINK_RELATED_ASSETS = "com.dotmarketing.links.related.assets";
    public static final String LINK_QUERY = "com.dotmarketing.link.query";
    public static final String LINK_SHOW_DELETED = "com.dotmarketing.link.show_deleted";
    public static final String LINK_HOST_CHANGED = "com.dotmarketing.link.host_changed";

    // COOKIES
    public static final String PREVIEW_MODE_COOKIE = "PREVIEW_MODE_COOKIE";
    public static final String PREPRECESS_RUN = "PREPRECESS_RUN_NUMBER";
    public static final String ADMIN_MODE_COOKIE = "ADMIN_MODE_COOKIE";

    // SESSION ATTRIBUTES
    public static final String EDIT_MODE_SESSION = "com.dotmarketing.EDIT_MODE_SESSION";
    public static final String PREVIEW_MODE_SESSION = "com.dotmarketing.PREVIEW_MODE_SESSION";
    public static final String ADMIN_MODE_SESSION = "com.dotmarketing.ADMIN_MODE_SESSION";
    public static final String SESSION_RATING_CACHE = "com.dotmarketing.beans.Rating";
    public static final String LAST_RATED_CONTENTLET = "last.rated.contentlet";
	public static final String CMSFILTER_REDIRECTING = "com.dotmarketing.filters.CMSFilter";
	public static final String CMSFILTER_URI = "com.dotmarketing.filters.CMSFilter.URI";
	public static final String PENDING_ALERT_SEEN = "PENDING_ALERT_SEEN";
	public static final String LOCALE = "com.dotmarketing.LOCALE";

    // NON_LOGGED_IN_USER_CATS
    public static final String NON_LOGGED_IN_USER_CATS = "com.dotmarketing.NON_LOGGED_IN_USER_CATS";
    public static final String LOGGED_IN_USER_CATS = "com.dotmarketing.LOGGED_IN_USER_CATS";

    // NON_LOGGED_IN_USER_TAGS
    public static final String NON_LOGGED_IN_USER_TAGS = "com.dotmarketing.NON_LOGGED_IN_USER_TAGS";
    public static final String LOGGED_IN_USER_TAGS = "com.dotmarketing.LOGGED_IN_USER_TAGS";

    //MENU
	public static final String MENU_OPEN = "com.dotmarketing.filters.MenuBuilder.open";
	public static final String MENU_PATH = "com.dotmarketing.filters.MenuBuilder.path";
	public static final String MENU_ITEMS = "com.dotmarketing.filters.MenuBuilder.items";
	public static final String MENU_MAIN_FOLDER = "com.dotmarketing.filters.MenuBuilder.main_folder";

    public static final String DIRECTORIES_LIST = "com.dotmarketing.servicesdirectory.list";
    public static final String DIRECTORY_EDIT = "com.dotmarketing.servicesdirectory.edit";

    //SHOPPING
    public static final String SHOPPING_C_A_ADDORDERNOTEACTION = "com.dotmarketing.portlets.shopping.c.a.AddOrderNoteAction";
	public static final String SHOPPING_C_A_BROWSECATEGORIESACTION = "com.dotmarketing.portlets.shopping.c.a.BrowseCategoriesAction";
	public static final String SHOPPING_C_A_CHANGEORDERACTION = "com.dotmarketing.portlets.shopping.c.a.ChangeOrderAction";
	public static final String SHOPPING_C_A_DELETECATEGORYACTION = "com.dotmarketing.portlets.shopping.c.a.DeleteCategoryAction";
	public static final String SHOPPING_C_A_DELETEITEMACTION = "com.dotmarketing.portlets.shopping.c.a.DeleteItemAction";
	public static final String SHOPPING_C_A_DELETEORDERACTION = "com.dotmarketing.portlets.shopping.c.a.DeleteOrderAction";
	public static final String SHOPPING_C_A_DELETEORDERNOTEACTION = "com.dotmarketing.portlets.shopping.c.a.DeleteOrderNoteAction";
	public static final String SHOPPING_C_A_EDITCATEGORYACTION = "com.dotmarketing.portlets.shopping.c.a.EditCategoryAction";
	public static final String SHOPPING_C_A_EDITITEMACTION = "com.dotmarketing.portlets.shopping.c.a.EditItemAction";
	public static final String SHOPPING_C_A_EDITLATESTORDERACTION = "com.dotmarketing.portlets.shopping.c.a.EditLatestOrderAction";
	public static final String SHOPPING_C_A_EDITORDERACTION = "com.dotmarketing.portlets.shopping.c.a.EditOrderAction";
	public static final String SHOPPING_C_A_FORWARDCHECKOUTACTION = "com.dotmarketing.portlets.shopping.c.a.ForwardCheckoutAction";
	public static final String SHOPPING_C_A_PAYPALNOTIFICATIONACTION = "com.dotmarketing.portlets.shopping.c.a.PayPalNotificationAction";
	public static final String SHOPPING_C_A_QUICKADDITEMSACTION = "com.dotmarketing.portlets.shopping.c.a.QuickAddItemsAction";
    public static final String SHOPPING_C_A_SAVELATESTORDERACTION ="com.dotmarketing.portlets.shopping.c.a.SaveLatestOrderAction";
	public static final String SHOPPING_C_A_SEARCHACTION = "com.dotmarketing.portlets.shopping.c.a.SearchAction";
    public static final String SHOPPING_C_A_SENDORDEREMAILACTION ="com.dotmarketing.portlets.shopping.c.a.SendOrderEmailAction";
    public static final String SHOPPING_C_A_SENDSHIPPINGEMAILACTION = "com.dotmarketing.portlets.shopping.c.a.SendShippingEmailAction";
	public static final String SHOPPING_C_A_UPDATECARTACTION = "com.dotmarketing.portlets.shopping.c.a.UpdateCartAction";
	public static final String SHOPPING_C_A_UPDATECATEGORYACTION = "com.dotmarketing.portlets.shopping.c.a.UpdateCategoryAction";
	public static final String SHOPPING_C_A_UPDATEITEMACTION = "com.dotmarketing.portlets.shopping.c.a.UpdateItemAction";
    public static final String SHOPPING_C_A_UPDATELATESTORDERACTION = "com.dotmarketing.portlets.shopping.c.a.UpdateLatestOrderAction";
    public static final String SHOPPING_C_A_UPDATEORDERACTION = "com.dotmarketing.portlets.shopping.c.a.UpdateOrderAction";
	public static final String SHOPPING_C_A_UPDATEPREFERENCEACTION = "com.dotmarketing.portlets.shopping.c.a.UpdatePreferenceAction";
	public static final String SHOPPING_C_A_UPDATESHOPPINGCONFIGACTION = "com.dotmarketing.portlets.shopping.c.a.UpdateShoppingConfigAction";
	public static final String SHOPPING_C_H_CARTHANDLER = "com.dotmarketing.portlets.shopping.c.h.CartHandler";
	public static final String SHOPPING_URL = "com.dotmarketing.portlets.shopping.URL";
	public static final String SHOPPING_C_A_HOMEACTION = "com.dotmarketing.portlets.shopping.c.a.ExtranetAction";

	//Polls
	public static final String POLLS_C_A_ADDVOTEACTION = "com.dotmarketing.portlets.polls.c.a.AddVoteAction";
	public static final String POLLS_C_A_DELETEQUESTIONACTION = "com.dotmarketing.portlets.polls.c.a.DeleteQuestionAction";
	public static final String POLLS_C_A_EDITQUESTIONACTION = "com.dotmarketing.portlets.polls.c.a.EditQuestionAction";
	public static final String POLLS_C_A_UPDATEQUESTIONACTION = "com.dotmarketing.portlets.polls.c.a.UpdateQuestionAction";
	public static final String POLLS_C_A_VIEWCHARTACTION = "com.dotmarketing.portlets.polls.c.a.ViewChartAction";
	public static final String POLLS_C_A_VIEWQUESTIONSACTION = "com.dotmarketing.portlets.polls.c.a.ViewQuestionsAction";
	public static final String POLLS_C_A_VIEWCURRENTQUESTIONSACTION = "com.dotmarketing.portlets.polls.c.a.ViewCurrentQuestionsAction";
	public static final String POLLS_CATID = "com.dotmarketing.portlets.polls.catid";
	public static final String POLLS_C_A_DELETECHOICEACTION = "com.dotmarketing.portlets.polls.c.a.DeleteChoiceAction";
	public static final String POLLS_C_A_EDITCHOICEACTION = "com.dotmarketing.portlets.polls.c.a.EditChoiceAction";
	public static final String POLLS_C_A_UPDATECHOICEACTION = "com.dotmarketing.portlets.polls.c.a.UpdateChoiceAction";
	public static final String POLLS_CHOICE = "com.dotmarketing.portlets.polls.choice";
	public static final String POLLS_C_A_REORDERCHOICESACTION = "com.dotmarketing.portlets.polls.c.a.ReorderChoicesAction";

	//Newsletter
	public static final String CAMPAIGN_LIST = "com.dotmarketing.campaign.list";
	public static final String CAMPAIGN_RECURRENT_OCURRENCES = "com.dotmarketing.campaign.recurrent.ocurrences";
	public static final String CAMPAIGN_EDIT = "com.dotmarketing.campaign.edit";
	public static final String CLICK_EDIT = "com.dotmarketing.click.edit";
	public static final String RECIPIENT_LIST = "com.dotmarketing.recipient.list";
	public static final String RECIPIENT_LIST_TITLE = "com.dotmarketing.recipient.list.title";
	public static final String RECIPIENT_EDIT = "com.dotmarketing.recipient.edit";

    // WORKFLOWS
    public static final String WORKFLOW_TASK_EDIT  = "com.dotmarketing.workflowtask.edit";
    public static final String WORKFLOW_TASK_FORM_EDIT   = "com.dotmarketing.workflowtask.edit_form";
    public static final String WORKFLOW_TASKS_LIST = "com.dotmarketing.workflowtasks.list";
    public static final String WORKFLOW_USER_TASKS_LIST = "com.dotmarketing.workflowtasks.user.list";
    public static final String WORKFLOW_FILTER_TASKS_LIST = "com.dotmarketing.workflowtasks.filter.list";
    public static final String WORKFLOW_FILTER_TASKS_COUNT = "com.dotmarketing.workflowtasks.filter.count";
    public static final String WORKFLOW_ACTIONLET_CLASSES = "WORKFLOW_ACTIONLET_CLASSES";
    public static final String WORKFLOW_SEARCHER = "com.dotmarketing.workflowtasks.WORKFLOW_SEARCHER";
    public static enum WorkflowStatuses { OPEN, RESOLVED, CANCELLED };

    // RULES ENGIGE
    public static final String RULES_CONDITIONLET_CLASSES = "RULES_CONDITIONLET_CLASSES";
    public static final String RULES_ACTIONLET_CLASSES = "RULES_ACTIONLET_CLASSES";
    public static final String RULES_CONDITIONLET_VISITEDURLS = "RULES_CONDITIONLET_VISITEDURLS";
    public static final String RULES_ENGINE_PARAM = "dotRules";
    public static final String RULES_ENGINE_FIRE_LIST = "dotRulesFired";

	//ADMIN CONTROL
    public static final String ADMIN_CONTROL_TOP = "com.dotmarketing.admin.control.top";
    public static final String ADMIN_CONTROL_LEFT = "com.dotmarketing.admin.control.left";
    public static final String ADMIN_CONTROL_CLOSED = "com.dotmarketing.admin.control.closed";

	//TASK CONTROL
    public static final String TASK_CONTROL_TOP = "com.dotmarketing.task.control.top";
    public static final String TASK_CONTROL_LEFT = "com.dotmarketing.task.control.left";
    public static final String TASK_CONTROL_CLOSED = "com.dotmarketing.task.control.closed";

	//USER PREFERENCES
    public static final String USER_PREFERENCE_EDIT = "com.dotmarketing.portlets.user.edit_userpreference";
    public static final String USER_PREFERENCE_HOME_PAGE = "com.dotmarketing.user.home_page";

    //USER COMMENTS
    public static final String USER_COMMENTS_VIEW = "com.dotmarketing.portlets.usercomments.view_user_comments";

	//USER CLICKS
    public static final String USER_CLICKS_VIEW = "com.dotmarketing.portlets.userclicks.view_user_clicks";

    //USER FILTERS
    public static final String USER_FILTER_LIST_VIEW_PORTLET = "com.dotmarketing.userfilter.view.portlet";
    public static final String USER_FILTER_LIST_VIEW = "com.dotmarketing.userfilter.view";
    public static final String USER_FILTER_LIST_TITLE = "com.dotmarketing.userfilter.title";
    public static final String USER_FILTER_LIST_INODE = "com.dotmarketing.userfilter.inode";

    //DIRECTOR VARIABLES FOR PORTLET URL
	public static final String JAVAX_PORTLET_REQUEST = "com.dotmarketing.javax.portlet.request";
	public static final String JAVAX_PORTLET_CONFIG = "com.dotmarketing.javax.portlet.config";
	public static final String LAYOUT = "com.dotmarketing.LAYOUT";
    public static final String SESSION_MESSAGES = "com.dotmarketing.session.messages";

    //LANGUAGE MANAGER
    public static final String LANGUAGE_MANAGER_LIST = "com.dotmarketing.languagemanager.view.portlet";
    public static final String LANGUAGE_MANAGER_PROPERTIES = "com.dotmarketing.languagemanager.properties";
    public static final String LANGUAGE_MANAGER_SEARCH= "com.dotmarketing.languagemanager.properties.search";
    public static final String LANGUAGE_MANAGER_PAGE_NUMBERS= "com.dotmarketing.languagemanager.properties.page_numbers";
    public static final String LANGUAGE_MANAGER_ADDEDKEY= "com.dotmarketing.languagemanager.properties.addedkey";
    public static final String LANGUAGE_MANAGER_LANGUAGE= "com.dotmarketing.languagemanager.language";
    public static final String LANGUAGE_MANAGER_LANGUAGE_FORM= "com.dotmarketing.languagemanager.language_form";
    public static final String LANGUAGES = "com.dotmarketing.languages.languages_list";
    public static final String LANGUAGE = "com.dotmarketing.languages.language_selected";
    public static final String LANGUAGE_SEARCHED = "com.dotmarketing.languages.language_searched";

    public static final String CRUMB_TRAIL = "com.dotmarketing.viewtool.crumbtrail";
	public static final String REDIRECT_AFTER_LOGIN = "REDIRECT_AFTER_LOGIN";

	// CMS USER LOGIN
    public static final String CMS_USER = "cms.user";
    public static final String CMS_PERSONALIZATION_BEAN = "cms.user.personalization";
    public static final String CMS_USER_REGISTRATIONS = "cms.user.registrations";
    public static final String CMS_CURRENT_PAGE = "cms.current.page";

    public static final String CLICKSTREAM_URI_OVERRIDE = "com.dotmarketing.clickstream.uri.override";
    public static final String CLICKSTREAM_IDENTIFIER_OVERRIDE = "com.dotmarketing.clickstream.identifier.override";

	//REGISTRATIONS MANAGER
    public static final String REGISTRATION_VIEW_PORTLET = "com.dotmarketing.registration.view.portlet";
    public static final String REGISTRATION_VIEW = "com.dotmarketing.registration.view";
    public static final String REGISTRATION_USERS = "com.dotmarketing.registration.users";
    public static final String REGISTRATION_VIEW_COUNT = "com.dotmarketing.registration.view.count";
    public static final String REGISTRATION_EDIT = "com.dotmarketing.registration.edit";
    public static final String REGISTRATION_FORM_EDIT = "com.dotmarketing.registration.formedit";

    //Marketing list builder
	public static final String MAILINGLIST = "com.dotmarketing.mailinglistbuilder.mailing_list";
	public static final String MAILINGLISTFORM = "com.dotmarketing.mailinglistbuilder.mailing_list_form";

    //EVENTS
	public static final String EVENTS_LIST = "com.dotmarketing.event.list";
	public static final String EVENT_EDIT = "com.dotmarketing.event.edit";
	public static final String EVENT_RECURRENCE_EDIT = "com.dotmarketing.event_recurrence.edit";
	public static final String EVENT_FORM = "com.dotmarketing.event.form";
	public static final String EVENT_CATEGORIES = "com.dotmarketing.event.categories";
	public static final String RECURANCE_EDIT = "com.dotmarketing.recurance.edit";
	public static final String EVENT_REGISTRATIONS = "com.dotmarketing.event.registrations";

	//Hosts
	public static final String CURRENT_HOST = "com.dotmarketing.session_host";
    public static final String SEARCH_HOST_ID = "com.dotmarketing.search_host_id";
    public static final String HOST_SHOW_DELETED = "com.dotmarketing.host.show_deleted";

	//Structure
    public static final String SEARCH_STRUCTURE_ID = "com.dotmarketing.search_structure_id";
    public static final String STRUCTURES_VIEW = "com.dotmarketing.structures.view";
    public static final String STRUCTURE_QUERY = "com.dotmarketing.structures.query";
    public static final String STRUCTURES_VIEW_COUNT = "com.dotmarketing.structures.view.count";

	//Structure
    public static final String SEARCH_TEMPLATE_ID = "com.dotmarketing.search_template_id";

    //FACILITIES
	public static final String FACILITIES_LIST = "com.dotmarketing.facilities.list";
	public static final String FACILITY_EDIT = "com.dotmarketing.facility.edit";

    //Organizations
    public static final String ORGANIZATION_VIEW = "com.dotmarketing.portlets.organization.model.Organization.view";
    public static final String ORGANIZATION_EDIT = "com.dotmarketing.portlets.organization.model.Organization.edit";

    //User Manage
    public static final String USERMANAGER_EDIT_FORM = "com.dotmarketing.portlets.usermanager.edit";
    public static final String USERMANAGERLISTFORM= "com.dotmarketing.portlets.usermanager.listForm";
    public static final String USERMANAGERLIST= "com.dotmarketing.portlets.usermanager.list";
    public static final String USERMANAGERLISTCOUNT = "com.dotmarketing.portlets.usermanager.listcount";
    public static final String USERMANAGERLISTPARAMETERS = "com.dotmarketing.portlets.usermanager.lastSearchParameters";
    public static final String USERMANAGER_PROPERTIES = "com.dotmarketing.portlets.usermanager.properties";

    // WORKFLOW MESSAGES
    public static final String WORKFLOW_MESSAGE_EDIT  = "com.dotmarketing.workflowmessages.edit";
    public static final String WORKFLOW_MESSAGE_FORM_EDIT   = "com.dotmarketing.workflowmessages.edit_form";
    public static final String WORKFLOW_MESSAGE_LIST = "com.dotmarketing.workflowmessages.list";
    public static final String WORKFLOW_MESSAGE_VIEW_PORTLET = "com.dotmarketing.workflowmessages.view.portlet";
    public static final String WORKFLOW_MESSAGE_VERSIONS  = "com.dotmarketing.workflowmessages.versions";
    public static final String WORKFLOW_MESSAGE_SHOW_DELETED  = "com.dotmarketing.workflowmessages.show.deleted";
    public static final String WORKFLOW_MESSAGE_ORDER_BY  = "com.dotmarketing.workflowmessages.order.by";
    public static final String WORKFLOW_MESSAGE_ORDER_BY_DIRECTION  = "com.dotmarketing.workflowmessages.order.by.direction";
    public static final String WORKFLOW_MESSAGE_STATUS_ID  = "com.dotmarketing.workflowmessages.status_id";
    public static final String WORKFLOW_MESSAGE_QUERY  = "com.dotmarketing.workflowmessages.query";
    public static final String WORKFLOW_MESSAGES_VIEW = "com.dotmarketing.workflowmessages.view";

    // USER FAVORITES
    public static final String USER_FAVORITES = "com.dotmarketing.user_favorites";

    //PRODUCT MANAGER
    //BACK END
    public static final String PRODUCT_PRODUCTS_TYPE = "ProductTypes";
    public static final String PRODUCT_CATEGORIES = "Ecommerce";
    public static final String PRODUCT_PRODUCT = "product";
    public static final String PRODUCT_PRODUCT_FORMAT = "productFormat";
    public static final String PRODUCT_PRODUCT_PRICE = "productPrice";
    public static final String PRODUCT_SMALL_IMAGE = "smallImage";
    public static final String PRODUCT_MEDIUM_IMAGE = "mediumImage";
    public static final String PRODUCT_LARGE_IMAGE = "largeImage";
    public static final String PRODUCT_FILES = "files";
    public static final String PRODUCT_RELATED = "relatedProduct";

    //FRONT END
    public static final String SHOPPING_CART = "shoppingCart";
    public static final String SHOPPING_CART_ORDER_FORM = "shoppingCartOrderForm";
    public static final String SHOPPING_CART_FORMAT_INODE = "shoppingCartFormatInode";
    public static final String SHOPPING_CART_FORMAT_QUANTITY = "shoppingCartFormatQuantity";
    public static final String SHOPPING_CART_ERRORS = "shoppingCartErrors";

	//Event Registration Manager
    public static final String WEBEVENTS_REG_VIEW = "com.dotmarketing.webevents.registration.view";
    public static final String WEBEVENTS_REG_EDIT = "com.dotmarketing.webevents.registration.edit";
    public static final String WEBEVENTS_REG_FORM = "com.dotmarketing.webevents.registration.form";
    public static final String WEBEVENT_REG_ATTENDEES = "com.dotmarketing.webevents..registration.attendees";
    public static final String WEBEVENTS_REG_USER = "com.dotmarketing.webevents.registration.user";
    public static final String WEBEVENTS_REG_USERID = "com.dotmarketing.webevents.registration.userid";
    public static final String WEBEVENTS_REG_ATTENDEE_EDIT = "com.dotmarketing.webevents.registration.attendee.edit";
    public static final String WEBEVENTS_REG_ATTENDEE_FORM = "com.dotmarketing.webevents.registration.attendee.form";
    public static final String WEBEVENTS_REG_STATUSES = "com.dotmarketing.webevents.registration.statuses";
    public static final String WEBEVENTS_REG_BEAN = "com.dotmarketing.webevents.registration.bean";
    public static final String WEBEVENTS_REG_ERRORS = "com.dotmarketing.webevents.registration.errors";

    //Order Manager
    public static final String ORDER_MGR_VIEW = "com.dotmarketing.order_manager.view";
    public static final String ORDER_MGR_EDIT = "com.dotmarketing.order_manager.edit";
    public static final String ORDER_MGR_FORM = "com.dotmarketing.order_manager.form";
    public static final String ORDER_MGR_ITEMS = "com.dotmarketing.order_manager.items";
    public static final String ORDER_MGR_ITEM_EDIT = "com.dotmarketing.order_manager.item.edit";
    public static final String ORDER_MGR_ITEM_FORM = "com.dotmarketing.order_manager.item.form";
    public static final String ORDER_MGR_STATUSES = "com.dotmarketing.order_manager.statuses";
    public static final String ORDER_MGR_PAY_STATUSES = "com.dotmarketing.order_manager.pay.statuses";

    //DISCOUNT CODE
    public static final String DISCOUNTCODE_DISCOUNTS = "discounts";
    public static final String DISCOUNTCODE_ORDER_BY = "orderby";
    public static final String DISCOUNTCODE_DIRECTION = "direction";
    public static final String DISCOUNTCODE_PERCENTAGE = "1";
    public static final String DISCOUNTCODE_DISCOUNT = "2";
    public static final String DISCOUNTCODE_PRODUCT_FORMAT = "productFormat";
    //END DISCOUNT CODE

    public static final String WEBEVENTS_VIEW = "com.dotmarketing.webevents.view";
    public static final String WEBEVENTS_EDIT = "com.dotmarketing.webevents.edit";
    public static final String WEBEVENTS_FORM = "com.dotmarketing.webevents.form";
    public static final String WEBEVENT_CATEGORIES = "com.dotmarketing.webevents.categories";
    public static final String WEBEVENT_LOCATIONS = "com.dotmarketing.webevents.locations";
    public static final String WEBEVENTS_LOCATION_EDIT = "com.dotmarketing.webevents.location.edit";
    public static final String WEBEVENTS_LOCATION_FORM = "com.dotmarketing.webevents.location.form";

    //ORGANIZATION
    public static final String ORGANIZATION_OBJECT = "com.dotmarketing.organization.object";
	public static final String REDIRECT_AFTER_UPDATE_ACCOUNT_INFO = "REDIRECT_AFTER_UPDATE_ACCOUNT_INFO";

	//SCHEDULER
    public static final String SCHEDULER_VIEW_PORTLET = "com.dotmarketing.scheduler.view.portlet";
    public static final String SCHEDULER_LIST_VIEW = "com.dotmarketing.scheduler.view";
    public static final String UNIQUE_SCHEDULER_EXCEPTION = "com.dotmarketing.scheduler.unique.exception";

    //REPORTS
	public static final String REPORT_EDIT = "com.dotmarketing.report.edit";

	//WIki
    public static final String WIKI_CONTENTLET = "com.dotmarketing.wiki.contentlet";
    public static final String WIKI_CONTENTLET_INODE = "com.dotmarketing.wiki.contentlet.inode";
    public static final String WIKI_IN_WIKI = "com.dotmarketing.wiki.in.wiki";
    public static final String WIKI_CONTENTLET_URL = "com.dotmarketing.wiki.contentlet.url";

    //VISITOR
    public static final String VISITOR = "com.dotcms.visitor";

    public static class Cache
    {
        public static final String CACHE_BANNER_CACHE = "com.dotmarketing.cache.BannerCache";
        public static final String CACHE_HOST_CACHE = "com.dotmarketing.cache.HostCache";
        public static final String CACHE_IDENTIFIER_CACHE = "com.dotmarketing.cache.IdentifierCache";
        public static final String CACHE_LIVE_CACHE = "com.dotmarketing.cache.LiveCache";
        public static final String CACHE_PAGE_NOT_FOUND_CACHE = "com.dotmarketing.cache.PageNotFoundCache";
        public static final String CACHE_PERMISSION_CACHE = PermissionCache.class.getName();

        public static final String CACHE_ALL_CACHES = "CACHE_ALL_CACHES";
        public static final String CACHE_WORKING_FILES = "CACHE_WORKING_FILES";
        public static final String CACHE_LIVE_FILES = "CACHE_LIVE_FILES";
        public static final String CACHE_NUMBER_LIVE_FILES = "CACHE_NUMBER_LIVE_FILES";
        public static final String CACHE_NUMBER_WORKING_FILES = "CACHE_WORKING_LIVE_FILES";
        public static final String CACHE_CONTENTS_INDEX = "CACHE_CONTENTS_INDEX";
        public static final String CACHE_OPTIMIZE_INDEX = "CACHE_OPTIMIZE_INDEX";
        public static final String CACHE_MENU_FILES = "CACHE_MENUS_CACHE";
        public static final String CACHE_NOT_FOUND = "_NOT_FOUND_";
    }

    public static class Structure
    {
    	public static final String STRUCTURES = "STRUCTURES";
    	public static final String STRUCTURE = "STRUCTURE";
    	public static final String REORDER = "REORDER";
    	public static final String SET_DEFAULT = "SET_DEFAULT";
    	public static final String STRUCTURE_ENTITY = "structure_entity";
    	public static final String STRUCTURE_TYPE = "Structure Type";
    	public static final String STRUCTURE_EDIT_TYPE = "structure_edit_type";
        public static final String  ENTRIES_NUMBER = "entries_number";
    }

    public static class Relationship
    {
        public static final String RELATIONSHIP_EDIT = "com.dotmarketing.relationships.edit_relationship";
        public static final String RELATIONSHIP_REQUIRED = "com.dotmarketing.relationships.required";
    	public static enum RELATIONSHIP_CARDINALITY { ONE_TO_MANY , MANY_TO_MANY };
    	public static final String RELATIONSHIPS = "RELATIONSHIPS";
    	public static final String STRUCTURES_LIST = "STRUCTURES_LIST";
    }

    public static class Field
    {
    	public static final String FIELDS = "FIELDS";
    	public static final String FIELD = "FIELD";
    }

    public static class FatContentlet
    {
    	public static final String CONTENTLET = "contentlet";
    }

    public static class DateFormats
    {
    	public static final String SHORTDATE = "dd/MM/yyyy";
        public static final String DBDATE = "yyyy-MM-dd";
        public static final String LONGDBDATE = "yyyy-MM-dd hh:mm:ss";

        public static final String EXP_IMP_DATE = "MM/dd/yyyy";
        public static final String EXP_IMP_DATETIME = "MM/dd/yyyy hh:mm aa";
        public static final String EXP_IMP_TIME = "hh:mm aa";

        public static final String DOTSCHEDULER_DATE = "yyyy-MM-dd hh:mm:ss a";
        public static final String DOTSCHEDULER_DATE2 = "yyyy-MM-dd HH:mm:ss";
    }

    public static class Report
    {
    	public static final String ReportList = "reportList";
    }

    //COMMUNICATION
	public static final String COMMUNICATIONS_LIST = "com.dotmarketing.communications.list";
	public static final String COMMUNICATION_EDIT = "com.dotmarketing.communications.edit";
	public static final String COMMUNICATION_EDIT_FORM = "com.dotmarketing.communications.editForm";
	public static final String COMMUNICATION_EDIT_FORM_PERMISSION = "com.dotmarketing.communications.editForm.permission";

	//WebFormsMailExcel
	public static final String WEBFORMS_MAIL_EXCEL_FROM_ADDRESS = "WEBFORMS_MAIL_EXCEL_FROM_ADDRESS";
	public static final String WEBFORMS_MAIL_EXCEL_FROM_NAME = "WEBFORMS_MAIL_EXCEL_FROM_NAME";
	public static final String WEBFORMS_MAIL_EXCEL_FROM_SUBJECT = "WEBFORMS_MAIL_EXCEL_FROM_SUBJECT";
	public static final String WEBFORMS_MAIL_EXCEL_GROUP_NAME = "WEBFORMS_MAIL_EXCEL_GROUP_NAME";
	public static final String WEBFORMS_MAIL_EXCEL_WEBFORM_TYPE = "WEBFORMS_MAIL_EXCEL_WEBFORM_TYPE";

	//JCaptcha
	public static final String SESSION_JCAPTCHA_SOUND_SERVICE = "DOTCMS_SESSION_JCAPTCHA_SOUND_SERVICE";

	//CMS SUB NAV VARIABLES
	public static final String CMS_SELECTED_HOST_ID = "CMS_SELECTED_HOST_ID";
	public static final String CMS_CRUMBTRAIL_OPTIONS = "CMS_CRUMBTRAIL_OPTIONS";
	public static final String DONT_DISPLAY_SUBNAV_ALL_HOSTS = "DONT_DISPLAY_SUBNAV_ALL_HOSTS";
	public static final String LOCK_SUBNAV_TO_ALL_HOST = "LOCK_SUBNAV_TO_ALL_HOST";

    public static final String SELECTED_ENVIRONMENTS = "SELECTED_ENVIRONMENTS";
    public static final String SELECTED_BUNDLE = "SELECTED_BUNDLE";

	public static final String CONTENT_EDITABLE = "CONTENT_EDITABLE";

	// SYS Monitor
	public static final String USER_SESSIONS = "USER_SESSIONS";
	
	// ACE Text Editor
	public static final String TEXT_EDITOR = "textEditor";
	public static final String VELOCITY = "velocity";
	
	// Personas
    public static final String CMS_PERSONA_PARAMETER= "com.dotmarketing.persona.id";
	
	public static final String OSGI_ENABLED="felix.osgi.enabled";
	
	public static final String DOTCMS_STARTED_UP="dotcms.started.up";
	public static final String DOTCMS_STARTUP_TIME="dotcms.startup.ms";
	public static final String DOTCMS_STARTUP_TIME_CACHE="dotcms.startup.cache.ms";
	public static final String DOTCMS_STARTUP_TIME_DB="dotcms.startup.db.ms";
	public static final String DOTCMS_STARTUP_TIME_ES="dotcms.startup.es.ms";
    public static final String DOTCMS_STARTUP_TIME_HAZEL="dotcms.startup.hazel.ms";
	public static final String DOTCMS_STARTUP_TIME_QUARTZ="dotcms.startup.quartz.ms";
	public static final String DOTCMS_STARTUP_TIME_OSGI="dotcms.startup.osgi.ms";
	
	// Websocket configuration parameters
	public static final String DOTCMS_WEBSOCKET_PROTOCOL = "dotcms.websocket.protocol";
	public static final String DOTCMS_WEBSOCKET_BASEURL = "dotcms.websocket.baseurl";
	public static final String DOTCMS_WEBSOCKET_ENDPOINTS = "dotcms.websocket.endpoints";
    public static final String DOTCMS_WEBSOCKET_TIME_TO_WAIT_TO_RECONNECT = "dotcms.websocket.reconnect.time";
    public static final String DOTCMS_DISABLE_WEBSOCKET_PROTOCOL = "dotcms.websocket.disable";

	// System Events
	public static final String WEBSOCKET_SYSTEMEVENTS_ENDPOINT = "websocket.systemevents.endpoint";

	// System Security
	public static final String AUTH_FAILED_ATTEMPTS_DELAY_STRATEGY_ENABLED = "auth.failedattempts.delay.enabled";
	public static final String AUTH_FAILED_ATTEMPTS_DELAY_STRATEGY = "auth.failedattempts.delay.strategy";

	// Cache Transport
	public static final String DOTCMS_CACHE_TRANSPORT_BIND_ADDRESS = "dotcms.cache.transport.bind.address";
	public static final String DOTCMS_CACHE_TRANSPORT_BIND_PORT = "dotcms.cache.transport.bind.port";
	public static final String DOTCMS_CACHE_TRANSPORT_TCP_INITIAL_HOSTS = "dotcms.cache.transport.tcp.initial.hosts";
	public static final String DOTCMS_CACHE_TRANSPORT_UDP_MCAST_ADDRESS = "dotcms.cache.transport.udp.mcast.address";
	public static final String DOTCMS_CACHE_TRANSPORT_UDP_MCAST_PORT = "dotcms.cache.transport.udp.mcast.port";

	//Pagination Parameters
    public static final String DOTCMS_PAGINATION_ROWS = "dotcms.paginator.rows";
    public static final String DOTCMS_PAGINATION_LINKS = "dotcms.paginator.links";

    //User validations
    public static final String DOTCMS_USE_REGEX_TO_VALIDATE_EMAILS = "dotcms.use.regex.to.validate.emails";
}
