/**
 * Copyright (c) 2000-2005 Liferay, LLC. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.liferay.portal.util;

/**
 * <a href="RoleNames.java.html"><b><i>View Source</i></b></a>
 *
 * @author  Brian Wing Shun Chan
 * @version $Revision: 1.14 $
 *
 */
public class RoleNames {

	public static final String ADMINISTRATOR = "Administrator";

	public static final String BOOKMARKS_ADMIN = "Bookmarks Admin";

	public static final String DOCUMENT_LIBRARY_ADMIN =
		"Document Library Admin";

	public static final String GUEST = "Guest";

	public static final String JOURNAL_ADMIN = "Journal Admin";

	public static final String JOURNAL_DESIGNER = "Journal Designer";

	public static final String JOURNAL_EDITOR = "Journal Editor";

	public static final String JOURNAL_WRITER = "Journal Writer";

	public static final String MESSAGE_BOARDS_ADMIN =
		"Message Boards Admin";

	public static final String POLLS_ADMIN = "Polls Admin";

	public static final String POWER_USER = "Power User";

	public static final String PROJECT_ADMIN = "Project Admin";

	public static final String SHOPPING_ADMIN = "Shopping Admin";

	public static final String USER = "User";

	public static final String LOGIN_AS = "Login As";

	public static final String WIKI_ADMIN = "Wiki Admin";

	public static final String[] SYSTEM_ROLES = {
		ADMINISTRATOR, BOOKMARKS_ADMIN, DOCUMENT_LIBRARY_ADMIN,
		GUEST, JOURNAL_ADMIN, JOURNAL_DESIGNER, JOURNAL_EDITOR, JOURNAL_WRITER,
		MESSAGE_BOARDS_ADMIN, POLLS_ADMIN, POWER_USER, PROJECT_ADMIN,
		SHOPPING_ADMIN, USER, WIKI_ADMIN
	};

}