/**
 * Copyright (c) 2000-2005 Liferay, LLC. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.liferay.util.dao.hibernate;

import com.dotcms.repackage.net.sf.hibernate.HibernateException;
import com.dotcms.repackage.net.sf.hibernate.Session;
import com.dotcms.repackage.net.sf.hibernate.SessionFactory;
import com.dotcms.repackage.net.sf.hibernate.dialect.Dialect;
import com.dotcms.repackage.net.sf.hibernate.impl.SessionFactoryImpl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <a href="SessionConfiguration.java.html"><b><i>View Source</i></b></a>
 *
 * @author  Brian Wing Shun Chan
 * @version $Revision: 1.4 $
 *
 */
public abstract class SessionConfiguration {

	public SessionConfiguration() {
		init();
	}

	public abstract void init();

	public void setSessionFactory(SessionFactory sessionFactory) {
		_sessionFactory = (SessionFactoryImpl)sessionFactory;
		_dialect = _sessionFactory.getDialect();

		_log.debug(
			"Connection provider " +
				_sessionFactory.getConnectionProvider().getClass().getName());

		_log.debug("Dialect " + _dialect.getClass().getName());
	}

	public Dialect getDialect() {
		return _dialect;
	}

	public Session openSession() throws HibernateException {
		return _sessionFactory.openSession();
	}

	private static final Log _log =
		LogFactory.getLog(SessionConfiguration.class);

	private SessionFactoryImpl _sessionFactory;
	private Dialect _dialect;

}