/**
 * Copyright (c) 2000-2005 Liferay, LLC. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.liferay.util.xml;

import com.dotcms.repackage.org.dom4j.Document;

import com.liferay.util.xml.descriptor.PortletAppDescriptor;
import com.liferay.util.xml.descriptor.StrictXMLDescriptor;
import com.liferay.util.xml.descriptor.StrutsConfigDescriptor;
import com.liferay.util.xml.descriptor.TilesDefsDescriptor;
import com.liferay.util.xml.descriptor.WebXMLDescriptor;
import com.liferay.util.xml.descriptor.XMLDescriptor;

/**
 * <a href="XMLTypeDetector.java.html"><b><i>View Source</i></b></a>
 *
 * @author  Jorge Ferrer
 * @version $Revision: 1.5 $
 *
 */
public class XMLTypeDetector {

	public static final XMLDescriptor[] REGISTERED_DESCRIPTORS = {
		new PortletAppDescriptor(), new StrutsConfigDescriptor(),
		new TilesDefsDescriptor(), new WebXMLDescriptor()
	};

	public static XMLDescriptor determineType(String doctype, Document root) {
		for (int i = 0; i < REGISTERED_DESCRIPTORS.length; i++) {
			XMLDescriptor descriptor = REGISTERED_DESCRIPTORS[i];

			if (descriptor.canHandleType(doctype, root)) {
				return descriptor;
			}
		}

		return new StrictXMLDescriptor();
	}

}