tinymce.PluginManager.add('validation', function(editor, url) {
	var t = this;
	t.url = url;
	var items = [];
	var guideLineSel='';
	var markSelGuideLine='';
	var defaultGuidLine='';
	
	items.push({ text: 'Validation Guidelines', 'class': 'mceMenuItemTitle' })  ;
	
	function validate(){
		if (navigator.appName == 'Netscape')
		    var language = navigator.language;
		else
		    var language = navigator.browserLanguage;
		var code = language.substring(0,2);
		
	        var request = {	'lang': code, 
	            	'content': tinyMCE.activeEditor.getContent({format : 'text'}), 
			        'guidelines': guideLineSel ,
			        'fragment'  : true
			};
			var idName ='acheck'+tinymce.activeEditor.id;
			
			var loaddialog = dijit.Dialog({
			title: "Validating",
			content : "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src='/html/images/icons/round-progress-bar.gif' alt='loading'/>"
			});
			loaddialog.show();
			
			function createValidationResult( response ){
			
			loaddialog.hide(); loaddialog.destroy();
			
			var div = document.createElement("div"); 
			div.id = idName; 
			div.setAttribute("align", "center");
			div.setAttribute("style", "height: 340px;overflow: scroll; width: auto;overflow-x: hidden;overflow-y:auto;");
			var text = "" ;
			var errors = false;
			var msgText = editor.getLang('validation.validation_complete', 0);
			
			if( response.errors.length > 0 ){
				errors = true;
				msgText += response.errors.length + editor.getLang('validation.errors_found', 0);
			}
			else {
			  msgText += editor.getLang('validation.no_errors_found', 0);
			}
			if( response.errors.length > 0 ){
				text  += "<p style='color:red;'><strong>"+editor.getLang('validation.table_summary', 0)+"" + guideLineSel +" </strong> </p>";
				var testo = editor.getLang('validation.table_description', 0);
				text += "<table border='1' class='listingTable'>";
				text += "<tr> <th>Check ID </th>  "+ 
					"<th>"+testo+"</th>"+
					"<th>"+editor.getLang('validation.table_rowcols', 0)+"</th>"+
					"<th>"+editor.getLang('validation.table_errortype', 0)+"</th> </tr>";
				
				for ( var i = 0; i < response.errors.length; i++ ) {
					var error = response.errors[i];
					var modulo = (i+1)   % 2;
					var classValue ="1";
					if( modulo == 0 ){
						classValue = "2";
					}
					var classType = "alternate_"+classValue;							 
						var idRow = "elem_"+i;								
					text += "<tr id='"+idRow+"' class='"+classType + "' >";	
					text += "<td class='titleCellDiv'>" +error.check.check_id + "</td>"; 
					text += "<td> " + error.check.err +"( " + error.check.description +" ) </td>";
					  						 
					text += "<td>" + error.line_number + "/" + error.col_number + "</td>";
					text += "<td>" + error.check.confidenceEnum +"</td>";
					text += "</tr> ";
				}
				text += "</table>";
				div.innerHTML = text;
				var dialog = dijit.Dialog({
					title: msgText,
					content : div,
					style: "width: 640px;"
				});
				dialog.show();
			}			
			} 
			try{
			
			ACheckerDWR.validate(request ,createValidationResult);
			
			} catch(e){
			alert(e);
			}
	}
	
	function createGuideline( response  ){
		tinymce.each (response, function (o) {
			if( guideLineSel == '' && o.defaultGuideLine ) 							
			{
				defaultGuidLine = o.title;
			}
			items.push({ 
				text:  o.title,
				 onclick: function () {
					 guideLineSel = o.abbr;
					 markSelGuideLine = o.title;
					 validate();},
				 data: o.title
			});
		});
	}
		 
	ACheckerDWR.getSupportedGudelines(createGuideline); 

	function updateSelection(e) {
		e.control.items().each(function(ctrl) {
			if(markSelGuideLine == '')
				markSelGuideLine = defaultGuidLine;
			ctrl.active(ctrl.settings.data === markSelGuideLine);
		});
	}

	editor.addButton('validation', {
		type: 'splitbutton',
		title : 'Achecker Validation',
		image : t.url + '/img/check.png',
		menu: items,
		onshow: updateSelection
		
	});
});