
# Sponsoring

Sponsorship is the easiest and often-most-helpful-to-us way to contribute; just register directly with [GitHub Sponsors](https://github.com/sponsors/lando) and start helping Lando!

[[toc]]

## How to Sponsor

While you can sponsor directly using any of the below platforms, we recommend you sponsor via [GitHub](https://github.com/sponsors/lando). This way, we can better engage with you in the future.

GitHub Sponsors, Patreon, and Open Collective: all three of these official Lando sponsorship methods are valid but each comes with its own transaction fees and caveats. Broadly speaking, we've adjusted the sponsorship amount to account for transaction fees.

### [With GitHub Sponsors](https://github.com/sponsors/lando)

[GitHub Sponsors](https://github.com/sponsors/lando) is the best way to sponsor Lando for the reasons as follows:

**Lowest Sponsorship Amount**: GitHub Sponsors doesn't charge a transaction fee right now, so all your sponsorship $$$ helps Lando!
**2X Matching**: GitHub Sponsors will match all sponsorship dollars up to $5,000 in the first year. Your cash goes further!

[Sponsor With GitHub Here](https://github.com/sponsors/lando)

### [With Patreon](https://www.patreon.com/devwithlando)

The gold standard of sponsoring creatives, [Patreon](https://www.patreon.com/devwithlando) does charge a transactional fee; hence why you'll see sponsorship rates are a little higher there. Rest assured that Lando gets the same amount, but all things being equal, you might want to use GitHub Sponsors instead.

[Sponsor with Patreon Here](https://www.patreon.com/devwithlando)

### [With Open Collective](https://opencollective.com/lando)

[Open Collective](https://opencollective.com/lando) has similar drawbacks to Patreon, _however_, it may allow us to redistribute funds to projects Lando relies upon and other contributors in the future. If you're a devotee to the Open Collective ethos, give here, otherwise, GitHub Sponsors!

[Sponsor with Open Collective Here](https://opencollective.com/lando)

## Why Sponsor Lando

Lando is free and open source but freedom isn't free in the land of the brave and home of the Lando. Thousands of man hours have gone into creating Lando and hundreds more are spent each year providing support and maintenance.

By sponsoring Lando with your hard earned American dollars, the Lando team can do the following:

* Fix bugs
* Pay for hosting/bug monitoring
* Develop new features
* Create guides, tutorial, video and improve Lando documentation
* Answer developer questions on [Slack](https://www.launchpass.com/devwithlando)
* Allow [@pirog](https://github.com/pirog) to see the light of day

If you'd like to read more about why you should sponsor Lando, we encourage you to check out the posts as follows:

* [Why you should sponsor Lando](https://lando.dev/blog/2020/02/07/why-you-should-sponsor-lando.html)
* [Why your agency or org should sponsor Lando](https://lando.dev/blog/2020/02/08/why-your-agency-should-sponsor-lando.html)
* [Why your PaaS or dev tool should sponsor Lando](https://lando.dev/blog/2020/02/08/why-your-pass-should-sponsor-lando.html)

If you are interested in sponsoring at one of our higher tiers, then definitely [contact us](https://lando.dev/contact/) so we can figure out the terms of your sponsorship.

## Helping others sponsors

The Lando revolution relies upon new converts. You've probably already told some of your co-workers and friends to try Lando. Maybe you've [written some guides](https://docs.lando.dev/guides) and [sponsored Lando yourself](https://github.com/sponsors/lando). What's the next step? Getting someone else to sponsor Lando!

Chances are you know another individual or a business that would be willing to sponsor Lando. All they need is someone they trust (read: YOU) to tell them about it. Do you know any of the following people who might be interested in sponsoring?

- Friends who use Lando.
- Development agencies.
- University development teams.
- "Enterprise" development teams.
- Hosting companies.
- Dev tool providers.
- [Eccentric mallard millionares.](https://www.youtube.com/watch?v=bEmjiCoZ6e4&t=11s)

### Why Should Your Organization Sponsor Lando?

If you and your team are saving development time using Lando, your organization is already receiving dividends from the bank of Lando. Instead of each developer on your team paying part of their paycheck to sponsor, shouldn't your organization invest back to make sure the Lando royalties keep getting dished out?

Asking your boss to sponsor Lando might seem tough. Why should they pay for something they're already getting for free? There are _many_ reasons and we've prepared them all in the easily distributable blog content below:

* [Why you should sponsor Lando](https://lando.dev/blog/2020/02/07/why-you-should-sponsor-lando.html)
* [Why your agency or org should sponsor Lando](https://lando.dev/blog/2020/02/08/why-your-agency-should-sponsor-lando.html)
* [Why your PaaS or dev tool should sponsor Lando](https://lando.dev/blog/2020/02/08/why-your-pass-should-sponsor-lando.html)

### They're Ready to Sponsor. Now What?

Most organizations will want to sponsor directly through our [Github sponsors page](https://github.com/sponsors/lando). If Lando saves your organization at least a couple hours each month, we highly encourage you making a recurring contribution, but for one-time contributions [Open Collective](https://opencollective.com/lando#category-CONTRIBUTE) can be more convenient.

To take full advantage of sponsorship benefits your organization will want to reach out to <sponsorships@lando.dev>.

## FAQ

Some answers to some of our most frequent questions about sponsorship are shown below:

### When will I show up on the website, Twitter, etc?

We usually batch update our [list of sponsors](https://lando.dev/sponsor/) and Twitter queue _at least_ once a week so you should expect to see yourself or your org on the website within a week. Twitter can be a different story and depends on the queue. If there are a lot of sponsors in front of you, you might have to wait up to a month to get your shoutout.

An exception to the above rule is if you have sponsored at one of our higher tiers and we've provided custom marketing benefits. However, in this case, you will be directly in touch with one of our team members to coordinate the rollout.

If you feel like the above has not happened correctly and something is wrong, please reach out to us at <sponsorships@lando.dev> so we can make it right.

### When can I expect my swag?

Due to the time and administrative overhead, we usually send swag out once a quarter. So, if it's been three months or more, reach out to us at <sponsorships@lando.dev> so we can make it right.

### I want to sponsor, but can I get different benefits?

Yes!

Our highest two tiers are fairly customizable based around your needs. If you would like to put together custom sponsorship terms, then [contact us](https://lando.dev/contact/) and let us know what you are looking for. Our team will get in touch with you shortly and try to figure out something that works for all.

### How do I cancel a sponsorship?

We rely on third party sponsorship platforms to manage your sponsorship so you will want to terminate your sponsorship with them! For convenience, the relevant docs on how to do so for each of the platforms we support are shown below:

* [Cancel GitHub Sponsors Sponsorship](https://docs.github.com/en/billing/managing-billing-for-your-products/managing-billing-for-github-sponsors/downgrading-a-sponsorship)
* [Cancel Patreon Sponsorship](https://support.patreon.com/hc/en-us/articles/360000126286-Changing-your-tier)
* [Cancel OpenCollective Sponsorship](https://docs.opencollective.com/help/financial-contributors/organizations/organization-faq#can-i-cancel-or-change-my-contribution)

### How can I convince my boss or org to sponsor?

We have some ideas for that [over here](https://lando.dev/blog/2020/02/08/why-your-agency-should-sponsor-lando.html)!
