---
title: Accessibility and Lando
description: Using Lando with adaptive services.
guide: true

authors:
  - name: Team Lando
    pic: https://gravatar.com/avatar/c335f31e62b453f747f39a84240b3bbd
    link: https://twitter.com/devwithlando
updated:
  timestamp: 1703011953000

---

# Accessibility and Lando

## Introduction

Lando is committed to ensuring digital accessibility for people with disabilities. As a text-based CLI tool, Lando should be compatible with most screenreaders. Indeed, accessibility is primarily a challenge of having a terminal application that integrates well with your screen reader or other adaptive devices.

## Accessibility Features

1. **Keyboard Navigation**: All Lando functionalities are accessible via keyboard. Users can navigate through the interface, access all features, and execute commands using standard keyboard shortcuts.

2. **Screen Reader Compatibility**: Lando should be compatible with popular screen readers, although again this primarily depends on your terminal application's compatibility. Textual information, including command outputs and error messages, is structured to be screen reader friendly. If you find command output that is challenging to your screen reader, let us know!

3. **Contrast and Text Size**: Since Lando primarily operates in a command-line interface, we suggest using your terminal application's ability to switch to high contrast modes and adjust text size for users with visual impairments.

4. **Documentation in Accessible Formats**: Lando's electronic documentation should largely conform to WCAG 2.0 A and AA specifications.

## Support and Feedback

We welcome your feedback on the accessibility of Lando. Please let us know if you encounter accessibility barriers:

- **Contact Information**: vpat@lando.dev
- **Support**: Support for Lando as a free, open-source tool is provided by the Lando community on a volunteer basis via [documented support channels.](https://lando.dev/support)

Please [contact us](https://lando.dev/contact) if you're interested in paid enterprise support, including accessibility support.
