# Publishing notebooks to the web

You can publish marimo notebooks to the web as interactive editable notebooks,
readonly web apps, or [static documents](../exporting.md).

Thanks to [WebAssembly](../wasm.md), you can even share executable
notebooks on GitHub Pages or other static sites without paying for backend
infrastrcture. This makes it easy to share your work with colleagues, embed
executable notebooks in web documentation or educational websites, and more.

This guide provides an overview of the various ways to publish marimo notebooks.

| Guide                                                 | Description                                                  |
| ----------------------------------------------------- | ------------------------------------------------------------ |
| [Embedding](embedding.md)                             | An overview of embedding notebooks in other sites            |
| [From GitHub](from_github.md)                         | How to share links to executable notebooks hosted on GitHUb  |
| [GitHub Pages](github_pages.md)                       | Publishing interactive notebooks on GitHub Pages             |
| [Online playground](playground.md)                    | Sharing notebook links using our online playground           |
| [Community Cloud](community_cloud/index.md)           | Save notebooks to our free Community Cloud                   |
| [Self-host WebAssembly notebooks](self_host_wasm.md)  | Self-hosting interactive WebAssembly (HTML export) notebooks |
| [View notebooks on GitHub](view_outputs_on_github.md) | Viewing notebook outputs on GitHub                           |
| [Deploy on a backend](deploy.md)                      | Deploying notebooks on backends                              |
