/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
COPYRIGHT 1993-1999 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/
#ifndef __FXDPMI_H__
#define __FXDPMI_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __3DFX_H__
#  include "3dfx.h"
#endif

/*
** type definitions
*/
typedef FxI16 DpmiSelector_t;

typedef struct
{
  FxI32 EDI;
  FxI32 ESI;
  FxI32 EBP;
  FxI32 reserved;
  FxI32 EBX;
  FxI32 EDX;
  FxI32 ECX;
  FxI32 EAX;
  FxI16 flags;
  FxI16 ES, DS, FS, GS, IP, CS, SP, SS;
} DpmiRMI;

/*
** function prototypes
*/
FxU32   DpmiMapPhysicalToLinear( FxU32 paddr, FxU32 length );
void   *DpmiAllocDosMem( FxU16 size, DpmiSelector_t *pSel );
FxBool  DpmiFreeDosMem( DpmiSelector_t sel );

void    DpmiExecuteRMI( DpmiRMI *data );

#ifdef __cplusplus
}
#endif

#endif
