<div align="center">
<img src="assets/header.gif"/>
  <a href="#contributors-"><img src="https://img.shields.io/badge/all_contributors-2-orange.svg?style=flat-square" alt="All contributors"></a>
  <img src="https://github.com/tuist/tuist/workflows/Tuist/badge.svg" alt="Tuist">
  <img src="https://img.shields.io/github/v/release/tuist/tuist?include_prereleases&style=flat-square" alt="Latest Version">
  <a href="http://slack.tuist.io"><img src="http://slack.tuist.io/badge.svg" alt="Slack"></a>
  <a href="http://community.tuist.io"><img src="https://img.shields.io/badge/community-tuist-blue?style=flat-square" alt="Community"></a>
  <img src="https://img.shields.io/github/forks/tuist/tuist?style=flat-square" alt="GitHub forks">
  <img src="https://img.shields.io/github/stars/tuist/tuist?style=flat-square" alt="GitHub stars">
  <img src="https://img.shields.io/github/commit-activity/w/tuist/tuist?style=flat-square" alt="Commit Activity">
    <img src="https://img.shields.io/github/contributors/tuist/tuist?style=flat-square" alt="Contributors">
  <img src="https://img.shields.io/github/commits-since/tuist/tuist/latest?style=flat-square" alt="Latest Commits">
  <a href="http://twitter.com/tuistio"><img src="https://img.shields.io/twitter/follow/tuistio?style=flat-square" alt="Twitter Followers"></a>
  <img src="https://img.shields.io/opencollective/sponsors/tuistapp?style=flat-square" alt="Sponsors">
  <img src="https://img.shields.io/opencollective/all/tuistapp?style=flat-square" alt="Backers and sponsors">
  <img src="https://img.shields.io/github/license/tuist/tuist?style=flat-square" alt="License">
  <img src="https://img.shields.io/badge/Powered%20by-Tuist-blue" alt="Powered by Tuist">
  <a href="#contributors-"><img src="https://img.shields.io/badge/all_contributors-3-orange.svg?style=flat-square" alt="Contributors"></a>
</div>

## What's Tuist 🕺

Tuist is a command line tool that helps you **generate**, **maintain** and **interact** with Xcode projects.

It's open source and written in Swift.

## Install ⬇️

### Running script (Recommended)

```bash
bash <(curl -Ls https://install.tuist.io)
```

## Bootstrap your first project 🌀

```bash
tuist init --platform ios
tuist generate # Generates Xcode project & workspace
tuist build # Builds your project
```

[Check out](https://tuist.io/docs) the project "Getting Started" guide to learn more about Tuist and all its features.

## Repository structure

The repository is a monorepo with multiple projects:

- [Swift Package (CLI) 📦](/)
- [Main Website 🌍](/website)

## Documentation 📝

Do you want to know more about what Tuist can offer you? Or perhaps want to contribute to the project and you need a starting point? You can check out the [project documentation](https://tuist.io/docs/usage/getting-started/).

## Supported by great companies

MacStadium supports this project by providing Mac mini hardware that we can use for running performance tests.

<img width="200" src="assets/MacStadium.png"/>

1Password supports this project by providing a team account to store sensitive like access tokens and passwords:

<img width="100" src="assets/1Password.png"/>

## Contribute 👩‍💻

If you are interested in contributed to the project, our documentation has a section with resources for contributors. We recommend starting from [this page](https://tuist.io/docs/contribution/getting-started/).

## Core Team ✨

<table>
  <tr>
    <td align="center"><a href="https://github.com/pepibumur"><img src="https://avatars1.githubusercontent.com/u/663605?v=4" width="100px;" alt=""/><br /><sub><b>Pedro Piñera</b></sub></a><br /></td>
    <td align="center"><a href="https://github.com/fortmarek"><img src="https://avatars0.githubusercontent.com/u/9371695?v=4" width="100px;" alt=""/><br /><sub><b>Marek Fořt</b></sub></a><br /></td>
    <td align="center"><a href="http://www.matrixprojects.net"><img src="https://avatars3.githubusercontent.com/u/11914919?v=4" width="100px;" alt=""/><br /><sub><b>Kas</b></sub></a><br /></td>
    <td align="center"><a href="http://natanrolnik.me"><img src="https://avatars3.githubusercontent.com/u/1164565?v=4" width="100px;" alt=""/><br /><sub><b>Natan Rolnik</b></sub></a><br /></td>
    <td align="center"><a href="https://github.com/andreacipriani"><img src="https://avatars3.githubusercontent.com/u/536929?v=4" width="100px;" alt=""/><br /><sub><b>Andrea Cipriani</b></sub></a><br /></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/ollieatkinson"><img src="https://avatars1.githubusercontent.com/u/1382565?v=4" width="100px;" alt=""/><br /><sub><b>Oliver Atkinson</b></sub></a><br /></td>
    <td align="center"><a href="https://github.com/RomainBoulay"><img src="https://avatars1.githubusercontent.com/u/169323?v=4" width="100px;" alt=""/><br /><sub><b>Romain Boulay</b></sub></a><br /></td>
    <td align="center"><a href="https://github.com/laxmorek"><img src="https://avatars1.githubusercontent.com/u/4774319?v=4" width="100px;" alt=""/><br /><sub><b>Kamil Harasimowicz</b></sub></a><br /></td>
  </tr>
</table>

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://github.com/kalkwarf"><img src="https://avatars1.githubusercontent.com/u/1033839?v=4" width="100px;" alt=""/><br /><sub><b>kalkwarf</b></sub></a></td>
    <td align="center"><a href="https://github.com/fortmarek"><img src="https://avatars0.githubusercontent.com/u/9371695?v=4" width="100px;" alt=""/><br /><sub><b>Marek Fořt</b></sub></a></td>
    <td align="center"><a href="https://github.com/fortmarek"><img src="https://avatars0.githubusercontent.com/u/9371695?v=4" width="100px;" alt=""/><br /><sub><b>Marek Fořt</b></sub></a></td>
    <td align="center"><a href="http://www.matrixprojects.net"><img src="https://avatars3.githubusercontent.com/u/11914919?v=4" width="100px;" alt=""/><br /><sub><b>Kas</b></sub></a></td>
    <td align="center"><a href="http://natanrolnik.me"><img src="https://avatars3.githubusercontent.com/u/1164565?v=4" width="100px;" alt=""/><br /><sub><b>Natan Rolnik</b></sub></a></td>
    <td align="center"><a href="https://github.com/svastven"><img src="https://avatars0.githubusercontent.com/u/42235915?v=4" width="100px;" alt=""/><br /><sub><b>svastven</b></sub></a></td>
    <td align="center"><a href="http://bhuemer.github.io"><img src="https://avatars2.githubusercontent.com/u/1212480?v=4" width="100px;" alt=""/><br /><sub><b>Bernhard Huemer</b></sub></a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://djankowski.dev"><img src="https://avatars0.githubusercontent.com/u/10795657?v=4" width="100px;" alt=""/><br /><sub><b>Daniel Jankowski</b></sub></a></td>
    <td align="center"><a href="https://github.com/facumenzella"><img src="https://avatars1.githubusercontent.com/u/1125252?v=4" width="100px;" alt=""/><br /><sub><b>Facundo Menzella</b></sub></a></td>
    <td align="center"><a href="https://github.com/eito"><img src="https://avatars3.githubusercontent.com/u/775643?v=4" width="100px;" alt=""/><br /><sub><b>Eric Ito</b></sub></a></td>
    <td align="center"><a href="https://github.com/laxmorek"><img src="https://avatars2.githubusercontent.com/u/4774319?v=4" width="100px;" alt=""/><br /><sub><b>Kamil Harasimowicz</b></sub></a></td>
    <td align="center"><a href="https://github.com/olejnjak"><img src="https://avatars1.githubusercontent.com/u/3148214?v=4" width="100px;" alt=""/><br /><sub><b>Jakub Olejník</b></sub></a></td>
    <td align="center"><a href="https://github.com/lakpa"><img src="https://avatars0.githubusercontent.com/u/389328?v=4" width="100px;" alt=""/><br /><sub><b>ldindu</b></sub></a></td>
    <td align="center"><a href="https://github.com/gtsifrikas"><img src="https://avatars2.githubusercontent.com/u/8904378?v=4" width="100px;" alt=""/><br /><sub><b>George Tsifrikas</b></sub></a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/yurapriv"><img src="https://avatars2.githubusercontent.com/u/7814127?v=4" width="100px;" alt=""/><br /><sub><b>Privezentsev Yura</b></sub></a></td>
    <td align="center"><a href="http://ferologics.github.io"><img src="https://avatars2.githubusercontent.com/u/5576161?v=4" width="100px;" alt=""/><br /><sub><b>Fero</b></sub></a></td>
    <td align="center"><a href="http://www.luispadron.com"><img src="https://avatars3.githubusercontent.com/u/13840545?v=4" width="100px;" alt=""/><br /><sub><b>Luis Padron</b></sub></a></td>
    <td align="center"><a href="https://heberti.com"><img src="https://avatars0.githubusercontent.com/u/103670?v=4" width="100px;" alt=""/><br /><sub><b>Heberti Almeida</b></sub></a></td>
    <td align="center"><a href="http://benscheirman.com"><img src="https://avatars0.githubusercontent.com/u/59140?v=4" width="100px;" alt=""/><br /><sub><b>Ben Scheirman</b></sub></a></td>
    <td align="center"><a href="https://jsorge.net"><img src="https://avatars3.githubusercontent.com/u/2585841?v=4" width="100px;" alt=""/><br /><sub><b>Jared Sorge</b></sub></a></td>
    <td align="center"><a href="https://joeblau.com"><img src="https://avatars1.githubusercontent.com/u/1218847?v=4" width="100px;" alt=""/><br /><sub><b>Joe Blau</b></sub></a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://twitter.com/dchavezlive"><img src="https://avatars0.githubusercontent.com/u/2475932?v=4" width="100px;" alt=""/><br /><sub><b>David Chavez</b></sub></a></td>
    <td align="center"><a href="https://www.linkedin.com/in/роман-подымов-72338ab0/"><img src="https://avatars3.githubusercontent.com/u/10789692?v=4" width="100px;" alt=""/><br /><sub><b>Roman Podymov</b></sub></a></td>
    <td align="center"><a href="https://github.com/marcinreliga-fn"><img src="https://avatars0.githubusercontent.com/u/76949651?v=4" width="100px;" alt=""/><br /><sub><b>Marcin Religa</b></sub></a></td>
    <td align="center"><a href="https://github.com/adellibovi"><img src="https://avatars3.githubusercontent.com/u/67916?v=4" width="100px;" alt=""/><br /><sub><b>Alfredo Delli Bovi</b></sub></a></td>
    <td align="center"><a href="https://github.com/Jake-Prickett"><img src="https://avatars1.githubusercontent.com/u/26095410?v=4" width="100px;" alt=""/><br /><sub><b>Jake Prickett</b></sub></a></td>
    <td align="center"><a href="https://github.com/danyf90"><img src="https://avatars.githubusercontent.com/u/2794031?v=4" width="100px;" alt=""/><br /><sub><b>Daniele Formichelli</b></sub></a></td>
    <td align="center"><a href="https://www.facebook.com/PetrachkovSergey"><img src="https://avatars.githubusercontent.com/u/7995896?v=4" width="100px;" alt=""/><br /><sub><b>Sergey Petrachkov</b></sub></a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
