import Foundation
import TSCBasic
import TuistAutomation
import TuistCore
import TuistGenerator
import TuistGraph

/// Custom mapper provider for automation features
/// It uses default `WorkspaceMapperProvider` but adds its own on top
final class AutomationWorkspaceMapperProvider: WorkspaceMapperProviding {
    private let workspaceDirectory: AbsolutePath
    private let workspaceMapperProvider: WorkspaceMapperProviding

    convenience init(
        workspaceDirectory: AbsolutePath
    ) {
        self.init(
            workspaceDirectory: workspaceDirectory,
            workspaceMapperProvider: WorkspaceMapperProvider(
                projectMapperProvider: AutomationProjectMapperProvider()
            )
        )
    }

    init(
        workspaceDirectory: AbsolutePath,
        workspaceMapperProvider: WorkspaceMapperProviding
    ) {
        self.workspaceDirectory = workspaceDirectory
        self.workspaceMapperProvider = workspaceMapperProvider
    }

    func mapper(config: Config) -> WorkspaceMapping {
        var mappers: [WorkspaceMapping] = []
        mappers.append(AutomationPathWorkspaceMapper(workspaceDirectory: workspaceDirectory))
        mappers.append(workspaceMapperProvider.mapper(config: config))
        if config.generationOptions.contains(.disableAutogeneratedSchemes) {
            mappers.append(AutogeneratedProjectSchemeWorkspaceMapper())
        }

        return SequentialWorkspaceMapper(mappers: mappers)
    }
}
