import Foundation
import TuistCore
import TuistGenerator
import TuistGraph

protocol WorkspaceMapperProviding {
    func mapper(config: Config) -> WorkspaceMapping
}

final class WorkspaceMapperProvider: WorkspaceMapperProviding {
    private let projectMapperProvider: ProjectMapperProviding

    convenience init(contentHasher: ContentHashing) {
        self.init(projectMapperProvider: ProjectMapperProvider(contentHasher: contentHasher))
    }

    init(projectMapperProvider: ProjectMapperProviding = ProjectMapperProvider()) {
        self.projectMapperProvider = projectMapperProvider
    }

    func mapper(config: Config) -> WorkspaceMapping {
        SequentialWorkspaceMapper(mappers: mappers(config: config))
    }

    func mappers(config: Config) -> [WorkspaceMapping] {
        var mappers: [WorkspaceMapping] = []

        mappers.append(
            ProjectWorkspaceMapper(mapper: projectMapperProvider.mapper(config: config))
        )

        mappers.append(
            TuistWorkspaceIdentifierMapper()
        )

        // Auto-generation of project scheme
        if !config.generationOptions.contains(.disableAutogeneratedSchemes) {
            mappers.append(AutogeneratedProjectSchemeWorkspaceMapper())
        }

        return mappers
    }
}
