import Foundation
import XCTest
@testable import ProjectDescription

final class ConfigTests: XCTestCase {
    func test_config_toJSON() throws {
        let config = Config(cloud: Cloud(url: "https://cloud.tuist.io", projectId: "123", options: [.insights]),
                            generationOptions: [
                                .xcodeProjectName("someprefix-\(.projectName)"),
                                .organizationName("TestOrg"),
                                .developmentRegion("de"),
                                .disableAutogeneratedSchemes,
                                .disableSynthesizedResourceAccessors,
                                .disableShowEnvironmentVarsInScriptPhases,
                                .enableCodeCoverage,
                            ])

        XCTAssertCodable(config)
    }

    func test_config_toJSON_WITH_gitPlugin() {
        let config = Config(plugins: [.git(url: "https://git.com/repo.git", branch: "main")],
                            generationOptions: [])

        XCTAssertCodable(config)
    }

    func test_config_toJSON_WITH_localPlugin() {
        let config = Config(plugins: [.local(path: "/some/path/to/plugin")],
                            generationOptions: [])

        XCTAssertCodable(config)
    }

    func test_config_toJSON_withAutogeneratedSchemes() throws {
        let config = Config(cloud: Cloud(url: "https://cloud.tuist.io", projectId: "123", options: [.insights]),
                            generationOptions: [
                                .xcodeProjectName("someprefix-\(.projectName)"),
                                .developmentRegion("de"),
                                .organizationName("TestOrg"),
                            ])

        XCTAssertCodable(config)
    }
}
