import Foundation
import TuistCache
import TuistCore
import TuistGenerator
import TuistGraph
import TuistGraphTesting
import XCTest

@testable import TuistKit
@testable import TuistSupportTesting

final class WorkspaceMapperProviderTests: TuistUnitTestCase {
    var subject: WorkspaceMapperProvider!

    override func setUp() {
        super.setUp()
        subject = WorkspaceMapperProvider(contentHasher: ContentHasher())
    }

    override func tearDown() {
        subject = nil
        super.tearDown()
    }

    func test_mapper_does_not_return_autogenerated_project_scheme_mapper_when_autogenerated_schemes_are_disabled() throws {
        // Given
        subject = WorkspaceMapperProvider(contentHasher: ContentHasher())

        // When
        let got = subject.mappers(
            config: Config.test(
                generationOptions: [
                    .disableAutogeneratedSchemes,
                ]
            )
        )

        // Then
        XCTAssertEqual(got.filter { $0 is AutogeneratedProjectSchemeWorkspaceMapper }.count, 0)
    }

    func test_mapper_returns_autogenerated_project_scheme_mapper() throws {
        // Given
        subject = WorkspaceMapperProvider(contentHasher: ContentHasher())

        // When
        let got = subject.mappers(config: Config.test())

        // Then
        XCTAssertEqual(got.filter { $0 is AutogeneratedProjectSchemeWorkspaceMapper }.count, 1)
    }
}
