# frozen_string_literal: true
module Fourier
  module Commands
    class Base < Thor
      def self.banner(command, _namespace = nil, _subcommand = false)
        "#{basename} #{subcommand_prefix} #{command.usage}"
      end

      def self.subcommand_prefix
        # Name returns the class of the command. For example: Fourier::Commands::Test::Tuist::Command
        # From this method we return how the command should be presented in the output generated by help.
        name
          .gsub("Fourier::Commands::", "")
          .gsub("::", " ")
          .downcase
      end
    end
  end
end
