---
title: "Schneider Electric: Streamlining Identity Management"
type: case-study
sitemap: false
logoUrl: "/media/articles/email-wall/case-studies/schneider-electric/logo-white.png"
iconUrl: "/media/articles/email-wall/case-studies/schneider-electric/logo-white.png"
bgColor: "#02A34F"
description: "Learn why Schneider Electric chose Auth0 as the foundation of their identity infrastructure, and the benefits of Auth0's developer-centric platform for this global leader in energy management."
hash: "schneider-electric"
fourKeyConcepts:
  -
    text: "Challenge: Flexible Enterprise SSO"
    icon: budicon-573
  -
    text: "Solution: Scalable Federated Identity With Auth0"
    icon: budicon-347
  -
    text: "Benefits: Enhanced Security, Risk Management, Happy Employees, Reduced Costs"
    icon: budicon-255
  -
    text: "Result: Seamless, Quick Implementation, Flexibility For Future"
    icon: budicon-540
keyMetrics:
  -
    label: "Revenue"
    content: "€24.9 B ($30.1 B)"
  -
    label: "Position"
    content: "In top 10 most sustainable corporations in the world"
  -
    label: "Employees"
    content: "170,000+ employees"
  -
    label: "Location"
    content: "In over 100 countries"
longDescription: >
 Schneider Electric needed an Identity Management solution that could take on their rapid growth to over 170,000 employees worldwide, and their expansion into new markets. The goal - implement Single Sign-On across the whole company, breaking down organizational silos, simplifying employee access to resources, reducing IT costs, and improving security. Learn why Schneider Electric chose Auth0 as the foundation of their identity infrastructure, and the benefits of Auth0's developer-centric platform for this global leader in energy management.
---

* * *
<div class="toc-box"></div>
## OVERVIEW
On the heels of significant growth and new partnerships, Schneider Electric, the world’s leading supplier of integrated energy solutions,  faced a major update to its IT infrastructure. With over 170,000 employees across more than 100 countries, the company needed an Identity and Authorization Management (IAM) strategy that could scale with the company’s next phase of growth while maximizing efficient use of resources.
Schneider Electric specializes in energy management. Not IAM. The goal: implement an IAM system with single sign-on (SSO) across the whole company. A system that could reuse identities and streamline disjointed “islands of data.

> *The Auth0 platform makes it easier for our developers and engineers to swiftly implement something ordinarily complicated. We’ve saved time, money, manpower (and a headache or two) when it comes to federated identity management. More importantly, Auth0 provides a value which translates to direct security and efficiency benefits for our company and a better user experience for our customers.*
> **- Stephen Berard, ‎Senior Global Software Architect at Schneider Electric**

<!-- |Schneider Electric At A Glance
|------------------------------
| * Revenue: €24.9 B ($30.1 B)
| * In top 10 most sustainable corporations in the world
| * 170,000+ employees
| * In over 100 countries -->

## THE CHALLENGE
### INITIAL CHALLENGE - FIND THE RIGHT PARTNER
A cost-benefit analysis quickly proved that Schneider Electric would be better off leveraging its employee resources to deliver on core business goals and objectives. The company needed a partner, but who would be right for Schneider Electric’s ambitious plan? Management was convinced that their current provider wasn’t up to the task, and time was of the essence. The company needed a reliable specialist in enterprise identity management with a solution that could be flexible and easy to work with, could integrate with externally facing web and mobile applications, that is compliant with open standards for identity federation, and that is powerful enough to satisfy long-term needs.
Several in-house developers and architects urged management to put Auth0’s IDaaS solution to the test. They were familiar with Auth0’s developer-friendly reputation, and had seen Auth0 successfully deliver efficient and effective authentication for a choosy government agency.

With the help of Auth0’s customer success team, Schneider Electric implemented a quick and successful proof of concept trial. With this success, and experiencing Auth0’s flexible, modern and developer-centric approach first-hand, Schneider Electric selected Auth0 for its new federated identity management system.

> *What we found in Auth0 was an authentication-as-a-service solution that was built by developers with the modern developer in mind.*
> **- Stephen Berard, ‎Schneider Electric**

### NEXT CHALLENGE - SINGLE SIGN-ON, UNIFIED IDENTITY ACROSS THE ENTERPRISE
Schneider Electric needed a single sign-on system that could let users log in once to all of the company’s diverse systems and applications. With the same identities and credentials unifying disparate parts of this global enterprise, Schneider Electric’s workforce would be able to securely connect to applications such as ERP and eCommerce without the hazards and inefficiencies of maintaining many username and strong password combinations. One unified process for all of Schneider Electric’s “islands of data” could break down barriers within the corporation and easily tackle challenging identity integration problems.

|What To Look For In An Enterprise IAM Partner
|---------------------------------------------
| * Flexible
| * Developer focused
| * Web/Mobile Friendly
| * Open Standards
| * Powerful, Future-Proof

## THE SOLUTION
### SCALABLE FEDERATED IDENTITY
Frustrated by the limitations of proprietary solutions, Schneider Electric leveraged Auth0 to create a scalable federated identity management system that is easy to build upon and easy to manage. Auth0 integrates across all widely adopted identity standards and providers, so now Schneider Electric can collaborate with external partners and services, and its external website users can authenticate with social logins such as Facebook. The Digital Services Platform team can give each user a single set of credentials and corresponding authorizations, and enterprise applications use federated identity protocols to authenticate users and grant allowed access across the whole business, and beyond.

### START SMALL, AND ITERATE
Led by Stephen Berard, ‎senior global software architect at Schneider Electric, Kenneth Carroll, VP of software platform and software architect, Manu Cohen-Yashar, the Digital Services Platform team started small with early-stage Auth0 pilot projects. Building upon success and gaining confidence in the platform with experience, the team’s on-going subscription contract has expanded with use, remaining flexible and improving overall business efficiency, meeting Schneider Electric’s growing needs.

“We were impressed by the predictable pricing and easy ability to build exactly what we need,” said Berard. “At first the discussions were around ‘whose corporate card is this going to go on?’ Then it became about, ‘how are we going to get corporate to sign-off on a new and emerging technology?’ It was quickly evident how efficient and effective Auth0 was at meeting our IAM existing and future needs, and how this translated to more of our precious resources being spent for the good of the company and our customers. They got it.”

## BENEFITS

| Realized Benefits | |
| ------------------- | ---------------- |
| * Extra work eliminated | * Fast time to market |
| * Reduced risk | * Responsive, flexible partner |
| * Fast, thorough reaction to vulnerabilities | * Increased security, IAM best practices implemented |
| * More resources for IT innovation | * Straightforward pricing, contract, subscription |
| * Easier planning, fast integrations | * Great docs, sample code, developer focus |
| * Enterprise SSO together with custom app acceleration | |

### ENHANCED SECURITY, RISK MANAGEMENT
“Before any news sites reported on last year’s Heartbleed zero day vulnerability, Auth0 emailed us to alert us to the situation. There was already a patch to eliminate the Heartbleed threat from Auth0’s systems, followed by a confirmation email that Auth0 had already installed this patch on the Schneider Electric instance of Auth0’s service,” said Berard. “Auth0 helps our platform team look really good. In this scenario, not only had the security issue been patched, our IT team was able to save valuable time by leveraging the detailed steps on how the issues were mitigated to report directly to our internal team. What’s more, Auth0 cycled the certificates, something else that would have been very labor intensive for the team to do on its own.

- Eliminates need to run an identity store, saving limited employee resources
- Reduces risk associated with authentication and authorization
- Quick and thorough security patching against vulnerabilities

“Security is often misunderstood, and when it is an afterthought, left to the end, it tends to bite you in the butt. We didn’t have to kick the proverbial can down the road every time a new security or authentication question came up, whether the question was  hypothetical, practical or mission critical,” said Berard. “With the Auth0 platform, we can plan and integrate identity architecture early to save critical time and ensure a secure system is in place when a project gets off the ground.”

- Empowers IT team to invest into strategic business and customer demands, and innovation
- IT team is able to plan identity scenarios early and make any necessary integrations quickly
- Provide both traditional enterprise SSO as well serve as the ultimate accelerator to integrate the same identity management into custom applications and APIs

### EASY TO WORK WITH, EASY TO IMPLEMENT
“The biggest selling point was that Auth0 is super easy for developers to use and integrate. We also appreciate that the Auth0 platform follows open standards and has extensive features to make it really easy for developers,” said Kenneth Carroll, VP of software platform, Schneider Electric.

- Implementation was quick, seamless and easy
- As Schneider Electric grows and company needs evolve, Auth0 works with the team to help address new and emerging identity needs
- Through SSO, Schneider Electric eliminates the burden of additional log-in prompts – one less password for valuable customers to manage; increasing security and reducing friction

“We were very impressed with how fast the Auth0 team gets back to us when we have a question. We have a different relationship with them compared to our other vendors. We feel they are one of us – solution and developer minded – always open to our questions, talking out an idea, and even adapting their service to our specific needs,” said Manu Cohen-Yashar, specialized tech architect, Schneider Electric.

> *It was quickly evident how efficient and effective Auth0 was at meeting our IAM existing and future needs, and how this translated to more of our precious resources being spent for the good of the company and our customers. They got it.*
> **- Stephen Berard, ‎Schneider Electric**

- Flexible and patient through contract discussions
- Comprehensive, easily understood documentation and code samples, and attentive, quick-responding customer service – especially through convenient online chat
