/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.commons.httpclient;

import hidden.org.apache.commons.httpclient.HttpException;
import hidden.org.apache.commons.httpclient.NameValuePair;
import hidden.org.apache.commons.logging.Log;
import hidden.org.apache.commons.logging.LogFactory;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class HeaderElement
extends NameValuePair {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$HeaderElement == null ? (class$org$apache$commons$httpclient$HeaderElement = HeaderElement.class$("hidden.org.apache.commons.httpclient.HeaderElement")) : class$org$apache$commons$httpclient$HeaderElement);
    private static final BitSet SEPARATORS = new BitSet(128);
    private static final BitSet TOKEN_CHAR = new BitSet(128);
    private static final BitSet UNSAFE_CHAR = new BitSet(128);
    private NameValuePair[] parameters = null;
    static /* synthetic */ Class class$org$apache$commons$httpclient$HeaderElement;

    public HeaderElement() {
        this(null, null, null);
    }

    public HeaderElement(String name, String value) {
        this(name, value, null);
    }

    public HeaderElement(String name, String value, NameValuePair[] parameters) {
        super(name, value);
        this.setParameters(parameters);
    }

    public NameValuePair[] getParameters() {
        return this.parameters;
    }

    protected void setParameters(NameValuePair[] pairs) {
        this.parameters = pairs;
    }

    public static final HeaderElement[] parse(String headerValue) throws HttpException {
        LOG.trace("enter HeaderElement.parse(String)");
        if (headerValue == null) {
            return null;
        }
        Vector<HeaderElement> elements = new Vector<HeaderElement>();
        StringTokenizer tokenizer = new StringTokenizer(headerValue.trim(), ",");
        while (tokenizer.countTokens() > 0) {
            String nextToken = tokenizer.nextToken();
            try {
                while (HeaderElement.hasOddNumberOfQuotationMarks(nextToken)) {
                    nextToken = nextToken + "," + tokenizer.nextToken();
                }
            }
            catch (NoSuchElementException exception) {
                throw new HttpException("Bad header format: wrong number of quotation marks");
            }
            try {
                String s;
                if (tokenizer.hasMoreTokens() && ((s = nextToken.toLowerCase()).endsWith("mon") || s.endsWith("tue") || s.endsWith("wed") || s.endsWith("thu") || s.endsWith("fri") || s.endsWith("sat") || s.endsWith("sun") || s.endsWith("monday") || s.endsWith("tuesday") || s.endsWith("wednesday") || s.endsWith("thursday") || s.endsWith("friday") || s.endsWith("saturday") || s.endsWith("sunday"))) {
                    nextToken = nextToken + "," + tokenizer.nextToken();
                }
            }
            catch (NoSuchElementException exception) {
                throw new HttpException("Bad header format: parsing with wrong header elements");
            }
            String tmp = nextToken.trim();
            if (!tmp.endsWith(";")) {
                tmp = tmp + ";";
            }
            char[] header = tmp.toCharArray();
            boolean inAString = false;
            int startPos = 0;
            HeaderElement element = new HeaderElement();
            Vector<NameValuePair> paramlist = new Vector<NameValuePair>();
            int i = 0;
            while (i < header.length) {
                if (header[i] == ';' && !inAString) {
                    NameValuePair pair = HeaderElement.parsePair(header, startPos, i);
                    if (pair == null) {
                        throw new HttpException("Bad header format: empty name/value pair in" + nextToken);
                    }
                    if (startPos == 0) {
                        element.setName(pair.getName());
                        element.setValue(pair.getValue());
                    } else {
                        paramlist.addElement(pair);
                    }
                    startPos = i + 1;
                } else if (!(header[i] != '\"' || inAString && i > 0 && header[i - 1] == '\\')) {
                    inAString = !inAString;
                }
                ++i;
            }
            if (paramlist.size() > 0) {
                Object[] tmp2 = new NameValuePair[paramlist.size()];
                paramlist.copyInto(tmp2);
                element.setParameters((NameValuePair[])tmp2);
                paramlist.removeAllElements();
            }
            elements.addElement(element);
        }
        Object[] headerElements = new HeaderElement[elements.size()];
        elements.copyInto(headerElements);
        return headerElements;
    }

    private static final boolean hasOddNumberOfQuotationMarks(String string) {
        boolean odd = false;
        int start = -1;
        while ((start = string.indexOf(34, start + 1)) != -1) {
            boolean bl = odd = !odd;
        }
        return odd;
    }

    private static final NameValuePair parsePair(char[] header, int start, int end) {
        LOG.trace("enter HeaderElement.parsePair(char[], int, int)");
        NameValuePair pair = null;
        String name = new String(header, start, end - start).trim();
        String value = null;
        int index = name.indexOf("=");
        if (index >= 0) {
            if (index + 1 < name.length() && (value = name.substring(index + 1).trim()).startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            name = name.substring(0, index).trim();
        }
        pair = new NameValuePair(name, value);
        return pair;
    }

    public NameValuePair getParameterByName(String name) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        NameValuePair found = null;
        NameValuePair[] parameters = this.getParameters();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                NameValuePair current = parameters[i];
                if (current.getName().equalsIgnoreCase(name)) {
                    found = current;
                    break;
                }
                ++i;
            }
        }
        return found;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SEPARATORS.set(40);
        SEPARATORS.set(41);
        SEPARATORS.set(60);
        SEPARATORS.set(62);
        SEPARATORS.set(64);
        SEPARATORS.set(44);
        SEPARATORS.set(59);
        SEPARATORS.set(58);
        SEPARATORS.set(92);
        SEPARATORS.set(34);
        SEPARATORS.set(47);
        SEPARATORS.set(91);
        SEPARATORS.set(93);
        SEPARATORS.set(63);
        SEPARATORS.set(61);
        SEPARATORS.set(123);
        SEPARATORS.set(125);
        SEPARATORS.set(32);
        SEPARATORS.set(9);
        int ch = 32;
        while (ch < 127) {
            TOKEN_CHAR.set(ch);
            ++ch;
        }
        TOKEN_CHAR.xor(SEPARATORS);
        int ch2 = 0;
        while (ch2 < 32) {
            UNSAFE_CHAR.set(ch2);
            ++ch2;
        }
        UNSAFE_CHAR.set(32);
        UNSAFE_CHAR.set(60);
        UNSAFE_CHAR.set(62);
        UNSAFE_CHAR.set(34);
        UNSAFE_CHAR.set(123);
        UNSAFE_CHAR.set(125);
        UNSAFE_CHAR.set(124);
        UNSAFE_CHAR.set(92);
        UNSAFE_CHAR.set(94);
        UNSAFE_CHAR.set(126);
        UNSAFE_CHAR.set(91);
        UNSAFE_CHAR.set(93);
        UNSAFE_CHAR.set(96);
        UNSAFE_CHAR.set(127);
    }
}

