package org.jboss.weld.tests.annotatedType.superclass;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.BeanArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.junit.Test;
import org.junit.runner.RunWith;

import javax.enterprise.inject.spi.Extension;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

/**
 * @author Ales Justin
 */
@RunWith(Arquillian.class)
public class SuperclassModifiedTest {

    @Deployment
    public static Archive getDeployment() {
        return ShrinkWrap.create(BeanArchive.class)
                .addPackage(Child.class.getPackage())
                .addAsServiceProvider(Extension.class, ModifyExtension.class);
    }

    @Test
    public void shouldNotInjectSuperclassFields(Child child) {
        assertNotNull("Should resolve Child", child);
        assertNull("Should not have Foo injected", child.getFoo());
    }
}
