/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.weld.tests.cditck11.contexts.dependent.instance;

import static org.junit.Assert.assertTrue;

import javax.enterprise.inject.spi.BeanManager;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.BeanArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * An instance of a bean with scope <code>@Dependent</code> obtained by direct invocation of an <code>Instance</code> is a
 * dependent object of the instance of <code>Instance</code>.
 *
 * Test taken from org.jboss.cdi.tck.tests.context.dependent.instance.BuiltinInstanceDependentObjectTest
 *
 * @author Martin Kouba
 * @author Jozef Hartinger
 */
@RunWith(Arquillian.class)
public class BuiltinInstanceDependentObjectTest {

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrap.create(BeanArchive.class).addPackage(BuiltinInstanceDependentObjectTest.class.getPackage());
    }

    @Test
    public void testInstanceDependentObject(BeanManager manager) {
        Foo.reset();
        manager.fireEvent(new GoodEvent(true));
        assertTrue(Foo.created);
        assertTrue(Foo.destroyed);
    }

}
