/*
 * JBoss, Home of Professional Open Source
 * Copyright 2013, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.weld.tests.event.observer.validation.enterprise;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * Test related to WELD-746, verifies inherited observer methods that is not
 * part of their business interface causes DefinitionException 
 */
@RunWith(Arquillian.class)
public class InheritedObserverMethodNotInBusinessInterfaceValidationTest {
    @Deployment
    // @ShouldThrowException(DefinitionException.class)
    @ShouldThrowException(Exception.class) // AS7-1197
    public static JavaArchive getDeployment() {
        return ShrinkWrap.create(JavaArchive.class, "test.jar")
                .addAsManifestResource(EmptyAsset.INSTANCE, "beans.xml")
                .addClasses(Egg.class, Farmer.class, FarmerLocal.class, 
                      LazyFarmer.class, LazyFarmerLocal.class);
    }

    @Test
    public void testDeployment() {
        // Arquillian ShouldThrowException marks it as allowed, does not stop @Test from execution
    }
}

