/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc. and/or its affiliates, and individual
 * contributors by the @authors tag. See the copyright.txt in the
 * distribution for a full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.weld.tests.interceptors.retry;

import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

/**
 * @author Marius Bogoevici
 */
@Interceptor
@Retriable
public class RetryInterceptor {
    static int invocationCount = 0;

    @AroundInvoke
    public Object retryOnFailure(InvocationContext invocationContext) throws Exception {
        int attempts = 0;
        do {
            try {
                invocationCount++;
                return invocationContext.proceed();
            } catch (Exception e) {

            }
            attempts++;
        } while (attempts < 3);
        return null;
    }
}
