/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.weld.tests.interceptors.singleInstance;

import static org.junit.Assert.assertEquals;

import javax.inject.Inject;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.BeanArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(Arquillian.class)
public class SingleInterceptorInstancePerBeanInstanceTest {

    @Inject
    private Lion lion;
    @Inject
    private Lioness lioness;
    @Inject
    private Tiger tiger;
    @Inject
    private Tigress tigress;

    @Deployment
    public static Archive<?> getDeployment() {
        return ShrinkWrap.create(BeanArchive.class).intercept(LionInterceptor.class, TigerInterceptor.class)
                .addPackage(SingleInterceptorInstancePerBeanInstanceTest.class.getPackage());
    }

    @Test
    public void testSingleInterceptorInstanceUsedForSubsequentInvocationWithCdiBinding() {
        assertEquals(tiger.foo(), tiger.foo());
        assertEquals(lion.foo(), lion.foo());
    }

    @Test
    public void testSingleInterceptorInstanceUsedForSubsequentInvocation() {
        assertEquals(lioness.foo(), lioness.foo());
        assertEquals(tigress.foo(), tigress.foo());
    }

    @Test
    public void testSingleInterceptorInstanceUsedForDifferentMethodsWithCdiBinding() {
        assertEquals(tiger.foo(), tiger.bar());
        assertEquals(lion.foo(), lion.bar());
    }

    @Test
    public void testSingleInterceptorInstanceUsedForDifferentMethods() {
        assertEquals(lioness.foo(), lioness.bar());
        assertEquals(tigress.foo(), tigress.bar());
    }

    @Test
    public void testSingleInterceptorInstanceUsedForMethodAndLifecycleCallbackWithCdiBinding() {
        assertEquals(lioness.getPostConstructInterceptor(), lioness.foo());
    }

    @Test
    public void testSingleInterceptorInstanceUsedForMethodAndLifecycleCallback() {
        assertEquals(lion.getPostConstructInterceptor(), lion.foo());
    }
}
