/*
 * Copyright (C) 2013, British Broadcasting Corporation
 * All Rights Reserved.
 *
 * Author: Philip de Nier
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the British Broadcasting Corporation nor the names
 *       of its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef BMX_PS_AVCI_HEADER_DATA_H_
#define BMX_PS_AVCI_HEADER_DATA_H_

#include <bmx/BMXTypes.h>
#include <bmx/EssenceType.h>


#define PS_AUD_DATA_SIZE    6
#define PS_SPS_DATA_SIZE    88
#define PS_PPS_DATA_SIZE    9


typedef struct
{
    bmx::EssenceType essence_type;
    bmx::Rational sample_rate;
    const char *format_str;
    unsigned char sps[PS_SPS_DATA_SIZE];
    unsigned char pps[PS_PPS_DATA_SIZE];
} PSAVCIHeaderData;



static const unsigned char PS_AVCI_AUD[PS_AUD_DATA_SIZE] =
{
    0x00, 0x00, 0x00, 0x01, 0x09, 0x10
};

static const PSAVCIHeaderData PS_AVCI_HEADER_DATA[] =
{
    {bmx::AVCI100_1080I, {25, 1}, "AVC-Intra 100 1080i50",
        {
            0x00, 0x00, 0x00, 0x01, 0x67, 0x7a, 0x10, 0x29,
            0xb6, 0xd4, 0x20, 0x22, 0x33, 0x19, 0xc6, 0x63,
            0x23, 0x21, 0x01, 0x11, 0x98, 0xce, 0x33, 0x19,
            0x18, 0x21, 0x03, 0x3a, 0x46, 0x65, 0x6a, 0x65,
            0x24, 0xad, 0xe9, 0x12, 0x32, 0x14, 0x1a, 0x26,
            0x34, 0xad, 0xa4, 0x41, 0x82, 0x23, 0x01, 0x50,
            0x2b, 0x1a, 0x24, 0x69, 0x48, 0x30, 0x40, 0x2e,
            0x11, 0x12, 0x08, 0xc6, 0x8c, 0x04, 0x41, 0x28,
            0x4c, 0x34, 0xf0, 0x1e, 0x01, 0x13, 0xf2, 0xe0,
            0x3c, 0x60, 0x20, 0x20, 0x28, 0x00, 0x00, 0x03,
            0x00, 0x08, 0x00, 0x00, 0x03, 0x01, 0x94, 0x20
        },
        {
            0x00, 0x00, 0x00, 0x01, 0x68, 0xce, 0x33, 0x48,
            0xd0
        },
    },
    {bmx::AVCI100_1080P, {25, 1}, "AVC-Intra 100 1080p25",
        {
            0x00, 0x00, 0x00, 0x01, 0x67, 0x7a, 0x10, 0x29,
            0xb6, 0xd4, 0x20, 0x22, 0x33, 0x19, 0xc6, 0x63,
            0x23, 0x21, 0x01, 0x11, 0x98, 0xce, 0x33, 0x19,
            0x18, 0x21, 0x02, 0x56, 0xb9, 0x3d, 0x7d, 0x7e,
            0x4f, 0xe3, 0x3f, 0x11, 0xf1, 0x9e, 0x08, 0xb8,
            0x8c, 0x54, 0x43, 0xc0, 0x78, 0x02, 0x27, 0xe2,
            0x70, 0x1e, 0x30, 0x10, 0x10, 0x14, 0x00, 0x00,
            0x03, 0x00, 0x04, 0x00, 0x00, 0x03, 0x00, 0xca,
            0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        },
        {
            0x00, 0x00, 0x00, 0x01, 0x68, 0xce, 0x33, 0x48,
            0xd0
        },
    },
    {bmx::AVCI100_720P, {25, 1}, "AVC-Intra 100 720p25",
        {
            0x00, 0x00, 0x00, 0x01, 0x67, 0x7a, 0x10, 0x29,
            0xb6, 0xd4, 0x20, 0x2a, 0x33, 0x1d, 0xc7, 0x62,
            0xa1, 0x08, 0x40, 0x54, 0x66, 0x3b, 0x8e, 0xc5,
            0x42, 0x02, 0x10, 0x25, 0x64, 0x2c, 0x89, 0xe8,
            0x85, 0xe4, 0x21, 0x4b, 0x90, 0x83, 0x06, 0x95,
            0xd1, 0x06, 0x46, 0x97, 0x20, 0xc8, 0xd7, 0x43,
            0x08, 0x11, 0xc2, 0x1e, 0x4c, 0x91, 0x0f, 0x01,
            0x40, 0x16, 0xec, 0x07, 0x8c, 0x04, 0x04, 0x05,
            0x00, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x03,
            0x00, 0x32, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        },
        {
            0x00, 0x00, 0x00, 0x01, 0x68, 0xce, 0x31, 0x12,
            0x11
        },
    },
    {bmx::AVCI100_720P, {50, 1}, "AVC-Intra 100 720p50",
        {
            0x00, 0x00, 0x00, 0x01, 0x67, 0x7a, 0x10, 0x29,
            0xb6, 0xd4, 0x20, 0x2a, 0x33, 0x1d, 0xc7, 0x62,
            0xa1, 0x08, 0x40, 0x54, 0x66, 0x3b, 0x8e, 0xc5,
            0x42, 0x02, 0x10, 0x25, 0x64, 0x2c, 0x89, 0xe8,
            0x85, 0xe4, 0x21, 0x4b, 0x90, 0x83, 0x06, 0x95,
            0xd1, 0x06, 0x46, 0x97, 0x20, 0xc8, 0xd7, 0x43,
            0x08, 0x11, 0xc2, 0x1e, 0x4c, 0x91, 0x0f, 0x01,
            0x40, 0x16, 0xec, 0x07, 0x8c, 0x04, 0x04, 0x05,
            0x00, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x03,
            0x00, 0x64, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        },
        {
            0x00, 0x00, 0x00, 0x01, 0x68, 0xce, 0x31, 0x12,
            0x11
        },
    },
    {bmx::AVCI50_1080I, {25, 1}, "AVC-Intra 50 1080i50",
        {
            0x00, 0x00, 0x00, 0x01, 0x67, 0x6e, 0x10, 0x28,
            0xa6, 0xd4, 0x20, 0x32, 0x33, 0x0c, 0x71, 0x18,
            0x88, 0x62, 0x10, 0x19, 0x19, 0x86, 0x38, 0x8c,
            0x44, 0x30, 0x21, 0x02, 0x56, 0x4e, 0x6e, 0x61,
            0x87, 0x3e, 0x73, 0x4d, 0x98, 0x0c, 0x03, 0x06,
            0x9c, 0x0b, 0x73, 0xe6, 0xc0, 0xb5, 0x18, 0x63,
            0x0d, 0x39, 0xe0, 0x5b, 0x02, 0xd4, 0xc6, 0x19,
            0x1a, 0x79, 0x8c, 0x32, 0x34, 0x24, 0xf0, 0x16,
            0x81, 0x13, 0xf7, 0xff, 0x80, 0x01, 0x80, 0x02,
            0x71, 0x80, 0x80, 0x80, 0xa0, 0x00, 0x00, 0x03,
            0x00, 0x20, 0x00, 0x00, 0x06, 0x50, 0x80, 0x00
        },
        {
            0x00, 0x00, 0x00, 0x01, 0x68, 0xee, 0x31, 0x12,
            0x11
        },
    },
    {bmx::AVCI50_1080P, {25, 1}, "AVC-Intra 50 1080p25",
        {
            0x00, 0x00, 0x00, 0x01, 0x67, 0x6e, 0x10, 0x28,
            0xa6, 0xd4, 0x20, 0x32, 0x33, 0x0c, 0x71, 0x18,
            0x88, 0x62, 0x10, 0x19, 0x19, 0x86, 0x38, 0x8c,
            0x44, 0x30, 0x21, 0x02, 0x56, 0x4e, 0x6f, 0x37,
            0xcd, 0xf9, 0xbf, 0x81, 0x6b, 0xf3, 0x7c, 0xde,
            0x6e, 0x6c, 0xd3, 0x3c, 0x05, 0xa0, 0x22, 0x7e,
            0x5f, 0xfc, 0x00, 0x0c, 0x00, 0x13, 0x8c, 0x04,
            0x04, 0x05, 0x00, 0x00, 0x03, 0x00, 0x01, 0x00,
            0x00, 0x03, 0x00, 0x32, 0x84, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        },
        {
            0x00, 0x00, 0x00, 0x01, 0x68, 0xee, 0x31, 0x12,
            0x11
        },
    },
    {bmx::AVCI50_720P, {25, 1}, "AVC-Intra 50 720p25",
        {
            0x00, 0x00, 0x00, 0x01, 0x67, 0x6e, 0x10, 0x20,
            0xa6, 0xd4, 0x20, 0x32, 0x33, 0x0c, 0x71, 0x18,
            0x88, 0x62, 0x10, 0x19, 0x19, 0x86, 0x38, 0x8c,
            0x44, 0x30, 0x21, 0x02, 0x56, 0x4e, 0x6f, 0x37,
            0xcd, 0xf9, 0xbf, 0x81, 0x6b, 0xf3, 0x7c, 0xde,
            0x6e, 0x6c, 0xd3, 0x3c, 0x0f, 0x01, 0x6e, 0xff,
            0xc0, 0x00, 0xc0, 0x01, 0x38, 0xc0, 0x40, 0x40,
            0x50, 0x00, 0x00, 0x03, 0x00, 0x10, 0x00, 0x00,
            0x03, 0x03, 0x28, 0x40, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        },
        {
            0x00, 0x00, 0x00, 0x01, 0x68, 0xee, 0x31, 0x12,
            0x11
        },
    },
    {bmx::AVCI50_720P, {50, 1}, "AVC-Intra 50 720p50",
        {
            0x00, 0x00, 0x00, 0x01, 0x67, 0x6e, 0x10, 0x20,
            0xa6, 0xd4, 0x20, 0x32, 0x33, 0x0c, 0x71, 0x18,
            0x88, 0x62, 0x10, 0x19, 0x19, 0x86, 0x38, 0x8c,
            0x44, 0x30, 0x21, 0x02, 0x56, 0x4e, 0x6f, 0x37,
            0xcd, 0xf9, 0xbf, 0x81, 0x6b, 0xf3, 0x7c, 0xde,
            0x6e, 0x6c, 0xd3, 0x3c, 0x0f, 0x01, 0x6e, 0xff,
            0xc0, 0x00, 0xc0, 0x01, 0x38, 0xc0, 0x40, 0x40,
            0x50, 0x00, 0x00, 0x03, 0x00, 0x10, 0x00, 0x00,
            0x06, 0x48, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        },
        {
            0x00, 0x00, 0x00, 0x01, 0x68, 0xee, 0x31, 0x12,
            0x11
        },
    },
};


#endif

