/*
 * Baseline S377M MXF data model definitions
 *
 * Copyright (C) 2012, British Broadcasting Corporation
 * All Rights Reserved.
 *
 * Author: Philip de Nier
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the British Broadcasting Corporation nor the names
 *       of its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */



/* Note: defines are undefined at the end of the file, unless KEEP_DATA_MODEL_DEFS defined */


#if !defined (MXF_BASIC_TYPE_DEF)
#define MXF_BASIC_TYPE_DEF(typeId, name, size)
#endif
#if !defined (MXF_ARRAY_TYPE_DEF)
#define MXF_ARRAY_TYPE_DEF(typeId, name, elementTypeId, fixedSize)
#endif
#if !defined (MXF_COMPOUND_TYPE_DEF)
#define MXF_COMPOUND_TYPE_DEF(typeId, name)
#endif
#if !defined (MXF_COMPOUND_TYPE_MEMBER)
#define MXF_COMPOUND_TYPE_MEMBER(memberName, memberTypeId)
#endif
#if !defined (MXF_INTERPRETED_TYPE_DEF)
#define MXF_INTERPRETED_TYPE_DEF(typeId, name, interpretedTypeId, fixedSize)
#endif

#if !defined (MXF_LABEL)
#define MXF_LABEL(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15)
#endif
#if !defined (MXF_SET_DEFINITION)
#define MXF_SET_DEFINITION(parentName, name, label)
#endif
#if !defined (MXF_ITEM_DEFINITION)
#define MXF_ITEM_DEFINITION(setName, name, label, localTag, typeId, isRequired)
#endif




/* Type Definitions */

MXF_BASIC_TYPE_DEF(MXF_INT8_TYPE,   "Int8", 1);
MXF_BASIC_TYPE_DEF(MXF_INT16_TYPE,  "Int16", 2);
MXF_BASIC_TYPE_DEF(MXF_INT32_TYPE,  "Int32", 4);
MXF_BASIC_TYPE_DEF(MXF_INT64_TYPE,  "Int64", 8);
MXF_BASIC_TYPE_DEF(MXF_UINT8_TYPE,  "UInt8", 1);
MXF_BASIC_TYPE_DEF(MXF_UINT16_TYPE, "UInt16", 2);
MXF_BASIC_TYPE_DEF(MXF_UINT32_TYPE, "UInt32", 4);
MXF_BASIC_TYPE_DEF(MXF_UINT64_TYPE, "UInt64", 8);
MXF_BASIC_TYPE_DEF(MXF_RAW_TYPE,    "Raw", 0);

MXF_ARRAY_TYPE_DEF(MXF_UTF16STRING_TYPE,            "UTF16String",          MXF_UTF16_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UTF16STRINGARRAY_TYPE,       "UTF16StringArray",     MXF_UTF16_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UTF8STRING_TYPE,             "UTF8String",           MXF_UTF8_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_INT8ARRAY_TYPE,              "Int8Array",            MXF_INT8_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_INT16ARRAY_TYPE,             "Int16Array",           MXF_INT16_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_INT32ARRAY_TYPE,             "Int32Array",           MXF_INT32_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_INT64ARRAY_TYPE,             "Int64Array",           MXF_INT64_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UINT8ARRAY_TYPE,             "UInt8Array",           MXF_UINT8_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UINT16ARRAY_TYPE,            "UInt16Array",          MXF_UINT16_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UINT32ARRAY_TYPE,            "UInt32Array",          MXF_UINT32_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UINT64ARRAY_TYPE,            "UInt64Array",          MXF_UINT64_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_ISO7STRING_TYPE,             "ISO7String",           MXF_ISO7_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_INT8BATCH_TYPE,              "Int8Batch",            MXF_INT8_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_INT16BATCH_TYPE,             "Int16Batch",           MXF_INT16_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_INT32BATCH_TYPE,             "Int32Batch",           MXF_INT32_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_INT64BATCH_TYPE,             "Int64Batch",           MXF_INT64_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UINT8BATCH_TYPE,             "UInt8Batch",           MXF_UINT8_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UINT16BATCH_TYPE,            "UInt16Batch",          MXF_UINT16_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UINT32BATCH_TYPE,            "UInt32Batch",          MXF_UINT32_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UINT64BATCH_TYPE,            "UInt64Batch",          MXF_UINT64_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_AUIDARRAY_TYPE,              "AUIDArray",            MXF_AUID_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_ULARRAY_TYPE,                "ULArray",              MXF_UL_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_ULBATCH_TYPE,                "ULBatch",              MXF_UL_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UUIDARRAY_TYPE,              "UUIDArray",            MXF_UUID_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_UUIDBATCH_TYPE,              "UUIDBatch",            MXF_UUID_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_STRONGREFARRAY_TYPE,         "StrongRefArray",       MXF_STRONGREF_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_STRONGREFBATCH_TYPE,         "StrongRefBatch",       MXF_STRONGREF_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_WEAKREFARRAY_TYPE,           "WeakRefArray",         MXF_WEAKREF_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_WEAKREFBATCH_TYPE,           "WeakRefBatch",         MXF_WEAKREF_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_RATIONALARRAY_TYPE,          "RationalArray",        MXF_RATIONAL_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_RGBALAYOUT_TYPE,             "RGBALayout",           MXF_RGBALAYOUTCOMPONENT_TYPE, 8);
MXF_ARRAY_TYPE_DEF(MXF_AES3_FIXED_DATA_ARRAY_TYPE,  "AES3FixedDataArray",   MXF_AES3_FIXED_DATA_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_J2K_COMPONENT_SIZING_ARRAY_TYPE, "J2KComponentSizingArray", MXF_J2K_COMPONENT_SIZING_TYPE, 0);
MXF_ARRAY_TYPE_DEF(MXF_THREE_COLOR_PRIMARIES_TYPE,  "ThreeColorPrimaries",  MXF_COLOR_PRIMARY_TYPE, 3);
MXF_ARRAY_TYPE_DEF(MXF_RIFF_CHUNK_ID_TYPE,          "RIFFChunkIDType",      MXF_ISO7_TYPE, 4);


MXF_COMPOUND_TYPE_DEF(MXF_RATIONAL_TYPE, "Rational");
MXF_COMPOUND_TYPE_MEMBER("Numerator",   MXF_INT32_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Denominator", MXF_INT32_TYPE);

MXF_COMPOUND_TYPE_DEF(MXF_TIMESTAMP_TYPE, "Timestamp");
MXF_COMPOUND_TYPE_MEMBER("Year",    MXF_UINT16_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Month",   MXF_UINT8_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Day",     MXF_UINT8_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Hours",   MXF_UINT8_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Minutes", MXF_UINT8_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Seconds", MXF_UINT8_TYPE);
MXF_COMPOUND_TYPE_MEMBER("QMSec",   MXF_UINT8_TYPE);

MXF_COMPOUND_TYPE_DEF(MXF_PRODUCTVERSION_TYPE, "ProductVersion");
MXF_COMPOUND_TYPE_MEMBER("Major",   MXF_UINT16_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Minor",   MXF_UINT16_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Patch",   MXF_UINT16_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Build",   MXF_UINT16_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Release", MXF_UINT16_TYPE);

MXF_COMPOUND_TYPE_DEF(MXF_INDIRECT_TYPE, "Indirect");
MXF_COMPOUND_TYPE_MEMBER("Type",    MXF_UL_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Value",   MXF_UINT8ARRAY_TYPE);

MXF_COMPOUND_TYPE_DEF(MXF_RGBALAYOUTCOMPONENT_TYPE, "RGBALayoutComponent");
MXF_COMPOUND_TYPE_MEMBER("Code",    MXF_RGBACODE_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Depth",   MXF_UINT8_TYPE);

MXF_COMPOUND_TYPE_DEF(MXF_J2K_COMPONENT_SIZING_TYPE, "J2KComponentSizing");
MXF_COMPOUND_TYPE_MEMBER("Ssiz",    MXF_UINT8_TYPE);
MXF_COMPOUND_TYPE_MEMBER("XRsiz",   MXF_UINT8_TYPE);
MXF_COMPOUND_TYPE_MEMBER("YRsiz",   MXF_UINT8_TYPE);

MXF_COMPOUND_TYPE_DEF(MXF_COLOR_PRIMARY_TYPE, "ColorPrimary");
MXF_COMPOUND_TYPE_MEMBER("X",   MXF_UINT16_TYPE);
MXF_COMPOUND_TYPE_MEMBER("Y",   MXF_UINT16_TYPE);


MXF_INTERPRETED_TYPE_DEF(MXF_VERSIONTYPE_TYPE,          "VersionType",      MXF_UINT16_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_UTF16_TYPE,                "UTF16",            MXF_UINT16_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_UTF8_TYPE,                 "UTF8",             MXF_UINT8_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_BOOLEAN_TYPE,              "Boolean",          MXF_UINT8_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_ISO7_TYPE,                 "ISO7",             MXF_UINT8_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_LENGTH_TYPE,               "Length",           MXF_INT64_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_POSITION_TYPE,             "Position",         MXF_INT64_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_RGBACODE_TYPE,             "RGBACode",         MXF_UINT8_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_STREAM_TYPE,               "Stream",           MXF_RAW_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_DATAVALUE_TYPE,            "DataValue",        MXF_UINT8ARRAY_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_IDENTIFIER_TYPE,           "Identifier",       MXF_UINT8ARRAY_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_OPAQUE_TYPE,               "Opaque",           MXF_UINT8ARRAY_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_UMID_TYPE,                 "UMID",             MXF_IDENTIFIER_TYPE, 32);
MXF_INTERPRETED_TYPE_DEF(MXF_UID_TYPE,                  "UID",              MXF_IDENTIFIER_TYPE, 16);
MXF_INTERPRETED_TYPE_DEF(MXF_UL_TYPE,                   "UL",               MXF_IDENTIFIER_TYPE, 16);
MXF_INTERPRETED_TYPE_DEF(MXF_UUID_TYPE,                 "UUID",             MXF_IDENTIFIER_TYPE, 16);
MXF_INTERPRETED_TYPE_DEF(MXF_AUID_TYPE,                 "AUID",             MXF_UL_TYPE, 16);
MXF_INTERPRETED_TYPE_DEF(MXF_PACKAGEID_TYPE,            "PackageID",        MXF_UMID_TYPE, 32);
MXF_INTERPRETED_TYPE_DEF(MXF_STRONGREF_TYPE,            "StrongRef",        MXF_UUID_TYPE, 16);
MXF_INTERPRETED_TYPE_DEF(MXF_WEAKREF_TYPE,              "WeakRef",          MXF_UUID_TYPE, 16);
MXF_INTERPRETED_TYPE_DEF(MXF_ORIENTATION_TYPE,          "Orientation",      MXF_UINT8_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_CODED_CONTENT_TYPE_TYPE,   "CodedContentType", MXF_UINT8_TYPE, 0);
MXF_INTERPRETED_TYPE_DEF(MXF_AES3_FIXED_DATA_TYPE,      "AES3FixedData",    MXF_UINT8ARRAY_TYPE, 24);
MXF_INTERPRETED_TYPE_DEF(MXF_J2K_EXTENDED_CAPABILITIES_TYPE, "J2KExtendedCapabilities", MXF_UINT8ARRAY_TYPE, 0);




/* Set and Item Definitions */


MXF_SET_DEFINITION(root, root,
  MXF_LABEL(0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00)
);

MXF_SET_DEFINITION(root, InterchangeObject,
  MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x01,0x00)
);

    MXF_ITEM_DEFINITION(InterchangeObject, InstanceUID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x01,0x01,0x15,0x02,0x00,0x00,0x00,0x00),
        0x3c0a,
        MXF_UUID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(InterchangeObject, GenerationUID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x20,0x07,0x01,0x08,0x00,0x00,0x00),
        0x0102,
        MXF_UUID_TYPE,
        0
    );



MXF_SET_DEFINITION(InterchangeObject, Preface,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x2f,0x00)
);

    MXF_ITEM_DEFINITION(Preface, LastModifiedDate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x07,0x02,0x01,0x10,0x02,0x04,0x00,0x00),
        0x3b02,
        MXF_TIMESTAMP_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Preface, Version,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x03,0x01,0x02,0x01,0x05,0x00,0x00,0x00),
        0x3b05,
        MXF_VERSIONTYPE_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Preface, ObjectModelVersion,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x03,0x01,0x02,0x01,0x04,0x00,0x00,0x00),
        0x3b07,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(Preface, PrimaryPackage,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x04,0x06,0x01,0x01,0x04,0x01,0x08,0x00,0x00),
        0x3b08,
        MXF_WEAKREF_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(Preface, Identifications,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x06,0x04,0x00,0x00),
        0x3b06,
        MXF_STRONGREFARRAY_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Preface, ContentStorage,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x02,0x01,0x00,0x00),
        0x3b03,
        MXF_STRONGREF_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Preface, OperationalPattern,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x01,0x02,0x02,0x03,0x00,0x00,0x00,0x00),
        0x3b09,
        MXF_UL_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Preface, EssenceContainers,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x01,0x02,0x02,0x10,0x02,0x01,0x00,0x00),
        0x3b0a,
        MXF_ULBATCH_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Preface, DMSchemes,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x01,0x02,0x02,0x10,0x02,0x02,0x00,0x00),
        0x3b0b,
        MXF_ULBATCH_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Preface, IsRIPPresent,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x04,0x05,0x03,0x00,0x00,0x00,0x00),
        0,
        MXF_BOOLEAN_TYPE,
        0
    );

MXF_SET_DEFINITION(InterchangeObject, Identification,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x30,0x00)
);

    MXF_ITEM_DEFINITION(Identification, ThisGenerationUID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x20,0x07,0x01,0x01,0x00,0x00,0x00),
        0x3c09,
        MXF_UUID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Identification, CompanyName,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x20,0x07,0x01,0x02,0x01,0x00,0x00),
        0x3c01,
        MXF_UTF16STRING_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Identification, ProductName,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x20,0x07,0x01,0x03,0x01,0x00,0x00),
        0x3c02,
        MXF_UTF16STRING_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Identification, ProductVersion,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x20,0x07,0x01,0x04,0x00,0x00,0x00),
        0x3c03,
        MXF_PRODUCTVERSION_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(Identification, VersionString,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x20,0x07,0x01,0x05,0x01,0x00,0x00),
        0x3c04,
        MXF_UTF16STRING_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Identification, ProductUID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x20,0x07,0x01,0x07,0x00,0x00,0x00),
        0x3c05,
        MXF_UUID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Identification, ModificationDate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x07,0x02,0x01,0x10,0x02,0x03,0x00,0x00),
        0x3c06,
        MXF_TIMESTAMP_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Identification, ToolkitVersion,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x20,0x07,0x01,0x0a,0x00,0x00,0x00),
        0x3c07,
        MXF_PRODUCTVERSION_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(Identification, Platform,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x20,0x07,0x01,0x06,0x01,0x00,0x00),
        0x3c08,
        MXF_UTF16STRING_TYPE,
        0
    );

MXF_SET_DEFINITION(InterchangeObject, ContentStorage,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x18,0x00)
);

    MXF_ITEM_DEFINITION(ContentStorage, Packages,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x05,0x01,0x00,0x00),
        0x1901,
        MXF_STRONGREFBATCH_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(ContentStorage, EssenceContainerData,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x05,0x02,0x00,0x00),
        0x1902,
        MXF_STRONGREFBATCH_TYPE,
        0
    );

MXF_SET_DEFINITION(InterchangeObject, EssenceContainerData,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x23,0x00)
);

    MXF_ITEM_DEFINITION(EssenceContainerData, LinkedPackageUID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x06,0x01,0x00,0x00,0x00),
        0x2701,
        MXF_UMID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(EssenceContainerData, IndexSID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x04,0x01,0x03,0x04,0x05,0x00,0x00,0x00,0x00),
        0x3f06,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(EssenceContainerData, BodySID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x04,0x01,0x03,0x04,0x04,0x00,0x00,0x00,0x00),
        0x3f07,
        MXF_UINT32_TYPE,
        1
    );

MXF_SET_DEFINITION(InterchangeObject, GenericPackage,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x34,0x00)
);

    MXF_ITEM_DEFINITION(GenericPackage, PackageUID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x01,0x01,0x15,0x10,0x00,0x00,0x00,0x00),
        0x4401,
        MXF_UMID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(GenericPackage, Name,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x01,0x03,0x03,0x02,0x01,0x00,0x00,0x00),
        0x4402,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPackage, PackageCreationDate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x07,0x02,0x01,0x10,0x01,0x03,0x00,0x00),
        0x4405,
        MXF_TIMESTAMP_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(GenericPackage, PackageModifiedDate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x07,0x02,0x01,0x10,0x02,0x05,0x00,0x00),
        0x4404,
        MXF_TIMESTAMP_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(GenericPackage, Tracks,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x06,0x05,0x00,0x00),
        0x4403,
        MXF_STRONGREFARRAY_TYPE,
        1
    );

MXF_SET_DEFINITION(InterchangeObject, Locator,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x31,0x00)
);

MXF_SET_DEFINITION(Locator, NetworkLocator,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x32,0x00)
);

    MXF_ITEM_DEFINITION(NetworkLocator, URLString,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x01,0x02,0x01,0x01,0x01,0x00,0x00,0x00),
        0x4001,
        MXF_UTF16STRING_TYPE,
        1
    );

MXF_SET_DEFINITION(Locator, TextLocator,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x33,0x00)
);

    MXF_ITEM_DEFINITION(TextLocator, LocatorName,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x01,0x04,0x01,0x02,0x01,0x00,0x00,0x00),
        0x4101,
        MXF_UTF16STRING_TYPE,
        1
    );

MXF_SET_DEFINITION(InterchangeObject, GenericTrack,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x38,0x00)
);

    MXF_ITEM_DEFINITION(GenericTrack, TrackID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x01,0x07,0x01,0x01,0x00,0x00,0x00,0x00),
        0x4801,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericTrack, TrackNumber,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x01,0x04,0x01,0x03,0x00,0x00,0x00,0x00),
        0x4804,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(GenericTrack, TrackName,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x01,0x07,0x01,0x02,0x01,0x00,0x00,0x00),
        0x4802,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericTrack, Sequence,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x02,0x04,0x00,0x00),
        0x4803,
        MXF_STRONGREF_TYPE,
        1
    );

MXF_SET_DEFINITION(GenericTrack, StaticTrack,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x3a,0x00)
);

MXF_SET_DEFINITION(GenericTrack, Track,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x3b,0x00)
);

    MXF_ITEM_DEFINITION(Track, EditRate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x30,0x04,0x05,0x00,0x00,0x00,0x00),
        0x4b01,
        MXF_RATIONAL_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(Track, Origin,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x07,0x02,0x01,0x03,0x01,0x03,0x00,0x00),
        0x4b02,
        MXF_POSITION_TYPE,
        1
    );

MXF_SET_DEFINITION(GenericTrack, EventTrack,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x39,0x00)
);

    MXF_ITEM_DEFINITION(EventTrack, EventEditRate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x30,0x04,0x02,0x00,0x00,0x00,0x00),
        0x4901,
        MXF_RATIONAL_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(EventTrack, EventOrigin,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x07,0x02,0x01,0x03,0x01,0x0b,0x00,0x00),
        0x4902,
        MXF_POSITION_TYPE,
        0
    );

MXF_SET_DEFINITION(InterchangeObject, StructuralComponent,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x02,0x00)
);

    MXF_ITEM_DEFINITION(StructuralComponent, DataDefinition,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x07,0x01,0x00,0x00,0x00,0x00,0x00),
        0x0201,
        MXF_UL_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(StructuralComponent, Duration,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x07,0x02,0x02,0x01,0x01,0x03,0x00,0x00),
        0x0202,
        MXF_LENGTH_TYPE,
        0
    );

MXF_SET_DEFINITION(StructuralComponent, Sequence,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x0f,0x00)
);

    MXF_ITEM_DEFINITION(Sequence, StructuralComponents,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x06,0x09,0x00,0x00),
        0x1001,
        MXF_STRONGREFARRAY_TYPE,
        1
    );

MXF_SET_DEFINITION(StructuralComponent, TimecodeComponent,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x14,0x00)
);

    MXF_ITEM_DEFINITION(TimecodeComponent, RoundedTimecodeBase,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x04,0x01,0x01,0x02,0x06,0x00,0x00),
        0x1502,
        MXF_UINT16_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(TimecodeComponent, StartTimecode,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x07,0x02,0x01,0x03,0x01,0x05,0x00,0x00),
        0x1501,
        MXF_POSITION_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(TimecodeComponent, DropFrame,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x04,0x01,0x01,0x05,0x00,0x00,0x00),
        0x1503,
        MXF_BOOLEAN_TYPE,
        1
    );

MXF_SET_DEFINITION(StructuralComponent, EdgeCode,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x04,0x00)
);
/* TODO: add EdgeCode item definitions */

MXF_SET_DEFINITION(StructuralComponent, SourceClip,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x11,0x00)
);

    MXF_ITEM_DEFINITION(SourceClip, StartPosition,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x07,0x02,0x01,0x03,0x01,0x04,0x00,0x00),
        0x1201,
        MXF_POSITION_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(SourceClip, SourcePackageID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x03,0x01,0x00,0x00,0x00),
        0x1101,
        MXF_PACKAGEID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(SourceClip, SourceTrackID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x03,0x02,0x00,0x00,0x00),
        0x1102,
        MXF_UINT32_TYPE,
        1
    );

MXF_SET_DEFINITION(StructuralComponent, DMSegment,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x41,0x00)
);

    MXF_ITEM_DEFINITION(DMSegment, EventStartPosition,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x07,0x02,0x01,0x03,0x03,0x03,0x00,0x00),
        0x0601,
        MXF_POSITION_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(DMSegment, EventComment,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x30,0x04,0x04,0x01,0x00,0x00,0x00),
        0x0602,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(DMSegment, TrackIDs,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x04,0x01,0x07,0x01,0x05,0x00,0x00,0x00,0x00),
        0x6102,
        MXF_UINT32BATCH_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(DMSegment, DMFramework,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x06,0x01,0x01,0x04,0x02,0x0c,0x00,0x00),
        0x6101,
        MXF_STRONGREF_TYPE,
        0
    );

MXF_SET_DEFINITION(SourceClip, DMSourceClip,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x45,0x00)
);

    MXF_ITEM_DEFINITION(DMSourceClip, DMSourceClipTrackIDs,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x01,0x07,0x01,0x06,0x00,0x00,0x00,0x00),
        0x6103,
        MXF_UINT32BATCH_TYPE,
        0
    );

MXF_SET_DEFINITION(GenericPackage, MaterialPackage,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x36,0x00)
);

MXF_SET_DEFINITION(GenericPackage, SourcePackage,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x37,0x00)
);

    MXF_ITEM_DEFINITION(SourcePackage, Descriptor,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x02,0x03,0x00,0x00),
        0x4701,
        MXF_STRONGREF_TYPE,
        0
    );

MXF_SET_DEFINITION(InterchangeObject, GenericDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x24,0x00)
);

    MXF_ITEM_DEFINITION(GenericDescriptor, Locators,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x06,0x03,0x00,0x00),
        0x2f01,
        MXF_STRONGREFARRAY_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericDescriptor, SubDescriptors,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x09,0x06,0x01,0x01,0x04,0x06,0x10,0x00,0x00),
        0,
        MXF_STRONGREFARRAY_TYPE,
        0
    );

MXF_SET_DEFINITION(GenericDescriptor, FileDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x25,0x00)
);

    MXF_ITEM_DEFINITION(FileDescriptor, LinkedTrackID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x06,0x01,0x01,0x03,0x05,0x00,0x00,0x00),
        0x3006,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(FileDescriptor, SampleRate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x06,0x01,0x01,0x00,0x00,0x00,0x00),
        0x3001,
        MXF_RATIONAL_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(FileDescriptor, ContainerDuration,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x06,0x01,0x02,0x00,0x00,0x00,0x00),
        0x3002,
        MXF_LENGTH_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(FileDescriptor, EssenceContainer,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x01,0x02,0x00,0x00),
        0x3004,
        MXF_UL_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(FileDescriptor, Codec,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x06,0x01,0x01,0x04,0x01,0x03,0x00,0x00),
        0x3005,
        MXF_UL_TYPE,
        0
    );

MXF_SET_DEFINITION(FileDescriptor, GenericPictureEssenceDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x27,0x00)
);

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, SignalStandard,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x05,0x01,0x13,0x00,0x00,0x00,0x00),
        0x3215,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, FrameLayout,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x03,0x01,0x04,0x00,0x00,0x00),
        0x320c,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, StoredWidth,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x02,0x02,0x00,0x00,0x00),
        0x3203,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, StoredHeight,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x02,0x01,0x00,0x00,0x00),
        0x3202,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, StoredF2Offset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x03,0x02,0x08,0x00,0x00,0x00),
        0x3216,
        MXF_INT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, SampledWidth,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x01,0x08,0x00,0x00,0x00),
        0x3205,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, SampledHeight,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x01,0x07,0x00,0x00,0x00),
        0x3204,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, SampledXOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x01,0x09,0x00,0x00,0x00),
        0x3206,
        MXF_INT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, SampledYOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x01,0x0A,0x00,0x00,0x00),
        0x3207,
        MXF_INT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, DisplayHeight,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x01,0x0B,0x00,0x00,0x00),
        0x3208,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, DisplayWidth,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x01,0x0C,0x00,0x00,0x00),
        0x3209,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, DisplayXOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x01,0x0D,0x00,0x00,0x00),
        0x320a,
        MXF_INT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, DisplayYOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x01,0x0E,0x00,0x00,0x00),
        0x320b,
        MXF_INT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, DisplayF2Offset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x03,0x02,0x07,0x00,0x00,0x00),
        0x3217,
        MXF_INT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, AspectRatio,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x01,0x01,0x01,0x00,0x00,0x00),
        0x320e,
        MXF_RATIONAL_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, ActiveFormatDescriptor,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x03,0x02,0x09,0x00,0x00,0x00),
        0x3218,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, VideoLineMap,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x03,0x02,0x05,0x00,0x00,0x00),
        0x320d,
        MXF_INT32ARRAY_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, AlphaTransparency,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x05,0x20,0x01,0x02,0x00,0x00,0x00,0x00),
        0x320f,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, CaptureGamma,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x02,0x01,0x01,0x01,0x02,0x00),
        0x3210,
        MXF_UL_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, ImageAlignmentOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x18,0x01,0x01,0x00,0x00,0x00,0x00),
        0x3211,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, ImageStartOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x18,0x01,0x02,0x00,0x00,0x00,0x00),
        0x3213,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, ImageEndOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x18,0x01,0x03,0x00,0x00,0x00,0x00),
        0x3214,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, FieldDominance,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x03,0x01,0x06,0x00,0x00,0x00),
        0x3212,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, PictureEssenceCoding,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x06,0x01,0x00,0x00,0x00,0x00),
        0x3201,
        MXF_UL_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, CodingEquations,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x02,0x01,0x01,0x03,0x01,0x00),
        0x321A,
        MXF_UL_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, ColorPrimaries,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x09,0x04,0x01,0x02,0x01,0x01,0x06,0x01,0x00),
        0x3219,
        MXF_UL_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, MasteringDisplayPrimaries,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x20,0x04,0x01,0x01,0x01,0x00,0x00),
        0x0000,
        MXF_THREE_COLOR_PRIMARIES_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, MasteringDisplayWhitePointChromaticity,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x20,0x04,0x01,0x01,0x02,0x00,0x00),
        0x0000,
        MXF_COLOR_PRIMARY_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, MasteringDisplayMaximumLuminance,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x20,0x04,0x01,0x01,0x03,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, MasteringDisplayMinimumLuminance,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x20,0x04,0x01,0x01,0x04,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, ActiveHeight,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x05,0x01,0x13,0x00,0x00,0x00),
        0,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, ActiveWidth,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x05,0x01,0x14,0x00,0x00,0x00),
        0,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, ActiveXOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x05,0x01,0x15,0x00,0x00,0x00),
        0,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, ActiveYOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x05,0x01,0x16,0x00,0x00,0x00),
        0,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericPictureEssenceDescriptor, AlternativeCenterCuts,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x03,0x02,0x0b,0x00,0x00,0x00),
        0,
        MXF_ULBATCH_TYPE,
        0
    );

MXF_SET_DEFINITION(GenericPictureEssenceDescriptor, CDCIEssenceDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x28,0x00)
);

    MXF_ITEM_DEFINITION(CDCIEssenceDescriptor, ComponentDepth,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x05,0x03,0x0A,0x00,0x00,0x00),
        0x3301,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(CDCIEssenceDescriptor, HorizontalSubsampling,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x01,0x05,0x00,0x00,0x00),
        0x3302,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(CDCIEssenceDescriptor, VerticalSubsampling,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x05,0x01,0x10,0x00,0x00,0x00),
        0x3308,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(CDCIEssenceDescriptor, ColorSiting,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x01,0x06,0x00,0x00,0x00),
        0x3303,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(CDCIEssenceDescriptor, ReversedByteOrder,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x03,0x01,0x02,0x01,0x0a,0x00,0x00,0x00),
        0x330b,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(CDCIEssenceDescriptor, PaddingBits,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x18,0x01,0x04,0x00,0x00,0x00,0x00),
        0x3307,
        MXF_INT16_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(CDCIEssenceDescriptor, AlphaSampleDepth,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x05,0x03,0x07,0x00,0x00,0x00),
        0x3309,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(CDCIEssenceDescriptor, BlackRefLevel,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x03,0x03,0x00,0x00,0x00),
        0x3304,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(CDCIEssenceDescriptor, WhiteReflevel,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x01,0x05,0x03,0x04,0x00,0x00,0x00),
        0x3305,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(CDCIEssenceDescriptor, ColorRange,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x05,0x03,0x05,0x00,0x00,0x00),
        0x3306,
        MXF_UINT32_TYPE,
        0
    );

MXF_SET_DEFINITION(CDCIEssenceDescriptor, MPEGVideoDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x51,0x00)
);

    MXF_ITEM_DEFINITION(MPEGVideoDescriptor, SingleSequence,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x06,0x02,0x01,0x02,0x00,0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MPEGVideoDescriptor, ConstantBFrames,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x06,0x02,0x01,0x03,0x00,0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MPEGVideoDescriptor, CodedContentType,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x06,0x02,0x01,0x04,0x00,0x00),
        0x0000,
        MXF_CODED_CONTENT_TYPE_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MPEGVideoDescriptor, LowDelay,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x06,0x02,0x01,0x05,0x00,0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MPEGVideoDescriptor, ClosedGOP,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x06,0x02,0x01,0x06,0x00,0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MPEGVideoDescriptor, IdenticalGOP,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x06,0x02,0x01,0x07,0x00,0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MPEGVideoDescriptor, MaxGOP,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x06,0x02,0x01,0x08,0x00,0x00),
        0x0000,
        MXF_UINT16_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MPEGVideoDescriptor, MaxBPictureCount,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x06,0x02,0x01,0x09,0x00,0x00),
        0x0000,
        MXF_UINT16_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MPEGVideoDescriptor, BitRate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x06,0x02,0x01,0x0B,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MPEGVideoDescriptor, ProfileAndLevel,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x06,0x02,0x01,0x0A,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );

MXF_SET_DEFINITION(GenericPictureEssenceDescriptor, RGBAEssenceDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x29,0x00)
);

    MXF_ITEM_DEFINITION(RGBAEssenceDescriptor, ComponentMaxRef,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x05,0x03,0x0b,0x00,0x00,0x00),
        0x3406,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(RGBAEssenceDescriptor, ComponentMinRef,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x05,0x03,0x0c,0x00,0x00,0x00),
        0x3407,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(RGBAEssenceDescriptor, AlphaMaxRef,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x05,0x03,0x0d,0x00,0x00,0x00),
        0x3408,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(RGBAEssenceDescriptor, AlphaMinRef,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x05,0x03,0x0e,0x00,0x00,0x00),
        0x3409,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(RGBAEssenceDescriptor, ScanningDirection,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x01,0x04,0x04,0x01,0x00,0x00,0x00),
        0x3405,
        MXF_ORIENTATION_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(RGBAEssenceDescriptor, PixelLayout,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x05,0x03,0x06,0x00,0x00,0x00),
        0x3401,
        MXF_RGBALAYOUT_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(RGBAEssenceDescriptor, Palette,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x05,0x03,0x08,0x00,0x00,0x00),
        0x3403,
        MXF_DATAVALUE_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(RGBAEssenceDescriptor, PaletteLayout,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x01,0x05,0x03,0x09,0x00,0x00,0x00),
        0x3404,
        MXF_RGBALAYOUT_TYPE,
        0
    );

MXF_SET_DEFINITION(FileDescriptor, GenericSoundEssenceDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x42,0x00)
);

    MXF_ITEM_DEFINITION(GenericSoundEssenceDescriptor, AudioSamplingRate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x03,0x01,0x01,0x01,0x00,0x00),
        0x3d03,
        MXF_RATIONAL_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericSoundEssenceDescriptor, Locked,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x04,0x04,0x02,0x03,0x01,0x04,0x00,0x00,0x00),
        0x3d02,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericSoundEssenceDescriptor, AudioRefLevel,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x02,0x01,0x01,0x03,0x00,0x00,0x00),
        0x3d04,
        MXF_INT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericSoundEssenceDescriptor, ElectroSpatialFormulation,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x01,0x04,0x02,0x01,0x01,0x01,0x00,0x00,0x00),
        0x3d05,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericSoundEssenceDescriptor, ChannelCount,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x01,0x01,0x04,0x00,0x00,0x00),
        0x3d07,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericSoundEssenceDescriptor, QuantizationBits,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x04,0x04,0x02,0x03,0x03,0x04,0x00,0x00,0x00),
        0x3d01,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericSoundEssenceDescriptor, DialNorm,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x07,0x01,0x00,0x00,0x00,0x00),
        0x3d0c,
        MXF_INT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericSoundEssenceDescriptor, SoundEssenceCompression,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x02,0x04,0x02,0x04,0x02,0x00,0x00,0x00,0x00),
        0x3d06,
        MXF_UL_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericSoundEssenceDescriptor, ReferenceImageEditRate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x01,0x01,0x06,0x00,0x00,0x00),
        0x0000,
        MXF_RATIONAL_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(GenericSoundEssenceDescriptor, ReferenceAudioAlignmentLevel,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x01,0x01,0x07,0x00,0x00,0x00),
        0x0000,
        MXF_INT8_TYPE,
        0
    );

MXF_SET_DEFINITION(FileDescriptor, GenericDataEssenceDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x43,0x00)
);

    MXF_ITEM_DEFINITION(GenericDataEssenceDescriptor, DataEssenceCoding,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x03,0x03,0x02,0x00,0x00,0x00,0x00),
        0x3e01,
        MXF_UL_TYPE,
        0
    );

MXF_SET_DEFINITION(GenericDataEssenceDescriptor, VBIDataDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x5b,0x00)
);

MXF_SET_DEFINITION(GenericDataEssenceDescriptor, ANCDataDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x5c,0x00)
);

MXF_SET_DEFINITION(FileDescriptor, MultipleDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x44,0x00)
);

    MXF_ITEM_DEFINITION(MultipleDescriptor, SubDescriptorUIDs,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x04,0x06,0x01,0x01,0x04,0x06,0x0b,0x00,0x00),
        0x3f01,
        MXF_STRONGREFARRAY_TYPE,
        1
    );

MXF_SET_DEFINITION(GenericSoundEssenceDescriptor, WaveAudioDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x48,0x00)
);

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, BlockAlign,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x03,0x02,0x01,0x00,0x00,0x00),
        0x3d0a,
        MXF_UINT16_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, SequenceOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x03,0x02,0x02,0x00,0x00,0x00),
        0x3d0b,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, AvgBps,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x03,0x03,0x05,0x00,0x00,0x00),
        0x3d09,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, ChannelAssignment,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x07,0x04,0x02,0x01,0x01,0x05,0x00,0x00,0x00),
        0x3d32,
        MXF_UL_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, PeakEnvelopeVersion,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x08,0x04,0x02,0x03,0x01,0x06,0x00,0x00,0x00),
        0x3d29,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, PeakEnvelopeFormat,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x08,0x04,0x02,0x03,0x01,0x07,0x00,0x00,0x00),
        0x3d2a,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, PointsPerPeakValue,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x08,0x04,0x02,0x03,0x01,0x08,0x00,0x00,0x00),
        0x3d2b,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, PeakEnvelopeBlockSize,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x08,0x04,0x02,0x03,0x01,0x09,0x00,0x00,0x00),
        0x3d2c,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, PeakChannels,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x08,0x04,0x02,0x03,0x01,0x0a,0x00,0x00,0x00),
        0x3d2d,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, PeakFrames,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x08,0x04,0x02,0x03,0x01,0x0b,0x00,0x00,0x00),
        0x3d2e,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, PeakOfPeaksPosition,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x08,0x04,0x02,0x03,0x01,0x0c,0x00,0x00,0x00),
        0x3d2f,
        MXF_POSITION_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, PeakEnvelopeTimestamp,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x08,0x04,0x02,0x03,0x01,0x0d,0x00,0x00,0x00),
        0x3d30,
        MXF_TIMESTAMP_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(WaveAudioDescriptor, PeakEnvelopeData,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x08,0x04,0x02,0x03,0x01,0x0e,0x00,0x00,0x00),
        0x3d31,
        MXF_STREAM_TYPE,
        0
    );

MXF_SET_DEFINITION(WaveAudioDescriptor, AES3AudioDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x47,0x00)
);

    MXF_ITEM_DEFINITION(AES3AudioDescriptor, Emphasis,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x05,0x01,0x06,0x00,0x00,0x00),
        0x3d0d,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AES3AudioDescriptor, BlockStartOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x03,0x02,0x03,0x00,0x00,0x00),
        0x3d0f,
        MXF_UINT16_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AES3AudioDescriptor, AuxiliaryBitsMode,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x05,0x01,0x01,0x00,0x00,0x00),
        0x3d08,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AES3AudioDescriptor, ChannelStatusMode,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x05,0x01,0x02,0x00,0x00,0x00),
        0x3d10,
        MXF_UINT8ARRAY_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AES3AudioDescriptor, FixedChannelStatusData,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x05,0x01,0x03,0x00,0x00,0x00),
        0x3d11,
        MXF_AES3_FIXED_DATA_ARRAY_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AES3AudioDescriptor, UserDataMode,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x05,0x01,0x04,0x00,0x00,0x00),
        0x3d12,
        MXF_UINT8ARRAY_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AES3AudioDescriptor, FixedUserData,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x05,0x01,0x05,0x00,0x00,0x00),
        0x3d13,
        MXF_AES3_FIXED_DATA_ARRAY_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AES3AudioDescriptor, LinkedTimecodeTrackID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x05,0x01,0x07,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AES3AudioDescriptor, SMPTE377MDataStreamNumber,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x05,0x04,0x02,0x05,0x01,0x08,0x00,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );

MXF_SET_DEFINITION(InterchangeObject, DMFramework,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x04,0x01,0x00,0x00,0x00,0x00)
);

MXF_SET_DEFINITION(InterchangeObject, DMSet,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x04,0x00,0x00,0x00,0x00,0x00)
);

MXF_SET_DEFINITION(InterchangeObject, SubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x59,0x00)
);

MXF_SET_DEFINITION(SubDescriptor, AVCSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x6e,0x00)
);

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCDecodingDelay,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x0e,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCConstantBPictureFlag,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x03,0x00,0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCCodedContentKind,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x04,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCClosedGOPIndicator,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x06,0x00,0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCIdenticalGOPIndicator,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x07,0x00,0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCMaximumGOPSize,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x08,0x00,0x00),
        0x0000,
        MXF_UINT16_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCMaximumBPictureCount,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x09,0x00,0x00),
        0x0000,
        MXF_UINT16_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCMaximumBitrate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x0b,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCAverageBitrate,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x14,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCProfile,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x0a,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCProfileConstraint,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x0c,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCLevel,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x0d,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCMaximumRefFrames,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x0f,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCSequenceParameterSetFlag,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x10,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(AVCSubDescriptor, AVCPictureParameterSetFlag,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x06,0x01,0x11,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );

MXF_SET_DEFINITION(DMFramework, TextBasedDMFramework,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x04,0x01,0x04,0x01,0x01,0x00)
);

    MXF_ITEM_DEFINITION(TextBasedDMFramework, TextBasedObject,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0d,0x06,0x01,0x01,0x04,0x05,0x41,0x01,0x00),
        0x0000,
        MXF_STRONGREF_TYPE,
        0
    );

MXF_SET_DEFINITION(DMSet, TextBasedObject,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x04,0x01,0x04,0x03,0x01,0x00)
);

    MXF_ITEM_DEFINITION(TextBasedObject, TextBasedMetadataPayloadSchemaID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0d,0x04,0x06,0x08,0x06,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UL_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(TextBasedObject, TextMIMEMediaType,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0d,0x04,0x09,0x02,0x02,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(TextBasedObject, RFC5646TextLanguageCode,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0d,0x03,0x01,0x01,0x02,0x02,0x14,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(TextBasedObject, TextDataDescription,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0d,0x03,0x02,0x01,0x06,0x03,0x02,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

MXF_SET_DEFINITION(TextBasedObject, GenericStreamTextBasedSet,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x04,0x01,0x04,0x02,0x01,0x00)
);

    MXF_ITEM_DEFINITION(GenericStreamTextBasedSet, GenericStreamSID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0d,0x01,0x03,0x04,0x08,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

MXF_SET_DEFINITION(TextBasedObject, UTF8TextBasedSet,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x04,0x01,0x04,0x02,0x02,0x00)
);

    MXF_ITEM_DEFINITION(UTF8TextBasedSet, UTF8TextData,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0d,0x03,0x01,0x02,0x20,0x03,0x01,0x00,0x00),
        0x0000,
        MXF_RAW_TYPE,
        1
    );

MXF_SET_DEFINITION(TextBasedObject, UTF16TextBasedSet,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x04,0x01,0x04,0x02,0x03,0x00)
);

    MXF_ITEM_DEFINITION(UTF16TextBasedSet, UTF16TextData,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0d,0x03,0x01,0x02,0x20,0x03,0x02,0x00,0x00),
        0x0000,
        MXF_RAW_TYPE,
        1
    );

MXF_SET_DEFINITION(SubDescriptor, MCALabelSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x6a,0x00)
);

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAChannelID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x03,0x04,0x0a,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCALabelDictionaryID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x03,0x07,0x01,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UL_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCATagSymbol,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x03,0x07,0x01,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCATagName,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x03,0x07,0x01,0x03,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCALinkID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x03,0x07,0x01,0x05,0x00,0x00,0x00),
        0x0000,
        MXF_UUID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAPartitionKind,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x04,0x01,0x05,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAPartitionNumber,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x04,0x01,0x06,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCATitle,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x05,0x10,0x00,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCATitleVersion,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x05,0x11,0x00,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCATitleSubVersion,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x05,0x12,0x00,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAEpisode,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x05,0x13,0x00,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, RFC5646SpokenLanguage,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0d,0x03,0x01,0x01,0x02,0x03,0x15,0x00,0x00),
        0x0000,
        MXF_ISO7STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAAudioContentKind,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x03,0x02,0x01,0x02,0x20,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAAudioElementKind,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x03,0x02,0x01,0x02,0x21,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAContent,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x03,0x02,0x01,0x02,0x22,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAUseClass,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x03,0x02,0x01,0x02,0x23,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAContentSubtype,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x03,0x02,0x01,0x02,0x24,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAContentDifferentiator,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x03,0x02,0x01,0x02,0x25,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCASpokenLanguageAttribute,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x03,0x02,0x01,0x02,0x26,0x00,0x00,0x00),
        0x0000,
        MXF_ISO7STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, RFC5646AdditionalSpokenLanguages,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x03,0x02,0x01,0x02,0x27,0x00,0x00,0x00),
        0x0000,
        MXF_ISO7STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MCALabelSubDescriptor, MCAAdditionalLanguageAttributes,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x03,0x02,0x01,0x02,0x28,0x00,0x00,0x00),
        0x0000,
        MXF_ISO7STRING_TYPE,
        0
    );


MXF_SET_DEFINITION(MCALabelSubDescriptor, AudioChannelLabelSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x6b,0x00)
);

    MXF_ITEM_DEFINITION(AudioChannelLabelSubDescriptor, SoundfieldGroupLinkID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x03,0x07,0x01,0x06,0x00,0x00,0x00),
        0x0000,
        MXF_UUID_TYPE,
        0
    );

MXF_SET_DEFINITION(MCALabelSubDescriptor, SoundfieldGroupLabelSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x6c,0x00)
);

    MXF_ITEM_DEFINITION(SoundfieldGroupLabelSubDescriptor, GroupOfSoundfieldGroupsLinkID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x01,0x03,0x07,0x01,0x04,0x00,0x00,0x00),
        0x0000,
        MXF_UUIDARRAY_TYPE,
        0
    );

MXF_SET_DEFINITION(MCALabelSubDescriptor, GroupOfSoundfieldGroupsLabelSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x6d,0x00)
);

MXF_SET_DEFINITION(SubDescriptor, VC2SubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x74,0x00)
);

    MXF_ITEM_DEFINITION(VC2SubDescriptor, VC2MajorVersion,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x07,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(VC2SubDescriptor, VC2MinorVersion,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x07,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(VC2SubDescriptor, VC2Profile,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x07,0x03,0x00,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(VC2SubDescriptor, VC2Level,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x07,0x04,0x00,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(VC2SubDescriptor, VC2WaveletFilters,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x07,0x05,0x00,0x00,0x00),
        0x0000,
        MXF_UINT8BATCH_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(VC2SubDescriptor, VC2SequenceHeadersIdentical,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x07,0x06,0x00,0x00,0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(VC2SubDescriptor, VC2EditUnitsAreCompleteSequences,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x07,0x07,0x00,0x00,0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );

MXF_SET_DEFINITION(GenericDataEssenceDescriptor, DCTimedTextDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x64,0x00)
);

    MXF_ITEM_DEFINITION(DCTimedTextDescriptor, ResourceID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0c,0x01,0x01,0x15,0x12,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UUID_TYPE,
        0   // changed from a required property to an optional property in ST 429-5 2017
    );

    MXF_ITEM_DEFINITION(DCTimedTextDescriptor, NamespaceURI,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x08,0x01,0x02,0x01,0x05,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(DCTimedTextDescriptor, RFC5646LanguageTagList,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x03,0x01,0x01,0x02,0x02,0x16,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(DCTimedTextDescriptor, UCSEncoding,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0c,0x04,0x09,0x05,0x00,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        1
    );

MXF_SET_DEFINITION(SubDescriptor, DCTimedTextResourceSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x65,0x00)
);

    MXF_ITEM_DEFINITION(DCTimedTextResourceSubDescriptor, AncillaryResourceID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0c,0x01,0x01,0x15,0x13,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UUID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(DCTimedTextResourceSubDescriptor, MIMEType,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x07,0x04,0x09,0x02,0x01,0x00,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        1
    );

    /* this the same property as EssenceContainerData::BodySID */
    /* Note that ST 429-5 or the registers do not specify a static local tag */
    MXF_ITEM_DEFINITION(DCTimedTextResourceSubDescriptor, EssenceStreamID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x04,0x01,0x03,0x04,0x04,0x00,0x00,0x00,0x00),
        0x3f07,
        MXF_UINT32_TYPE,
        1
    );

MXF_SET_DEFINITION(SubDescriptor, JPEG2000SubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x5a,0x00)
);

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, Rsiz,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UINT16_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, Xsiz,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, Ysiz,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x03,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, XOsiz,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x04,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, YOsiz,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x05,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, XTsiz,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x06,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, YTsiz,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x07,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, XTOsiz,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x08,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, YTOsiz,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x09,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, Csiz,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x0a,0x00,0x00,0x00),
        0x0000,
        MXF_UINT16_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, PictureComponentSizing,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x0b,0x00,0x00,0x00),
        0x0000,
        MXF_J2K_COMPONENT_SIZING_ARRAY_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, CodingStyleDefault,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x0c,0x00,0x00,0x00),
        0x0000,
        MXF_DATAVALUE_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, QuantizationDefault,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0a,0x04,0x01,0x06,0x03,0x0d,0x00,0x00,0x00),
        0x0000,
        MXF_DATAVALUE_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, J2CLayout,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x03,0x0e,0x00,0x00,0x00),
        0x0000,
        MXF_RGBALAYOUT_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, J2KExtendedCapabilities,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x03,0x0f,0x00,0x00,0x00),
        0x0000,
        MXF_J2K_EXTENDED_CAPABILITIES_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, J2KProfile,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x03,0x10,0x00,0x00,0x00),
        0x0000,
        MXF_UINT16ARRAY_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(JPEG2000SubDescriptor, J2KCorrespondingProfile,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x01,0x06,0x03,0x11,0x00,0x00,0x00),
        0x0000,
        MXF_UINT16ARRAY_TYPE,
        0
    );

MXF_SET_DEFINITION(SubDescriptor, ContainerConstraintsSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x67,0x00)
);

MXF_SET_DEFINITION(SubDescriptor, RIFFChunkDefinitionSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x81,0x0d)
);

    MXF_ITEM_DEFINITION(RIFFChunkDefinitionSubDescriptor, RIFFChunkStreamID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x08,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(RIFFChunkDefinitionSubDescriptor, RIFFChunkID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x08,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_RIFF_CHUNK_ID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(RIFFChunkDefinitionSubDescriptor, RIFFChunkUUID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x08,0x03,0x00,0x00,0x00),
        0x0000,
        MXF_UUID_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(RIFFChunkDefinitionSubDescriptor, RIFFChunkHashSHA1,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x08,0x04,0x00,0x00,0x00),
        0x0000,
        MXF_DATAVALUE_TYPE,
        0
    );

MXF_SET_DEFINITION(SubDescriptor, ADM_CHNASubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x81,0x0e)
);

    MXF_ITEM_DEFINITION(ADM_CHNASubDescriptor, NumLocalChannels,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x09,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UINT16_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(ADM_CHNASubDescriptor, NumADMAudioTrackUIDs,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x09,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_UINT16_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(ADM_CHNASubDescriptor, ADMChannelMappingsArray,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x09,0x03,0x00,0x00,0x00),
        0x0000,
        MXF_STRONGREFARRAY_TYPE,
        1
    );

MXF_SET_DEFINITION(InterchangeObject, ADMChannelMapping,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x81,0x0f)
);

    MXF_ITEM_DEFINITION(ADMChannelMapping, LocalChannelID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x09,0x04,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(ADMChannelMapping, ADMAudioTrackUID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x09,0x05,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(ADMChannelMapping, ADMAudioTrackChannelFormatID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x09,0x06,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(ADMChannelMapping, ADMAudioPackFormatID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x09,0x07,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

MXF_SET_DEFINITION(SubDescriptor, RIFFChunkReferencesSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x81,0x10)
);

    MXF_ITEM_DEFINITION(RIFFChunkReferencesSubDescriptor, RIFFChunkStreamIDsArray,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x08,0x06,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32ARRAY_TYPE,
        1
    );

MXF_SET_DEFINITION(SubDescriptor, ADMAudioMetadataSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x81,0x11)
);

    MXF_ITEM_DEFINITION(ADMAudioMetadataSubDescriptor, RIFFChunkStreamID_link1,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x0a,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(ADMAudioMetadataSubDescriptor, ADMProfileLevelULBatch,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x0a,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_ULBATCH_TYPE,
        0
    );

MXF_SET_DEFINITION(SoundfieldGroupLabelSubDescriptor, ADMSoundfieldGroupLabelSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x81,0x12)
);

    MXF_ITEM_DEFINITION(ADMSoundfieldGroupLabelSubDescriptor, RIFFChunkStreamID_link2,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x0b,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(ADMSoundfieldGroupLabelSubDescriptor, ADMAudioProgrammeID_ST2131,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x0b,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(ADMSoundfieldGroupLabelSubDescriptor, ADMAudioContentID_ST2131,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x0b,0x03,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(ADMSoundfieldGroupLabelSubDescriptor, ADMAudioObjectID_ST2131,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x0b,0x04,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

MXF_SET_DEFINITION(GenericSoundEssenceDescriptor, MGASoundEssenceDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x81,0x06)
);

    MXF_ITEM_DEFINITION(MGASoundEssenceDescriptor, MGASoundEssenceBlockAlign,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x04,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UINT16_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(MGASoundEssenceDescriptor, MGASoundEssenceAverageBytesPerSecond,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x04,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_UINT32_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(MGASoundEssenceDescriptor, MGASoundEssenceSequenceOffset,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x04,0x03,0x00,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );

MXF_SET_DEFINITION(SubDescriptor, MGAAudioMetadataSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x81,0x07)
);

    MXF_ITEM_DEFINITION(MGAAudioMetadataSubDescriptor, MGALinkID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0xe,0x04,0x02,0x03,0x05,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UUID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(MGAAudioMetadataSubDescriptor, MGAAudioMetadataIndex,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0xe,0x04,0x02,0x03,0x05,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(MGAAudioMetadataSubDescriptor, MGAAudioMetadataIdentifier,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0xe,0x04,0x02,0x03,0x05,0x03,0x00,0x00,0x00),
        0x0000,
        MXF_UINT8_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(MGAAudioMetadataSubDescriptor, MGAAudioMetadataPayloadULArray,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0xe,0x04,0x02,0x03,0x05,0x04,0x00,0x00,0x00),
        0x0000,
        MXF_ULARRAY_TYPE,
        1
    );

MXF_SET_DEFINITION(SubDescriptor, SADMAudioMetadataSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x81,0x09)
);

    MXF_ITEM_DEFINITION(SADMAudioMetadataSubDescriptor, SADMMetadataSectionLinkID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x07,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UUID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(SADMAudioMetadataSubDescriptor, SADMProfileLevelULBatch,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x07,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_ULBATCH_TYPE,
        0
    );

MXF_SET_DEFINITION(SoundfieldGroupLabelSubDescriptor, MGASoundfieldGroupLabelSubDescriptor,
    MXF_LABEL(0x06,0x0e,0x2b,0x34,0x02,0x53,0x01,0x01,0x0d,0x01,0x01,0x01,0x01,0x01,0x81,0x08)
);

    MXF_ITEM_DEFINITION(MGASoundfieldGroupLabelSubDescriptor, MGAMetadataSectionLinkID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x06,0x01,0x00,0x00,0x00),
        0x0000,
        MXF_UUID_TYPE,
        1
    );

    MXF_ITEM_DEFINITION(MGASoundfieldGroupLabelSubDescriptor, ADMAudioProgrammeID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x06,0x02,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MGASoundfieldGroupLabelSubDescriptor, ADMAudioContentID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x06,0x03,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(MGASoundfieldGroupLabelSubDescriptor, ADMAudioObjectID,
        MXF_LABEL(0x06,0x0e,0x2b,0x34,0x01,0x01,0x01,0x0e,0x04,0x02,0x03,0x06,0x04,0x00,0x00,0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );



#if !defined(KEEP_DATA_MODEL_DEFS)
#undef MXF_BASIC_TYPE_DEF
#undef MXF_ARRAY_TYPE_DEF
#undef MXF_COMPOUND_TYPE_DEF
#undef MXF_COMPOUND_TYPE_MEMBER
#undef MXF_INTERPRETED_TYPE_DEF
#undef MXF_LABEL
#undef MXF_SET_DEFINITION
#undef MXF_ITEM_DEFINITION
#endif
