[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](LICENSE)
[![contributions welcome](https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat)](https://github.com/bcgov/pims/issues)
![API (.Net Core)](<https://github.com/bcgov/PIMS/workflows/API%20(.NET%20Core)/badge.svg?branch=dev>)
![APP (React)](<https://github.com/bcgov/PIMS/workflows/APP%20(React)/badge.svg?branch=dev>)

[![img](https://img.shields.io/badge/Lifecycle-Stable-97ca00)](https://github.com/bcgov/repomountie/blob/master/doc/lifecycle-badges.md)

# PIMS

Property Inventory Management System

## Introduction

Strategic Real Estate Services (SRES), comprised of professionals from a variety of backgrounds (sales, marketing, First Nations consultation, environmental management and communications) was formed to dispose of assets surplus to government, in order to help government meet its commitment to balance the provincial budget, and to generate economic activity in communities throughout BC. The SRES team is tasked with coordinating the province-wide management of this initiative ensuring that all issues are addressed appropriately and the return to government is maximized.

SRES is responsible for:

- Maintaining a complete inventory of the Province’s real estate assets
- Tracking Ministry organizations compliance with policies related to disposition of real estate assets
- Marketing property internally for repurposing (transfer to another ministry)
- Oversight of sales process from pre-marketing to completion
- First Nations Consultation real estate development and dispositions
- Providing strategic real estate analysis and advice to Ministries and Broader Public Sectors
- Reporting to Treasury Board

To support SRES’s overall strategic real estate initiatives a modern Information Management System is required that will aid in strategic decision making, support its client Ministries and the Broader Public Sector, and remain compliant with current Inventory Policies (CPPM Policy Chapter 8: Asset Management). Ideally the system will be flexible to allow for ad hoc customized reporting and adaptable to support unforeseen future real estate strategies.

## Problem Statement

The Province is not able to make the most informed, timely, and strategic decisions on the optimal use of its real property assets on behalf of the people and priorities of British Columbia.

## Hypothesis

If we have a modern easy to use system built in collaboration with, and for the benefit of, clients they will want to use it to provide Strategic Real Estate Services (SRES) with the data required to support real time executive decision making and to remain compliant with core policy.

## Goal

The goal of the PIMS project team is to create a Geo-spatial Client Relationship Management System to support the Strategic Real Estate Services branch of Real Property Division to manage and oversee the disposal of assets surplus to government, optimize the benefits to the government and citizens of BC related to the management of public real estate assets, and be a trusted source for accurate information for Government owned titled property.

The system will support the management of titled properties through the government property ownership life cycle from acquisition to disposal (transfer to another ministry or sale outside of the government). This would include the ability to manage internal workflows. PIMS will be capable of collection, analysis, and reporting of spatial data and related asset information from multiple data sources.

Ideally reporting and query requirements would allow SRES staff to run technical detailed reports through the GIS and linked database. Simple query, collaboration and reporting should be available to non-technical users such as external stakeholders.

Objectives include:

- Increase the total amount of properties in the inventory Map
- Ensure data validation occurs at time of project submission – BC Assessment and/or Land Title Survey Authority
- Increase client satisfaction with system
- Allow for portals for clients to add, edit, and report on properties in the system
- Accurate, customizable, instant financial reporting
- Seamless data migration from clients to PIMS

## Development

> We are actively adding new features and enhancements.

Read the documentation [here](https://github.com/bcgov/PIMS/wiki)

## License

```
Copyright 2020 Province of British Columbia

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
